/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class JobScmToJobLevelHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOBSCM = "hbjm_jobscmhr";
    private static final String ENTITY_JOBLEVEL = "hbjm_joblevelhr";
    private static final String ENTITY_JOBLEVELSCM = "hbjm_joblevelscmhr";
    private SWCDataServiceHelper jobScmServiceHelper = new SWCDataServiceHelper("hbjm_jobscmhr");
    private SWCDataServiceHelper jobLevelServiceHelper = new SWCDataServiceHelper("hbjm_joblevelhr");

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode jobScmNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBSCM.equals(jobScmNode.getEntityNumber())) {
            List<Long> jobScmIds = jobScmNode.getDataSet();
            DynamicObject[] jobGradeScmObjs = jobScmNode.getEntityDataObjsFromCache(jobScmIds);
            if (jobGradeScmObjs == null) {
                jobGradeScmObjs = this.jobScmServiceHelper.query("id,joblevelscm,jobgradescm", new QFilter[]{new QFilter("id", "in", jobScmIds)});
                jobScmNode.cacheEntityDataObj(jobGradeScmObjs);
            }
            Set levelScmIds = Arrays.stream(jobGradeScmObjs).map(object -> object.getLong("joblevelscm.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("joblevelscm", "in", levelScmIds);
            if (levelScmIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode jobLevelNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBLEVEL.equals(jobLevelNode.getEntityNumber())) {
            List<Long> jobLevelIdSet = jobLevelNode.getDataSet();
            DynamicObject[] jobLevelObjs = jobLevelNode.getEntityDataObjsFromCache(jobLevelIdSet);
            if (jobLevelObjs == null) {
                jobLevelObjs = this.jobLevelServiceHelper.query("id,joblevelseq,joblevelscm", new QFilter[]{new QFilter("id", "in", jobLevelIdSet)});
                jobLevelNode.cacheEntityDataObj(jobLevelObjs);
            }
            Set jobLevelScmIds = Arrays.stream(jobLevelObjs).map(object -> object.getLong("joblevelscm.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("joblevelscm", "in", jobLevelScmIds);
            if (jobLevelScmIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

