/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class JobScmToJobSeqHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOBSCM = "hbjm_jobscmhr";
    private static final String ENTITY_JOBSEQ = "hbjm_jobseqhr";
    private static final String ENTITY_JOBSEQSCM = "hbjm_jobseqscm";
    private SWCDataServiceHelper jobSeqScmServiceHelper = new SWCDataServiceHelper("hbjm_jobseqscm");
    private Map<Long, Map<Long, DynamicObject>> jobSeqIdToSeqScmObjMap = Maps.newHashMap();
    private Map<Long, Map<Long, DynamicObject>> jobScmIdToSeqScmObjMap = Maps.newHashMap();

    private void cacheSeqScmObj(DynamicObject[] seqScmObj) {
        this.getGraphCacheManager().cacheSeqScmObj(seqScmObj);
        for (DynamicObject obj : seqScmObj) {
            Map map1 = this.jobSeqIdToSeqScmObjMap.computeIfAbsent(obj.getLong("jobseq.id"), o1 -> Maps.newHashMap());
            map1.putIfAbsent(obj.getLong("id"), obj);
            Map map2 = this.jobScmIdToSeqScmObjMap.computeIfAbsent(obj.getLong("jobscm.id"), o1 -> Maps.newHashMap());
            map2.putIfAbsent(obj.getLong("id"), obj);
        }
    }

    private DynamicObject[] getSeqScmObjByJobSeqIdFromCache(Collection<Long> jobSeqIds) {
        if (jobSeqIds == null) {
            return null;
        }
        if (this.jobSeqIdToSeqScmObjMap.keySet().containsAll(jobSeqIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)jobSeqIds.size());
            for (Long aLong : jobSeqIds) {
                Map<Long, DynamicObject> map = this.jobSeqIdToSeqScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    private DynamicObject[] getSeqScmObjByJobScmIdFromCache(Collection<Long> jobScmIds) {
        if (jobScmIds == null) {
            return null;
        }
        if (this.jobScmIdToSeqScmObjMap.keySet().containsAll(jobScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)jobScmIds.size());
            for (Long aLong : jobScmIds) {
                Map<Long, DynamicObject> map = this.jobScmIdToSeqScmObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode sourceNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBSCM.equals(sourceNode.getEntityNumber())) {
            List<Long> jobScmIds = sourceNode.getDataSet();
            DynamicObject[] jobSeqScmObjs = this.getSeqScmObjByJobScmIdFromCache(jobScmIds);
            if (jobSeqScmObjs == null) {
                jobSeqScmObjs = this.jobSeqScmServiceHelper.query("id,jobscm,jobseq", new QFilter[]{new QFilter("jobscm", "in", jobScmIds)});
                this.cacheSeqScmObj(jobSeqScmObjs);
            }
            Set jobSeqIds = Arrays.stream(jobSeqScmObjs).map(object -> object.getLong("jobseq.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", jobSeqIds);
            if (jobSeqIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode targetNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBSEQ.equals(targetNode.getEntityNumber())) {
            List<Long> jobSeqIdSet = targetNode.getDataSet();
            DynamicObject[] jobSeqScmObjs = this.getSeqScmObjByJobSeqIdFromCache(jobSeqIdSet);
            if (jobSeqScmObjs == null) {
                jobSeqScmObjs = this.jobSeqScmServiceHelper.query("id,jobseq,jobscm", new QFilter[]{new QFilter("jobseq", "in", jobSeqIdSet)});
                this.cacheSeqScmObj(jobSeqScmObjs);
            }
            Set scmIds = Arrays.stream(jobSeqScmObjs).map(object -> object.getLong("jobscm.id")).collect(Collectors.toSet());
            resultQFilter = new QFilter("id", "in", scmIds);
            if (scmIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

