/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ContrastConstraintHelper;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hcdm.common.entity.Pair;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class JobToJobGradeHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_JOB = "hbjm_jobhr";
    private static final String ENTITY_JOBGRADE = "hbjm_jobgradehr";
    private SWCDataServiceHelper jobServiceHelper = new SWCDataServiceHelper("hbjm_jobhr");
    private SWCDataServiceHelper jobGradeServiceHelper = new SWCDataServiceHelper("hbjm_jobgradehr");
    private Map<Long, Map<Long, DynamicObject>> gradeScmIdToJobObjMap = Maps.newHashMap();

    private DynamicObject[] getJobObjByGradeScmIdFromCache(Map<Long, DynamicObject> jobObjCache, Collection<Long> gradeScmIds) {
        for (DynamicObject obj : jobObjCache.values()) {
            Map map = this.gradeScmIdToJobObjMap.computeIfAbsent(obj.getLong("highjobgrade.jobgradescm.id"), o1 -> Maps.newHashMap());
            map.putIfAbsent(obj.getLong("id"), obj);
        }
        if (gradeScmIds == null) {
            return null;
        }
        if (this.gradeScmIdToJobObjMap.keySet().containsAll(gradeScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)gradeScmIds.size());
            for (Long aLong : gradeScmIds) {
                Map<Long, DynamicObject> map = this.gradeScmIdToJobObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode jobNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOB.equals(jobNode.getEntityNumber())) {
            List<Long> jobIds = jobNode.getDataSet();
            DynamicObject[] jobObjs = jobNode.getEntityDataObjsFromCache(jobIds);
            if (jobObjs == null) {
                jobObjs = this.jobServiceHelper.query("id,lowjobgrade,highjobgrade,lowjoblevel,highjoblevel", new QFilter[]{new QFilter("id", "in", jobIds), BaseDataHisHelper.getHisCurrFilter()});
                jobNode.cacheEntityDataObj(jobObjs);
            }
            HashMap gradeScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)jobObjs.length);
            for (DynamicObject job : jobObjs) {
                if (job.getDynamicObject("lowjobgrade") == null) continue;
                int lowSeq = job.getInt("lowjobgrade.jobgradeseq");
                Long jobGradeScm = job.getLong("lowjobgrade.jobgradescm.id");
                int highSeq = job.getInt("highjobgrade.jobgradeseq");
                Pair seqPair = (Pair)gradeScmMinMaxSeq.get(jobGradeScm);
                if (seqPair == null) {
                    gradeScmMinMaxSeq.put(jobGradeScm, Pair.create((Object)lowSeq, (Object)highSeq));
                    continue;
                }
                seqPair.setKey((Object)(lowSeq < (Integer)seqPair.getKey() ? Integer.valueOf(lowSeq) : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(highSeq > (Integer)seqPair.getValue() ? Integer.valueOf(highSeq) : (Integer)seqPair.getValue()));
            }
            resultQFilter = ContrastConstraintHelper.createQFilterByScmSeqForGradeLevel(gradeScmMinMaxSeq, true);
            if (gradeScmMinMaxSeq.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode jobNode = edge.getSourceNode();
        GraphNode jobGradeNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBGRADE.equals(jobGradeNode.getEntityNumber())) {
            List<Long> jobGradeIdSet = jobGradeNode.getDataSet();
            DynamicObject[] jobGradeObjs = jobGradeNode.getEntityDataObjsFromCache(jobGradeIdSet);
            if (jobGradeObjs == null) {
                jobGradeObjs = this.jobGradeServiceHelper.query("id,jobgradeseq,jobgradescm", new QFilter[]{new QFilter("id", "in", jobGradeIdSet)});
                jobGradeNode.cacheEntityDataObj(jobGradeObjs);
            }
            HashMap gradeScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject jobGradeObj : jobGradeObjs) {
                long scmId = jobGradeObj.getLong("jobgradescm.id");
                Integer jobGradeSeq = jobGradeObj.getInt("jobgradeseq");
                Pair seqPair = (Pair)gradeScmMinMaxSeq.get(scmId);
                if (seqPair == null) {
                    gradeScmMinMaxSeq.put(scmId, Pair.create((Object)jobGradeSeq, (Object)jobGradeSeq));
                    continue;
                }
                seqPair.setKey((Object)(jobGradeSeq < (Integer)seqPair.getKey() ? jobGradeSeq : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(jobGradeSeq > (Integer)seqPair.getValue() ? jobGradeSeq : (Integer)seqPair.getValue()));
            }
            DynamicObject[] jobObjs = this.getJobObjByGradeScmIdFromCache(edge.getSourceNode().getNodeEntityDataObjCache(), gradeScmMinMaxSeq.keySet());
            if (jobObjs == null) {
                jobObjs = this.jobServiceHelper.query("id,lowjobgrade,highjobgrade,lowjoblevel,highjoblevel", new QFilter[]{new QFilter("highjobgrade.jobgradescm", "in", gradeScmMinMaxSeq.keySet()), BaseDataHisHelper.getHisCurrFilter()});
                jobNode.cacheEntityDataObj(jobObjs);
            }
            HashSet jobIds = Sets.newHashSetWithExpectedSize((int)jobObjs.length);
            for (DynamicObject job : jobObjs) {
                int lowSeq = job.getInt("lowjobgrade.jobgradeseq");
                Long jobGradeScm = job.getLong("lowjobgrade.jobgradescm.id");
                int highSeq = job.getInt("highjobgrade.jobgradeseq");
                Pair gradeRange = (Pair)gradeScmMinMaxSeq.get(jobGradeScm);
                if (gradeRange == null || lowSeq > (Integer)gradeRange.getKey() || highSeq < (Integer)gradeRange.getValue()) continue;
                Long jobId = job.getLong("id");
                jobIds.add(jobId);
            }
            resultQFilter = new QFilter("id", "in", (Object)jobIds);
            if (jobIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

