/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class StPositionToAdminOrgHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_STPOSITION = "hbpm_stposition";
    private static final String ENTITY_ADMINORG = "haos_adminorghr";
    private final Log log = LogFactory.getLog(StPositionToAdminOrgHandler.class);
    private SWCDataServiceHelper adminOrgServiceHelper = new SWCDataServiceHelper("haos_adminorghr");
    private Map<Long, DynamicObject> adminOrgObjCache = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, Map<String, Object>> positionObjCache = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, List<Long>> orgIdToPositionIdCache = Maps.newHashMapWithExpectedSize((int)16);
    private DynamicObject nullDynamicObject = new DynamicObject();
    private Map<String, Object> nullMap = new HashMap<String, Object>(0);
    private List<Long> nullList = new ArrayList<Long>(0);

    private List<String> getAdminOrgLongNumberFromCache(HashSet<Long> orgContainsIds) {
        if (CollectionUtils.isEmpty(orgContainsIds)) {
            return Collections.emptyList();
        }
        ArrayList idSetOfNeedQuery = Lists.newArrayListWithExpectedSize((int)orgContainsIds.size());
        ArrayList objectList = Lists.newArrayListWithExpectedSize((int)orgContainsIds.size());
        for (Long orgContainsId : orgContainsIds) {
            DynamicObject object = this.adminOrgObjCache.get(orgContainsId);
            if (object != null) {
                if (object == this.nullDynamicObject) continue;
                objectList.add(object);
                continue;
            }
            idSetOfNeedQuery.add(orgContainsId);
        }
        if (!idSetOfNeedQuery.isEmpty()) {
            DynamicObject[] adminOrgObjArr = this.adminOrgServiceHelper.query("id,structlongnumber", new QFilter[]{new QFilter("id", "in", (Object)idSetOfNeedQuery)});
            Map resultMap = Arrays.stream(adminOrgObjArr).collect(Collectors.toMap(obj -> obj.getLong("id"), Function.identity(), (o1, o2) -> o2));
            for (Long id : idSetOfNeedQuery) {
                DynamicObject obj2 = (DynamicObject)resultMap.get(id);
                if (obj2 != null) {
                    this.adminOrgObjCache.put(id, obj2);
                    objectList.add(obj2);
                    continue;
                }
                this.adminOrgObjCache.put(id, this.nullDynamicObject);
            }
        }
        return objectList.stream().map(obj -> obj.getString("structlongnumber")).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getPositionObjFromCache(List<Long> stPositionIdSet) {
        Map result;
        List data;
        if (CollectionUtils.isEmpty(stPositionIdSet)) {
            return Collections.emptyList();
        }
        ArrayList objectList = Lists.newArrayListWithExpectedSize((int)stPositionIdSet.size());
        ArrayList idSetOfNeedQuery = Lists.newArrayListWithExpectedSize((int)stPositionIdSet.size());
        for (Long id : stPositionIdSet) {
            Map<String, Object> object = this.positionObjCache.get(id);
            if (object != null) {
                if (object == this.nullMap) continue;
                objectList.add(object);
                continue;
            }
            idSetOfNeedQuery.add(id);
        }
        if (!idSetOfNeedQuery.isEmpty() && CollectionUtils.isNotEmpty((Collection)(data = (List)(result = (Map)SWCMServiceUtils.invokeHRMPService((String)"hbpm", (String)"IStandardPositionQueryService", (String)"queryStandardPosition", (Object[])new Object[]{idSetOfNeedQuery})).get("data")))) {
            Map resultMap = data.stream().collect(Collectors.toMap(obj -> (Long)obj.get("id"), Function.identity(), (o1, o2) -> o2));
            for (Long posId : idSetOfNeedQuery) {
                Map map = (Map)resultMap.get(posId);
                if (map != null) {
                    this.positionObjCache.put(posId, map);
                    objectList.add(map);
                    continue;
                }
                this.positionObjCache.put(posId, this.nullMap);
            }
        }
        return objectList;
    }

    private Set<Long> getPositionIdByAdminOrgIdFromCache(List<Long> adminOrgIdSet) {
        Map result;
        List dataList;
        if (CollectionUtils.isEmpty(adminOrgIdSet)) {
            return Collections.emptySet();
        }
        HashSet finalPositionIdSet = Sets.newHashSetWithExpectedSize((int)adminOrgIdSet.size());
        ArrayList idSetOfNeedQuery = Lists.newArrayListWithExpectedSize((int)adminOrgIdSet.size());
        for (Long id : adminOrgIdSet) {
            List<Long> positionIds = this.orgIdToPositionIdCache.get(id);
            if (positionIds != null) {
                if (positionIds == this.nullList) continue;
                finalPositionIdSet.addAll(positionIds);
                continue;
            }
            idSetOfNeedQuery.add(id);
        }
        if (!idSetOfNeedQuery.isEmpty() && (dataList = (List)(result = (Map)SWCMServiceUtils.invokeHRMPService((String)"hbpm", (String)"IStandardPositionQueryService", (String)"queryStandardPositionByOrg", (Object[])new Object[]{idSetOfNeedQuery})).get("data")) != null) {
            Map resultMap = dataList.stream().collect(Collectors.toMap(obj -> (Long)obj.get("orgId"), Function.identity(), (o1, o2) -> o2));
            for (Long orgId : idSetOfNeedQuery) {
                Map data = (Map)resultMap.get(orgId);
                boolean hasResult = false;
                if (data != null) {
                    List collect;
                    List standardPositions = (List)data.get("standardPositions");
                    List list = collect = standardPositions != null ? standardPositions.stream().map(pos -> pos.getLong("id")).collect(Collectors.toList()) : null;
                    if (collect != null) {
                        hasResult = true;
                        this.orgIdToPositionIdCache.put(orgId, collect);
                        finalPositionIdSet.addAll(collect);
                    }
                }
                if (hasResult) continue;
                this.orgIdToPositionIdCache.put(orgId, this.nullList);
            }
        }
        return finalPositionIdSet;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode sourceNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_STPOSITION.equals(sourceNode.getEntityNumber())) {
            List<String> structLongNumbers;
            List<String> finalStructLongNumbers;
            List<Map<String, Object>> data;
            List<Long> stPositionIdSet = sourceNode.getDataSet();
            HashSet orgContainsIds = Sets.newHashSetWithExpectedSize((int)10);
            HashSet orgNotContainsIds = Sets.newHashSetWithExpectedSize((int)10);
            if (CollectionUtils.isNotEmpty(stPositionIdSet) && CollectionUtils.isNotEmpty(data = this.getPositionObjFromCache(stPositionIdSet))) {
                data.forEach(pos -> {
                    Map entryEntity = (Map)pos.get("entryentity");
                    if (entryEntity != null) {
                        for (Map.Entry entry : entryEntity.entrySet()) {
                            Boolean contains = (Boolean)entry.getValue();
                            Long orgId = (Long)entry.getKey();
                            if (orgId <= 0L) continue;
                            if (contains.booleanValue()) {
                                orgContainsIds.add(orgId);
                                continue;
                            }
                            orgNotContainsIds.add(orgId);
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(finalStructLongNumbers = this.removeNumberWithPrefixMatch(structLongNumbers = this.getAdminOrgLongNumberFromCache(orgContainsIds)))) {
                String numberLikeTpl = " structlongnumber like ''{0}%'' ";
                StringJoiner joiner = new StringJoiner("or");
                for (String finalStructLongNumber : finalStructLongNumbers) {
                    joiner.add(MessageFormat.format(numberLikeTpl, finalStructLongNumber));
                }
                String longNumberQFilterStr = joiner.toString();
                int maxLikeStr = 81920;
                if (longNumberQFilterStr.length() > maxLikeStr) {
                    this.log.warn("longNumberQFilterStr too large ,length is {}", (Object)longNumberQFilterStr.length());
                    String substring = longNumberQFilterStr.substring(0, maxLikeStr);
                    int lastIndexOr = substring.lastIndexOf("or");
                    longNumberQFilterStr = substring.substring(0, lastIndexOr);
                }
                resultQFilter = QFilter.of((String)longNumberQFilterStr, (Object[])new Object[0]);
            }
            if (CollectionUtils.isNotEmpty((Collection)orgNotContainsIds)) {
                QFilter idQFilter = new QFilter("id", "in", (Object)orgNotContainsIds);
                resultQFilter = resultQFilter == null ? idQFilter : resultQFilter.or(idQFilter);
            }
            if (resultQFilter == null) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode targetNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_ADMINORG.equals(targetNode.getEntityNumber())) {
            List<Long> adminOrgIds = targetNode.getDataSet();
            if (CollectionUtils.isNotEmpty(adminOrgIds)) {
                Set<Long> positionIds = this.getPositionIdByAdminOrgIdFromCache(adminOrgIds);
                resultQFilter = CollectionUtils.isEmpty(positionIds) ? ConstraintGraphCalculator.getNOTFilter() : new QFilter("id", "in", positionIds);
            }
            if (resultQFilter == null) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    private List<String> removeNumberWithPrefixMatch(List<String> structLongNumbers) {
        if (structLongNumbers.size() <= 1) {
            return structLongNumbers;
        }
        structLongNumbers.sort(Comparator.comparingInt(String::length));
        HashSet removedNumberIndex = Sets.newHashSetWithExpectedSize((int)16);
        for (int curIndex = 0; curIndex < structLongNumbers.size() - 1; ++curIndex) {
            if (removedNumberIndex.contains(curIndex)) continue;
            String curNumber = structLongNumbers.get(curIndex);
            for (int nextIndex = curIndex + 1; nextIndex < structLongNumbers.size(); ++nextIndex) {
                String nextNumber;
                if (removedNumberIndex.contains(nextIndex) || !StringUtils.equals((CharSequence)curNumber, (CharSequence)(nextNumber = structLongNumbers.get(nextIndex))) && !StringUtils.startsWith((CharSequence)nextNumber, (CharSequence)curNumber)) continue;
                removedNumberIndex.add(nextIndex);
            }
        }
        ArrayList finalNumber = Lists.newArrayListWithExpectedSize((int)(structLongNumbers.size() - removedNumberIndex.size()));
        for (int idx = 0; idx < structLongNumbers.size(); ++idx) {
            if (removedNumberIndex.contains(idx)) continue;
            finalNumber.add(structLongNumbers.get(idx));
        }
        return finalNumber;
    }
}

