/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ContrastConstraintHelper;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hcdm.common.entity.Pair;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class StPositionToJobGradeHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_STPOSITION = "hbpm_stposition";
    private static final String ENTITY_JOBGRADE = "hbjm_jobgradehr";
    private SWCDataServiceHelper stpositionServiceHelper = new SWCDataServiceHelper("hbpm_stposition");
    private SWCDataServiceHelper jobGradeServiceHelper = new SWCDataServiceHelper("hbjm_jobgradehr");
    private Map<Long, Map<Long, DynamicObject>> gradeScmIdToStPositionObjMap = Maps.newHashMap();

    private DynamicObject[] getStPositionObjByGradeScmIdFromCache(Map<Long, DynamicObject> stPositionObjCache, Collection<Long> gradeScmIds) {
        for (DynamicObject obj : stPositionObjCache.values()) {
            Map map = this.gradeScmIdToStPositionObjMap.computeIfAbsent(obj.getLong("highjobgrade.jobgradescm.id"), o1 -> Maps.newHashMap());
            map.putIfAbsent(obj.getLong("id"), obj);
        }
        if (gradeScmIds == null) {
            return null;
        }
        if (this.gradeScmIdToStPositionObjMap.keySet().containsAll(gradeScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)gradeScmIds.size());
            for (Long aLong : gradeScmIds) {
                Map<Long, DynamicObject> map = this.gradeScmIdToStPositionObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode stPositionNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_STPOSITION.equals(stPositionNode.getEntityNumber())) {
            List<Long> stpositionIds = stPositionNode.getDataSet();
            DynamicObject[] stPositionObjs = stPositionNode.getEntityDataObjsFromCache(stpositionIds);
            if (stPositionObjs == null) {
                stPositionObjs = this.stpositionServiceHelper.query("id,lowjobgrade,highjobgrade,lowjoblevel,highjoblevel", new QFilter[]{new QFilter("id", "in", stpositionIds), BaseDataHisHelper.getHisCurrFilter()});
                stPositionNode.cacheEntityDataObj(stPositionObjs);
            }
            HashMap gradeScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)stPositionObjs.length);
            for (DynamicObject stposition : stPositionObjs) {
                if (stposition.getDynamicObject("lowjobgrade") == null) continue;
                int lowSeq = stposition.getInt("lowjobgrade.jobgradeseq");
                Long jobGradeScm = stposition.getLong("lowjobgrade.jobgradescm.id");
                int highSeq = stposition.getInt("highjobgrade.jobgradeseq");
                Pair seqPair = (Pair)gradeScmMinMaxSeq.get(jobGradeScm);
                if (seqPair == null) {
                    gradeScmMinMaxSeq.put(jobGradeScm, Pair.create((Object)lowSeq, (Object)highSeq));
                    continue;
                }
                seqPair.setKey((Object)(lowSeq < (Integer)seqPair.getKey() ? Integer.valueOf(lowSeq) : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(highSeq > (Integer)seqPair.getValue() ? Integer.valueOf(highSeq) : (Integer)seqPair.getValue()));
            }
            resultQFilter = ContrastConstraintHelper.createQFilterByScmSeqForGradeLevel(gradeScmMinMaxSeq, true);
            if (gradeScmMinMaxSeq.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode stPositionNode = edge.getSourceNode();
        GraphNode jobGradeNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBGRADE.equals(jobGradeNode.getEntityNumber())) {
            List<Long> jobGradeIdSet = jobGradeNode.getDataSet();
            DynamicObject[] jobGradeObjs = jobGradeNode.getEntityDataObjsFromCache(jobGradeIdSet);
            if (jobGradeObjs == null) {
                jobGradeObjs = this.jobGradeServiceHelper.query("id,jobgradeseq,jobgradescm", new QFilter[]{new QFilter("id", "in", jobGradeIdSet)});
                jobGradeNode.cacheEntityDataObj(jobGradeObjs);
            }
            HashMap gradeScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject jobGradeObj : jobGradeObjs) {
                long scmId = jobGradeObj.getLong("jobgradescm.id");
                Integer jobGradeSeq = jobGradeObj.getInt("jobgradeseq");
                Pair seqPair = (Pair)gradeScmMinMaxSeq.get(scmId);
                if (seqPair == null) {
                    gradeScmMinMaxSeq.put(scmId, Pair.create((Object)jobGradeSeq, (Object)jobGradeSeq));
                    continue;
                }
                seqPair.setKey((Object)(jobGradeSeq < (Integer)seqPair.getKey() ? jobGradeSeq : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(jobGradeSeq > (Integer)seqPair.getValue() ? jobGradeSeq : (Integer)seqPair.getValue()));
            }
            DynamicObject[] stpositionObjs = this.getStPositionObjByGradeScmIdFromCache(stPositionNode.getNodeEntityDataObjCache(), gradeScmMinMaxSeq.keySet());
            if (stpositionObjs == null) {
                stpositionObjs = this.stpositionServiceHelper.query("id,lowjobgrade,highjobgrade,lowjoblevel,highjoblevel", new QFilter[]{new QFilter("highjobgrade.jobgradescm", "in", gradeScmMinMaxSeq.keySet()), BaseDataHisHelper.getHisCurrFilter()});
                stPositionNode.cacheEntityDataObj(stpositionObjs);
            }
            HashSet jobIds = Sets.newHashSetWithExpectedSize((int)stpositionObjs.length);
            for (DynamicObject stposition : stpositionObjs) {
                int lowSeq = stposition.getInt("lowjobgrade.jobgradeseq");
                Long jobGradeScm = stposition.getLong("lowjobgrade.jobgradescm.id");
                int highSeq = stposition.getInt("highjobgrade.jobgradeseq");
                Pair gradeRange = (Pair)gradeScmMinMaxSeq.get(jobGradeScm);
                if (gradeRange == null || lowSeq > (Integer)gradeRange.getKey() || highSeq < (Integer)gradeRange.getValue()) continue;
                Long jobId = stposition.getLong("id");
                jobIds.add(jobId);
            }
            resultQFilter = new QFilter("id", "in", (Object)jobIds);
            if (jobIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

