/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.constraint.graph.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hcdm.business.salarystandard.constraint.graph.AbstractGraphHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ComplexConstraintHandler;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ConstraintGraphCalculator;
import kd.swc.hcdm.business.salarystandard.constraint.graph.ContrastConstraintHelper;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphEdge;
import kd.swc.hcdm.business.salarystandard.constraint.graph.GraphNode;
import kd.swc.hcdm.common.entity.Pair;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.MapUtils;

public class StPositionToJobLevelHandler
extends AbstractGraphHandler
implements ComplexConstraintHandler {
    private static final String ENTITY_STPOSITION = "hbpm_stposition";
    private static final String ENTITY_JOBLEVEL = "hbjm_joblevelhr";
    private SWCDataServiceHelper stpositionServiceHelper = new SWCDataServiceHelper("hbpm_stposition");
    private SWCDataServiceHelper jobLevelServiceHelper = new SWCDataServiceHelper("hbjm_joblevelhr");
    private Map<Long, Map<Long, DynamicObject>> levelScmIdToStPositionObjMap = Maps.newHashMap();

    private DynamicObject[] getStPositionObjByLevelScmIdFromCache(Map<Long, DynamicObject> nodeEntityDataObjCache, Collection<Long> levelScmIds) {
        for (DynamicObject obj : nodeEntityDataObjCache.values()) {
            Map map = this.levelScmIdToStPositionObjMap.computeIfAbsent(obj.getLong("highjoblevel.joblevelscm.id"), o1 -> Maps.newHashMap());
            map.putIfAbsent(obj.getLong("id"), obj);
        }
        if (levelScmIds == null) {
            return null;
        }
        if (this.levelScmIdToStPositionObjMap.keySet().containsAll(levelScmIds)) {
            ArrayList resultList = Lists.newArrayListWithExpectedSize((int)levelScmIds.size());
            for (Long aLong : levelScmIds) {
                Map<Long, DynamicObject> map = this.levelScmIdToStPositionObjMap.get(aLong);
                if (!MapUtils.isNotEmpty(map)) continue;
                resultList.addAll(map.values());
            }
            return resultList.toArray(new DynamicObject[0]);
        }
        return null;
    }

    @Override
    public QFilter getConstraintFilter(GraphEdge edge) {
        GraphNode stPositionNode = edge.getSourceNode();
        QFilter resultQFilter = null;
        if (ENTITY_STPOSITION.equals(stPositionNode.getEntityNumber())) {
            List<Long> stpositionIds = stPositionNode.getDataSet();
            DynamicObject[] stPositionObjs = stPositionNode.getEntityDataObjsFromCache(stpositionIds);
            if (stPositionObjs == null) {
                stPositionObjs = this.stpositionServiceHelper.query("id,lowjobgrade,highjobgrade,lowjoblevel,highjoblevel", new QFilter[]{new QFilter("id", "in", stpositionIds), BaseDataHisHelper.getHisCurrFilter()});
                stPositionNode.cacheEntityDataObj(stPositionObjs);
            }
            HashMap levelScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)stPositionObjs.length);
            for (DynamicObject stposition : stPositionObjs) {
                if (stposition.getDynamicObject("lowjoblevel") == null) continue;
                int lowSeq = stposition.getInt("lowjoblevel.joblevelseq");
                Long jobLevelScm = stposition.getLong("lowjoblevel.joblevelscm.id");
                int highSeq = stposition.getInt("highjoblevel.joblevelseq");
                Pair seqPair = (Pair)levelScmMinMaxSeq.get(jobLevelScm);
                if (seqPair == null) {
                    levelScmMinMaxSeq.put(jobLevelScm, Pair.create((Object)lowSeq, (Object)highSeq));
                    continue;
                }
                seqPair.setKey((Object)(lowSeq < (Integer)seqPair.getKey() ? Integer.valueOf(lowSeq) : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(highSeq > (Integer)seqPair.getValue() ? Integer.valueOf(highSeq) : (Integer)seqPair.getValue()));
            }
            resultQFilter = ContrastConstraintHelper.createQFilterByScmSeqForGradeLevel(levelScmMinMaxSeq, false);
            if (levelScmMinMaxSeq.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }

    @Override
    public QFilter getInverseConstraintFilter(GraphEdge edge) {
        GraphNode stPositionNode = edge.getSourceNode();
        GraphNode jobLevelNode = edge.getTargetNode();
        QFilter resultQFilter = null;
        if (ENTITY_JOBLEVEL.equals(jobLevelNode.getEntityNumber())) {
            List<Long> jobLevelIdSet = jobLevelNode.getDataSet();
            DynamicObject[] jobLevelObjs = jobLevelNode.getEntityDataObjsFromCache(jobLevelIdSet);
            if (jobLevelObjs == null) {
                jobLevelObjs = this.jobLevelServiceHelper.query("id,joblevelseq,joblevelscm", new QFilter[]{new QFilter("id", "in", jobLevelIdSet)});
                jobLevelNode.cacheEntityDataObj(jobLevelObjs);
            }
            HashMap levelScmMinMaxSeq = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject jobLevelObj : jobLevelObjs) {
                long scmId = jobLevelObj.getLong("joblevelscm.id");
                Integer jobLevelSeq = jobLevelObj.getInt("joblevelseq");
                Pair seqPair = (Pair)levelScmMinMaxSeq.get(scmId);
                if (seqPair == null) {
                    levelScmMinMaxSeq.put(scmId, Pair.create((Object)jobLevelSeq, (Object)jobLevelSeq));
                    continue;
                }
                seqPair.setKey((Object)(jobLevelSeq < (Integer)seqPair.getKey() ? jobLevelSeq : (Integer)seqPair.getKey()));
                seqPair.setValue((Object)(jobLevelSeq > (Integer)seqPair.getValue() ? jobLevelSeq : (Integer)seqPair.getValue()));
            }
            DynamicObject[] stpositionObjs = this.getStPositionObjByLevelScmIdFromCache(stPositionNode.getNodeEntityDataObjCache(), levelScmMinMaxSeq.keySet());
            if (stpositionObjs == null) {
                stpositionObjs = this.stpositionServiceHelper.query("id,lowjobgrade,highjobgrade,lowjoblevel,highjoblevel", new QFilter[]{new QFilter("highjoblevel.joblevelscm", "in", levelScmMinMaxSeq.keySet()), BaseDataHisHelper.getHisCurrFilter()});
                stPositionNode.cacheEntityDataObj(stpositionObjs);
            }
            HashSet jobIds = Sets.newHashSetWithExpectedSize((int)stpositionObjs.length);
            for (DynamicObject stposition : stpositionObjs) {
                int lowSeq = stposition.getInt("lowjoblevel.joblevelseq");
                Long jobLevelScm = stposition.getLong("lowjoblevel.joblevelscm.id");
                int highSeq = stposition.getInt("highjoblevel.joblevelseq");
                Pair gradeRange = (Pair)levelScmMinMaxSeq.get(jobLevelScm);
                if (gradeRange == null || lowSeq > (Integer)gradeRange.getKey() || highSeq < (Integer)gradeRange.getValue()) continue;
                Long jobId = stposition.getLong("id");
                jobIds.add(jobId);
            }
            resultQFilter = new QFilter("id", "in", (Object)jobIds);
            if (jobIds.isEmpty()) {
                resultQFilter = ConstraintGraphCalculator.getNOTFilter();
            }
        } else {
            throw new KDBizException(String.format(Locale.ROOT, "please check hcdm_constraintedge config, edge name = [%s]", edge.getName()));
        }
        return resultQFilter;
    }
}

