/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.grid;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.SalaryStandardSerializationUtils;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.ContrastGridViewHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardCacheHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStandardViewHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.common.entity.salarystandard.ContrastDataQueryParam;

public class ContrastDataPrepareContext {
    DynamicObjectCollection rows;
    SalaryStandardEntryData stdData;
    Map<Long, List<Long>> propFilterParam;
    Map<Long, List<QFilter>> previewQFilterMap;
    Map<Long, Map<Long, DynamicObject>> dbData;
    DynamicObject currencyFromDb;
    Map<Long, SalaryGradeEntity> gradeEntityMap;
    Map<Long, SalaryRankEntity> rankEntityMap;
    Map<GradeRankKey, Map<String, BigDecimal>> stdDataMap;
    IFormView mainView;
    IFormView gridView;
    ContrastDataQueryParam queryParam;
    Map<Long, Map<String, BigDecimal>> dataMap;
    Map<Long, SalaryStdItemEntity> itemMap;

    public ContrastDataPrepareContext(IFormView mainView, IFormView gridView, String gridType) {
        this.mainView = mainView;
        this.gridView = gridView;
        DynamicObject dataEntity = new DynamicObject((DynamicObjectType)gridView.getModel().getDataEntityType());
        this.rows = dataEntity.getDynamicObjectCollection("entryentity");
        this.stdData = SalaryStandardCacheHelper.getEntryData(mainView.getPageId());
        String filterParam = (String)gridView.getFormShowParameter().getCustomParam("contrastFilterParam");
        this.queryParam = SalaryStandardSerializationUtils.fromJsonString(filterParam, ContrastDataQueryParam.class);
        this.propFilterParam = this.queryParam == null ? null : this.queryParam.getPropValues();
        this.previewQFilterMap = ContrastGridViewHelper.getPreviewQFilterWithExt(this.stdData.getContrastPropEntities().stream().map(ContrastPropEntity::getPropConfigEntity).collect(Collectors.toList()), mainView);
        this.currencyFromDb = SalaryStandardViewHelper.queryCurrencyFromDb(this.stdData.getStdBaseEntity().getCurrencyId());
        this.gradeEntityMap = GradeRankHelper.groupByGradeIdentity(this.stdData.getGradeEntities());
        this.rankEntityMap = GradeRankHelper.groupByRankIdentity(this.stdData.getRankEntities());
        this.itemMap = SalaryStdItemHelper.groupBySalaryItemId(this.stdData.getItemEntities());
        if (gridType.equals("hcdm_contrastgrid")) {
            Map<GradeRankKey, List<SalaryStdDataEntity>> gradeRankDataMap = SalaryStdDataHelper.groupByGradeRankKey(this.stdData.getStdDataEntities(), this.gradeEntityMap, this.rankEntityMap);
            this.stdDataMap = SalaryStdDataHelper.groupDataForTabularFieldKey(gradeRankDataMap);
        } else {
            Map<Long, List<SalaryStdDataEntity>> gradeDataMap = SalaryStdDataHelper.groupByGrade(this.stdData.getStdDataEntities());
            List<SalaryGradeEntity> gradeEntities = GradeRankHelper.sortGradeList(this.stdData.getGradeEntities(), this.stdData.getDisplayParam().getDisplaySalaryGradeSort());
            this.dataMap = SalaryStdDataHelper.groupDataForGroupItemFieldKey(gradeDataMap, gradeEntities);
        }
        List contrastPropEntities = this.stdData.getContrastPropEntities();
        List contrastRowEntities = this.stdData.getContrastRowEntities();
        ContrastGridViewHelper.filterContrastRow(contrastRowEntities, contrastPropEntities, this.previewQFilterMap, this.propFilterParam);
        this.dbData = ContrastDataHelper.queryFromDb(contrastPropEntities, contrastRowEntities);
    }

    public Map<Long, SalaryStdItemEntity> getItemMap() {
        return this.itemMap;
    }

    public void setItemMap(Map<Long, SalaryStdItemEntity> itemMap) {
        this.itemMap = itemMap;
    }

    public SalaryStandardEntryData getStdData() {
        return this.stdData;
    }

    public void setStdData(SalaryStandardEntryData stdData) {
        this.stdData = stdData;
    }

    public Map<Long, Map<String, BigDecimal>> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(Map<Long, Map<String, BigDecimal>> dataMap) {
        this.dataMap = dataMap;
    }

    public DynamicObjectCollection getRows() {
        return this.rows;
    }

    public void setRows(DynamicObjectCollection rows) {
        this.rows = rows;
    }

    public SalaryStandardEntryData getStandardEntryData() {
        return this.stdData;
    }

    public void setStandardEntryData(SalaryStandardEntryData standardEntryData) {
        this.stdData = standardEntryData;
    }

    public Map<Long, List<Long>> getPropFilterParam() {
        return this.propFilterParam;
    }

    public void setPropFilterParam(Map<Long, List<Long>> propFilterParam) {
        this.propFilterParam = propFilterParam;
    }

    public Map<Long, List<QFilter>> getPreviewQFilterMap() {
        return this.previewQFilterMap;
    }

    public void setPreviewQFilterMap(Map<Long, List<QFilter>> previewQFilterMap) {
        this.previewQFilterMap = previewQFilterMap;
    }

    public Map<Long, Map<Long, DynamicObject>> getDbData() {
        return this.dbData;
    }

    public void setDbData(Map<Long, Map<Long, DynamicObject>> dbData) {
        this.dbData = dbData;
    }

    public DynamicObject getCurrencyFromDb() {
        return this.currencyFromDb;
    }

    public void setCurrencyFromDb(DynamicObject currencyFromDb) {
        this.currencyFromDb = currencyFromDb;
    }

    public Map<Long, SalaryGradeEntity> getGradeEntityMap() {
        return this.gradeEntityMap;
    }

    public void setGradeEntityMap(Map<Long, SalaryGradeEntity> gradeEntityMap) {
        this.gradeEntityMap = gradeEntityMap;
    }

    public Map<Long, SalaryRankEntity> getRankEntityMap() {
        return this.rankEntityMap;
    }

    public void setRankEntityMap(Map<Long, SalaryRankEntity> rankEntityMap) {
        this.rankEntityMap = rankEntityMap;
    }

    public Map<GradeRankKey, Map<String, BigDecimal>> getStdDataMap() {
        return this.stdDataMap;
    }

    public void setStdDataMap(Map<GradeRankKey, Map<String, BigDecimal>> stdDataMap) {
        this.stdDataMap = stdDataMap;
    }

    public IFormView getMainView() {
        return this.mainView;
    }

    public void setMainView(IFormView mainView) {
        this.mainView = mainView;
    }

    public IFormView getGridView() {
        return this.gridView;
    }

    public void setGridView(IFormView gridView) {
        this.gridView = gridView;
    }

    public ContrastDataQueryParam getQueryParam() {
        return this.queryParam;
    }

    public void setQueryParam(ContrastDataQueryParam queryParam) {
        this.queryParam = queryParam;
    }
}

