/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.grid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.entity.Features;
import kd.bos.entity.Tips;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.IntervalPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdGridDisplayTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.ViewControlParam;
import kd.swc.hcdm.business.converter.DecimalConverter;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.FieldLockStatusMapping;
import kd.swc.hcdm.business.salarystandard.FieldTipsHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.IntervalPropOperationFunction;
import kd.swc.hcdm.business.salarystandard.SalaryStandardViewHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.salarystandard.constraint.EntryFieldConstraintMapping;
import kd.swc.hcdm.business.vo.salarystandard.FieldColumnWidthMapping;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hcdm.common.entity.salarystandard.DynamicCommonFieldIdGenerationParam;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForGroup;
import kd.swc.hcdm.common.entity.salarystandard.DynamicFieldIdGenerationParamForTabular;
import kd.swc.hcdm.common.entity.salarystandard.FixedFieldIdGenerationParam;
import kd.swc.hcdm.common.enums.ItemGroupTypeEnum;
import kd.swc.hsbp.common.dynamic.FieldIdGenerationParam;
import kd.swc.hsbp.common.dynamic.grid.AmountFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.CurrencyFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.DecimalFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainer;
import kd.swc.hsbp.common.dynamic.grid.EntryParamContainerBaseHelper;
import kd.swc.hsbp.common.dynamic.grid.FieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.GroupParamContainer;
import kd.swc.hsbp.common.dynamic.grid.IntegerFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.MulBasedataFieldParamContainer;
import kd.swc.hsbp.common.dynamic.grid.TextFieldParamContainer;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class EntryParamContainerHelper {
    private static final String KEY_QUERY_PANEL = "query_panel";

    public static List<EntryParamContainer> createEntryBuildParamForGroupItem(EntityMetadata entityMetadata, SalaryStandardEntryData stdData) {
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(10);
        CurrencyFieldParamContainer currencyParam = new CurrencyFieldParamContainer();
        currencyParam.setKey("currencyfield");
        currencyParam.setVisible("");
        currencyParam.setEntityMetadata(entityMetadata);
        allContainer.add((EntryParamContainer)currencyParam);
        List itemEntities = stdData.getItemEntities();
        List<SalaryRankEntity> rankEntities = stdData.getRankEntities();
        DisplayParamNew displayParam = stdData.getDisplayParam();
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        List propEntities = stdData.getPropEntities();
        ViewControlParam viewCtrParam = stdData.getViewControlParam();
        Map<ItemGroupTypeEnum, List<SalaryStdItemEntity>> itemEntityMap = SalaryStdItemHelper.groupByItemType(itemEntities);
        rankEntities = GradeRankHelper.sortRankList(rankEntities, displayParam.getDisplaySalaryRankSort());
        TextFieldParamContainer gradeContainer = EntryParamContainerHelper.createGradeContainer(entityMetadata, SalaryStdGridDisplayTypeEnum.GROUPITEMS);
        allContainer.add((EntryParamContainer)gradeContainer);
        IntervalPropOperationFunction propOperationFunction = IntervalPropOperationFunction.getInstance();
        FieldLockStatusMapping fieldLockStatusMapping = FieldLockStatusMapping.getInstance();
        FieldTipsHelper fieldTipsHelper = FieldTipsHelper.getInstance();
        FieldColumnWidthMapping fieldColumnWidthMapping = FieldColumnWidthMapping.getInstance();
        EntryFieldConstraintMapping constraintMapping = new EntryFieldConstraintMapping();
        for (Map.Entry<ItemGroupTypeEnum, List<SalaryStdItemEntity>> itemEntityEntry : itemEntityMap.entrySet()) {
            ItemGroupTypeEnum groupType = itemEntityEntry.getKey();
            List<SalaryStdItemEntity> salaryStdItemEntities = itemEntityEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)itemEntityEntry.getValue())) continue;
            GroupParamContainer topContainer = null;
            if (groupType == ItemGroupTypeEnum.FIXED || groupType == ItemGroupTypeEnum.UNFIXED) {
                GroupParamContainer fixContainer = new GroupParamContainer();
                fixContainer.setKey(String.format("%s_%s", "dgdg", groupType.name()));
                fixContainer.setName(groupType.getI18nName().loadKDString());
                fixContainer.setHidden(false);
                fixContainer.setEntityMetadata(entityMetadata);
                fixContainer.setTextAlign("center");
                topContainer = fixContainer;
                allContainer.add((EntryParamContainer)fixContainer);
            } else {
                topContainer = null;
            }
            for (SalaryStdItemEntity salaryStdItemEntity : salaryStdItemEntities) {
                GroupParamContainer itemAsGroup;
                List<SalaryRankEntity> rankList = GradeRankHelper.getInstance().getDisplayRankForGroupItemWithExt(stdBaseEntity, salaryStdItemEntity, rankEntities);
                if (CollectionUtils.isEmpty(rankList)) continue;
                Tips tips = fieldTipsHelper.getSalaryStdItemTips(salaryStdItemEntity, stdData.getStdBaseEntity());
                List<IntervalPropEntity> propEntityListOfStandard = propOperationFunction.getIntervalPropWithExtForStdRank(stdBaseEntity, salaryStdItemEntity, displayParam.getDisplayOnlySalaryCount(), propEntities);
                boolean itemIsVisible = DisplayParamHelper.getItemVisibleFlagByDisplayParam(salaryStdItemEntity, displayParam);
                if (rankList.size() == 1 && rankList.get(0).getRankIsUserSet() == 0) {
                    if (propEntityListOfStandard.size() == 1) {
                        DecimalFieldParamContainer createParamContainerByRank = EntryParamContainerHelper.createParamContainerByItemForGroupItems(stdBaseEntity, salaryStdItemEntity, rankList.get(0), viewCtrParam, propEntityListOfStandard.get(0), entityMetadata, currencyParam.getOrGenKey(), itemIsVisible, tips, constraintMapping, fieldLockStatusMapping, fieldColumnWidthMapping);
                        EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)topContainer, (EntryParamContainer)createParamContainerByRank);
                        continue;
                    }
                    itemAsGroup = EntryParamContainerBaseHelper.createGroupParamContainer((String)EntryParamContainerHelper.genGroupParamContainerKey(salaryStdItemEntity.getItemIdentity().toString()), (String)salaryStdItemEntity.getItemName(), (!itemIsVisible ? 1 : 0) != 0);
                    itemAsGroup.setTextAlign("center");
                    EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)topContainer, (EntryParamContainer)itemAsGroup);
                    for (IntervalPropEntity intervalPropEntity : propEntityListOfStandard) {
                        DecimalFieldParamContainer container = EntryParamContainerHelper.createParamContainerByIntervalForGroupItems(stdBaseEntity, salaryStdItemEntity, rankList.get(0), intervalPropEntity, viewCtrParam, entityMetadata, currencyParam.getOrGenKey(), itemIsVisible, null, constraintMapping, fieldLockStatusMapping, fieldColumnWidthMapping);
                        EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)itemAsGroup, (EntryParamContainer)container);
                    }
                    continue;
                }
                itemAsGroup = EntryParamContainerBaseHelper.createGroupParamContainer((String)EntryParamContainerHelper.genGroupParamContainerKey(salaryStdItemEntity.getItemIdentity().toString()), (String)salaryStdItemEntity.getItemName(), (!itemIsVisible ? 1 : 0) != 0);
                itemAsGroup.setTextAlign("center");
                EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)topContainer, (EntryParamContainer)itemAsGroup);
                for (SalaryRankEntity rankEntity : rankList) {
                    boolean rankVisible = itemIsVisible ? DisplayParamHelper.getRankVisibleFlagByDisplayParam(rankEntity, displayParam) : itemIsVisible;
                    List<IntervalPropEntity> propList = propEntityListOfStandard;
                    if (rankEntity.getRankLabel() == SalaryRankLabelEnum.SPECIAL) {
                        propList = propOperationFunction.getIntervalPropWithExtForSpecialRank(stdBaseEntity, salaryStdItemEntity, rankEntity, displayParam.getDisplayOnlySalaryCount(), propEntities);
                    }
                    if (propList.size() == 1) {
                        DecimalFieldParamContainer createParamContainerByRank = EntryParamContainerHelper.createParamContainerByRankForGroupItems(stdBaseEntity, salaryStdItemEntity, rankEntity, viewCtrParam, propList.get(0), entityMetadata, currencyParam.getOrGenKey(), rankVisible, tips, constraintMapping, fieldLockStatusMapping, fieldColumnWidthMapping);
                        EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)itemAsGroup, (EntryParamContainer)createParamContainerByRank);
                        continue;
                    }
                    boolean rankAsGroupVisible = DisplayParamHelper.getItemVisibleFlagByDisplayParam(salaryStdItemEntity, displayParam);
                    GroupParamContainer rankAsGroup = EntryParamContainerBaseHelper.createGroupParamContainer((String)EntryParamContainerHelper.genGroupParamContainerKey(salaryStdItemEntity.getItemIdentity().toString()), (String)rankEntity.getRankName(), (!rankVisible ? 1 : 0) != 0);
                    rankAsGroup.setTextAlign("center");
                    EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)itemAsGroup, (EntryParamContainer)rankAsGroup);
                    for (IntervalPropEntity intervalPropEntity : propList) {
                        DecimalFieldParamContainer container = EntryParamContainerHelper.createParamContainerByIntervalForGroupItems(stdBaseEntity, salaryStdItemEntity, rankEntity, intervalPropEntity, viewCtrParam, entityMetadata, currencyParam.getOrGenKey(), itemIsVisible, tips, constraintMapping, fieldLockStatusMapping, fieldColumnWidthMapping);
                        EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)rankAsGroup, (EntryParamContainer)container);
                    }
                }
            }
        }
        return allContainer;
    }

    private static DecimalFieldParamContainer createParamContainerByItemForGroupItems(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, SalaryRankEntity rank, ViewControlParam viewCtrParam, IntervalPropEntity intervalPropEntity, EntityMetadata entityMetadata, String currencyFieldId, boolean isVisible, Tips tips, EntryFieldConstraintMapping constraintMapping, FieldLockStatusMapping fieldLockStatusMapping, FieldColumnWidthMapping fieldColumnWidthMapping) {
        String fieldType = constraintMapping.getFieldTypeHelper().getFieldTypeForGroupItemWithExt(stdBaseEntity.getType(), item, rank, intervalPropEntity.getIntervalPropIndex());
        DynamicFieldIdGenerationParamForGroup idGenParam = new DynamicFieldIdGenerationParamForGroup("dgdf", SalaryStdGridDisplayTypeEnum.GROUPITEMS, fieldType, item.getItemIdentity(), rank.getRankIdentity(), intervalPropEntity.getIntervalPropIndex());
        Boolean defaultLockState = fieldLockStatusMapping.checkForGroupItem(stdBaseEntity, item, rank, intervalPropEntity.getIntervalPropIndex(), stdBaseEntity.getCalcMethod());
        String lock = SalaryStandardViewHelper.getFieldLockStatus(viewCtrParam.getCanEdit(), defaultLockState, intervalPropEntity.getNeedLock());
        boolean light = SalaryStandardViewHelper.checkFieldHighLight(viewCtrParam.getCanEdit(), defaultLockState, intervalPropEntity.getNeedLock());
        String bgColor = light ? "rgba(85,130,243,0.1)" : "";
        String width = fieldColumnWidthMapping.getFieldColWidthForGroupItemExt(stdBaseEntity.getType(), item, rank, intervalPropEntity.getIntervalPropIndex());
        Features features = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        features.setExportable(true);
        if (!light) {
            features.setImportable(true);
        }
        DecimalConverter converter = constraintMapping.getConstraintWithCache(stdBaseEntity, item, rank, intervalPropEntity.getIntervalPropIndex());
        switch (fieldType) {
            case "decimalfield": {
                DecimalFieldParamContainer decimalContainer = new DecimalFieldParamContainer();
                EntryParamContainerHelper.setDecimalFieldValue(decimalContainer, (FieldIdGenerationParam)idGenParam, item.getItemName(), lock, bgColor, width, !isVisible, "", entityMetadata, tips, features);
                decimalContainer.setPrecision(converter.getPrecision());
                decimalContainer.setScale(converter.getScale());
                return decimalContainer;
            }
            case "amountfield": {
                AmountFieldParamContainer amountContainer = new AmountFieldParamContainer();
                EntryParamContainerHelper.setDecimalFieldValue((DecimalFieldParamContainer)amountContainer, (FieldIdGenerationParam)idGenParam, item.getItemName(), lock, bgColor, width, !isVisible, "", entityMetadata, tips, features);
                amountContainer.setCurrencyFieldId(currencyFieldId);
                amountContainer.setPrecision(converter.getPrecision());
                amountContainer.setScale(converter.getScale());
                return amountContainer;
            }
        }
        return null;
    }

    private static DecimalFieldParamContainer createParamContainerByRankForGroupItems(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, SalaryRankEntity rank, ViewControlParam viewCtrParam, IntervalPropEntity intervalPropEntity, EntityMetadata entityMetadata, String currencyFieldId, boolean isVisible, Tips tips, EntryFieldConstraintMapping constraintMapping, FieldLockStatusMapping fieldLockStatusMapping, FieldColumnWidthMapping fieldColumnWidthMapping) {
        String fieldType = constraintMapping.getFieldTypeHelper().getFieldTypeForGroupItemWithExt(stdBaseEntity.getType(), item, rank, intervalPropEntity.getIntervalPropIndex());
        DynamicFieldIdGenerationParamForGroup idGenParam = new DynamicFieldIdGenerationParamForGroup("dgdf", SalaryStdGridDisplayTypeEnum.GROUPITEMS, fieldType, item.getItemIdentity(), rank.getRankIdentity(), intervalPropEntity.getIntervalPropIndex());
        Boolean defaultLockState = fieldLockStatusMapping.checkForGroupItem(stdBaseEntity, item, rank, intervalPropEntity.getIntervalPropIndex(), stdBaseEntity.getCalcMethod());
        String lock = SalaryStandardViewHelper.getFieldLockStatus(viewCtrParam.getCanEdit(), defaultLockState, intervalPropEntity.getNeedLock());
        boolean light = SalaryStandardViewHelper.checkFieldHighLight(viewCtrParam.getCanEdit(), defaultLockState, intervalPropEntity.getNeedLock());
        String bgColor = light ? "rgba(85,130,243,0.1)" : "";
        String width = fieldColumnWidthMapping.getFieldColWidthForGroupItemExt(stdBaseEntity.getType(), item, rank, intervalPropEntity.getIntervalPropIndex());
        Features features = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        features.setExportable(true);
        if (!light) {
            features.setImportable(true);
        }
        DecimalConverter converter = constraintMapping.getConstraintWithCache(stdBaseEntity, item, rank, intervalPropEntity.getIntervalPropIndex());
        switch (fieldType) {
            case "decimalfield": {
                DecimalFieldParamContainer decimalContainer = new DecimalFieldParamContainer();
                EntryParamContainerHelper.setDecimalFieldValue(decimalContainer, (FieldIdGenerationParam)idGenParam, rank.getRankName(), lock, bgColor, width, !isVisible, "", entityMetadata, tips, features);
                decimalContainer.setPrecision(converter.getPrecision());
                decimalContainer.setScale(converter.getScale());
                return decimalContainer;
            }
            case "amountfield": {
                AmountFieldParamContainer amountContainer = new AmountFieldParamContainer();
                EntryParamContainerHelper.setDecimalFieldValue((DecimalFieldParamContainer)amountContainer, (FieldIdGenerationParam)idGenParam, rank.getRankName(), lock, bgColor, width, !isVisible, "", entityMetadata, tips, features);
                amountContainer.setCurrencyFieldId(currencyFieldId);
                amountContainer.setPrecision(converter.getPrecision());
                amountContainer.setScale(converter.getScale());
                return amountContainer;
            }
        }
        return null;
    }

    private static DecimalFieldParamContainer createParamContainerByIntervalForGroupItems(SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, SalaryRankEntity rank, IntervalPropEntity intervalPropEntity, ViewControlParam viewCtrParam, EntityMetadata entityMetadata, String currencyFieldId, boolean isVisible, Tips tips, EntryFieldConstraintMapping constraintMapping, FieldLockStatusMapping fieldLockStatusMapping, FieldColumnWidthMapping fieldColumnWidthMapping) {
        String fieldType = constraintMapping.getFieldTypeHelper().getFieldTypeForGroupItemWithExt(stdBaseEntity.getType(), item, rank, intervalPropEntity.getIntervalPropIndex());
        DynamicFieldIdGenerationParamForGroup idGenParam = new DynamicFieldIdGenerationParamForGroup("dgdf", SalaryStdGridDisplayTypeEnum.GROUPITEMS, fieldType, item.getItemIdentity(), rank.getRankIdentity(), intervalPropEntity.getIntervalPropIndex());
        Boolean defaultLockState = fieldLockStatusMapping.checkForGroupItem(stdBaseEntity, item, rank, intervalPropEntity.getIntervalPropIndex(), stdBaseEntity.getCalcMethod());
        String lock = SalaryStandardViewHelper.getFieldLockStatus(viewCtrParam.getCanEdit(), defaultLockState, intervalPropEntity.getNeedLock());
        boolean light = SalaryStandardViewHelper.checkFieldHighLight(viewCtrParam.getCanEdit(), defaultLockState, intervalPropEntity.getNeedLock());
        String bgColor = light ? "rgba(85,130,243,0.1)" : "";
        String width = fieldColumnWidthMapping.getFieldColWidthForGroupItemExt(stdBaseEntity.getType(), item, rank, intervalPropEntity.getIntervalPropIndex());
        Features features = EntryParamContainerBaseHelper.createInitFeature((boolean)false);
        features.setExportable(true);
        if (!light) {
            features.setImportable(true);
        }
        DecimalConverter converter = constraintMapping.getConstraintWithCache(stdBaseEntity, item, rank, intervalPropEntity.getIntervalPropIndex());
        switch (fieldType) {
            case "decimalfield": {
                DecimalFieldParamContainer decimalContainer = new DecimalFieldParamContainer();
                EntryParamContainerHelper.setDecimalFieldValue(decimalContainer, (FieldIdGenerationParam)idGenParam, intervalPropEntity.getIntervalPropDisplayName(), lock, bgColor, width, !isVisible, "", entityMetadata, tips, features);
                decimalContainer.setPrecision(converter.getPrecision());
                decimalContainer.setScale(converter.getScale());
                return decimalContainer;
            }
            case "amountfield": {
                AmountFieldParamContainer amountContainer = new AmountFieldParamContainer();
                EntryParamContainerHelper.setDecimalFieldValue((DecimalFieldParamContainer)amountContainer, (FieldIdGenerationParam)idGenParam, intervalPropEntity.getIntervalPropDisplayName(), lock, bgColor, width, !isVisible, "", entityMetadata, tips, features);
                amountContainer.setCurrencyFieldId(currencyFieldId);
                amountContainer.setPrecision(converter.getPrecision());
                amountContainer.setScale(converter.getScale());
                return amountContainer;
            }
        }
        return null;
    }

    private static DecimalFieldParamContainer createParamContainerByIntervalPropForTabular(String displayName, SalaryStandardBaseEntity stdBaseEntity, SalaryStdItemEntity item, ViewControlParam viewCtrParam, IntervalPropEntity intervalPropEntity, EntityMetadata entityMetadata, String currencyFieldId, boolean isVisible, Tips tips, EntryFieldConstraintMapping constraintMapping, FieldLockStatusMapping fieldLockStatusMapping) {
        String fieldType = constraintMapping.getFieldTypeHelper().getFieldTypeForTabularWithExt(stdBaseEntity.getType(), item, intervalPropEntity.getIntervalPropIndex());
        DynamicFieldIdGenerationParamForTabular idGenParam = new DynamicFieldIdGenerationParamForTabular("dgdf", SalaryStdGridDisplayTypeEnum.TABULAR, fieldType, item.getItemIdentity(), intervalPropEntity.getIntervalPropIndex());
        String lock = SalaryStandardViewHelper.getFieldLockStatus(viewCtrParam.getCanEdit(), fieldLockStatusMapping.checkForTabular(stdBaseEntity, item, intervalPropEntity.getIntervalPropIndex(), stdBaseEntity.getCalcMethod()), intervalPropEntity.getNeedLock());
        Features features = new Features();
        DecimalConverter converter = (DecimalConverter)constraintMapping.getConverterWithExt(stdBaseEntity, item, null, intervalPropEntity.getIntervalPropIndex());
        switch (fieldType) {
            case "decimalfield": {
                DecimalFieldParamContainer decimalContainer = new DecimalFieldParamContainer();
                EntryParamContainerHelper.setDecimalFieldValue(decimalContainer, (FieldIdGenerationParam)idGenParam, displayName, lock, "", "", !isVisible, "", entityMetadata, tips, features);
                decimalContainer.setPrecision(converter.getPrecision());
                decimalContainer.setScale(converter.getScale());
                return decimalContainer;
            }
            case "amountfield": {
                AmountFieldParamContainer amountContainer = new AmountFieldParamContainer();
                EntryParamContainerHelper.setDecimalFieldValue((DecimalFieldParamContainer)amountContainer, (FieldIdGenerationParam)idGenParam, displayName, lock, "", "", !isVisible, "", entityMetadata, tips, features);
                amountContainer.setCurrencyFieldId(currencyFieldId);
                amountContainer.setPrecision(converter.getPrecision());
                amountContainer.setScale(converter.getScale());
                return amountContainer;
            }
        }
        return null;
    }

    public static List<EntryParamContainer> createEntryBuildParamForTabular(EntityMetadata entityMetadata, SalaryStandardEntryData stdData) {
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(10);
        CurrencyFieldParamContainer currencyParam = new CurrencyFieldParamContainer();
        currencyParam.setKey("currencyfield");
        currencyParam.setVisible("");
        currencyParam.setEntityMetadata(entityMetadata);
        allContainer.add((EntryParamContainer)currencyParam);
        List itemEntities = stdData.getItemEntities();
        DisplayParamNew displayParam = stdData.getDisplayParam();
        SalaryStandardBaseEntity stdBaseEntity = stdData.getStdBaseEntity();
        List propEntities = stdData.getPropEntities();
        ViewControlParam viewCtrParam = stdData.getViewControlParam();
        Map<ItemGroupTypeEnum, List<SalaryStdItemEntity>> itemEntityMap = SalaryStdItemHelper.groupByItemType(itemEntities);
        TextFieldParamContainer gradeContainer = EntryParamContainerHelper.createGradeContainer(entityMetadata, SalaryStdGridDisplayTypeEnum.TABULAR);
        allContainer.add((EntryParamContainer)gradeContainer);
        TextFieldParamContainer rankContainer = EntryParamContainerHelper.createRankContainer(entityMetadata);
        rankContainer.setHidden(!stdData.getStdBaseEntity().isUseSalaryRank());
        allContainer.add((EntryParamContainer)rankContainer);
        EntryFieldConstraintMapping constraintMapping = new EntryFieldConstraintMapping();
        IntervalPropOperationFunction intervalPropOperationFunction = IntervalPropOperationFunction.getInstance();
        FieldLockStatusMapping fieldLockStatusMapping = FieldLockStatusMapping.getInstance();
        FieldTipsHelper fieldTipsHelper = FieldTipsHelper.getInstance();
        for (Map.Entry<ItemGroupTypeEnum, List<SalaryStdItemEntity>> itemEntityEntry : itemEntityMap.entrySet()) {
            ItemGroupTypeEnum groupType = itemEntityEntry.getKey();
            List<SalaryStdItemEntity> salaryStdItemEntities = itemEntityEntry.getValue();
            if (CollectionUtils.isEmpty(salaryStdItemEntities)) continue;
            GroupParamContainer topContainer = null;
            if (groupType == ItemGroupTypeEnum.FIXED || groupType == ItemGroupTypeEnum.UNFIXED) {
                GroupParamContainer fixContainer = new GroupParamContainer();
                fixContainer.setKey(String.format("%s_%s", "dgdg", groupType.name()));
                fixContainer.setName(groupType.getI18nName().loadKDString());
                fixContainer.setHidden(false);
                fixContainer.setTextAlign("center");
                topContainer = fixContainer;
                allContainer.add((EntryParamContainer)fixContainer);
            } else {
                topContainer = null;
            }
            for (SalaryStdItemEntity itemEntity : salaryStdItemEntities) {
                List<IntervalPropEntity> propEntityList = intervalPropOperationFunction.getIntervalPropWithExtForStdRank(stdBaseEntity, itemEntity, displayParam.getDisplayOnlySalaryCount(), propEntities);
                boolean isVisible = DisplayParamHelper.getItemVisibleFlagByDisplayParam(itemEntity, displayParam);
                if (!isVisible) continue;
                Tips tips = fieldTipsHelper.getSalaryStdItemTips(itemEntity, stdBaseEntity);
                if (propEntityList.size() == 1) {
                    DecimalFieldParamContainer paramContainer = EntryParamContainerHelper.createParamContainerByIntervalPropForTabular(itemEntity.getItemName(), stdBaseEntity, itemEntity, viewCtrParam, propEntityList.get(0), entityMetadata, currencyParam.getOrGenKey(), isVisible, tips, constraintMapping, fieldLockStatusMapping);
                    EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)topContainer, (EntryParamContainer)paramContainer);
                    continue;
                }
                GroupParamContainer itemAsGroup = EntryParamContainerBaseHelper.createGroupParamContainer((String)EntryParamContainerHelper.genGroupParamContainerKey(itemEntity.getItemIdentity().toString()), (String)itemEntity.getItemName(), (!isVisible ? 1 : 0) != 0);
                itemAsGroup.setTextAlign("center");
                EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)topContainer, (EntryParamContainer)itemAsGroup);
                for (IntervalPropEntity propEntity : propEntityList) {
                    DecimalFieldParamContainer paramContainer = EntryParamContainerHelper.createParamContainerByIntervalPropForTabular(propEntity.getIntervalPropDisplayName(), stdBaseEntity, itemEntity, viewCtrParam, propEntity, entityMetadata, currencyParam.getOrGenKey(), isVisible, null, constraintMapping, fieldLockStatusMapping);
                    EntryParamContainerBaseHelper.addChild(allContainer, (GroupParamContainer)itemAsGroup, (EntryParamContainer)paramContainer);
                }
            }
        }
        return allContainer;
    }

    public static List<EntryParamContainer> createMulBaseParamForContrast(EntityMetadata entityMetadata, List<ContrastPropEntity> contrastPropEntities) {
        ArrayList<ContrastPropEntity> contrastPropEntitiesTemp = new ArrayList<ContrastPropEntity>(contrastPropEntities);
        Collections.sort(contrastPropEntitiesTemp, Comparator.comparingInt(ContrastPropEntity::getPropIndex));
        ArrayList<EntryParamContainer> mulBaseParamForContrast = new ArrayList<EntryParamContainer>(contrastPropEntitiesTemp.size());
        for (ContrastPropEntity contrastPropEntity : contrastPropEntitiesTemp) {
            MulBasedataFieldParamContainer container = new MulBasedataFieldParamContainer();
            DynamicFieldIdGenerationParamForTabular idGenParam = new DynamicFieldIdGenerationParamForTabular("dgdf", SalaryStdGridDisplayTypeEnum.TABULAR, "mulbasedatafield", contrastPropEntity.getPropConfigId());
            container.setFieldIdGenerationParam((FieldIdGenerationParam)idGenParam);
            container.setName(contrastPropEntity.getPropConfigEntity().getName());
            container.setLock("new,edit,view,submit,audit");
            container.setEntityMetadata(entityMetadata);
            container.setBaseEntityId(contrastPropEntity.getPropConfigEntity().getObjectTypeIId());
            container.setFeatures(new Features());
            container.setDisplayProp("name");
            mulBaseParamForContrast.add((EntryParamContainer)container);
        }
        return mulBaseParamForContrast;
    }

    public static EntryAp createEntryApForTabular(EntityMetadata entityMetadata, SalaryStandardEntryData stdData) {
        List<EntryParamContainer> containers = EntryParamContainerHelper.createEntryBuildParamForTabular(entityMetadata, stdData);
        return EntryParamContainerBaseHelper.createControlAp(containers);
    }

    public static EntryAp createEntryApForGroupItem(EntityMetadata entityMetadata, SalaryStandardEntryData stdData) {
        List<EntryParamContainer> containers = EntryParamContainerHelper.createEntryBuildParamForGroupItem(entityMetadata, stdData);
        return EntryParamContainerBaseHelper.createControlAp(containers);
    }

    public static List<EntryParamContainer> createEntryBuildParamForContrast(EntityMetadata entityMetadata, SalaryStandardBaseEntity stdBaseEntity, List<ContrastPropEntity> contrastPropEntities) {
        ArrayList<EntryParamContainer> allContainer = new ArrayList<EntryParamContainer>(contrastPropEntities.size() + 3);
        Collections.sort(contrastPropEntities, Comparator.comparingInt(ContrastPropEntity::getPropIndex));
        IntegerFieldParamContainer rowIndexFieldParam = EntryParamContainerHelper.createRowIndexFieldParam();
        allContainer.add((EntryParamContainer)rowIndexFieldParam);
        for (ContrastPropEntity contrastPropEntity : contrastPropEntities) {
            MulBasedataFieldParamContainer container = new MulBasedataFieldParamContainer();
            container.setWidth(contrastPropEntity.getPropConfigEntity().getWidth());
            DynamicFieldIdGenerationParamForTabular idGenParam = new DynamicFieldIdGenerationParamForTabular("dgdf", SalaryStdGridDisplayTypeEnum.TABULAR, "mulbasedatafield", contrastPropEntity.getPropConfigId());
            container.setFieldIdGenerationParam((FieldIdGenerationParam)idGenParam);
            container.setName(contrastPropEntity.getPropConfigEntity().getName());
            container.setEntityMetadata(entityMetadata);
            container.setLock("view");
            container.setBaseEntityId(contrastPropEntity.getPropConfigEntity().getObjectTypeIId());
            container.setFeatures(new Features());
            container.setOpenFuzzyQuery(false);
            allContainer.add((EntryParamContainer)container);
        }
        TextFieldParamContainer gradeRankContainer = new TextFieldParamContainer();
        gradeRankContainer.setHyperlink(true);
        gradeRankContainer.setLock("new,edit,view,submit,audit");
        gradeRankContainer.setWidth("100");
        gradeRankContainer.setTextAlign("left");
        gradeRankContainer.setFieldIdGenerationParam((FieldIdGenerationParam)new DynamicCommonFieldIdGenerationParam("dgff", "grade_rank"));
        gradeRankContainer.setName(SalaryStandardConstants.FORM_STATIC_GRADE_RANK_FIELD_NAME());
        gradeRankContainer.setFeatures(new Features());
        gradeRankContainer.setEntityMetadata(entityMetadata);
        allContainer.add((EntryParamContainer)gradeRankContainer);
        TextFieldParamContainer opContainer = new TextFieldParamContainer();
        opContainer.setHyperlink(true);
        opContainer.setLock("new,edit,view,submit,audit");
        opContainer.setWidth("70");
        opContainer.setTextAlign("center");
        opContainer.setFieldIdGenerationParam((FieldIdGenerationParam)new DynamicCommonFieldIdGenerationParam("dgff", "lookup"));
        opContainer.setName(SalaryStandardConstants.FORM_STATIC_OPERATE_FIELD_NAME());
        Features features = new Features();
        features.setExportable(false);
        features.setImportable(false);
        opContainer.setFeatures(features);
        opContainer.setEntityMetadata(entityMetadata);
        allContainer.add((EntryParamContainer)opContainer);
        return allContainer;
    }

    public static IntegerFieldParamContainer createRowIndexFieldParam() {
        IntegerFieldParamContainer rowIndexFieldParam = new IntegerFieldParamContainer();
        rowIndexFieldParam.setFieldIdGenerationParam((FieldIdGenerationParam)new DynamicCommonFieldIdGenerationParam("dgff", "rowindex"));
        rowIndexFieldParam.setName("rowindex");
        rowIndexFieldParam.setControlPropName("rowindex");
        rowIndexFieldParam.setHidden(true);
        return rowIndexFieldParam;
    }

    public static EntryAp createEntryApForContrastRelationSettingGrid(String key) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(key);
        entryAp.setShowSelChexkbox(true);
        entryAp.setShowSeq(true);
        return entryAp;
    }

    public static List<EntryParamContainer> createMulBaseParamForQueryPanel(EntityMetadata entityMetadata, List<ContrastPropEntity> contrastPropEntities) {
        ArrayList<EntryParamContainer> allParams = new ArrayList<EntryParamContainer>(contrastPropEntities.size());
        for (ContrastPropEntity contrastPropEntity : contrastPropEntities) {
            MulBasedataFieldParamContainer param = new MulBasedataFieldParamContainer();
            param.setName(contrastPropEntity.getPropConfigEntity().getName());
            param.setFieldIdGenerationParam((FieldIdGenerationParam)new DynamicCommonFieldIdGenerationParam("dqpdf", contrastPropEntity.getPropConfigId().toString()));
            param.setBaseEntityId(contrastPropEntity.getPropConfigEntity().getObjectTypeIId());
            allParams.add((EntryParamContainer)param);
        }
        return allParams;
    }

    public static FlexPanelAp createPanelAp(List<EntryParamContainer> containers) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(KEY_QUERY_PANEL);
        for (EntryParamContainer entryParamContainer : containers) {
            if (!(entryParamContainer instanceof FieldParamContainer)) continue;
            FieldParamContainer fieldParamContainer = (FieldParamContainer)entryParamContainer;
            EntryFieldAp createFieldAp = fieldParamContainer.createEntryFieldAp();
            EntryParamContainerHelper.setMarginRight(createFieldAp);
            flexPanelAp.getItems().add(createFieldAp);
        }
        return flexPanelAp;
    }

    private static void setMarginRight(EntryFieldAp mulBaseDataFieldAp) {
        Margin margin = new Margin();
        Style style = new Style();
        margin.setRight("70px");
        style.setMargin(margin);
        mulBaseDataFieldAp.setStyle(style);
    }

    public static void setDecimalFieldValue(DecimalFieldParamContainer decimalContainer, FieldIdGenerationParam idGenParam, String name, String lock, String backColor, String width, boolean hidden, String textAlign, EntityMetadata entityMetadata, Tips tips, Features features) {
        EntryParamContainerBaseHelper.setBaseFieldValue((FieldParamContainer)decimalContainer, (FieldIdGenerationParam)idGenParam, (String)name, (String)lock, (String)backColor, (String)width, (boolean)hidden, (String)textAlign, (EntityMetadata)entityMetadata, (Tips)tips, (Features)features);
        decimalContainer.setTextAlign("right");
        decimalContainer.setDataScope(EntryParamContainerHelper.getDataScopeByName(name));
        decimalContainer.setEnableNull(true);
    }

    private static String getDataScopeByName(String name) {
        if (SWCStringUtils.equalsIgnoreCase((String)name, (String)SalaryItemLabelEnum.FIXEDSALARYSCALE.getI18nName().loadKDString())) {
            return "[0,100]";
        }
        return "[0,]";
    }

    public static TextFieldParamContainer createGradeContainer(EntityMetadata entityMetadata, SalaryStdGridDisplayTypeEnum type) {
        TextFieldParamContainer gradeContainer = new TextFieldParamContainer();
        gradeContainer.setFieldIdGenerationParam((FieldIdGenerationParam)new FixedFieldIdGenerationParam("dgff", type, "textfield", "grade"));
        gradeContainer.setName(SalaryStandardConstants.FORM_STATIC_GRADE_FIELD_NAME());
        gradeContainer.setHyperlink(false);
        gradeContainer.setBackColor("");
        gradeContainer.setLock("new,edit,view,submit,audit");
        gradeContainer.setEntityMetadata(entityMetadata);
        gradeContainer.setWidth("60");
        gradeContainer.setFeatures(new Features());
        gradeContainer.setTextAlign("center");
        return gradeContainer;
    }

    public static TextFieldParamContainer createRankContainer(EntityMetadata entityMetadata) {
        TextFieldParamContainer rankContainer = new TextFieldParamContainer();
        rankContainer.setFieldIdGenerationParam((FieldIdGenerationParam)new FixedFieldIdGenerationParam("dgff", SalaryStdGridDisplayTypeEnum.TABULAR, "textfield", "rank"));
        rankContainer.setName(SalaryStandardConstants.FORM_STATIC_RANK_FIELD_NAME());
        rankContainer.setHyperlink(false);
        rankContainer.setBackColor("");
        rankContainer.setLock("new,edit,view,submit,audit");
        rankContainer.setFeatures(new Features());
        rankContainer.setEntityMetadata(entityMetadata);
        rankContainer.setTextAlign("center");
        return rankContainer;
    }

    private static String genGroupParamContainerKey(String groupKey) {
        return String.format("%s_%s", "dgdg", groupKey);
    }
}

