/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.AppliedRangeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.MustInputValidator;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class StdApplyRangeMustInputValidator
extends MustInputValidator<SalaryStandardEntryData> {
    public StdApplyRangeMustInputValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = this.checkInputRangeDataWhenHasType(data.getAppliedRangeEntities());
        return result;
    }

    private ValidateResult checkInputRangeDataWhenHasType(List<AppliedRangeEntity> appliedRangeEntities) {
        ValidateResult result = new ValidateResult(this.getLevel());
        if (appliedRangeEntities == null || appliedRangeEntities.isEmpty()) {
            return result;
        }
        String msgPattern = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5e94\u7528\u8303\u56f4\u201d\u7b2c%s\u884c\uff1a\u201c\u5e94\u7528\u8303\u56f4\u201d\u3002", (String)"StdApplyRangeMustInputValidator_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        for (int i = 0; i < appliedRangeEntities.size(); ++i) {
            for (AppliedRangeEntity rangeEntity : appliedRangeEntities) {
                if (!SWCStringUtils.isNotEmpty((String)rangeEntity.getRangeType()) || !CollectionUtils.isEmpty((Collection)rangeEntity.getRangeIds())) continue;
                result.addErrorMsg(String.format(Locale.ROOT, msgPattern, i + 1));
            }
        }
        return result;
    }

    private String checkNeedInputRangeDataWhenHasType(List<AppliedRangeEntity> appliedRangeEntities) {
        return null;
    }
}

