/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.CompleteValidator;
import org.apache.commons.collections.CollectionUtils;

public class StdContrastPropCompleteValidator
extends CompleteValidator<SalaryStandardEntryData> {
    public StdContrastPropCompleteValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = this.veriContrastDataSetContProp(data.getContrastPropEntities(), data.getContrastRowEntities());
        return result;
    }

    public ValidateResult veriContrastDataSetContProp(List<ContrastPropEntity> contrastPropEntities, List<ContrastRowDataEntity> contrastRows) {
        ValidateResult result = new ValidateResult(this.getLevel());
        if (contrastRows == null || contrastRows.isEmpty()) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5bf9\u7167\u5173\u7cfb\u3002", (String)"SalaryStandardVeriHelper_7", (String)"swc-hcdm-business", (Object[])new Object[0]));
            return result;
        }
        LinkedHashMap<Integer, String> emptyMsgMap = new LinkedHashMap<Integer, String>(16);
        for (ContrastRowDataEntity entry : contrastRows) {
            Map stdPropValueMap = entry.getStdPropValueMap();
            HashSet contIdWhereNotSetValue = Sets.newHashSetWithExpectedSize((int)stdPropValueMap.size());
            for (ContrastPropEntity propEntity : contrastPropEntities) {
                Long propConfigId = propEntity.getPropConfigId();
                List longs = (List)stdPropValueMap.get(propConfigId);
                if (!CollectionUtils.isEmpty((Collection)longs)) continue;
                contIdWhereNotSetValue.add(propConfigId);
            }
            Integer rowIndex = entry.getRowIndex() + 1;
            ArrayList<String> errNameList = new ArrayList<String>(10);
            for (ContrastPropEntity contProp : contrastPropEntities) {
                if (!contIdWhereNotSetValue.contains(contProp.getPropConfigId())) continue;
                errNameList.add(contProp.getPropConfigEntity().getName());
            }
            if (errNameList.isEmpty()) continue;
            StringJoiner sj = new StringJoiner("\uff0c", "\uff08", "\uff09");
            errNameList.forEach(name -> sj.add((CharSequence)name));
            emptyMsgMap.put(rowIndex, sj.toString());
        }
        if (!emptyMsgMap.isEmpty()) {
            result.addErrorMsgs(StdContrastPropCompleteValidator.buildContrastEmptyMsg(emptyMsgMap));
        }
        return result;
    }

    private static List<String> buildContrastEmptyMsg(Map<Integer, String> emptyMsgMap) {
        ArrayList<String> list = new ArrayList<String>(emptyMsgMap.size());
        String pattern = ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bf9\u7167\u5173\u7cfb\u7b2c{0}\u884c\u7684{1}\u672a\u586b\u5199\u3002", (String)"SalaryStandardVeriHelper_8", (String)"swc-hcdm-business", (Object[])new Object[0]);
        for (Map.Entry<Integer, String> emptyMsg : emptyMsgMap.entrySet()) {
            list.add(MessageFormat.format(pattern, emptyMsg.getKey(), emptyMsg.getValue()));
        }
        return list;
    }
}

