/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.MustInputValidator;

public class StdContrastPropMustInputValidator
extends MustInputValidator<SalaryStandardEntryData> {
    public StdContrastPropMustInputValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = this.validateMustInputInContrastProp(data.getContrastPropEntities());
        return result;
    }

    private ValidateResult validateMustInputInContrastProp(List<ContrastPropEntity> contrastPropEntities) {
        ValidateResult result = new ValidateResult(this.getLevel());
        String atLeastOneContrastPropMsg = this.veriAtLeastOneContrastProp(contrastPropEntities);
        if (StringUtils.isNotEmpty((CharSequence)atLeastOneContrastPropMsg)) {
            result.addErrorMsg(atLeastOneContrastPropMsg);
        }
        return result;
    }

    private String veriAtLeastOneContrastProp(List<ContrastPropEntity> contrastPropEntities) {
        if (contrastPropEntities == null || contrastPropEntities.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5bf9\u7167\u5c5e\u6027\u3002", (String)"SalaryStandardVeriHelper_6", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        return null;
    }
}

