/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.LegalValidator;
import org.apache.commons.collections.CollectionUtils;

public class StdContrastPropOverrideValidator
extends LegalValidator<SalaryStandardEntryData> {
    public StdContrastPropOverrideValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = this.veriContrastDataOverrideAll(data.getContrastRowEntities(), data.getStdBaseEntity(), data.getGradeEntities(), data.getRankEntities());
        return result;
    }

    public ValidateResult veriContrastDataOverrideAll(List<ContrastRowDataEntity> contrastDataEntities, SalaryStandardBaseEntity salaryStdEntity, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> allRankEntities) {
        ValidateResult result = new ValidateResult(this.getLevel());
        boolean isUseRank = salaryStdEntity.getIsUseSalaryRank() > 0;
        List<SalaryRankEntity> rankEntities = GradeRankHelper.fetchStandardRank(allRankEntities);
        int maxCount = gradeEntities.size() * rankEntities.size() - 1;
        GradeRankValue maxRange = new GradeRankValue(0, maxCount);
        ArrayList allRange = Lists.newArrayListWithExpectedSize((int)10);
        for (ContrastRowDataEntity rowDataEntity : contrastDataEntities) {
            List rangeCode = rowDataEntity.getRangeCode();
            if (!CollectionUtils.isNotEmpty((Collection)rangeCode)) continue;
            allRange.addAll(rangeCode);
        }
        List<GradeRankValue> unionAllRange = GradeRankHelper.unionRangeByCode(allRange);
        boolean coverAll = GradeRankHelper.checkRangeContainsByCode(unionAllRange, Lists.newArrayList((Object[])new GradeRankValue[]{maxRange}));
        if (!coverAll) {
            String errorMsg = isUseRank ? ResManager.loadKDString((String)"\u5bf9\u7167\u5173\u7cfb\u672a\u8986\u76d6\u6240\u6709\u85aa\u7b49\u85aa\u6863\u3002", (String)"SalaryStandardVeriHelper_10", (String)"swc-hcdm-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5bf9\u7167\u5173\u7cfb\u672a\u8986\u76d6\u6240\u6709\u85aa\u7b49\u3002", (String)"SalaryStandardVeriHelper_11", (String)"swc-hcdm-business", (Object[])new Object[0]);
            result.addErrorMsg(errorMsg);
        }
        return result;
    }
}

