/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.CompleteValidator;
import org.apache.commons.collections.CollectionUtils;

public class StdContrastSetGradeRankValidator
extends CompleteValidator<SalaryStandardEntryData> {
    public StdContrastSetGradeRankValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = this.veriContrastDataSetGrade(data.getContrastRowEntities());
        return result;
    }

    public ValidateResult veriContrastDataSetGrade(List<ContrastRowDataEntity> contrastDataEntities) {
        ValidateResult result = new ValidateResult(this.getLevel());
        for (ContrastRowDataEntity entry : contrastDataEntities) {
            List rangeCode = entry.getRangeCode();
            int rowIndex = entry.getRowIndex();
            if (!CollectionUtils.isEmpty((Collection)rangeCode)) continue;
            String format = ResManager.loadKDString((String)"\u8bbe\u7f6e\u5bf9\u7167\u5173\u7cfb\u7b2c%d\u884c\u7684\uff08\u85aa\u7b49\u85aa\u6863\uff09\u672a\u586b\u5199\u3002", (String)"SalaryStandardVeriHelper_9", (String)"swc-hcdm-business", (Object[])new Object[0]);
            result.addErrorMsg(String.format(Locale.ROOT, format, ++rowIndex));
        }
        return result;
    }
}

