/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.CompleteValidator;

public class StdDesignerCompleteValidator
extends CompleteValidator<SalaryStandardEntryData> {
    public StdDesignerCompleteValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = new ValidateResult(this.getLevel());
        SalaryStandardBaseEntity stdBaseEntity = data.getStdBaseEntity();
        List itemEntities = data.getItemEntities();
        this.veriAtLeastOneItemSetRank(stdBaseEntity, itemEntities, result);
        this.veriAtLeastOneItemSetCount(stdBaseEntity, itemEntities, result);
        return result;
    }

    private void veriAtLeastOneItemSetRank(SalaryStandardBaseEntity salaryStandardBaseEntity, List<SalaryStdItemEntity> itemEntities, ValidateResult result) {
        int isUseSalaryRank = salaryStandardBaseEntity.getIsUseSalaryRank();
        if (isUseSalaryRank <= 0) {
            return;
        }
        if ((itemEntities = itemEntities.stream().filter(entity -> SalaryItemLabelEnum.STANDARD == entity.getItemLabel() && entity.getItemIsUseSalaryRank() > 0).collect(Collectors.toList())) == null || itemEntities.isEmpty()) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u4f7f\u7528\u85aa\u6863\u9700\u8bbe\u7f6e\u5e94\u7528\u5b9a\u8c03\u85aa\u9879\u76ee\u3002", (String)"SalaryStandardVeriHelper_3", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
    }

    private void veriAtLeastOneItemSetCount(SalaryStandardBaseEntity salaryStandardBaseEntity, List<SalaryStdItemEntity> itemEntities, ValidateResult result) {
        int isUseSalaryCount = salaryStandardBaseEntity.getIsUseSalaryCount();
        if (isUseSalaryCount <= 0) {
            return;
        }
        if ((itemEntities = itemEntities.stream().filter(entity -> SalaryItemLabelEnum.STANDARD == entity.getItemLabel() && entity.getItemIsUseSalaryCount() > 0).collect(Collectors.toList())) == null || itemEntities.isEmpty()) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u4f7f\u7528\u85aa\u70b9\u9700\u8bbe\u7f6e\u5e94\u7528\u5b9a\u8c03\u85aa\u9879\u76ee\u3002", (String)"SalaryStandardVeriHelper_5", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
    }
}

