/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryItemLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.MustInputValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class StdDesignerMustInputValidator
extends MustInputValidator<SalaryStandardEntryData> {
    public StdDesignerMustInputValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        String atLeastOneSalaryRankMsg;
        String atLeastOneSalaryGradeMsg;
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = new ValidateResult(this.getLevel());
        String atLeastOneSalaryItemMsg = this.veriAtLeastOneSalaryItem(data.getItemEntities());
        if (StringUtils.isNotEmpty((CharSequence)atLeastOneSalaryItemMsg)) {
            result.addErrorMsg(atLeastOneSalaryItemMsg);
        }
        if (StringUtils.isNotEmpty((CharSequence)(atLeastOneSalaryGradeMsg = this.veriAtLeastOneSalaryGrade(data.getGradeEntities())))) {
            result.addErrorMsg(atLeastOneSalaryGradeMsg);
        }
        if (SalaryStandardTypeEnum.BROADBAND == data.getStdBaseEntity().getType() && StringUtils.isNotEmpty((CharSequence)(atLeastOneSalaryRankMsg = StdDesignerMustInputValidator.veriAtLeastOneSalaryRank(GradeRankHelper.fetchStandardRank(data.getRankEntities()))))) {
            result.addErrorMsg(atLeastOneSalaryRankMsg);
        }
        this.veriAlreadySetRank(data.getStdBaseEntity(), data.getRankEntities(), result);
        this.veriAlreadySetCount(data.getStdBaseEntity(), result);
        return result;
    }

    private void veriAlreadySetRank(SalaryStandardBaseEntity stdBaseEntity, List<SalaryRankEntity> rankEntities, ValidateResult result) {
        SalaryStandardTypeEnum type = stdBaseEntity.getType();
        if (SalaryStandardTypeEnum.BROADBAND == type) {
            return;
        }
        int isUseSalaryRank = stdBaseEntity.getIsUseSalaryRank();
        if (isUseSalaryRank <= 0) {
            return;
        }
        if ((rankEntities = rankEntities.stream().filter(entity -> entity.getRankIsUserSet() > 0).collect(Collectors.toList())) == null || rankEntities.isEmpty()) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u4f7f\u7528\u85aa\u6863\u9700\u8bbe\u7f6e\u85aa\u6863\u3002", (String)"SalaryStandardVeriHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
    }

    private void veriAlreadySetCount(SalaryStandardBaseEntity stdBaseEntity, ValidateResult result) {
        int isUseSalaryCount = stdBaseEntity.getIsUseSalaryCount();
        if (isUseSalaryCount <= 0) {
            return;
        }
        BigDecimal salaryCountAmount = stdBaseEntity.getSalaryCountAmount();
        if (salaryCountAmount == null || salaryCountAmount.compareTo(BigDecimal.ZERO) == 0) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u4f7f\u7528\u85aa\u70b9\u9700\u8bbe\u7f6e\u85aa\u70b9\u3002", (String)"SalaryStandardVeriHelper_15", (String)"swc-hcdm-business", (Object[])new Object[0]));
        }
    }

    private String veriAtLeastOneSalaryItem(List<SalaryStdItemEntity> itemEntities) {
        if ((itemEntities = itemEntities.stream().filter(entity -> SalaryItemLabelEnum.STANDARD == entity.getItemLabel()).collect(Collectors.toList())) == null || itemEntities.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5b9a\u8c03\u85aa\u9879\u76ee\u3002", (String)"SalaryStandardVeriHelper_0", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        return null;
    }

    private String veriAtLeastOneSalaryGrade(List<SalaryGradeEntity> gradeEntities) {
        if (gradeEntities == null || gradeEntities.isEmpty()) {
            return ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u85aa\u7b49\u3002", (String)"SalaryStandardVeriHelper_1", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        return null;
    }

    private static String veriAtLeastOneSalaryRank(List<SalaryRankEntity> rankEntities) {
        List setRankEntities = rankEntities.stream().filter(entity -> entity.getRankIsUserSet() > 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(setRankEntities)) {
            return ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u85aa\u6863", (String)"SalaryStandardVeriHelper_18", (String)"swc-hcdm-business", (Object[])new Object[0]);
        }
        return null;
    }
}

