/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.sdk.swc.hcdm.common.stdtab.DisplayParamNew;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.salarystandard.DisplayParamHelper;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.LegalValidator;
import org.apache.commons.collections4.CollectionUtils;

public class StdDesignerOrderValidator
extends LegalValidator<SalaryStandardEntryData> {
    public StdDesignerOrderValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = new ValidateResult(this.getLevel());
        this.veriAmountIsInOrder(data.getStdDataEntities(), data.getItemEntities(), data.getGradeEntities(), data.getRankEntities(), data.getDisplayParam(), data.getStdBaseEntity(), result);
        return result;
    }

    private void veriAmountIsInOrder(List<SalaryStdDataEntity> stdData, List<SalaryStdItemEntity> stdItemEntities, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, DisplayParamNew displayParam, SalaryStandardBaseEntity baseEntity, ValidateResult result) {
        List<SalaryGradeEntity> sortGradesEntities = GradeRankHelper.sortGradeList(gradeEntities, 1);
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(rankEntities);
        Set<Long> rankIdSet = GradeRankHelper.getRankIdSet(standardRanks);
        List<SalaryStdDataEntity> stdDataEntities = SalaryStdDataHelper.getByRankIds(rankIdSet, stdData);
        List<SalaryRankEntity> sortRankEntities = GradeRankHelper.sortRankList(standardRanks, 1);
        Map<Long, List<SalaryStdDataEntity>> standardItemDataList = this.dataGroupByStandardItem(stdDataEntities, stdItemEntities);
        Set<String> errorSet = this.veriDataIsInOrder(standardItemDataList, sortRankEntities, sortGradesEntities, displayParam, baseEntity);
        if (CollectionUtils.isNotEmpty(errorSet)) {
            result.addErrorMsgs(errorSet);
            return;
        }
    }

    private Set<String> veriDataIsInOrder(Map<Long, List<SalaryStdDataEntity>> standardItemDataMap, List<SalaryRankEntity> rankEntities, List<SalaryGradeEntity> gradesEntities, DisplayParamNew displayParam, SalaryStandardBaseEntity baseEntity) {
        HashSet errStrSet = Sets.newHashSetWithExpectedSize((int)16);
        if (SalaryStandardTypeEnum.BROADBAND == baseEntity.getType()) {
            return errStrSet;
        }
        for (Map.Entry<Long, List<SalaryStdDataEntity>> standardItemDataGroup : standardItemDataMap.entrySet()) {
            List<SalaryStdDataEntity> standardItemDataList = standardItemDataGroup.getValue();
            if (!CollectionUtils.isEmpty((Collection)errStrSet)) break;
            HashSet veriDataSet = Sets.newHashSetWithExpectedSize((int)16);
            this.veriDataByGrade(standardItemDataList, gradesEntities, veriDataSet, displayParam);
            this.veriDataByRank(standardItemDataList, rankEntities, veriDataSet, displayParam);
            if (veriDataSet.isEmpty() || veriDataSet.size() <= 0) continue;
            StringJoiner sj = new StringJoiner("\u3001");
            for (String veRiStr : veriDataSet) {
                String[] veRiStRs = veRiStr.split("-");
                sj.add(veRiStRs[0]);
            }
            errStrSet.add(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u540c\u4e00\u5b9a\u8c03\u85aa\u9879\u76ee\u53ca\u85aa\u7b49\uff0c\u85aa\u6863\u5bf9\u5e94\u91d1\u989d\u6839\u636e%1$s\u987a\u5e8f\u9012\u589e\u6216\u9012\u51cf\u3002", (String)"DisplayParamHelper_2", (String)"swc-hcdm-business", (Object[])new Object[0]), sj));
        }
        return errStrSet;
    }

    private void veriDataByRank(List<SalaryStdDataEntity> standardItemDataList, List<SalaryRankEntity> rankEntities, Set<String> errStrSet, DisplayParamNew displayParam) {
        Map<Long, List<SalaryStdDataEntity>> dataGroupByRank = standardItemDataList.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getGradeIdentity));
        block0: for (Map.Entry<Long, List<SalaryStdDataEntity>> entry : dataGroupByRank.entrySet()) {
            List<SalaryStdDataEntity> dataInSameRank = entry.getValue();
            HashMap<Long, BigDecimal> rankAmountMap = new HashMap<Long, BigDecimal>(dataInSameRank.size());
            dataInSameRank.forEach(data -> rankAmountMap.put(data.getRankIdentity(), data.getMin()));
            for (int i = 0; i < rankEntities.size() - 1; ++i) {
                BigDecimal nextAmount;
                SalaryRankEntity rank = rankEntities.get(i);
                BigDecimal curAmount = (BigDecimal)rankAmountMap.get(rank.getRankIdentity());
                if (curAmount == null || curAmount.compareTo(BigDecimal.ZERO) < 0 || (nextAmount = this.findNextRank(rankEntities, i, rankAmountMap)) == null || nextAmount.compareTo(BigDecimal.ZERO) < 0 || nextAmount.compareTo(curAmount) >= 0) continue;
                errStrSet.add(DisplayParamHelper.getRankOrderErrorMsg(displayParam));
                continue block0;
            }
        }
    }

    private void veriDataByGrade(List<SalaryStdDataEntity> standardItemDataList, List<SalaryGradeEntity> gradesEntities, Set<String> errStrSet, DisplayParamNew displayParam) {
        Map<Long, List<SalaryStdDataEntity>> dataGroupByGrade = standardItemDataList.stream().collect(Collectors.groupingBy(SalaryStdDataEntity::getRankIdentity));
        block0: for (Map.Entry<Long, List<SalaryStdDataEntity>> entry : dataGroupByGrade.entrySet()) {
            List<SalaryStdDataEntity> dataInSameGrade = entry.getValue();
            HashMap<Long, BigDecimal> gradeAmountMap = new HashMap<Long, BigDecimal>(dataInSameGrade.size());
            dataInSameGrade.forEach(data -> gradeAmountMap.put(data.getGradeIdentity(), data.getMin()));
            for (int i = 0; i < gradesEntities.size() - 1; ++i) {
                BigDecimal nextAmount;
                SalaryGradeEntity grade = gradesEntities.get(i);
                BigDecimal curAmount = (BigDecimal)gradeAmountMap.get(grade.getGradeIdentity());
                if (curAmount == null || curAmount.compareTo(BigDecimal.ZERO) < 0 || (nextAmount = this.findNextGrade(gradesEntities, i, gradeAmountMap)) == null || nextAmount.compareTo(BigDecimal.ZERO) < 0 || nextAmount.compareTo(curAmount) >= 0) continue;
                errStrSet.add(DisplayParamHelper.getGradeOrderErrorMsg(displayParam));
                continue block0;
            }
        }
    }

    private BigDecimal findNextGrade(List<SalaryGradeEntity> gradesEntities, int i1, Map<Long, BigDecimal> gradeAmountMap) {
        int j1 = i1 + 1;
        BigDecimal nextAmount = null;
        while ((nextAmount == null || nextAmount.compareTo(BigDecimal.ZERO) < 0) && j1 <= gradesEntities.size() - 1) {
            SalaryGradeEntity nextGrade = gradesEntities.get(j1++);
            nextAmount = gradeAmountMap.get(nextGrade.getGradeIdentity());
        }
        return nextAmount;
    }

    private BigDecimal findNextRank(List<SalaryRankEntity> rankEntities, int i1, Map<Long, BigDecimal> rankAmountMap) {
        int j1 = i1 + 1;
        BigDecimal nextAmount = null;
        while ((nextAmount == null || nextAmount.compareTo(BigDecimal.ZERO) < 0) && j1 <= rankEntities.size() - 1) {
            SalaryRankEntity nextRank = rankEntities.get(j1++);
            nextAmount = rankAmountMap.get(nextRank.getRankIdentity());
        }
        return nextAmount;
    }

    private Map<Long, List<SalaryStdDataEntity>> dataGroupByStandardItem(List<SalaryStdDataEntity> stdDataEntities, List<SalaryStdItemEntity> stdItemEntities) {
        List<SalaryStdItemEntity> stdItem = SalaryStdItemHelper.fetchStandardItem(stdItemEntities);
        return SalaryStdDataHelper.groupByItem(SalaryStdDataHelper.filterByItem(stdDataEntities, stdItem));
    }
}

