/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandard.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.util.CollectionUtils;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.impl.CompleteValidator;
import kd.swc.hcdm.common.entity.salarystandard.GradeIncRankInfo;
import kd.swc.hcdm.common.entity.salarystandard.SalaryStdDataEmptyInfo;
import kd.swc.hcdm.common.entity.salarystandard.SalaryStdDataEntityKey;

public class StdDesignerWeakCompleteValidator
extends CompleteValidator<SalaryStandardEntryData> {
    public StdDesignerWeakCompleteValidator(ValidateContext<SalaryStandardEntryData> context, ErrorLevel level) {
        super(context, level);
    }

    @Override
    protected ValidateResult doValidate() {
        ValidateContext context = this.getContext();
        SalaryStandardEntryData data = (SalaryStandardEntryData)context.getData();
        ValidateResult result = new ValidateResult(this.getLevel());
        this.veriDataIntegrity(data.getStdBaseEntity(), data.getStdDataEntities(), data.getItemEntities(), data.getGradeEntities(), data.getRankEntities(), result);
        return result;
    }

    public void veriDataIntegrity(SalaryStandardBaseEntity stdBaseEntity, List<SalaryStdDataEntity> datas, List<SalaryStdItemEntity> items, List<SalaryGradeEntity> grades, List<SalaryRankEntity> ranks, ValidateResult result) {
        if (CollectionUtils.isEmpty(datas)) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u6807\u51c6\u8868\u8bbe\u7f6e\u672a\u586b\u5199\u3002", (String)"SalaryStandardVeriHelper_16", (String)"swc-hcdm-business", (Object[])new Object[0]));
            return;
        }
        List<SalaryStdItemEntity> stdItems = SalaryStdItemHelper.fetchStandardItem(items);
        List<Long> salaryItemIds = SalaryStdItemHelper.getAllItemIdentities(stdItems);
        List<SalaryRankEntity> stdRanks = GradeRankHelper.getDefaultRankByCalMethod(ranks, stdBaseEntity.getCalcMethod());
        stdRanks.sort(Comparator.comparingInt(o1 -> o1.getRankLabel().getIndex()).thenComparingInt(SalaryRankEntity::getRankIndex));
        List<SalaryStdDataEntity> stdDatas = SalaryStdDataHelper.getByRankIds(GradeRankHelper.getRankIdSet(stdRanks), SalaryStdDataHelper.getByItemIds(salaryItemIds, datas));
        Map<SalaryStdDataEntityKey, SalaryStdDataEntity> dataValueMap = SalaryStdDataHelper.groupBySalaryStdDataEntityKey(stdDatas);
        ArrayList<SalaryStdDataEmptyInfo> emptyInfoList = new ArrayList<SalaryStdDataEmptyInfo>(stdDatas.size());
        boolean isEmpty = true;
        for (SalaryStdItemEntity stdItem : stdItems) {
            for (SalaryGradeEntity grade : grades) {
                for (SalaryRankEntity stdRank : stdRanks) {
                    SalaryStdDataEntityKey key = new SalaryStdDataEntityKey(stdItem.getItemIdentity(), grade.getGradeIdentity(), stdRank.getRankIdentity());
                    SalaryStdDataEntity data = dataValueMap.get(key);
                    if (data == null) {
                        this.addErrorInfo(emptyInfoList, stdItem, grade, stdRank);
                        continue;
                    }
                    BigDecimal dataValue = data.getMin();
                    if (dataValue == null) {
                        this.addErrorInfo(emptyInfoList, stdItem, grade, stdRank);
                        continue;
                    }
                    isEmpty = false;
                }
            }
        }
        if (isEmpty) {
            result.addErrorMsg(ResManager.loadKDString((String)"\u6807\u51c6\u8868\u8bbe\u7f6e\u672a\u586b\u5199\u3002", (String)"SalaryStandardVeriHelper_16", (String)"swc-hcdm-business", (Object[])new Object[0]));
        } else {
            this.buildEmptyResult(stdBaseEntity, emptyInfoList, grades, ranks, result);
        }
    }

    private void addErrorInfo(List<SalaryStdDataEmptyInfo> emptyInfoList, SalaryStdItemEntity stdItem, SalaryGradeEntity grade, SalaryRankEntity stdRank) {
        ArrayList<GradeIncRankInfo> gradeRankInfo;
        Long itemIdentity = stdItem.getItemIdentity();
        Long gradeIdentity = grade.getGradeIdentity();
        SalaryStdDataEmptyInfo curEmptyInfo = null;
        for (SalaryStdDataEmptyInfo info : emptyInfoList) {
            SalaryStdItemEntity item = info.getItem();
            if (!item.getItemIdentity().equals(itemIdentity)) continue;
            curEmptyInfo = info;
        }
        if (curEmptyInfo == null) {
            gradeRankInfo = new ArrayList<GradeIncRankInfo>(10);
            ArrayList<SalaryRankEntity> ranks = new ArrayList<SalaryRankEntity>(10);
            ranks.add(stdRank);
            gradeRankInfo.add(new GradeIncRankInfo(grade, ranks));
            curEmptyInfo = new SalaryStdDataEmptyInfo(stdItem, gradeRankInfo);
            emptyInfoList.add(curEmptyInfo);
            return;
        }
        gradeRankInfo = curEmptyInfo.getGradeRankInfo();
        GradeIncRankInfo curGradeIncRankInfo = null;
        for (GradeIncRankInfo info : gradeRankInfo) {
            if (!info.getGrade().getGradeIdentity().equals(gradeIdentity)) continue;
            curGradeIncRankInfo = info;
        }
        ArrayList<SalaryRankEntity> ranks = null;
        if (curGradeIncRankInfo == null) {
            ranks = new ArrayList<SalaryRankEntity>(10);
            curGradeIncRankInfo = new GradeIncRankInfo(grade, ranks);
            gradeRankInfo.add(curGradeIncRankInfo);
        } else {
            ranks = curGradeIncRankInfo.getRanks();
        }
        ranks.add(stdRank);
        curEmptyInfo.setGradeRankInfo(gradeRankInfo);
    }

    private void buildEmptyResult(SalaryStandardBaseEntity stdBaseEntity, List<SalaryStdDataEmptyInfo> emptyInfoList, List<SalaryGradeEntity> grades, List<SalaryRankEntity> ranks, ValidateResult result) {
        if (emptyInfoList.isEmpty()) {
            return;
        }
        String blankMsg = ResManager.loadKDString((String)"\u672a\u586b\u5199\u3002", (String)"SalaryStandardVeriHelper_14", (String)"swc-hcdm-business", (Object[])new Object[0]);
        String suffix = ")" + blankMsg;
        String delimiter = ",";
        for (SalaryStdDataEmptyInfo emptyInfo : emptyInfoList) {
            SalaryStdItemEntity item = emptyInfo.getItem();
            String itemName = item.getItemName();
            boolean isUseRank = item.getItemIsUseSalaryRank() > 0;
            List gradeRankInfo = emptyInfo.getGradeRankInfo();
            StringBuilder sb = new StringBuilder(itemName);
            int length = sb.length();
            for (GradeIncRankInfo gradeRank : gradeRankInfo) {
                SalaryGradeEntity grade = gradeRank.getGrade();
                sb.setLength(length);
                if (isUseRank) {
                    String curPrefix = "\uff08" + grade.getGradeName();
                    StringJoiner sj = new StringJoiner(delimiter, curPrefix, suffix);
                    List rankList = gradeRank.getRanks();
                    rankList.forEach(rank -> sj.add(rank.getRankName()));
                    sb.append(sj);
                } else {
                    sb.append('(').append(grade.getGradeName()).append('\uff09').append(blankMsg);
                }
                result.addErrorMsg(sb.toString());
            }
        }
    }
}

