/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.salarystandardscm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import org.apache.commons.collections.CollectionUtils;

public class SalaryStandardScmHelper {
    private static Log logger = LogFactory.getLog(SalaryStandardScmHelper.class);

    public static boolean checkDateCovered(Date bsed, Date bsled, Date dataBsed, Date dataBsled) {
        return dataBsed.after(bsled) || dataBsled != null && dataBsled.before(bsed);
    }

    public static Map<String, String> getLastVersionIdNameMap(DynamicObjectCollection coll) {
        return coll.stream().filter(object -> "1".equals(object.getString("datastatus"))).collect(Collectors.toMap(dy -> dy.getString("boid"), dy -> dy.getString("name"), (oldVal, newVal) -> oldVal));
    }

    public static Map<String, List<DynamicObject>> groupByBo(List<DynamicObject> coll) {
        return coll.stream().collect(Collectors.groupingBy(dy -> dy.getString("boid")));
    }

    public static Map<String, List<DynamicObject>> groupByBo(DynamicObjectCollection coll) {
        return coll.stream().collect(Collectors.groupingBy(dy -> dy.getString("boid")));
    }

    public static Map<String, List<DynamicObject>> groupByCoeffTabId(DynamicObjectCollection coll) {
        return coll.stream().collect(Collectors.groupingBy(dy -> dy.getString("coefficienttab")));
    }

    public static DynamicObjectCollection queryCoefHisInfoByIds(Collection<Long> coefIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_coefficient");
        QFilter qFilter = new QFilter("boid", "in", coefIds);
        qFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        logger.info("SalaryStandardScmHelper.queryCoefHisInfoByIds,coefIds = {}", coefIds);
        return helper.queryOriginalCollection("id,boid,name,bsed,bsled,iscurrentversion,datastatus,coefficienttab", new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection queryDateInStdHisById(Collection<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salarystandard");
        QFilter qFilter = new QFilter("boid", "in", ids);
        qFilter.and("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        BaseDataHisHelper.addHisVerFilter((QFilter)qFilter);
        logger.info("SalaryStandardScmHelper.queryDateInStdHisById,ids = {}", ids);
        return helper.queryOriginalCollection("id,boid,name,bsed,bsled,datastatus", new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection queryCoefByTabId(Collection<Long> ids) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_coefficient");
        QFilter qFilter = new QFilter("coefficienttab.id", "in", ids);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        return helper.queryOriginalCollection("id,name,coefficienttab", new QFilter[]{qFilter});
    }

    public static Set<Long> getCoefIds(DynamicObjectCollection coll) {
        return coll.stream().map(object -> object.getLong("id")).collect(Collectors.toSet());
    }

    public static Map<String, List<DynamicObject>> getEnabledCoeffHisData(Collection<String> coefIds, Map<String, List<DynamicObject>> boMap) {
        return boMap.entrySet().stream().filter(entry -> coefIds.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<Long, List<DynamicObject>> queryStdScmByIds(Map<Long, Set<Long>> idStcIds) {
        if (idStcIds == null) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_stdscm");
        QFilter qFilter = new QFilter("id", "in", idStcIds.keySet());
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        DynamicObject[] dynamicObjects = helper.query("id,sourcevid", new QFilter[]{qFilter});
        Map<Long, Long> sourceIdMaps = Arrays.stream(dynamicObjects).collect(Collectors.toMap(object -> object.getLong("id"), val -> val.getLong("sourcevid")));
        qFilter = new QFilter("id", "in", sourceIdMaps.keySet());
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        DynamicObject[] resultDynamicObjects = helper.query("id,entryentity,entryentity.salstructurent,entryentity.salstructurent,entryentity.standarditem,entryentity.salarystandard,entryentity.coefficienttabent,entryentity.excesscontrol,sourcevid,entryentity.ismatchgraderank,entryentity.matchstrategy", new QFilter[]{qFilter});
        Map<Long, List<DynamicObject>> result = Arrays.stream(resultDynamicObjects).collect(Collectors.toMap(object -> object.getLong("id"), object -> object.getDynamicObjectCollection("entryentity").stream().filter(object1 -> CollectionUtils.isNotEmpty((Collection)((Collection)idStcIds.get(object.getLong("id")))) && !((Set)idStcIds.get(object.getLong("id"))).contains(0L) && object1.getLong("salstructurent.id") != 0L && ((Set)idStcIds.get(object.getLong("id"))).contains(object1.getLong("salstructurent.id"))).collect(Collectors.toList())));
        return result;
    }

    public static List<DynamicObject> queryStdScmByStructureIds(Set<Long> structureIds) {
        if (structureIds == null) {
            return Lists.newArrayListWithExpectedSize((int)1);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_stdscm");
        QFilter qFilter = new QFilter("entryentity.salstructurent.id", "in", structureIds);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = helper.query("id,name", new QFilter[]{qFilter});
        return Arrays.asList(dynamicObjects);
    }

    public static Map<Long, List<DynamicObject>> queryStdScmMapByStructureIds(Set<Long> structureIds) {
        if (structureIds == null) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_stdscm");
        QFilter qFilter = new QFilter("entryentity.salstructurent.id", "in", structureIds);
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = helper.query("id,name,boid,salaystructure,sourcevid,createorg,entryentity,entryentity.salstructurent,entryentity.salstructurent,entryentity.standarditem,entryentity.salarystandard,entryentity.coefficienttabent", new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)structureIds.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            MulBasedataDynamicObjectCollection salaryStructures = (MulBasedataDynamicObjectCollection)dynamicObject.get("salaystructure");
            for (DynamicObject salaryStructure : salaryStructures) {
                if (!structureIds.contains(salaryStructure.getLong("fbasedataid_id"))) continue;
                List list = result.computeIfAbsent(salaryStructure.getLong("fbasedataid_id"), key -> new ArrayList());
                list.add(dynamicObject);
            }
        }
        return result;
    }

    public static Map<Long, List<DynamicObject>> queryStdScmMapWithNoStatusByStructureIds(Set<Long> structureIds) {
        if (structureIds == null) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_stdscm");
        QFilter qFilter = new QFilter("entryentity.salstructurent.id", "in", structureIds);
        qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] dynamicObjects = helper.query("id,name,boid,salaystructure,sourcevid,createorg,entryentity,entryentity.salstructurent,entryentity.salstructurent,entryentity.standarditem,entryentity.salarystandard,entryentity.coefficienttabent", new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)structureIds.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            MulBasedataDynamicObjectCollection salaryStructures = (MulBasedataDynamicObjectCollection)dynamicObject.get("salaystructure");
            for (DynamicObject salaryStructure : salaryStructures) {
                if (!structureIds.contains(salaryStructure.getLong("fbasedataid_id"))) continue;
                List list = result.computeIfAbsent(salaryStructure.getLong("fbasedataid_id"), key -> new ArrayList());
                list.add(dynamicObject);
            }
        }
        return result;
    }

    public static Map<Long, List<DynamicObject>> queryAllStdScmByStructureIds(Set<Long> structureIds) {
        if (structureIds == null) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_stdscm");
        QFilter qFilter = new QFilter("entryentity.salstructurent.id", "in", structureIds);
        qFilter.and("datastatus", "in", (Object)new String[]{"-2", "0", "2", "1"});
        DynamicObject[] dynamicObjects = helper.query("id,name,boid,salaystructure,sourcevid,entryentity,entryentity.salstructurent,entryentity.salstructurent,entryentity.standarditem,entryentity.salarystandard,entryentity.coefficienttabent", new QFilter[]{qFilter});
        HashMap result = Maps.newHashMapWithExpectedSize((int)structureIds.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            MulBasedataDynamicObjectCollection salaryStructures = (MulBasedataDynamicObjectCollection)dynamicObject.get("salaystructure");
            for (DynamicObject salaryStructure : salaryStructures) {
                if (!structureIds.contains(salaryStructure.getLong("fbasedataid_id"))) continue;
                List list = result.computeIfAbsent(salaryStructure.getLong("fbasedataid_id"), key -> new ArrayList());
                list.add(dynamicObject);
            }
        }
        return result;
    }

    public static List<Map<String, Object>> querySalaryStandardByScm(Map<String, Object> params) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)10);
        if (SWCObjectUtils.isEmpty((Object)params.get("stdScmBoId")) && SWCObjectUtils.isEmpty((Object)params.get("structureId")) && SWCObjectUtils.isEmpty((Object)params.get("standardItemId"))) {
            return resultList;
        }
        try {
            Set stdScmBoId = (Set)params.get("stdScmBoId");
            Set structureId = (Set)params.get("structureId");
            Set standardItemId = (Set)params.get("standardItemId");
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_stdscm");
            QFilter qFilter = new QFilter("boid", "in", (Object)stdScmBoId);
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
            DynamicObject[] dynamicObjects = helper.query("id,name,entryentity,entryentity.salarystandard,entryentity.salstructurent,entryentity.standarditem,entryentity.ismatchgraderank,entryentity.matchstrategy", new QFilter[]{qFilter});
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                HashMap salaryStandardListMap = Maps.newHashMapWithExpectedSize((int)16);
                for (DynamicObject dy : dynamicObjects) {
                    Long stdScmId = dy.getLong("id");
                    DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentity");
                    if (SWCListUtils.isEmpty((List)entryEntity)) continue;
                    for (DynamicObject entry : entryEntity) {
                        if (!structureId.contains(entry.getLong("salstructurent.id")) || !standardItemId.contains(entry.getLong("standarditem.id"))) continue;
                        String key = String.valueOf(stdScmId).concat("_").concat(entry.getString("salstructurent.id")).concat("_").concat(entry.getString("standarditem.id"));
                        HashMap salaryStandardMap = Maps.newHashMapWithExpectedSize((int)16);
                        salaryStandardMap.put("id", entry.getLong("salarystandard.id"));
                        salaryStandardMap.put("name", entry.getString("salarystandard.name"));
                        salaryStandardMap.put("number", entry.getString("salarystandard.number"));
                        salaryStandardMap.put("ismatchgraderank", entry.getString("ismatchgraderank"));
                        salaryStandardMap.put("matchstrategy", entry.getString("matchstrategy"));
                        salaryStandardListMap.put(key, salaryStandardMap);
                        resultList.add(salaryStandardListMap);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("querySalaryStandardByScm...", (Throwable)e);
        }
        return resultList;
    }
}

