/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.sdkservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.SimpleMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SimpleStdRangeMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SimpleStdRangeMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.sdk.swc.hcdm.common.stdtab.StdMatchParamWithDepEmp;
import kd.sdk.swc.hcdm.common.stdtab.StdRangeNameFormatParam;
import kd.sdk.swc.hcdm.common.stdtab.StdSimpleMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.StdTableDataQueryParam;
import kd.sdk.swc.hcdm.service.spi.SalaryStdQueryService;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;

public class SalaryStdQueryServiceImpl
implements SalaryStdQueryService {
    private AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
    private SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);

    public Map<Long, List<ContrastPropResult>> getContrastProp(List<Long> stdTableIdList) {
        return this.salaryStdApplicationService.getContrastProp(stdTableIdList);
    }

    public Map<String, StdSimpleMatchResult> matchTableRange(List<SimpleMatchParam> params) {
        return this.salaryStdApplicationService.matchTableRange(params);
    }

    public List<SalaryCountAmountMatchResult> matchTableRangeBySalaryCountOrAmount(List<SalaryCountAmountMatchParam> params) {
        return this.salaryStdApplicationService.matchTableRangeBySalaryCountOrAmount(params);
    }

    public List<SalaryStdMatchResultNew> batchMatchStdTableWithDepEmp(List<StdMatchParamWithDepEmp> list) {
        return this.adjApprovalApplicationService.batchMatchStdTableWithDepEmp(list);
    }

    public Map<Long, List<Map<String, Object>>> getRankInfo(Collection<Long> stdTableIds) {
        Map<Long, List<SalaryRankEntity>> rankMap = this.salaryStdApplicationService.getRankInfo(stdTableIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)rankMap.size());
        for (Map.Entry<Long, List<SalaryRankEntity>> entry : rankMap.entrySet()) {
            ArrayList rankInfo = Lists.newArrayListWithExpectedSize((int)entry.getValue().size());
            for (SalaryRankEntity rankEntity : entry.getValue()) {
                HashMap oneRank = Maps.newHashMapWithExpectedSize((int)16);
                oneRank.put("entryId", rankEntity.getId());
                oneRank.put("rankId", rankEntity.getId());
                oneRank.put("rankName", rankEntity.getRankName());
                oneRank.put("rankIdentity", rankEntity.getRankIdentity());
                oneRank.put("rankIndex", rankEntity.getRankIndex());
                rankInfo.add(oneRank);
            }
            resultMap.put(entry.getKey(), rankInfo);
        }
        return resultMap;
    }

    public Map<Long, List<Map<String, Object>>> getGradeInfo(Collection<Long> stdTableIds) {
        Map<Long, List<SalaryGradeEntity>> gradeMap = this.salaryStdApplicationService.getGradeInfo(stdTableIds);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)gradeMap.size());
        for (Map.Entry<Long, List<SalaryGradeEntity>> entry : gradeMap.entrySet()) {
            ArrayList gradeInfo = Lists.newArrayListWithExpectedSize((int)entry.getValue().size());
            for (SalaryGradeEntity GradeEntity : entry.getValue()) {
                HashMap oneGrade = Maps.newHashMapWithExpectedSize((int)16);
                oneGrade.put("entry", GradeEntity.getId());
                oneGrade.put("gradeId", GradeEntity.getId());
                oneGrade.put("gradeName", GradeEntity.getGradeName());
                oneGrade.put("gradeIdentity", GradeEntity.getGradeIdentity());
                oneGrade.put("gradeIndex", GradeEntity.getGradeIndex());
                gradeInfo.add(oneGrade);
            }
            resultMap.put(entry.getKey(), gradeInfo);
        }
        return resultMap;
    }

    public Map<String, Map<Long, List<SalaryStdDataEntity>>> getStdTableData(List<StdTableDataQueryParam> list) {
        return this.salaryStdApplicationService.getStdTableData(list);
    }

    public Map<String, SimpleStdRangeMatchResult> matchRangeWithStdTableId(List<SimpleStdRangeMatchParam> list) {
        return this.adjApprovalApplicationService.matchRangeWithStdTableId(list);
    }

    public Map<Long, Map<Long, Boolean>> getSalaryItemUseRankFlag(Map<Long, List<Long>> stdTableToItemMap) {
        return this.salaryStdApplicationService.getSalaryItemUseRankFlag(stdTableToItemMap);
    }

    public Map<String, String> getStdRangeNameByRangeId(List<StdRangeNameFormatParam> list) {
        return this.salaryStdApplicationService.getStdRangeNameByRangeId(list);
    }

    public List<StdAmountAndSalaryCountQueryResult> queryAmountAndSalaryCount(List<StdAmountQueryParam> params) {
        return this.salaryStdApplicationService.queryAmountAndSalaryCount(params);
    }
}

