/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.stdapplication.domain.stdtab.entityservice;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

@HrDomainEntity
public class SalaryStdTabService {
    private static final Log logger = LogFactory.getLog(SalaryStdTabService.class);
    private static final String ENTITY_NUMBER = "hcdm_salarystandard";
    private final SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salarystandard");

    public Map<Long, DynamicObject> queryStdObj(Set<Long> stdIdSet) {
        DynamicObject[] dynamicObjects = this.helper.loadDynamicObjectArray(stdIdSet.toArray());
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
    }

    public Map<Long, DynamicObject> queryStdObjWithIgnore(Set<Long> stdIdSet, String ... ignoreEntryName) {
        Set ignoreEntryNameSet = Arrays.stream(ignoreEntryName).collect(Collectors.toSet());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)ENTITY_NUMBER);
        try {
            DynamicObjectType cloneType = (DynamicObjectType)type.clone();
            cloneType.getProperties().removeIf(next -> next instanceof ICollectionProperty && ignoreEntryNameSet.contains(next.getName()) || next.getParent() instanceof ICollectionProperty && ignoreEntryNameSet.contains(next.getParent().getName()));
            for (int i = 0; i < cloneType.getProperties().size(); ++i) {
                DynamicProperty iDataEntityProperty = (DynamicProperty)cloneType.getProperties().get(i);
                iDataEntityProperty.setOrdinal(i);
            }
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])stdIdSet.toArray(), (DynamicObjectType)cloneType);
            return Arrays.stream(dynamicObjects).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        }
        catch (Exception exc) {
            logger.error((Throwable)exc);
            throw new KDBizException((Throwable)exc, null, new Object[0]);
        }
    }

    public Map<Long, List<SalaryStdItemEntity>> queryStdItemEntry(Set<Long> stdIdSet) {
        return SalaryStdItemHelper.queryItemEntities(stdIdSet);
    }

    public DynamicObject[] queryVersionObjs(Collection<Long> stdTabBoIds) {
        return this.helper.query("id,name,number,boid,enable,datastatus,iscurrentversion,bsed,bsled", new QFilter[]{new QFilter("boid", "in", stdTabBoIds), BaseDataHisHelper.getHisVerFilter(), new QFilter("enable", "=", (Object)"1"), new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "1", "0"}))}, "bsed asc");
    }

    public DynamicObject[] queryVersionObjsWithVid(Set<Long> stdVIds) {
        return this.helper.query("id,name,number,boid,enable,datastatus,iscurrentversion,bsed,bsled", new QFilter[]{new QFilter("id", "in", stdVIds), BaseDataHisHelper.getHisVerFilter()}, "bsed asc");
    }
}

