/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.stdapplication.domain.stdtab.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.hr.hbp.common.util.HrDomainEntity;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropResult;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankSeqMapEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.MatchBaseParam;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardBaseEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdItemEntity;
import kd.sdk.swc.hcdm.common.stdtab.SimpleMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.sdk.swc.hcdm.common.stdtab.StdRangeNameFormatParam;
import kd.sdk.swc.hcdm.common.stdtab.StdSimpleMatchResult;
import kd.sdk.swc.hcdm.common.stdtab.StdTableDataQueryParam;
import kd.swc.hcdm.business.adjapprbill.enums.OverStandardTypeEnum;
import kd.swc.hcdm.business.matchprop.SalaryStdMatchManager;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.salarystandard.SalaryStdItemHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdscm.entityservice.CoefficientService;
import kd.swc.hcdm.business.stdapplication.domain.stdscm.entityservice.SalaryStdScmService;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.entityservice.SalaryStdTabService;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdAmountQueryResult;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryParam;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryResult;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdRangeQueryParam;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdRangeQueryResult;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.EnumUtils;

@HrDomainEntity
public class SalaryStdDomainService {
    private final Log log = LogFactory.getLog(SalaryStdDomainService.class);
    private SalaryStdTabService salaryStdTabService;
    private CoefficientService coefficientService;
    private SalaryStdScmService salaryStdScmService;
    private static final Log logger = LogFactory.getLog(SalaryStdDomainService.class);
    private static final String PASS_DATA = "passData";
    private static final String FAIL_DATA = "failData";

    public SalaryStdTabService getSalaryStdTabService() {
        return this.salaryStdTabService;
    }

    public void setSalaryStdTabService(SalaryStdTabService salaryStdTabService) {
        this.salaryStdTabService = salaryStdTabService;
    }

    public CoefficientService getCoefficientService() {
        return this.coefficientService;
    }

    public void setCoefficientService(CoefficientService coefficientService) {
        this.coefficientService = coefficientService;
    }

    public SalaryStdScmService getSalaryStdScmService() {
        return this.salaryStdScmService;
    }

    public void setSalaryStdScmService(SalaryStdScmService salaryStdScmService) {
        this.salaryStdScmService = salaryStdScmService;
    }

    @Deprecated
    public Map<StdAmountQueryParam, StdAmountQueryResult> getSalaryStdAmount(List<StdAmountQueryParam> salaryStdAmountParams, boolean isThrowException) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)salaryStdAmountParams.size());
        Map<Long, List<StdAmountQueryParam>> paramMap = salaryStdAmountParams.stream().collect(Collectors.groupingBy(StdAmountQueryParam::getStdTabId));
        Map<Long, DynamicObject> stdMap = this.salaryStdTabService.queryStdObj(paramMap.keySet());
        for (Map.Entry<Long, List<StdAmountQueryParam>> entry : paramMap.entrySet()) {
            Long tabId = entry.getKey();
            List<StdAmountQueryParam> paramOfTab = entry.getValue();
            DynamicObject tabObj = stdMap.get(tabId);
            if (tabId <= 0L || tabObj == null) continue;
            SalaryStandardEntryData standardEntryData = EntityConverter.fetchEntityFromModel(tabObj, false);
            Map<Long, SalaryStdItemEntity> itemMap = SalaryStdItemHelper.groupBySalaryItemId(standardEntryData.getItemEntities());
            Map<Long, SalaryGradeEntity> gradeIdMap = GradeRankHelper.groupByGradeId(standardEntryData.getGradeEntities());
            List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(standardEntryData.getRankEntities());
            Map<Long, SalaryRankEntity> rankIdMap = GradeRankHelper.groupByRankId(standardRanks);
            List<SalaryStdDataEntity> standardStdDataList = SalaryStdDataHelper.getByRankIds(GradeRankHelper.getRankIdSet(standardRanks), standardEntryData.getStdDataEntities());
            Map<Long, SalaryRankEntity> rankIdentityMap = GradeRankHelper.groupByRankIdentity(standardRanks);
            Map<Long, Map<Long, List<SalaryStdDataEntity>>> gradeItemDataMap = SalaryStdDataHelper.groupByGradeItem(standardStdDataList);
            for (StdAmountQueryParam stdAmountQueryParam : paramOfTab) {
                StdAmountQueryResult queryResult;
                StdAmountQueryResult oldResult = resultMap.put(stdAmountQueryParam, queryResult = new StdAmountQueryResult());
                if (oldResult != null) {
                    if (isThrowException) {
                        throw new KDBizException("duplicate key ,type is StdAmountQueryParam");
                    }
                    logger.warn("duplicate key ,type is StdAmountQueryParam, stdId = {}", (Object)stdAmountQueryParam.getStdTabId());
                    continue;
                }
                queryResult.setCurrency(standardEntryData.getStdBaseEntity().getCurrencyId());
                queryResult.setUnit(standardEntryData.getStdBaseEntity().getMonetaryUnit());
                SalaryStdItemEntity salaryStdItemEntity = itemMap.get(stdAmountQueryParam.getItemId());
                if (salaryStdItemEntity == null) {
                    if (isThrowException) {
                        throw new KDBizException("itemId not exist in table");
                    }
                    logger.warn("itemId not exist in table, stdId = {}, itemId = {}", (Object)stdAmountQueryParam.getStdTabId(), (Object)stdAmountQueryParam.getItemId());
                    continue;
                }
                SalaryGradeEntity gradeEntity = gradeIdMap.get(stdAmountQueryParam.getGradeId());
                if (gradeEntity == null) {
                    if (isThrowException) {
                        throw new KDBizException("gradeId not exist in table");
                    }
                    logger.warn("gradeId not exist in table, stdId = {}, gradeId = {}", (Object)stdAmountQueryParam.getStdTabId(), (Object)stdAmountQueryParam.getGradeId());
                    continue;
                }
                Map<Long, List<SalaryStdDataEntity>> stdDataOfGrade = gradeItemDataMap.get(gradeEntity.getGradeIdentity());
                if (MapUtils.isEmpty(stdDataOfGrade)) {
                    if (isThrowException) {
                        throw new KDBizException("current grade not set amount");
                    }
                    logger.warn("current grade not set amount, stdId = {}, gradeId = {}", (Object)stdAmountQueryParam.getStdTabId(), (Object)stdAmountQueryParam.getGradeId());
                    continue;
                }
                List<SalaryStdDataEntity> stdDataEntities = stdDataOfGrade.get(salaryStdItemEntity.getItemIdentity());
                if (CollectionUtils.isEmpty(stdDataEntities)) {
                    if (isThrowException) {
                        throw new KDBizException("current item not set amount");
                    }
                    logger.warn("current item not set amount, stdId = {}, itemId = {}", (Object)stdAmountQueryParam.getStdTabId(), (Object)stdAmountQueryParam.getItemId());
                    continue;
                }
                SalaryStdDataHelper.sortByRankIndex(stdDataEntities, rankIdentityMap);
                SalaryStdDataEntity minData = stdDataEntities.get(0);
                SalaryStdDataEntity maxData = stdDataEntities.get(stdDataEntities.size() - 1);
                queryResult.setIntervalMin(minData.getMin());
                queryResult.setIntervalMax(maxData.getMin());
                if (stdAmountQueryParam.getRankId() <= 0L) continue;
                SalaryRankEntity rankEntity = rankIdMap.get(stdAmountQueryParam.getRankId());
                if (rankEntity == null) {
                    if (isThrowException) {
                        throw new KDBizException("rankId not exist in table");
                    }
                    logger.warn("rankId not exist in table, stdId = {}, rankId = {}", (Object)stdAmountQueryParam.getStdTabId(), (Object)stdAmountQueryParam.getRankId());
                    continue;
                }
                BigDecimal amount = null;
                for (SalaryStdDataEntity stdDataEntity : stdDataEntities) {
                    if (!stdDataEntity.getRankIdentity().equals(rankEntity.getRankIdentity())) continue;
                    amount = stdDataEntity.getMin();
                    break;
                }
                queryResult.setAmount(amount);
            }
        }
        return resultMap;
    }

    public Map<Long, Map<Long, Boolean>> getSalaryItemUseRankFlag(Map<Long, List<Long>> stdItemMap) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdItemMap.size());
        Map<Long, List<SalaryStdItemEntity>> stdItemObjMap = this.salaryStdTabService.queryStdItemEntry(stdItemMap.keySet());
        for (Map.Entry<Long, List<Long>> entry : stdItemMap.entrySet()) {
            Long tabId = entry.getKey();
            if (tabId <= 0L) continue;
            Map itemFlagMap = resultMap.computeIfAbsent(tabId, val -> Maps.newHashMap());
            List<Long> itemIds = entry.getValue();
            List<SalaryStdItemEntity> itemEntryRows = stdItemObjMap.get(tabId);
            for (Long itemId : itemIds) {
                SalaryStdItemEntity itemRow = null;
                for (SalaryStdItemEntity itemEntryRow : itemEntryRows) {
                    long entryItemId = itemEntryRow.getSalaryItemId();
                    if (!itemId.equals(entryItemId)) continue;
                    itemRow = itemEntryRow;
                    break;
                }
                if (itemRow == null) continue;
                itemFlagMap.put(itemId, itemRow.getItemIsUseSalaryRank() > 0);
            }
        }
        return resultMap;
    }

    @Deprecated
    public Map<String, StdRangeQueryResult> getSalaryStdRange(List<StdRangeQueryParam> paramList) {
        Map<Long, List<StdRangeQueryParam>> tabParamMap = paramList.stream().collect(Collectors.groupingBy(StdRangeQueryParam::getStdTabId));
        Map<Long, DynamicObject> stdObj = this.salaryStdTabService.queryStdObj(tabParamMap.keySet());
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)paramList.size());
        for (Map.Entry<Long, List<StdRangeQueryParam>> entry : tabParamMap.entrySet()) {
            Long tabId = entry.getKey();
            DynamicObject tabObj = stdObj.get(tabId);
            if (tabObj == null) continue;
            SalaryStandardEntryData salaryStandardEntryData = EntityConverter.fetchEntityFromModel(tabObj, false);
            List itemEntities = salaryStandardEntryData.getItemEntities();
            List<SalaryGradeEntity> gradeList = GradeRankHelper.sortGradeList(salaryStandardEntryData.getGradeEntities(), 1);
            Map<Long, SalaryGradeEntity> gradeEntityMap = GradeRankHelper.groupByGradeIdentity(gradeList);
            List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(salaryStandardEntryData.getRankEntities());
            List<SalaryRankEntity> rankList = GradeRankHelper.sortRankList(salaryStandardEntryData.getRankEntities(), 1);
            List<SalaryStdDataEntity> stdDataList = SalaryStdDataHelper.getByRankIds(GradeRankHelper.getRankIdSet(standardRanks), salaryStandardEntryData.getStdDataEntities());
            Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(rankList);
            Map<Long, Map<Long, List<SalaryStdDataEntity>>> itemDataMap = SalaryStdDataHelper.groupByItemGrade(stdDataList);
            for (StdRangeQueryParam param : entry.getValue()) {
                Long salaryItemId = param.getItemId();
                BigDecimal amount = param.getAmount();
                if (amount == null) continue;
                long itemIdentity = 0L;
                for (SalaryStdItemEntity entity : itemEntities) {
                    if (!entity.getSalaryItemId().equals(salaryItemId)) continue;
                    itemIdentity = entity.getItemIdentity();
                    break;
                }
                if (itemIdentity == 0L) {
                    throw new KDBizException("salaryitem not exist in standardtable");
                }
                Map<Long, List<SalaryStdDataEntity>> stdDataOfItem = itemDataMap.get(itemIdentity);
                SalaryGradeEntity gradeEntity = null;
                SalaryRankEntity equalRank = null;
                SalaryStdDataEntity gradeMinData = null;
                SalaryStdDataEntity gradeMaxData = null;
                SalaryStdDataEntity rankEqualData = null;
                SalaryStdDataEntity itemMinData = null;
                SalaryStdDataEntity itemMaxData = null;
                block3: for (int i = 0; i < gradeList.size(); ++i) {
                    BigDecimal tempMaxDataMin;
                    SalaryGradeEntity grade = gradeList.get(i);
                    List<SalaryStdDataEntity> stdDataOfGrade = stdDataOfItem.get(grade.getGradeIdentity());
                    if (CollectionUtils.isEmpty(stdDataOfGrade)) continue;
                    SalaryStdDataHelper.sortByRankIndex(stdDataOfGrade, rankEntityMap);
                    int rankSize = stdDataOfGrade.size();
                    SalaryStdDataEntity tempMinData = stdDataOfGrade.get(0);
                    SalaryStdDataEntity tempMaxData = stdDataOfGrade.get(rankSize - 1);
                    BigDecimal tempMinDataMin = tempMinData.getMin() == null ? BigDecimal.ZERO : tempMinData.getMin();
                    BigDecimal bigDecimal = tempMaxDataMin = tempMaxData.getMin() == null ? BigDecimal.ZERO : tempMaxData.getMin();
                    if (param.getRateInfo() != null) {
                        tempMinDataMin = this.convertStdAmountWithExrate(tempMinData.getMin(), param.getRateInfo());
                        tempMaxDataMin = this.convertStdAmountWithExrate(tempMaxData.getMin(), param.getRateInfo());
                    }
                    if (i == 0) {
                        itemMinData = tempMinData;
                    }
                    if (i == gradeList.size() - 1) {
                        itemMaxData = tempMaxData;
                    }
                    if (gradeEntity != null || amount.compareTo(tempMinDataMin) < 0 || amount.compareTo(tempMaxDataMin) > 0) continue;
                    gradeEntity = grade;
                    gradeMinData = tempMinData;
                    gradeMaxData = tempMaxData;
                    for (SalaryStdDataEntity dataEntity : stdDataOfGrade) {
                        BigDecimal dataEntityMin = this.convertStdAmountWithExrate(dataEntity.getMin(), param.getRateInfo());
                        if (dataEntityMin == null || amount.compareTo(dataEntityMin) != 0) continue;
                        equalRank = rankEntityMap.get(dataEntity.getRankIdentity());
                        rankEqualData = dataEntity;
                        continue block3;
                    }
                }
                StdRangeQueryResult queryResult = new StdRangeQueryResult();
                queryResult.setItemMin(itemMinData == null ? null : itemMinData.getMin());
                queryResult.setItemMax(itemMaxData == null ? null : itemMaxData.getMin());
                if (gradeEntity != null) {
                    queryResult.setGradeId(gradeEntity.getId());
                    queryResult.setIntervalMin(gradeMinData == null ? null : gradeMinData.getMin());
                    queryResult.setIntervalMax(gradeMaxData == null ? null : gradeMaxData.getMin());
                    if (equalRank != null) {
                        queryResult.setRankId(equalRank.getId());
                        queryResult.setAmount(rankEqualData == null ? null : rankEqualData.getMin());
                    }
                }
                resultMap.put(param.getUnionKey(), queryResult);
            }
        }
        return resultMap;
    }

    private BigDecimal convertStdAmountWithExrate(BigDecimal originalAmount, ExchangeRateInfo exrate) {
        BigDecimal convertAmount = originalAmount;
        if (exrate != null) {
            Boolean quoteType = exrate.getQuoteType();
            BigDecimal exchangeRate = exrate.getExchangeRate();
            convertAmount = quoteType != false ? originalAmount.divide(exchangeRate, 2, 4) : originalAmount.multiply(exchangeRate);
        }
        return convertAmount;
    }

    public List<SalaryCountAmountMatchResult> matchTableRangeBySalaryCountOrAmount(List<SalaryCountAmountMatchParam> params) {
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)params.size());
        Set<Long> stdIds = params.stream().map(MatchBaseParam::getStdTableId).collect(Collectors.toSet());
        Set usableStdIds = BaseDataHisHelper.getUsableId((String)"hcdm_salarystandard", stdIds);
        if (usableStdIds == null || usableStdIds.size() == 0) {
            return resultList;
        }
        this.removeIllegalItemId(params);
        if (SWCListUtils.isEmpty(params)) {
            return resultList;
        }
        long st = System.currentTimeMillis();
        Map<Long, Map<Long, SalaryGradeEntity>> gradeMap = GradeRankHelper.queryGradeEntityMap(stdIds);
        Map<Long, Map<Long, SalaryRankEntity>> rankMap = GradeRankHelper.queryRankEntityMap(stdIds, true);
        this.log.info(" query grade and rank info cost:{} ms", (Object)(System.currentTimeMillis() - st));
        Set coeficientVidSet = params.stream().map(SalaryCountAmountMatchParam::getCoeficientVid).collect(Collectors.toSet());
        Map<Object, Object> coeficientMap = coeficientVidSet != null && coeficientVidSet.size() > 0 ? this.coefficientService.queryCoefficientValueByIds(new ArrayList<Long>(coeficientVidSet)) : Maps.newHashMapWithExpectedSize((int)0);
        st = System.currentTimeMillis();
        this.doMatchTableBySalaryCountOrAmount(params, resultList, gradeMap, rankMap, usableStdIds, coeficientMap);
        this.log.info("doMatchTableBySalaryCountOrAmount cost:{} ms", (Object)(System.currentTimeMillis() - st));
        return resultList;
    }

    private void doMatchTableBySalaryCountOrAmount(List<SalaryCountAmountMatchParam> params, List<SalaryCountAmountMatchResult> resultList, Map<Long, Map<Long, SalaryGradeEntity>> gradeMap, Map<Long, Map<Long, SalaryRankEntity>> rankMap, Set<Long> usableStdIds, Map<Long, BigDecimal> coeficientMap) {
        long st = System.currentTimeMillis();
        Map<Long, DynamicObject> stdMap = this.salaryStdTabService.queryStdObj(usableStdIds);
        this.log.info("queryStdObj cost:{} ms", (Object)(System.currentTimeMillis() - st));
        st = System.currentTimeMillis();
        Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag = this.getItemUseRankMap(params);
        this.log.info("getItemUseRankMap cost:{} ms", (Object)(System.currentTimeMillis() - st));
        Map<Long, Map<Long, List<SalaryCountAmountMatchParam>>> paramMap = this.groupParamsByStdIdAndItemId(params);
        for (Map.Entry<Long, Map<Long, List<SalaryCountAmountMatchParam>>> stdItemParam : paramMap.entrySet()) {
            Long stdTableId = stdItemParam.getKey();
            Map<Long, List<SalaryCountAmountMatchParam>> itemParamMap = stdItemParam.getValue();
            Set<SalaryGradeEntity> gradeSet = gradeMap.get(stdTableId).values().stream().collect(Collectors.toSet());
            Map<Long, SalaryGradeEntity> gradeIdToEntityMap = gradeSet.stream().collect(Collectors.toMap(SalaryGradeEntity::getId, Function.identity(), (o1, o2) -> o2));
            Map<Long, SalaryRankEntity> rankMapOfTab = rankMap.get(stdTableId);
            Set<SalaryRankEntity> rankSet = rankMapOfTab.values().stream().collect(Collectors.toSet());
            List<SalaryRankEntity> rankList = GradeRankHelper.sortRankList(new ArrayList<SalaryRankEntity>(rankSet), 1);
            Set<Long> rankIdSet = rankList.stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toSet());
            st = System.currentTimeMillis();
            SalaryStandardEntryData salaryStandardEntryData = EntityConverter.fetchEntityFromModel(stdMap.get(stdTableId), false);
            this.log.info("EntityConverter.fetchEntityFromModel cost:{} ms", (Object)(System.currentTimeMillis() - st));
            st = System.currentTimeMillis();
            List itemEntities = salaryStandardEntryData.getItemEntities();
            int amtPrecision = salaryStandardEntryData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision();
            Set itemIdSet = itemEntities.stream().map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toSet());
            List stdDataEntities = salaryStandardEntryData.getStdDataEntities();
            List<SalaryStdDataEntity> stdDataList = SalaryStdDataHelper.getByRankIds(rankIdSet, stdDataEntities);
            SalaryStdDataHelper.sortByRankIndex(stdDataList, rankMapOfTab);
            Map<Long, Map<Long, List<SalaryStdDataEntity>>> itemDataMap = SalaryStdDataHelper.groupByItemGrade(stdDataList);
            Map<Long, Map<Long, List<SalaryStdDataEntity>>> itemDataMapOfReadable = SalaryStdDataHelper.groupByItemGrade(stdDataList);
            for (Map.Entry<Long, List<SalaryCountAmountMatchParam>> itemParam : itemParamMap.entrySet()) {
                Long itemId = itemParam.getKey();
                if (!itemIdSet.contains(itemId)) continue;
                List<SalaryCountAmountMatchParam> paramList = itemParam.getValue();
                Map<Long, List<SalaryStdDataEntity>> stdDataOfItem = itemDataMap.get(itemId);
                Map<Long, List<SalaryStdDataEntity>> stdDataOfItemOfReadable = itemDataMapOfReadable.get(itemId);
                if (stdDataOfItem == null || stdDataOfItem.size() == 0) continue;
                for (SalaryCountAmountMatchParam param : paramList) {
                    SalaryCountAmountMatchResult result = new SalaryCountAmountMatchResult(param.getUnionId());
                    Map gradeRankInfoLimit = param.getGradeRankInfo();
                    Long coeficientVid = param.getCoeficientVid();
                    Long gradeId = param.getGradeId();
                    Boolean useRankFlag = salaryItemUseRankFlag.get(stdTableId).get(itemId);
                    Set<Object> tempGradeSet = useRankFlag != false && gradeId != null ? gradeSet.stream().filter(single -> single.getId().compareTo(gradeId) == 0).collect(Collectors.toSet()) : gradeSet;
                    List<SalaryGradeEntity> gradeList = GradeRankHelper.sortGradeList(new ArrayList<SalaryGradeEntity>(tempGradeSet), 1);
                    if (gradeRankInfoLimit != null && gradeRankInfoLimit.size() > 0) {
                        this.removeNotInLimitData(rankList, gradeList, stdDataOfItem, gradeRankInfoLimit);
                    }
                    if (stdDataOfItem.size() == 0) continue;
                    BigDecimal amount = param.getAmount();
                    BigDecimal salaryCount = param.getSalaryCount();
                    if (amount == null && salaryCount == null) continue;
                    String matchType = amount != null ? "1" : "2";
                    LinkedHashMap matchData = Maps.newLinkedHashMapWithExpectedSize((int)gradeSet.size());
                    ArrayList norankMatchData = Lists.newArrayListWithCapacity((int)gradeSet.size());
                    long start = System.currentTimeMillis();
                    boolean match = this.doSingleMatch(useRankFlag, gradeList, rankList, coeficientMap, coeficientVid, amount, salaryCount, "", matchData, stdDataOfItem, norankMatchData, amtPrecision);
                    this.log.info("doSingleMatch cost:{} ms", (Object)(System.currentTimeMillis() - start));
                    if (!match) continue;
                    result.setItemUseRank(useRankFlag.booleanValue());
                    HashMap gradeIntervalInfo = Maps.newHashMapWithExpectedSize((int)matchData.size());
                    HashMap itemIntervalInfo = Maps.newHashMapWithExpectedSize((int)2);
                    HashSet<Long> matchGradeSet = new HashSet(16);
                    if (useRankFlag.booleanValue()) {
                        matchGradeSet = matchData.keySet();
                    } else {
                        for (Pair pair2 : norankMatchData) {
                            Long key2 = (Long)pair2.getKey();
                            Long value2 = (Long)pair2.getValue();
                            if (key2 > 0L) {
                                matchGradeSet.add(key2);
                            }
                            if (value2 <= 0L) continue;
                            matchGradeSet.add(value2);
                        }
                    }
                    this.assembleGradeAndItemIntervalInfo(salaryStandardEntryData, itemId, gradeIntervalInfo, itemIntervalInfo, matchGradeSet, new ArrayList<SalaryGradeEntity>(gradeSet), matchType, rankSet);
                    result.setPositionInfo((Map)matchData);
                    result.setGradeIntervalInfo((Map)gradeIntervalInfo);
                    if (!useRankFlag.booleanValue()) {
                        result.setPositionInfoOfNotUseRank((List)norankMatchData);
                    }
                    result.setItemIntervalInfo((Map)itemIntervalInfo);
                    result.setAllRankIds(this.assembleAllRankIds(rankSet));
                    result.setAllGradeIds(this.assembleAllGradeIds(gradeSet));
                    this.addMiddleValueToResult(result.getGradeIntervalInfo(), stdDataOfItemOfReadable, gradeIdToEntityMap, SWCStringUtils.equals((String)"1", (String)matchType));
                    LinkedHashMap matchStrategyDataMap = Maps.newLinkedHashMapWithExpectedSize((int)gradeSet.size());
                    ArrayList norankMatchStrategyDataList = Lists.newArrayListWithCapacity((int)gradeSet.size());
                    String matchStrategy = param.getMatchStrategy();
                    List<Object> onGradeIdList = new ArrayList(10);
                    ArrayList<Long> gradeIdList = new ArrayList<Long>(10);
                    ArrayList rankIdList = new ArrayList(10);
                    if (MapUtils.isNotEmpty((Map)matchData)) {
                        matchStrategyDataMap.putAll(matchData);
                        matchStrategyDataMap.forEach((key, value) -> {
                            List positionInfo = (List)matchStrategyDataMap.get(key);
                            positionInfo.forEach(item -> {
                                Long minRankId = (Long)item.getValue();
                                Long maxRankId = (Long)item.getKey();
                                if (minRankId == 0L || maxRankId == 0L) {
                                    gradeIdList.add((Long)key);
                                }
                                rankIdList.add(minRankId);
                                rankIdList.add(maxRankId);
                            });
                        });
                        matchStrategyDataMap.keySet().removeIf(item -> gradeIdList.contains(item));
                    } else if (!CollectionUtils.isEmpty((Collection)norankMatchData)) {
                        norankMatchStrategyDataList.addAll(norankMatchData);
                        for (Pair positionInfoOfNotUseRank : norankMatchStrategyDataList) {
                            Long minGradeId = (Long)positionInfoOfNotUseRank.getKey();
                            Long maxGradeId = (Long)positionInfoOfNotUseRank.getValue();
                            if (minGradeId != 0L && maxGradeId != 0L) continue;
                            gradeIdList.add(minGradeId);
                            gradeIdList.add(maxGradeId);
                        }
                        norankMatchStrategyDataList.removeIf(item -> gradeIdList.contains(item.getKey()) || gradeIdList.contains(item.getValue()));
                        onGradeIdList = norankMatchStrategyDataList.stream().map(map -> (Long)map.getKey()).collect(Collectors.toList());
                        List onGradeValueList = norankMatchStrategyDataList.stream().map(map -> (Long)map.getValue()).collect(Collectors.toList());
                        if (!SWCListUtils.isEmpty(onGradeValueList)) {
                            onGradeIdList.addAll(onGradeValueList);
                        }
                    }
                    if (StringUtils.isNotEmpty((CharSequence)matchStrategy)) {
                        switch (matchStrategy) {
                            case "1": {
                                List rankPairKeyList;
                                List rankPairList;
                                if (MapUtils.isNotEmpty((Map)matchStrategyDataMap)) {
                                    SalaryGradeEntity maxSalaryGradeEntity = gradeSet.stream().filter(entity -> matchStrategyDataMap.containsKey(entity.getId())).max(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).orElse(null);
                                    if (null == maxSalaryGradeEntity) break;
                                    rankPairList = (List)matchStrategyDataMap.get(maxSalaryGradeEntity.getId());
                                    rankPairKeyList = rankPairList.stream().flatMap(pair -> Stream.of((Long)pair.getKey(), (Long)pair.getValue())).collect(Collectors.toList());
                                    SalaryRankEntity maxSalaryRankEntity = rankSet.stream().filter(rankEntity -> rankPairKeyList.contains(rankEntity.getId())).max(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).orElse(null);
                                    result.setGradeId(maxSalaryGradeEntity.getId());
                                    if (null == maxSalaryRankEntity) break;
                                    result.setRankId(maxSalaryRankEntity.getId());
                                    break;
                                }
                                if (CollectionUtils.isEmpty((Collection)norankMatchStrategyDataList)) break;
                                ArrayList finalOnGradeIdList = onGradeIdList;
                                SalaryGradeEntity maxSalaryGradeEntity = gradeSet.stream().filter(entity -> finalOnGradeIdList.contains(entity.getId())).max(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).orElse(null);
                                if (null == maxSalaryGradeEntity) break;
                                result.setGradeId(maxSalaryGradeEntity.getId());
                                break;
                            }
                            case "2": {
                                break;
                            }
                            case "3": {
                                List rankPairKeyList;
                                List rankPairList;
                                if (!CollectionUtils.isEmpty(gradeIdList)) {
                                    SalaryGradeEntity minSalaryGradeEntity = gradeSet.stream().filter(entity -> matchStrategyDataMap.containsKey(entity.getId())).min(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).orElse(null);
                                    if (null == minSalaryGradeEntity) break;
                                    rankPairList = (List)matchStrategyDataMap.get(minSalaryGradeEntity.getId());
                                    rankPairKeyList = rankPairList.stream().flatMap(pair -> Stream.of((Long)pair.getKey(), (Long)pair.getValue())).collect(Collectors.toList());
                                    SalaryRankEntity minSalaryRankEntity = rankSet.stream().filter(entity -> rankPairKeyList.contains(entity.getId())).min(Comparator.comparingInt(SalaryRankEntity::getRankIndex)).orElse(null);
                                    result.setGradeId(minSalaryGradeEntity.getId());
                                    if (null == minSalaryRankEntity) break;
                                    result.setRankId(minSalaryRankEntity.getId());
                                    break;
                                }
                                if (CollectionUtils.isEmpty(onGradeIdList)) break;
                                ArrayList finalOnGradeIdList = onGradeIdList;
                                SalaryGradeEntity minSalaryGradeEntity = gradeSet.stream().filter(entity -> finalOnGradeIdList.contains(entity.getId())).min(Comparator.comparingInt(SalaryGradeEntity::getGradeIndex)).orElse(null);
                                if (null == minSalaryGradeEntity) break;
                                result.setGradeId(minSalaryGradeEntity.getId());
                                break;
                            }
                        }
                    }
                    resultList.add(result);
                }
            }
        }
    }

    private void addMiddleValueToResult(Map<Long, Map<String, BigDecimal>> gradeIntervalInfo, Map<Long, List<SalaryStdDataEntity>> stdDataOfItem, Map<Long, SalaryGradeEntity> gradeIdToEntityMap, boolean withAmount) {
        for (Map.Entry<Long, Map<String, BigDecimal>> entry : gradeIntervalInfo.entrySet()) {
            Long gradeId = entry.getKey();
            Map<String, BigDecimal> intervalMap = entry.getValue();
            BigDecimal middleValue = SalaryStdDataHelper.getMiddleValueByStandardRankData(stdDataOfItem.get(gradeIdToEntityMap.get(gradeId).getGradeIdentity()), withAmount);
            intervalMap.put("gradeMiddle", middleValue);
        }
    }

    private Map<Long, Map<Long, List<SalaryCountAmountMatchParam>>> groupParamsByStdIdAndItemId(List<SalaryCountAmountMatchParam> params) {
        HashMap<Long, Map<Long, List<SalaryCountAmountMatchParam>>> paramMap = new HashMap<Long, Map<Long, List<SalaryCountAmountMatchParam>>>(16);
        for (SalaryCountAmountMatchParam param : params) {
            Long stdTableId = param.getStdTableId();
            Long itemId = param.getItemId();
            Map stdParamMap = paramMap.computeIfAbsent(stdTableId, single -> new HashMap(16));
            List itemParamList = stdParamMap.computeIfAbsent(itemId, single -> new ArrayList(10));
            itemParamList.add(param);
        }
        return paramMap;
    }

    private Map<Long, Map<Long, List<SimpleMatchParam>>> groupSimpleParamsByStdIdAndItemId(List<SimpleMatchParam> params) {
        HashMap<Long, Map<Long, List<SimpleMatchParam>>> paramMap = new HashMap<Long, Map<Long, List<SimpleMatchParam>>>(16);
        for (SimpleMatchParam param : params) {
            Long stdTableId = param.getStdTableId();
            Long itemId = param.getItemId();
            Map stdParamMap = paramMap.computeIfAbsent(stdTableId, single -> new HashMap(16));
            List itemParamList = stdParamMap.computeIfAbsent(itemId, single -> new ArrayList(10));
            itemParamList.add(param);
        }
        return paramMap;
    }

    private List<Long> assembleAllGradeIds(Set<SalaryGradeEntity> gradeSet) {
        List<SalaryGradeEntity> gradeList = GradeRankHelper.sortGradeList(new ArrayList<SalaryGradeEntity>(gradeSet), 1);
        return gradeList.stream().map(SalaryGradeEntity::getId).collect(Collectors.toList());
    }

    private List<Long> assembleAllRankIds(Set<SalaryRankEntity> rankSet) {
        List<SalaryRankEntity> rankList = GradeRankHelper.sortRankList(new ArrayList<SalaryRankEntity>(rankSet), 1);
        return rankList.stream().map(SalaryRankEntity::getId).collect(Collectors.toList());
    }

    private void assembleGradeAndItemIntervalInfo(SalaryStandardEntryData salaryStandardEntryData, Long itemId, Map<Long, Map<String, BigDecimal>> gradeIntervalInfo, Map<String, BigDecimal> itemIntervalInfo, Set<Long> gradeSet, List<SalaryGradeEntity> gradeList, String matchType, Set<SalaryRankEntity> rankSet) {
        Map<Long, List<SalaryStdDataEntity>> groupDataMap = SalaryStdDataHelper.groupByGrade(salaryStandardEntryData.getStdDataEntities());
        Map<Long, SalaryGradeEntity> gradeEntityMap = GradeRankHelper.groupByGradeId(gradeList);
        this.assembleGradeIntervalInfo(itemId, gradeIntervalInfo, gradeSet, matchType, rankSet, groupDataMap, gradeEntityMap);
        this.assembleItemIntervalInfo(itemId, itemIntervalInfo, gradeList, matchType, rankSet, groupDataMap);
    }

    private void assembleItemIntervalInfo(Long itemId, Map<String, BigDecimal> itemIntervalInfo, List<SalaryGradeEntity> gradeList, String matchType, Set<SalaryRankEntity> rankSet, Map<Long, List<SalaryStdDataEntity>> groupDataMap) {
        BigDecimal maxValue;
        BigDecimal minValue;
        List<SalaryGradeEntity> sortedGradeList = GradeRankHelper.sortGradeList(gradeList, 1);
        SalaryGradeEntity minGrade = sortedGradeList.get(0);
        SalaryGradeEntity maxGrade = sortedGradeList.get(sortedGradeList.size() - 1);
        List<SalaryRankEntity> rankList = GradeRankHelper.sortRankList(new ArrayList<SalaryRankEntity>(rankSet), 1);
        SalaryRankEntity minRank = rankList.get(0);
        SalaryRankEntity maxRank = rankList.get(rankList.size() - 1);
        List<SalaryStdDataEntity> minGradeDatas = groupDataMap.get(minGrade.getGradeIdentity());
        List<SalaryStdDataEntity> maxGradeDatas = groupDataMap.get(maxGrade.getGradeIdentity());
        Map<Long, List<SalaryStdDataEntity>> minDataByItemMap = SalaryStdDataHelper.groupByItem(minGradeDatas);
        Map<Long, List<SalaryStdDataEntity>> maxDataByItemMap = SalaryStdDataHelper.groupByItem(maxGradeDatas);
        List<SalaryStdDataEntity> minItemDataList = minDataByItemMap.get(itemId);
        List<SalaryStdDataEntity> maxItemDataList = maxDataByItemMap.get(itemId);
        Map minRankDataMap = minItemDataList.stream().collect(Collectors.toMap(SalaryStdDataEntity::getRankIdentity, Function.identity()));
        Map maxRankDataMap = maxItemDataList.stream().collect(Collectors.toMap(SalaryStdDataEntity::getRankIdentity, Function.identity()));
        SalaryStdDataEntity minEntity = (SalaryStdDataEntity)minRankDataMap.get(minRank.getRankIdentity());
        SalaryStdDataEntity maxEntity = (SalaryStdDataEntity)maxRankDataMap.get(maxRank.getRankIdentity());
        if (SWCStringUtils.equals((String)"1", (String)matchType)) {
            minValue = minEntity == null ? null : minEntity.getMin();
            maxValue = maxEntity == null ? null : maxEntity.getMin();
        } else {
            minValue = minEntity == null ? null : minEntity.getSalaryCount();
            maxValue = maxEntity == null ? null : maxEntity.getSalaryCount();
        }
        itemIntervalInfo.put("itemMin", minValue);
        itemIntervalInfo.put("itemMax", maxValue);
    }

    private void assembleGradeIntervalInfo(Long itemId, Map<Long, Map<String, BigDecimal>> gradeIntervalInfo, Set<Long> gradeSet, String matchType, Set<SalaryRankEntity> rankSet, Map<Long, List<SalaryStdDataEntity>> groupDataMap, Map<Long, SalaryGradeEntity> gradeEntityMap) {
        List<SalaryRankEntity> rankList = GradeRankHelper.sortRankList(new ArrayList<SalaryRankEntity>(rankSet), 1);
        SalaryRankEntity minRankData = rankList.get(0);
        SalaryRankEntity maxRankData = rankList.get(rankList.size() - 1);
        for (Long gradeId : gradeSet) {
            BigDecimal maxValue;
            BigDecimal minValue;
            List<SalaryStdDataEntity> salaryStdDataEntities;
            SalaryGradeEntity salaryGradeEntity = gradeEntityMap.get(gradeId);
            if (salaryGradeEntity == null || SWCListUtils.isEmpty(salaryStdDataEntities = groupDataMap.get(salaryGradeEntity.getGradeIdentity()))) continue;
            Map<Long, List<SalaryStdDataEntity>> dataByItemMap = SalaryStdDataHelper.groupByItem(salaryStdDataEntities);
            List<SalaryStdDataEntity> itemDataList = dataByItemMap.get(itemId);
            Map rankDataMap = itemDataList.stream().collect(Collectors.toMap(SalaryStdDataEntity::getRankIdentity, Function.identity()));
            Map gradeIntervalMap = gradeIntervalInfo.computeIfAbsent(gradeId, single -> Maps.newLinkedHashMapWithExpectedSize((int)2));
            SalaryStdDataEntity minEntity = (SalaryStdDataEntity)rankDataMap.get(minRankData.getRankIdentity());
            SalaryStdDataEntity maxEntity = (SalaryStdDataEntity)rankDataMap.get(maxRankData.getRankIdentity());
            if (SWCStringUtils.equals((String)"1", (String)matchType)) {
                minValue = minEntity == null ? null : minEntity.getMin();
                maxValue = maxEntity == null ? null : maxEntity.getMin();
            } else {
                minValue = minEntity == null ? null : minEntity.getSalaryCount();
                maxValue = maxEntity == null ? null : maxEntity.getSalaryCount();
            }
            gradeIntervalMap.put("gradeMin", minValue);
            gradeIntervalMap.put("gradeMax", maxValue);
        }
    }

    private Map<String, Long> assemblePositionNotUseRank(List<SalaryGradeEntity> gradeList, Map<Long, List<Pair<Long, Long>>> onlyGradeMatchData) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
        if (onlyGradeMatchData.size() > 0) {
            Set<Long> gradeIdSet = onlyGradeMatchData.keySet();
            Map gradeMap = gradeList.stream().collect(Collectors.toMap(SalaryGradeEntity::getId, Function.identity(), (v1, v2) -> v1));
            HashSet<SalaryGradeEntity> tempGradeSet = new HashSet<SalaryGradeEntity>(onlyGradeMatchData.size());
            for (Long gradeId : gradeIdSet) {
                tempGradeSet.add((SalaryGradeEntity)gradeMap.get(gradeId));
            }
            List<Long> gradeIdList = this.assembleAllGradeIds(tempGradeSet);
            dataMap.put("minGradeId", gradeIdList.get(0));
            dataMap.put("maxGradeId", gradeIdList.get(gradeIdList.size() - 1));
        }
        return dataMap;
    }

    private Map<Long, Map<String, Long>> assemblePositionInfo(Map<Long, Map<Long, Long>> matchData) {
        HashMap data = Maps.newHashMapWithExpectedSize((int)matchData.size());
        if (matchData.size() == 0) {
            return data;
        }
        for (Map.Entry<Long, Map<Long, Long>> entry : matchData.entrySet()) {
            Map<Long, Long> value = entry.getValue();
            if (value.size() == 0) continue;
            Map dataMap = data.computeIfAbsent(entry.getKey(), single -> Maps.newHashMapWithExpectedSize((int)2));
            dataMap.put("minRankId", new ArrayList<Long>(value.keySet()).get(0));
            dataMap.put("maxRankId", new ArrayList<Long>(value.values()).get(0));
        }
        return data;
    }

    private boolean doSingleMatch(Boolean useRankFlag, List<SalaryGradeEntity> gradeList, List<SalaryRankEntity> rankList, Map<Long, BigDecimal> coeficientMap, Long coeficientVid, BigDecimal amount, BigDecimal salaryCount, String matchType, LinkedHashMap<Long, List<Pair<Long, Long>>> matchData, Map<Long, List<SalaryStdDataEntity>> stdDataOfItem, List<Pair<Long, Long>> norankMatchData, int amtPrecision) {
        Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(rankList);
        Map<Long, SalaryGradeEntity> gradeEntityMap = GradeRankHelper.groupByGradeIdentity(gradeList);
        if (SWCStringUtils.isEmpty((String)matchType)) {
            matchType = amount != null ? "1" : "2";
            BigDecimal coeficientValue = coeficientMap.get(coeficientVid);
            BigDecimal matchAmount = amount != null ? amount : salaryCount;
            this.matchByAmountOrSCount(useRankFlag, norankMatchData, coeficientValue, gradeList, rankEntityMap, gradeEntityMap, matchAmount, stdDataOfItem, matchData, matchType, amtPrecision);
        } else {
            this.matchByAmountOrSCount(useRankFlag, norankMatchData, null, gradeList, rankEntityMap, gradeEntityMap, amount, stdDataOfItem, matchData, "1", amtPrecision);
        }
        return true;
    }

    private Map<Long, Map<Long, Boolean>> getItemUseRankMap(List<? extends MatchBaseParam> params) {
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)params.size());
        for (MatchBaseParam matchBaseParam : params) {
            Long stdId = matchBaseParam.getStdTableId();
            Long itemId = matchBaseParam.getItemId();
            List itemIdList = stdItemMap.computeIfAbsent(stdId, single -> Lists.newArrayListWithExpectedSize((int)10));
            itemIdList.add(itemId);
        }
        return this.getSalaryItemUseRankFlag(stdItemMap);
    }

    private void removeNotInLimitData(List<SalaryRankEntity> rankList, List<SalaryGradeEntity> gradeList, Map<Long, List<SalaryStdDataEntity>> stdDataOfItem, Map<Long, List<Long>> gradeRankInfoLimit) {
        Map<Long, Long> gradeMap = gradeList.stream().collect(Collectors.toMap(SalaryGradeEntity::getGradeIdentity, SalaryGradeEntity::getId));
        Map<Long, Long> rankMap = rankList.stream().collect(Collectors.toMap(SalaryRankEntity::getRankIdentity, SalaryRankEntity::getId));
        Iterator<SalaryGradeEntity> gradeIterator = gradeList.iterator();
        while (gradeIterator.hasNext()) {
            SalaryGradeEntity next = gradeIterator.next();
            Long tmpGradeId = next.getId();
            if (gradeRankInfoLimit.containsKey(tmpGradeId)) continue;
            gradeIterator.remove();
        }
        Iterator<Map.Entry<Long, List<SalaryStdDataEntity>>> stdDataIterator = stdDataOfItem.entrySet().iterator();
        while (stdDataIterator.hasNext()) {
            Map.Entry<Long, List<SalaryStdDataEntity>> entry = stdDataIterator.next();
            Long tempGradeIdentity = entry.getKey();
            Long tempGradeId = gradeMap.get(tempGradeIdentity);
            List<Long> tempRankList = gradeRankInfoLimit.get(tempGradeId);
            if (SWCListUtils.isEmpty(tempRankList)) {
                stdDataIterator.remove();
                continue;
            }
            List<SalaryStdDataEntity> stdDataEntityList = entry.getValue();
            Iterator<SalaryStdDataEntity> iterator = stdDataEntityList.iterator();
            while (iterator.hasNext()) {
                SalaryStdDataEntity next = iterator.next();
                Long rankIdentity = next.getRankIdentity();
                Long tempRankId = rankMap.get(rankIdentity);
                if (tempRankList.contains(tempRankId)) continue;
                iterator.remove();
            }
        }
    }

    public Map<String, StdSimpleMatchResult> matchTableRange(List<SimpleMatchParam> params) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)params.size());
        Set stdIds = params.stream().map(MatchBaseParam::getStdTableId).collect(Collectors.toSet());
        Set usableStdIds = BaseDataHisHelper.getUsableId((String)"hcdm_salarystandard", stdIds);
        if (usableStdIds == null || usableStdIds.size() == 0) {
            return result;
        }
        this.removeIllegalItemId(params);
        if (SWCListUtils.isEmpty(params)) {
            return result;
        }
        SalaryStdMatchManager matchManager = new SalaryStdMatchManager();
        Map<Long, List<GradeRankKey>> stdGradeRankLimitMap = matchManager.assembleGradeAndRankByConfProp(params, result, usableStdIds);
        this.log.info("assembleGradeAndRankByConfProp_result:{}", (Object)JSON.toJSONString((Object)result));
        this.matchGradeRankByAmount(params, result, usableStdIds, stdGradeRankLimitMap);
        return result;
    }

    public void matchByAmountOrSCount(Boolean useRankFlag, List<Pair<Long, Long>> norankMatchData, BigDecimal coeficientValue, List<SalaryGradeEntity> gradeList, Map<Long, SalaryRankEntity> rankEntityMap, Map<Long, SalaryGradeEntity> gradeEntityMap, BigDecimal amount, Map<Long, List<SalaryStdDataEntity>> stdDataOfItem, LinkedHashMap<Long, List<Pair<Long, Long>>> matchData, String type, int amtPrecision) {
        if (!useRankFlag.booleanValue()) {
            List<Object> gradeDataList = Lists.newArrayListWithCapacity((int)stdDataOfItem.size());
            for (int i = 0; i < gradeList.size(); ++i) {
                SalaryGradeEntity grade = gradeList.get(i);
                Long gradeIdentity = grade.getGradeIdentity();
                List<SalaryStdDataEntity> stdDataOfGrade = stdDataOfItem.get(gradeIdentity);
                if (CollectionUtils.isEmpty(stdDataOfGrade)) continue;
                gradeDataList.addAll(stdDataOfGrade);
            }
            gradeDataList = this.transferByCoeficientOrExchageRate(coeficientValue, (List<SalaryStdDataEntity>)gradeDataList, amtPrecision);
            List<Pair<Long, Long>> matchList = this.getMatchData(amount, type, (List<SalaryStdDataEntity>)gradeDataList, rankEntityMap, gradeEntityMap, useRankFlag);
            norankMatchData.addAll(matchList);
        } else {
            for (int i = 0; i < gradeList.size(); ++i) {
                SalaryGradeEntity grade = gradeList.get(i);
                Long gradeIdentity = grade.getGradeIdentity();
                Long gradeId = gradeEntityMap.get(gradeIdentity).getId();
                List<SalaryStdDataEntity> stdDataOfGrade = stdDataOfItem.get(gradeIdentity);
                if (CollectionUtils.isEmpty(stdDataOfGrade)) continue;
                Iterator<SalaryStdDataEntity> iterator = stdDataOfGrade.iterator();
                while (iterator.hasNext()) {
                    SalaryStdDataEntity next = iterator.next();
                    Long rankIdentity = next.getRankIdentity();
                    if (rankEntityMap.containsKey(rankIdentity)) continue;
                    iterator.remove();
                }
                SalaryStdDataHelper.sortByRankIndex(stdDataOfGrade, rankEntityMap);
                stdDataOfGrade = this.transferByCoeficientOrExchageRate(coeficientValue, stdDataOfGrade, amtPrecision);
                long st = System.currentTimeMillis();
                List<Pair<Long, Long>> matchList = this.getMatchData(amount, type, stdDataOfGrade, rankEntityMap, gradeEntityMap, true);
                this.log.info(" getMatchData cost:{} ms", (Object)(System.currentTimeMillis() - st));
                matchData.put(gradeId, matchList);
            }
        }
    }

    private List<SalaryStdDataEntity> transferByCoeficientOrExchageRate(BigDecimal coeficientValue, List<SalaryStdDataEntity> stdDataOfGrade, int amtPrecision) {
        if (CollectionUtils.isEmpty(stdDataOfGrade)) {
            return Collections.emptyList();
        }
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)stdDataOfGrade.size());
        long st = System.currentTimeMillis();
        for (int j = 0; j < stdDataOfGrade.size(); ++j) {
            SalaryStdDataEntity tempMinData = stdDataOfGrade.get(j).cloneBy();
            resultList.add(tempMinData);
            BigDecimal minAmount = tempMinData.getMin();
            BigDecimal salaryCount = tempMinData.getSalaryCount();
            if (coeficientValue != null) {
                if (minAmount != null) {
                    minAmount = minAmount.multiply(coeficientValue).setScale(amtPrecision, 4);
                }
                if (salaryCount != null) {
                    salaryCount = salaryCount.multiply(coeficientValue);
                }
            }
            tempMinData.setMin(minAmount);
            tempMinData.setSalaryCount(salaryCount);
        }
        this.log.info("transferByCoeficientOrExchageRate cost:{} ms", (Object)(System.currentTimeMillis() - st));
        return resultList;
    }

    private List<Pair<Long, Long>> getMatchData(BigDecimal amount, String type, List<SalaryStdDataEntity> stdDataOfGrade, Map<Long, SalaryRankEntity> rankEntityMap, Map<Long, SalaryGradeEntity> gradeEntityMap, boolean useRank) {
        BigDecimal tempLastAmount;
        Iterator<SalaryStdDataEntity> iterator = stdDataOfGrade.iterator();
        while (iterator.hasNext()) {
            SalaryStdDataEntity next = iterator.next();
            BigDecimal min = next.getMin();
            BigDecimal salaryCount = next.getSalaryCount();
            boolean nullCheck = SWCStringUtils.equals((String)"1", (String)type) && min == null || SWCStringUtils.equals((String)"2", (String)type) && salaryCount == null;
            if (!nullCheck) continue;
            iterator.remove();
        }
        ArrayList matchList = Lists.newArrayListWithCapacity((int)10);
        if (stdDataOfGrade.size() == 1) {
            BigDecimal singleAmount;
            SalaryStdDataEntity singleData = stdDataOfGrade.get(0);
            BigDecimal bigDecimal = singleAmount = SWCStringUtils.equals((String)"1", (String)type) ? singleData.getMin().stripTrailingZeros() : singleData.getSalaryCount().stripTrailingZeros();
            if (amount.compareTo(singleAmount) == 0) {
                Long sameId = useRank ? rankEntityMap.get(singleData.getRankIdentity()).getId() : gradeEntityMap.get(singleData.getGradeIdentity()).getId();
                matchList.add(new Pair((Object)sameId, (Object)sameId));
            } else if (amount.compareTo(singleAmount) > 0) {
                Long minId = useRank ? rankEntityMap.get(singleData.getRankIdentity()).getId() : gradeEntityMap.get(singleData.getGradeIdentity()).getId();
                matchList.add(new Pair((Object)minId, (Object)0L));
            } else {
                Long maxId = useRank ? rankEntityMap.get(singleData.getRankIdentity()).getId() : gradeEntityMap.get(singleData.getGradeIdentity()).getId();
                matchList.add(new Pair((Object)0L, (Object)maxId));
            }
            return matchList;
        }
        Map<BigDecimal, List<SalaryStdDataEntity>> amountMap = stdDataOfGrade.stream().collect(Collectors.groupingBy(single -> single.getMin().stripTrailingZeros()));
        Map<BigDecimal, List<SalaryStdDataEntity>> salaryCountMap = stdDataOfGrade.stream().filter(single -> single.getSalaryCount() != null).collect(Collectors.groupingBy(single -> single.getSalaryCount().stripTrailingZeros()));
        ArrayList tempDataList = Lists.newArrayListWithCapacity((int)stdDataOfGrade.size());
        tempDataList.addAll(stdDataOfGrade);
        tempDataList.sort(Comparator.comparing(SalaryStdDataEntity::getMin));
        SalaryStdDataEntity firstDataRank = (SalaryStdDataEntity)tempDataList.get(0);
        SalaryStdDataEntity lastDataRank = (SalaryStdDataEntity)tempDataList.get(tempDataList.size() - 1);
        BigDecimal tempFirstAmount = SWCStringUtils.equals((String)"1", (String)type) ? firstDataRank.getMin().stripTrailingZeros() : firstDataRank.getSalaryCount().stripTrailingZeros();
        BigDecimal bigDecimal = tempLastAmount = SWCStringUtils.equals((String)"1", (String)type) ? lastDataRank.getMin().stripTrailingZeros() : lastDataRank.getSalaryCount().stripTrailingZeros();
        if (amount.compareTo(tempFirstAmount) < 0) {
            Long minId = 0L;
            List<SalaryStdDataEntity> maxList = SWCStringUtils.equals((String)"1", (String)type) ? amountMap.get(tempFirstAmount) : salaryCountMap.get(tempFirstAmount);
            for (SalaryStdDataEntity dataEntity : maxList) {
                Long maxId = useRank ? rankEntityMap.get(dataEntity.getRankIdentity()).getId() : gradeEntityMap.get(dataEntity.getGradeIdentity()).getId();
                matchList.add(new Pair((Object)minId, (Object)maxId));
            }
            return matchList;
        }
        if (amount.compareTo(tempLastAmount) > 0) {
            Long maxId = 0L;
            List<SalaryStdDataEntity> minList = SWCStringUtils.equals((String)"1", (String)type) ? amountMap.get(tempLastAmount) : salaryCountMap.get(tempLastAmount);
            for (SalaryStdDataEntity dataEntity : minList) {
                Long minId = useRank ? rankEntityMap.get(dataEntity.getRankIdentity()).getId() : gradeEntityMap.get(dataEntity.getGradeIdentity()).getId();
                matchList.add(new Pair((Object)minId, (Object)maxId));
            }
            return matchList;
        }
        for (int j = 0; j < stdDataOfGrade.size() - 1; ++j) {
            BigDecimal tempMaxAmount;
            SalaryStdDataEntity tempMinData = stdDataOfGrade.get(j);
            SalaryStdDataEntity tempMaxData = stdDataOfGrade.get(j + 1);
            BigDecimal tempMinAmount = SWCStringUtils.equals((String)"1", (String)type) ? tempMinData.getMin().stripTrailingZeros() : tempMinData.getSalaryCount().stripTrailingZeros();
            BigDecimal bigDecimal2 = tempMaxAmount = SWCStringUtils.equals((String)"1", (String)type) ? tempMaxData.getMin().stripTrailingZeros() : tempMaxData.getSalaryCount().stripTrailingZeros();
            if (tempMinAmount.compareTo(tempMaxAmount) > 0) {
                tempMinAmount = tempMinAmount.add(tempMaxAmount);
                tempMaxAmount = tempMinAmount.subtract(tempMaxAmount);
                tempMinAmount = tempMinAmount.subtract(tempMaxAmount);
            }
            if (amount.compareTo(tempMinAmount) == 0 || amount.compareTo(tempMaxAmount) == 0) {
                List<SalaryStdDataEntity> dataList = SWCStringUtils.equals((String)"1", (String)type) ? amountMap.get(amount.stripTrailingZeros()) : salaryCountMap.get(amount.stripTrailingZeros());
                for (SalaryStdDataEntity dataEntity : dataList) {
                    Long sameId = useRank ? rankEntityMap.get(dataEntity.getRankIdentity()).getId() : gradeEntityMap.get(dataEntity.getGradeIdentity()).getId();
                    matchList.add(new Pair((Object)sameId, (Object)sameId));
                }
                return matchList;
            }
            if (amount.compareTo(tempMinAmount) <= 0 || amount.compareTo(tempMaxAmount) >= 0) continue;
            Long minId = useRank ? rankEntityMap.get(tempMinData.getRankIdentity()).getId() : gradeEntityMap.get(tempMinData.getGradeIdentity()).getId();
            Long maxId = useRank ? rankEntityMap.get(tempMaxData.getRankIdentity()).getId() : gradeEntityMap.get(tempMaxData.getGradeIdentity()).getId();
            matchList.add(new Pair((Object)minId, (Object)maxId));
        }
        return matchList;
    }

    public void matchGradeRankByAmount(List<SimpleMatchParam> params, Map<String, StdSimpleMatchResult> result, Set<Long> stdIds, Map<Long, List<GradeRankKey>> stdGradeRankLimitMap) {
        Map<Long, DynamicObject> stdMap = this.salaryStdTabService.queryStdObj(stdIds);
        Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag = this.getItemUseRankMap(params);
        Map<Long, Map<Long, List<SimpleMatchParam>>> paramMap = this.groupSimpleParamsByStdIdAndItemId(params);
        for (Map.Entry<Long, Map<Long, List<SimpleMatchParam>>> stdItemParam : paramMap.entrySet()) {
            Long stdTableId = stdItemParam.getKey();
            Map<Long, List<SimpleMatchParam>> itemParamMap = stdItemParam.getValue();
            List<GradeRankKey> gradeRankInfo = stdGradeRankLimitMap.get(stdTableId);
            if (SWCListUtils.isEmpty(gradeRankInfo)) continue;
            Set gradeSet = gradeRankInfo.stream().map(GradeRankKey::getGradeEntity).collect(Collectors.toSet());
            Set rankSet = gradeRankInfo.stream().map(GradeRankKey::getRankEntity).collect(Collectors.toSet());
            List<SalaryGradeEntity> gradeList = GradeRankHelper.sortGradeList(new ArrayList<SalaryGradeEntity>(gradeSet), 1);
            List<SalaryRankEntity> rankList = GradeRankHelper.sortRankList(new ArrayList<SalaryRankEntity>(rankSet), 1);
            Set<Long> rankIdSet = rankList.stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toSet());
            SalaryStandardEntryData salaryStandardEntryData = EntityConverter.fetchEntityFromModel(stdMap.get(stdTableId), false);
            List itemEntities = salaryStandardEntryData.getItemEntities();
            int amtPrecision = salaryStandardEntryData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision();
            Set itemIdSet = itemEntities.stream().map(SalaryStdItemEntity::getItemIdentity).collect(Collectors.toSet());
            for (Map.Entry<Long, List<SimpleMatchParam>> itemParam : itemParamMap.entrySet()) {
                Long itemId = itemParam.getKey();
                if (!itemIdSet.contains(itemId)) continue;
                List<SimpleMatchParam> paramList = itemParam.getValue();
                List<SalaryStdDataEntity> stdDataList = SalaryStdDataHelper.getByRankIds(rankIdSet, salaryStandardEntryData.getStdDataEntities());
                Map<Long, Map<Long, List<SalaryStdDataEntity>>> itemDataMap = SalaryStdDataHelper.groupByItemGrade(stdDataList);
                Map<Long, List<SalaryStdDataEntity>> stdDataOfItem = itemDataMap.get(itemId);
                if (stdDataOfItem == null || stdDataOfItem.size() == 0) continue;
                Map<Long, List<Long>> gradeRankInfoLimit = this.assembleGradeRankLimitMap(gradeRankInfo);
                this.removeNotInLimitData(rankList, gradeList, stdDataOfItem, gradeRankInfoLimit);
                if (stdDataOfItem.size() == 0) continue;
                for (SimpleMatchParam param : paramList) {
                    ArrayList norankMatchData;
                    LinkedHashMap matchData;
                    String uniqueCode = param.getUniqueCode();
                    StdSimpleMatchResult stdSimpleMatchResult = result.get(uniqueCode);
                    if (stdSimpleMatchResult == null) continue;
                    BigDecimal amount = param.getAmount();
                    Boolean useRankFlag = salaryItemUseRankFlag.get(stdTableId).get(itemId);
                    boolean match = this.doSingleMatch(useRankFlag, gradeList, rankList, null, null, amount, null, "1", matchData = Maps.newLinkedHashMapWithExpectedSize((int)gradeSet.size()), stdDataOfItem, norankMatchData = Lists.newArrayListWithCapacity((int)gradeSet.size()), amtPrecision);
                    if (!match) continue;
                    if (useRankFlag.booleanValue()) {
                        stdSimpleMatchResult.setPositionInfo((Map)matchData);
                        continue;
                    }
                    stdSimpleMatchResult.setPositionInfoOfNotUseRank((List)norankMatchData);
                }
            }
        }
    }

    private Map<Long, List<Long>> assembleGradeRankLimitMap(List<GradeRankKey> gradeRankInfo) {
        HashMap limitMap = Maps.newHashMapWithExpectedSize((int)gradeRankInfo.size());
        for (GradeRankKey gradeRankKey : gradeRankInfo) {
            Long gradeId = gradeRankKey.getGradeEntity().getId();
            Long rankId = gradeRankKey.getRankEntity().getId();
            List rankIdList = limitMap.computeIfAbsent(gradeId, single -> new ArrayList(10));
            rankIdList.add(rankId);
        }
        return limitMap;
    }

    public Map<Long, List<ContrastPropResult>> getContrastProp(List<Long> stdTableIdList) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)stdTableIdList.size());
        Set usableStdIds = BaseDataHisHelper.getUsableId((String)"hcdm_salarystandard", stdTableIdList);
        if (usableStdIds == null || usableStdIds.size() == 0) {
            return dataMap;
        }
        Map<Long, DynamicObject> stdObjMap = this.queryStdObj(usableStdIds, "salarystddata_a");
        for (Map.Entry<Long, DynamicObject> entry : stdObjMap.entrySet()) {
            Long tabId = entry.getKey();
            DynamicObject tabObj = entry.getValue();
            SalaryStandardEntryData standardEntryData = EntityConverter.fetchEntityFromModelWithEntryName(tabObj, "contrastps", "contrastsumdata");
            List contrastRowEntities = standardEntryData.getContrastRowEntities();
            List contrastPropEntities = standardEntryData.getContrastPropEntities();
            ArrayList propResultList = Lists.newArrayListWithExpectedSize((int)contrastPropEntities.size());
            dataMap.put(tabId, propResultList);
            for (ContrastPropEntity propEntity : contrastPropEntities) {
                ContrastPropResult contrastPropResult = new ContrastPropResult(propEntity.getPropConfigEntity());
                HashSet valueSet = Sets.newHashSetWithExpectedSize((int)contrastRowEntities.size());
                for (ContrastRowDataEntity contrastRowEntity : contrastRowEntities) {
                    Map stdPropValueMap = contrastRowEntity.getStdPropValueMap();
                    List propValues = (List)stdPropValueMap.get(propEntity.getPropConfigId());
                    if (!CollectionUtils.isNotEmpty((Collection)propValues)) continue;
                    valueSet.addAll(propValues);
                }
                contrastPropResult.setPropValueList((List)Lists.newArrayList((Iterable)valueSet));
                propResultList.add(contrastPropResult);
            }
        }
        this.log.info("contrastProps:{}", (Object)JSON.toJSONString((Object)dataMap));
        return dataMap;
    }

    @Deprecated
    private void mergeData(Map<Long, List<ContrastPropResult>> dataMap, Map<Long, List<ContrastPropConfigEntity>> applyRangeContrastProps, Map<Long, List<ContrastPropConfigEntity>> contrastProps, Map<Long, List<ContrastDataEntity>> contrastDataList, Map<Long, List<ContrastDataEntity>> appliedRangeDataList) {
    }

    @Deprecated
    private void mergePropValue(Map<Long, List<ContrastPropResult>> dataMap, Map<Long, List<ContrastPropConfigEntity>> contrastProps, Map<Long, List<ContrastDataEntity>> contrastDataList, Set<Long> existPropConfigIdSet) {
    }

    public void removeIllegalItemId(List<? extends MatchBaseParam> params) {
        SalaryStandardEntryData salaryStandardEntryData;
        Long stdTableId;
        Set<Long> stdIds = params.stream().map(MatchBaseParam::getStdTableId).collect(Collectors.toSet());
        Map<Long, DynamicObject> stdMap = this.salaryStdTabService.queryStdObj(stdIds);
        if (stdMap == null || stdMap.size() == 0) {
            this.log.info("stdMap is empty,stdIds:{}", stdIds);
            return;
        }
        HashMap stdEntryDataMap = Maps.newHashMapWithExpectedSize((int)stdMap.size());
        for (Map.Entry<Long, DynamicObject> entry : stdMap.entrySet()) {
            stdTableId = entry.getKey();
            DynamicObject tabObj = entry.getValue();
            salaryStandardEntryData = EntityConverter.fetchEntityFromModel(tabObj, false);
            stdEntryDataMap.put(stdTableId, salaryStandardEntryData);
        }
        Iterator<? extends MatchBaseParam> iterator = params.iterator();
        while (iterator.hasNext()) {
            Set itemSet;
            MatchBaseParam param = iterator.next();
            stdTableId = param.getStdTableId();
            Long itemId = param.getItemId();
            salaryStandardEntryData = (SalaryStandardEntryData)stdEntryDataMap.get(stdTableId);
            List itemEntities = salaryStandardEntryData.getItemEntities();
            if (SWCListUtils.isEmpty((List)itemEntities)) {
                iterator.remove();
            }
            if ((itemSet = itemEntities.stream().map(SalaryStdItemEntity::getSalaryItemId).collect(Collectors.toSet())).contains(itemId)) continue;
            iterator.remove();
        }
    }

    private List<StdAmountQueryParam> checkParamList(List<StdAmountQueryParam> paramsList, List<StdAmountQueryParam> allFailResultDataList) {
        Map<String, List<StdAmountQueryParam>> checkResultMap = this.checkMustField(paramsList);
        List<StdAmountQueryParam> passCheckDataList = checkResultMap.get(PASS_DATA);
        List<StdAmountQueryParam> checkMustFailAdjInfoList = checkResultMap.get(FAIL_DATA);
        allFailResultDataList.addAll(checkMustFailAdjInfoList);
        return passCheckDataList;
    }

    private Map<String, List<StdAmountQueryParam>> checkMustField(List<StdAmountQueryParam> paramsList) {
        HashMap<String, List<StdAmountQueryParam>> checkResultMap = new HashMap<String, List<StdAmountQueryParam>>(16);
        ArrayList<StdAmountQueryParam> passCheckDataList = new ArrayList<StdAmountQueryParam>(10);
        ArrayList<StdAmountQueryParam> checkMustFailAdjInfoList = new ArrayList<StdAmountQueryParam>(10);
        HashSet<String> unionIds = new HashSet<String>(16);
        for (StdAmountQueryParam params : paramsList) {
            if (params.getStdTabId() == null || params.getItemId() == null || params.getGradeId() == null || params.getUnionId() == null) {
                checkMustFailAdjInfoList.add(params);
                continue;
            }
            String unionId = params.getUnionId();
            if (!unionIds.add(unionId)) {
                checkMustFailAdjInfoList.add(params);
                continue;
            }
            passCheckDataList.add(params);
        }
        checkResultMap.put(PASS_DATA, passCheckDataList);
        checkResultMap.put(FAIL_DATA, checkMustFailAdjInfoList);
        return checkResultMap;
    }

    public List<StdAmountAndSalaryCountQueryResult> queryAmountAndSalaryCount(List<StdAmountQueryParam> params) {
        if (params == null || params.isEmpty()) {
            return new ArrayList<StdAmountAndSalaryCountQueryResult>();
        }
        ArrayList<StdAmountQueryParam> allFailResultDataList = new ArrayList<StdAmountQueryParam>(10);
        List<StdAmountQueryParam> passCheckDataList = this.checkParamList(params, allFailResultDataList);
        ArrayList queryResults = Lists.newArrayListWithExpectedSize((int)passCheckDataList.size());
        Set itemIds = passCheckDataList.stream().map(StdAmountQueryParam::getItemId).collect(Collectors.toCollection(() -> new HashSet(16)));
        SWCDataServiceHelper itemHelper = new SWCDataServiceHelper("hsbs_standarditem");
        QFilter itemFilter = new QFilter("id", "in", (Object)itemIds);
        DynamicObject[] itemDys = itemHelper.loadDynamicObjectArray(itemFilter.toArray());
        Set existItemIds = Arrays.stream(itemDys).map(itemDy -> itemDy.getLong("id")).collect(Collectors.toCollection(() -> new HashSet(16)));
        Map<Long, List<StdAmountQueryParam>> paramMap = passCheckDataList.stream().collect(Collectors.groupingBy(StdAmountQueryParam::getStdTabId));
        Set coefficientIds = passCheckDataList.stream().map(StdAmountQueryParam::getCoefficientVid).collect(Collectors.toCollection(() -> new HashSet(16)));
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salarystandard");
        QFilter filter = new QFilter("id", "in", paramMap.keySet());
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = helper.loadDynamicObjectArray(filter.toArray());
        Map stdMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(object -> object.getLong("id"), Function.identity(), (o1, o2) -> o2));
        Map<Long, BigDecimal> coefficientIdAndValue = this.coefficientService.queryCoefficientValueByIds(coefficientIds);
        for (Map.Entry<Long, List<StdAmountQueryParam>> entry : paramMap.entrySet()) {
            Long tabId = entry.getKey();
            List<StdAmountQueryParam> paramOfTab = entry.getValue();
            DynamicObject tabObj = (DynamicObject)stdMap.get(tabId);
            if (tabId <= 0L || tabObj == null) continue;
            SalaryStandardEntryData standardEntryData = EntityConverter.fetchEntityFromModel(tabObj, false);
            Map<Long, SalaryStdItemEntity> itemMap = SalaryStdItemHelper.groupBySalaryItemId(standardEntryData.getItemEntities());
            Map<Long, SalaryGradeEntity> gradeIdMap = GradeRankHelper.groupByGradeId(standardEntryData.getGradeEntities());
            List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(standardEntryData.getRankEntities());
            Map<Long, SalaryRankEntity> rankIdMap = GradeRankHelper.groupByRankId(standardRanks);
            List<SalaryStdDataEntity> standardStdDataList = SalaryStdDataHelper.getByRankIds(GradeRankHelper.getRankIdSet(standardRanks), standardEntryData.getStdDataEntities());
            Map<Long, SalaryRankEntity> rankIdentityMap = GradeRankHelper.groupByRankIdentity(standardRanks);
            Map<Long, Map<Long, List<SalaryStdDataEntity>>> gradeItemDataMap = SalaryStdDataHelper.groupByGradeItem(standardStdDataList);
            SalaryStandardBaseEntity stdBaseEntity = standardEntryData.getStdBaseEntity();
            assert (stdBaseEntity != null);
            boolean isSalaryCount = SalaryStandardTypeEnum.SALARYCOUNT.equals((Object)stdBaseEntity.getType());
            for (StdAmountQueryParam stdAmountQueryParam : paramOfTab) {
                StdAmountAndSalaryCountQueryResult result = new StdAmountAndSalaryCountQueryResult();
                Long coefficientVid = stdAmountQueryParam.getCoefficientVid();
                BigDecimal coefficientValue = null;
                if (coefficientVid != null) {
                    coefficientValue = coefficientIdAndValue.get(coefficientVid);
                }
                boolean isNeedMultiply = coefficientValue != null;
                result.setUnionId(stdAmountQueryParam.getUnionId());
                result.setCurrency(stdBaseEntity.getCurrencyId());
                result.setUnit(stdBaseEntity.getMonetaryUnit());
                result.setCountry(stdBaseEntity.getCountryId());
                result.setFrequency(stdBaseEntity.getFrequencyId());
                Long itemId = stdAmountQueryParam.getItemId();
                if (!existItemIds.contains(itemId)) {
                    logger.info("itemId not audit or enable");
                    continue;
                }
                SalaryStdItemEntity salaryStdItemEntity = itemMap.get(itemId);
                if (salaryStdItemEntity == null) {
                    logger.info("itemId not exist in table");
                    continue;
                }
                if (salaryStdItemEntity.getItemIsUseSalaryRank() == 1 && stdAmountQueryParam.getRankId() == null) {
                    logger.info("ItemIsUseSalaryCount but rankId is null");
                    continue;
                }
                SalaryGradeEntity gradeEntity = gradeIdMap.get(stdAmountQueryParam.getGradeId());
                if (gradeEntity == null) {
                    logger.info("gradeId not exist in table");
                    continue;
                }
                Map<Long, List<SalaryStdDataEntity>> stdDataOfGrade = gradeItemDataMap.get(gradeEntity.getGradeIdentity());
                if (MapUtils.isEmpty(stdDataOfGrade)) {
                    logger.info("current grade not set amount");
                    continue;
                }
                List<SalaryStdDataEntity> stdDataEntities = stdDataOfGrade.get(salaryStdItemEntity.getItemIdentity());
                if (CollectionUtils.isEmpty(stdDataEntities)) {
                    logger.info("current item not set amount");
                    continue;
                }
                SalaryStdDataHelper.sortByRankIndex(stdDataEntities, rankIdentityMap);
                SalaryStdDataEntity minData = stdDataEntities.get(0);
                SalaryStdDataEntity maxData = stdDataEntities.get(stdDataEntities.size() - 1);
                BigDecimal middleAmountVal = SalaryStdDataHelper.getMiddleValueByStandardRankData(stdDataEntities, true);
                BigDecimal middleSalaryCountVal = SalaryStdDataHelper.getMiddleValueByStandardRankData(stdDataEntities, false);
                BigDecimal minDataMin = minData.getMin();
                BigDecimal maxDataMin = maxData.getMin();
                BigDecimal minDataSalaryCount = minData.getSalaryCount();
                BigDecimal maxDataSalaryCount = maxData.getSalaryCount();
                if (isNeedMultiply) {
                    if (minDataMin != null) {
                        minDataMin = coefficientValue.multiply(minDataMin);
                    }
                    if (maxDataMin != null) {
                        maxDataMin = coefficientValue.multiply(maxDataMin);
                    }
                    if (minDataSalaryCount != null) {
                        minDataSalaryCount = coefficientValue.multiply(minDataSalaryCount);
                    }
                    if (maxDataSalaryCount != null) {
                        maxDataSalaryCount = coefficientValue.multiply(maxDataSalaryCount);
                    }
                    if (middleSalaryCountVal != null) {
                        middleSalaryCountVal = coefficientValue.multiply(middleSalaryCountVal);
                    }
                    if (middleAmountVal != null) {
                        middleAmountVal = coefficientValue.multiply(middleAmountVal);
                    }
                }
                result.setGradeMinAmount(minDataMin);
                result.setGradeMaxAmount(maxDataMin);
                result.setGradeMiddleAmount(middleAmountVal);
                if (isSalaryCount) {
                    result.setGradeMinCount(minDataSalaryCount);
                    result.setGradeMaxCount(maxDataSalaryCount);
                    result.setGradeMiddleCount(middleSalaryCountVal);
                }
                Long rankId = stdAmountQueryParam.getRankId();
                BigDecimal amount = null;
                BigDecimal salaryCount = null;
                if (rankId != null && rankId != 0L) {
                    SalaryRankEntity rankEntity = rankIdMap.get(rankId);
                    if (rankEntity == null) {
                        logger.info("rankId not exist in table");
                        continue;
                    }
                    for (SalaryStdDataEntity stdDataEntity : stdDataEntities) {
                        if (!stdDataEntity.getRankIdentity().equals(rankEntity.getRankIdentity())) continue;
                        amount = stdDataEntity.getMin();
                        salaryCount = stdDataEntity.getSalaryCount();
                        break;
                    }
                } else {
                    for (SalaryStdDataEntity stdDataEntity : stdDataEntities) {
                        if (!stdDataEntity.getGradeIdentity().equals(gradeEntity.getGradeIdentity())) continue;
                        amount = stdDataEntity.getMin();
                        salaryCount = stdDataEntity.getSalaryCount();
                        break;
                    }
                }
                if (isNeedMultiply && amount != null) {
                    amount = coefficientValue.multiply(amount);
                }
                result.setAmount(amount);
                if (isSalaryCount) {
                    if (isNeedMultiply && salaryCount != null) {
                        salaryCount = coefficientValue.multiply(salaryCount);
                    }
                    result.setSalaryCount(salaryCount);
                }
                queryResults.add(result);
            }
        }
        return queryResults;
    }

    public List<StdOverStandardQueryResult> getOverStandardType(List<StdOverStandardQueryParam> params) {
        long beginTime = TimeServiceHelper.now().getTime();
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)params.size());
        HashSet coefficientIdSet = Sets.newHashSet();
        HashMap tabIdItemIdToParamMap = Maps.newHashMap();
        Iterator<StdOverStandardQueryParam> iterator = params.iterator();
        while (iterator.hasNext()) {
            StdOverStandardQueryParam param = iterator.next();
            if (param.getTabId() > 0L && param.getItemId() > 0L && param.getUnionId() != null && MapUtils.isNotEmpty(param.getPersonRange()) && (param.getAmount() != null || param.getSalaryCount() != null)) {
                Map stdOverStandardQueryParams = tabIdItemIdToParamMap.computeIfAbsent(param.getTabId(), o1 -> Maps.newHashMap());
                List paramsOfItem = stdOverStandardQueryParams.computeIfAbsent(param.getItemId(), o1 -> Lists.newArrayList());
                paramsOfItem.add(param);
                if (param.getCoefficientId() == null || param.getCoefficientId() <= 0L) continue;
                coefficientIdSet.add(param.getCoefficientId());
                continue;
            }
            iterator.remove();
        }
        if (tabIdItemIdToParamMap.isEmpty()) {
            return resultList;
        }
        Map<Long, DynamicObject> stdObjMap = this.salaryStdTabService.queryStdObjWithIgnore(tabIdItemIdToParamMap.keySet(), "contrastsumdata");
        Map<Long, BigDecimal> coefficientValueMap = this.coefficientService.queryCoefficientValueByIds(coefficientIdSet);
        this.log.info("getOverStandardType_cost afterqueryStdObj costtime {}", (Object)(TimeServiceHelper.now().getTime() - beginTime));
        for (Map.Entry entry : tabIdItemIdToParamMap.entrySet()) {
            Long tabId = (Long)entry.getKey();
            Map tabParams = (Map)entry.getValue();
            DynamicObject tabObj = stdObjMap.get(tabId);
            if (tabObj == null) continue;
            long oneTableBeginTime = TimeServiceHelper.now().getTime();
            SalaryStandardEntryData salaryStandardEntryData = EntityConverter.fetchEntityFromModelWithEntryName(tabObj, "salarystditem", "salarygrade", "salaryrank", "salarystddata_a");
            int amtPrecision = salaryStandardEntryData.getStdBaseEntity().getCurrencyEntity().getAmtPrecision();
            List gradeEntities = salaryStandardEntryData.getGradeEntities();
            List<SalaryStdItemEntity> itemEntities = SalaryStdItemHelper.fetchStandardItem(salaryStandardEntryData.getItemEntities());
            List<SalaryRankEntity> rankEntities = GradeRankHelper.fetchStandardRank(salaryStandardEntryData.getRankEntities());
            Map<Long, SalaryStdItemEntity> standardItemIdToEntryMap = SalaryStdItemHelper.groupBySalaryItemId(itemEntities);
            Map<Long, SalaryGradeEntity> gradeIdToEntryMap = GradeRankHelper.groupByGradeId(gradeEntities);
            Map<Long, Integer> gradeIdentityIndexMap = GradeRankHelper.groupGradeIdToIndex(gradeEntities, true);
            Map<Long, Integer> gradeIdIndexMap = GradeRankHelper.groupGradeIdToIndex(gradeEntities, false);
            Map<Long, SalaryRankEntity> rankIdToEntryMap = GradeRankHelper.groupByRankId(rankEntities);
            Map<Long, Integer> rankIdentityIndexMap = GradeRankHelper.groupRankIdToIndex(rankEntities, true);
            List<SalaryStdDataEntity> stdDataEntities = SalaryStdDataHelper.getByRankIds(rankIdentityIndexMap.keySet(), salaryStandardEntryData.getStdDataEntities());
            Map<Long, Integer> rankIdIndexMap = GradeRankHelper.groupRankIdToIndex(rankEntities, false);
            Map<Long, SalaryRankEntity> rankIdentityToEntryMap = GradeRankHelper.groupByRankIdentity(rankEntities);
            Map<Long, List<SalaryStdDataEntity>> itemIdentityToDataMap = SalaryStdDataHelper.groupByItem(SalaryStdDataHelper.filterByItem(stdDataEntities, itemEntities));
            boolean isUseSalaryRank = salaryStandardEntryData.getStdBaseEntity().getIsUseSalaryRank() == 1;
            SalaryRankEntity systemSetRank = rankEntities.get(0);
            this.log.info("getOverStandardType_cost afteroneTablePrepared costtime {}", (Object)(TimeServiceHelper.now().getTime() - oneTableBeginTime));
            for (Map.Entry itemParamsEntry : tabParams.entrySet()) {
                long oneParamBeginTime = TimeServiceHelper.now().getTime();
                Long standardItemId = (Long)itemParamsEntry.getKey();
                List itemParams = (List)itemParamsEntry.getValue();
                SalaryStdItemEntity itemEntity = standardItemIdToEntryMap.get(standardItemId);
                if (itemEntity != null) {
                    List<SalaryStdDataEntity> oneItemDataList = itemIdentityToDataMap.get(itemEntity.getItemIdentity());
                    if (CollectionUtils.isEmpty(oneItemDataList)) continue;
                    for (StdOverStandardQueryParam param : itemParams) {
                        boolean rangeInTab = this.checkPersonRangeInTab(param.getPersonRange(), gradeIdToEntryMap, rankIdToEntryMap);
                        if (!rangeInTab) continue;
                        List<SalaryStdDataEntity> oneItemDataListOfCurParam = this.transferByCoeficientOrExchageRate(coefficientValueMap.get(param.getCoefficientId()), oneItemDataList, amtPrecision);
                        SalaryStdDataHelper.sortByRankIndex(oneItemDataListOfCurParam, rankIdentityToEntryMap);
                        Map<Long, List<Long>> personRange = param.getPersonRange();
                        boolean withAmount = param.getAmount() != null;
                        List<Pair<GradeRankKey, GradeRankKey>> splitRanges = GradeRankHelper.splitToMultiInterval(personRange, gradeIdToEntryMap, rankIdToEntryMap, gradeIdIndexMap, rankIdIndexMap, systemSetRank);
                        BigDecimal minOffirstRange = null;
                        BigDecimal maxOffirstRange = null;
                        boolean belongInterval = false;
                        OverStandardTypeEnum overStandardTypeEnum = OverStandardTypeEnum.WITHIN_LIMIT;
                        StdOverStandardQueryResult queryResult = new StdOverStandardQueryResult();
                        resultList.add(queryResult);
                        BigDecimal paramValue = withAmount ? param.getAmount() : param.getSalaryCount();
                        for (Pair<GradeRankKey, GradeRankKey> oneRange : splitRanges) {
                            Pair<BigDecimal, BigDecimal> intervalVal = ContrastDataHelper.getMinMaxValueByInterval((GradeRankKey)oneRange.getKey(), (GradeRankKey)oneRange.getValue(), oneItemDataListOfCurParam, gradeIdentityIndexMap, rankIdentityIndexMap, withAmount);
                            BigDecimal rangeMin = (BigDecimal)intervalVal.getKey();
                            BigDecimal rangeMax = (BigDecimal)intervalVal.getValue();
                            if (paramValue.compareTo(rangeMin) >= 0 && paramValue.compareTo(rangeMax) <= 0) {
                                belongInterval = true;
                            }
                            if (minOffirstRange == null) {
                                minOffirstRange = rangeMin;
                            }
                            if (maxOffirstRange != null) continue;
                            maxOffirstRange = rangeMax;
                        }
                        if (!belongInterval) {
                            if (minOffirstRange != null && paramValue.compareTo(minOffirstRange) < 0) {
                                overStandardTypeEnum = OverStandardTypeEnum.BELOW_LIMIT;
                            } else if (maxOffirstRange != null && paramValue.compareTo(maxOffirstRange) > 0) {
                                overStandardTypeEnum = OverStandardTypeEnum.UPPER_LIMIT;
                            }
                        }
                        queryResult.setOverStandardTypeEnum(overStandardTypeEnum);
                        queryResult.setUnionId(param.getUnionId());
                        this.log.info("getOverStandardType minOffirstRange ={} ,maxOffirstRange ={} , overStandardType = {}", new Object[]{minOffirstRange, maxOffirstRange, overStandardTypeEnum.getCode()});
                    }
                }
                this.log.info("getOverStandardType_cost oneParamHandled costtime {}", (Object)(TimeServiceHelper.now().getTime() - oneParamBeginTime));
            }
        }
        this.log.info("getOverStandardType costtime {} , param size = {}", (Object)(TimeServiceHelper.now().getTime() - beginTime), (Object)params.size());
        return resultList;
    }

    private boolean checkPersonRangeInTab(Map<Long, List<Long>> personRange, Map<Long, SalaryGradeEntity> gradeIdToEntryMap, Map<Long, SalaryRankEntity> rankIdToEntryMap) {
        if (MapUtils.isNotEmpty(personRange)) {
            for (Long gradeId : personRange.keySet()) {
                if (gradeIdToEntryMap.containsKey(gradeId)) continue;
                return false;
            }
        }
        return true;
    }

    public void parseJsonToMap(JSONObject rankMap, Map<Long, Integer> rankSeqMap) {
        if (rankMap == null) {
            return;
        }
        for (Map.Entry entry : rankMap.entrySet()) {
            String identity = (String)entry.getKey();
            Object index = entry.getValue();
            if (identity == null || index == null) continue;
            rankSeqMap.put(Long.parseLong(identity), Integer.parseInt(index.toString()));
        }
    }

    public void putValueToMap(Map<String, String> valueMap, String key, BigDecimal value) {
        if (value != null) {
            valueMap.put(key, value.toPlainString());
        }
    }

    public Map<String, Map<Long, Integer>> parseGradeRankSeqMap(String gradeRankSeqMapStr) {
        HashMap<String, Map<Long, Integer>> gradeRankSeqMap = new HashMap<String, Map<Long, Integer>>(2);
        JSONObject jsonObject = JSON.parseObject((String)gradeRankSeqMapStr);
        if (StringUtils.isEmpty((CharSequence)gradeRankSeqMapStr) || jsonObject == null) {
            return gradeRankSeqMap;
        }
        JSONObject gradeMap = jsonObject.getJSONObject("grade");
        JSONObject rankMap = jsonObject.getJSONObject("rank");
        HashMap<Long, Integer> gradeSeqMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> rankSeqMap = new HashMap<Long, Integer>(16);
        this.parseJsonToMap(gradeMap, gradeSeqMap);
        this.parseJsonToMap(rankMap, rankSeqMap);
        gradeRankSeqMap.put("grade", gradeSeqMap);
        gradeRankSeqMap.put("rank", rankSeqMap);
        return gradeRankSeqMap;
    }

    public Map<String, Map<Integer, Long>> reverseGradeRankSeqMap(Map<String, Map<Long, Integer>> gradeRankSeqMap) {
        HashMap<String, Map<Integer, Long>> result = new HashMap<String, Map<Integer, Long>>(2);
        Map<Long, Integer> gradeSeqMap = gradeRankSeqMap.get("grade");
        Map<Long, Integer> rankSeqMap = gradeRankSeqMap.get("rank");
        if (gradeSeqMap == null || rankSeqMap == null) {
            return result;
        }
        Map gradeSeqMapNew = gradeSeqMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1, () -> new HashMap(16)));
        Map rankSeqMapNew = rankSeqMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (v1, v2) -> v1, () -> new HashMap(16)));
        result.put("grade", gradeSeqMapNew);
        result.put("rank", rankSeqMapNew);
        return result;
    }

    public LinkedHashMap<Long, String> getItemLevelStdDataStr(List<SalaryStdDataEntity> dataList, Map<String, Map<Long, Integer>> gradeRankSeqMap) {
        LinkedHashMap<Long, String> result = new LinkedHashMap<Long, String>(16);
        LinkedHashMap groupData = Maps.newLinkedHashMapWithExpectedSize((int)50);
        for (SalaryStdDataEntity data : dataList) {
            List stdDataEntities = groupData.computeIfAbsent(data.getItemIdentity(), codeMap -> new ArrayList(16));
            stdDataEntities.add(data);
        }
        Map<Long, Integer> gradeIdAndSeq = gradeRankSeqMap.get("grade");
        Map<Long, Integer> rankIdAndSeq = gradeRankSeqMap.get("rank");
        if (gradeIdAndSeq == null || gradeIdAndSeq.isEmpty() || rankIdAndSeq == null || rankIdAndSeq.isEmpty()) {
            return result;
        }
        for (Map.Entry entry : groupData.entrySet()) {
            Long itemIdentityId = (Long)entry.getKey();
            result.put(itemIdentityId, this.getOneItemStdDataStr((List)entry.getValue(), gradeIdAndSeq, rankIdAndSeq));
        }
        return result;
    }

    public String getOneItemStdDataStr(List<SalaryStdDataEntity> stdDataEntities, Map<Long, Integer> gradeIdAndSeq, Map<Long, Integer> rankIdAndSeq) {
        HashMap<String, HashMap<String, String>> stdDataMap = new HashMap<String, HashMap<String, String>>();
        for (SalaryStdDataEntity entity : stdDataEntities) {
            Integer rankSeq = rankIdAndSeq.get(entity.getRankIdentity());
            Integer gradeSeq = gradeIdAndSeq.get(entity.getGradeIdentity());
            if (rankSeq == null || gradeSeq == null) continue;
            String key = gradeSeq + String.valueOf('&') + rankSeq;
            HashMap<String, String> valueMap = new HashMap<String, String>(4);
            this.putValueToMap(valueMap, "s", entity.getSalaryCount());
            this.putValueToMap(valueMap, "n", entity.getMin());
            this.putValueToMap(valueMap, "d", entity.getMiddle());
            this.putValueToMap(valueMap, "m", entity.getMax());
            if (valueMap.isEmpty()) continue;
            stdDataMap.put(key, valueMap);
        }
        return JSON.toJSONString(stdDataMap);
    }

    public List<SalaryStdDataEntity> parseStdDataToEntity(Long stdId, Long itemIdentity, String stdData, String gradeRankSeqMapStr) {
        List<SalaryStdDataEntity> stdDataEntities = this.parseStdDataToEntity(stdData, gradeRankSeqMapStr);
        stdDataEntities.forEach(stdDataEntity -> {
            stdDataEntity.setSalaryStandardId(stdId);
            stdDataEntity.setItemIdentity(itemIdentity);
        });
        return stdDataEntities;
    }

    public List<SalaryStdDataEntity> parseStdDataToEntity(Long stdId, Long itemIdentity, String stdData, Map<String, Map<Integer, Long>> reverseGradeRankSeqMap) {
        List<SalaryStdDataEntity> stdDataEntities = this.parseStdDataToEntity(stdData, reverseGradeRankSeqMap);
        stdDataEntities.forEach(stdDataEntity -> {
            stdDataEntity.setSalaryStandardId(stdId);
            stdDataEntity.setItemIdentity(itemIdentity);
        });
        return stdDataEntities;
    }

    private List<SalaryStdDataEntity> parseStdDataToEntity(String stdData, Map<String, Map<Integer, Long>> reverseGradeRankSeqMap) {
        Map<String, Map<String, String>> gradeRankValueMap = this.parseJsonToMap(stdData);
        return this.getSalaryStdDataEntities(reverseGradeRankSeqMap, gradeRankValueMap);
    }

    public List<SalaryStdDataEntity> parseStdDataToEntity(String stdData, String gradeRankSeqMapStr) {
        Map<String, Map<Long, Integer>> gradeRankSeqMap = this.parseGradeRankSeqMap(gradeRankSeqMapStr);
        Map<String, Map<Integer, Long>> reverseGradeRankSeqMap = this.reverseGradeRankSeqMap(gradeRankSeqMap);
        Map<String, Map<String, String>> gradeRankValueMap = this.parseJsonToMap(stdData);
        return this.getSalaryStdDataEntities(reverseGradeRankSeqMap, gradeRankValueMap);
    }

    public Map<String, Long> getGradeAndRankIdFromCombineKey(String gradeRankKey, Map<String, Map<Integer, Long>> gradeRankSeqMap) {
        HashMap<String, Long> result = new HashMap<String, Long>(2);
        int index = gradeRankKey.indexOf(38);
        String gradeSeqStr = gradeRankKey.substring(0, index);
        String rankSeqStr = gradeRankKey.substring(index + 1);
        Map<Integer, Long> gradeIdAndSeq = gradeRankSeqMap.get("grade");
        Map<Integer, Long> rankIdAndSeq = gradeRankSeqMap.get("rank");
        Long gradeIdentity = gradeIdAndSeq.get(Integer.parseInt(gradeSeqStr));
        Long rankIdentity = rankIdAndSeq.get(Integer.parseInt(rankSeqStr));
        result.put("gradeIdentity", gradeIdentity);
        result.put("rankIdentity", rankIdentity);
        return result;
    }

    public Map<String, Map<String, String>> parseJsonToMap(String stdDataJsonStr) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(16);
        JSONObject jsonObject = JSON.parseObject((String)stdDataJsonStr);
        if (jsonObject == null) {
            return result;
        }
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            Map valueA = (Map)value;
            result.put((String)entry.getKey(), valueA);
        }
        return result;
    }

    private BigDecimal getValueFromMap(Map<String, String> valueMap, String key) {
        String valueStr = valueMap.get(key);
        if (StringUtils.isNotEmpty((CharSequence)valueStr)) {
            return new BigDecimal(valueStr);
        }
        return null;
    }

    private List<SalaryStdDataEntity> getSalaryStdDataEntities(Map<String, Map<Integer, Long>> reverseGradeRankSeqMap, Map<String, Map<String, String>> gradeRankValueMap) {
        ArrayList<SalaryStdDataEntity> entities = new ArrayList<SalaryStdDataEntity>(10);
        for (Map.Entry<String, Map<String, String>> entry : gradeRankValueMap.entrySet()) {
            String gradeRankKey = entry.getKey();
            Map<String, Long> gradeAndRankIdFromCombineKey = this.getGradeAndRankIdFromCombineKey(gradeRankKey, reverseGradeRankSeqMap);
            Long gradeIdentity = gradeAndRankIdFromCombineKey.get("gradeIdentity");
            Long rankIdentity = gradeAndRankIdFromCombineKey.get("rankIdentity");
            Map<String, String> valueMap = entry.getValue();
            BigDecimal max = this.getValueFromMap(valueMap, "m");
            BigDecimal min = this.getValueFromMap(valueMap, "n");
            BigDecimal middle = this.getValueFromMap(valueMap, "d");
            BigDecimal salaryCount = this.getValueFromMap(valueMap, "s");
            entities.add(new SalaryStdDataEntity(Long.valueOf(0L), Long.valueOf(0L), gradeIdentity, rankIdentity, salaryCount, min, middle, max));
        }
        return entities;
    }

    public GradeRankSeqMapEntity getGradeRankSeqMapEntity(String gradeRankSeqMapStr) {
        GradeRankSeqMapEntity gradeRankSeqMapEntity = new GradeRankSeqMapEntity();
        gradeRankSeqMapEntity.setDbValue(gradeRankSeqMapStr);
        Map<String, Map<Long, Integer>> gradeRankSeqMap = this.parseGradeRankSeqMap(gradeRankSeqMapStr);
        gradeRankSeqMapEntity.setGradeSeqMap(gradeRankSeqMap.get("grade"));
        gradeRankSeqMapEntity.setGradeSeqMap(gradeRankSeqMap.get("rank"));
        return gradeRankSeqMapEntity;
    }

    public Map<Long, DynamicObject> queryStdObj(Set<Long> stdIdSet, String ... ignoreEntryName) {
        return this.salaryStdTabService.queryStdObjWithIgnore(stdIdSet, ignoreEntryName);
    }

    public Pair<Long, Long> getMinOrMaxGradeAndRankIdFromRel(Map<Long, List<Long>> rangeData, Long stdId, String matchStrategy) {
        if (stdId == null || stdId == 0L || MapUtils.isEmpty(rangeData)) {
            logger.info("getMinOrMaxGradeAndRankIdFromRel stdId[{}] or rangeData[{}] is null", (Object)stdId, rangeData);
            return new Pair(null, null);
        }
        Map<Long, List<SalaryGradeEntity>> stdGradeMap = GradeRankHelper.queryGradeEntities(Sets.newHashSet((Object[])new Long[]{stdId}));
        if (MapUtils.isEmpty(stdGradeMap)) {
            logger.info("getMinOrMaxGradeAndRankIdFromRel stdGradeMap is null");
            return new Pair(null, null);
        }
        Pair result = new Pair();
        Map<Long, SalaryGradeEntity> gradeMap = stdGradeMap.get(stdId).stream().collect(Collectors.toMap(SalaryGradeEntity::getId, grade -> grade, (o1, o2) -> o2));
        List sortedGradeList = rangeData.keySet().stream().map(gradeMap::get).sorted(Comparator.comparing(SalaryGradeEntity::getGradeIndex)).collect(Collectors.toList());
        if (StringUtils.isNotEmpty((CharSequence)matchStrategy)) {
            switch (matchStrategy) {
                case "1": {
                    result.setKey((Object)((SalaryGradeEntity)sortedGradeList.get(sortedGradeList.size() - 1)).getId());
                    break;
                }
                case "2": {
                    break;
                }
                case "3": {
                    result.setKey((Object)((SalaryGradeEntity)sortedGradeList.get(0)).getId());
                }
            }
        }
        if (result.getKey() == null || (Long)result.getKey() == 0L) {
            return result;
        }
        Map<Long, List<SalaryRankEntity>> stdRankMap = GradeRankHelper.querySalaryRankEntities(Sets.newHashSet((Object[])new Long[]{stdId}), true);
        Map<Long, SalaryRankEntity> rankMap = stdRankMap.get(stdId).stream().collect(Collectors.toMap(SalaryRankEntity::getId, grade -> grade, (o1, o2) -> o2));
        List sortedRankList = rangeData.get(result.getKey()).stream().map(rankMap::get).sorted(Comparator.comparing(SalaryRankEntity::getRankIndex)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sortedRankList)) {
            return result;
        }
        if (StringUtils.isNotEmpty((CharSequence)matchStrategy)) {
            switch (matchStrategy) {
                case "1": {
                    result.setValue((Object)((SalaryRankEntity)sortedRankList.get(sortedRankList.size() - 1)).getId());
                    break;
                }
                case "2": {
                    break;
                }
                case "3": {
                    result.setValue((Object)((SalaryRankEntity)sortedRankList.get(0)).getId());
                }
            }
        }
        logger.info("getMinOrMaxGradeAndRankIdFromRel result is [{}]", (Object)result);
        return result;
    }

    public Map<String, Map<Long, List<SalaryStdDataEntity>>> getStdTableData(List<StdTableDataQueryParam> params) {
        if (CollectionUtils.isEmpty(params)) {
            return Collections.emptyMap();
        }
        Set unionIdSet = params.stream().map(StdTableDataQueryParam::getUnionId).collect(Collectors.toSet());
        if (params.size() > unionIdSet.size()) {
            throw new KDBizException("unionid is duplicated");
        }
        Map<Long, List<StdTableDataQueryParam>> tableGroupParam = params.stream().filter(param -> StringUtils.isNotBlank((CharSequence)param.getUnionId()) && param.getStdTabId() != null && param.getGradeId() != null).collect(Collectors.groupingBy(StdTableDataQueryParam::getStdTabId));
        Map<Long, DynamicObject> objectMap = this.queryStdObj(tableGroupParam.keySet(), "contrastps", "contrastsumdata");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)params.size());
        GradeRankHelper gradeRankHelper = GradeRankHelper.getInstance();
        for (Map.Entry<Long, List<StdTableDataQueryParam>> tableParamEntry : tableGroupParam.entrySet()) {
            Long tableId = tableParamEntry.getKey();
            DynamicObject tableObj = objectMap.get(tableId);
            if (tableObj == null) {
                throw new KDBizException("tableId not exist in system");
            }
            SalaryStandardEntryData standardEntryData = EntityConverter.fetchEntityFromModelWithEntryName(tableObj, "salarystditem", "salarygrade", "salaryrank", "salarystddata_a");
            List stdDataEntities = standardEntryData.getStdDataEntities();
            List<SalaryStdItemEntity> standardItemList = SalaryStdItemHelper.fetchStandardItem(standardEntryData.getItemEntities());
            List<Long> itemIdentityList = SalaryStdItemHelper.getAllItemIdentities(standardEntryData.getItemEntities());
            Map<Long, SalaryStdItemEntity> salaryItemIdToEntityMap = SalaryStdItemHelper.groupBySalaryItemId(standardItemList);
            Map<Long, SalaryStdItemEntity> itemIdToEntityMap = SalaryStdItemHelper.groupById(standardEntryData.getItemEntities());
            Map<Long, SalaryRankEntity> rankIdentityMap = GradeRankHelper.groupByRankIdentity(standardEntryData.getRankEntities());
            Map<Long, SalaryGradeEntity> gradeIdToEntityMap = GradeRankHelper.groupByGradeId(standardEntryData.getGradeEntities());
            Map<Integer, SalaryGradeEntity> gradeIndexToEntityMap = GradeRankHelper.gradeMapByIndexAsc(standardEntryData.getGradeEntities());
            Map<Long, SalaryGradeEntity> gradeIdentityToEntityMap = GradeRankHelper.groupByGradeIdentity(standardEntryData.getGradeEntities());
            List<SalaryRankEntity> rankEntities = GradeRankHelper.sortRankList(standardEntryData.getRankEntities(), 1);
            Set<Long> rankIdentitySet = rankIdentityMap.keySet();
            List<SalaryStdDataEntity> standardData = stdDataEntities.stream().filter(dataEntity -> dataEntity.getRankIdentity() != null && dataEntity.getRankIdentity() > 0L && rankIdentitySet.contains(dataEntity.getRankIdentity())).filter(dataEntity -> dataEntity.getItemIdentity() != null && dataEntity.getItemIdentity() > 0L && itemIdentityList.contains(dataEntity.getItemIdentity())).collect(Collectors.toList());
            Map<Long, Map<Long, List<SalaryStdDataEntity>>> itemGradeMapData = SalaryStdDataHelper.groupByItemGrade(standardData);
            for (StdTableDataQueryParam param2 : tableParamEntry.getValue()) {
                List<Long> gradeIdentityRange;
                boolean predictItemNotEmpty;
                boolean itemIdNotEmpty = param2.getItemId() != null && param2.getItemId() > 0L;
                boolean bl = predictItemNotEmpty = param2.getVarPredictItemId() != null && param2.getVarPredictItemId() > 0L;
                if (param2.getStdTabId() == 0L || !itemIdNotEmpty && !predictItemNotEmpty || param2.getGradeId() == 0L) continue;
                boolean withSpecialItem = predictItemNotEmpty && !itemIdNotEmpty;
                Long itemId = withSpecialItem ? param2.getVarPredictItemId() : param2.getItemId();
                NeedRankType needRankType = (NeedRankType)EnumUtils.getEnum(NeedRankType.class, (String)(StringUtils.isEmpty((CharSequence)param2.getNeedRankType()) ? "STANDARD" : param2.getNeedRankType()));
                if (needRankType == null) {
                    throw new KDBizException("needRankType Illegal");
                }
                SalaryStdItemEntity salaryStdItemEntity = itemIdToEntityMap.get(itemId);
                if (salaryStdItemEntity == null) {
                    throw new KDBizException("itemId or varPredictItemId not exist");
                }
                Map<Long, List<SalaryStdDataEntity>> gradeMapData = itemGradeMapData.get(itemId);
                if (MapUtils.isEmpty(gradeMapData) || (gradeIdentityRange = this.getGradeIdentityRangeByOffSet(gradeIdToEntityMap, gradeIndexToEntityMap, param2)).isEmpty()) continue;
                List<SalaryRankEntity> displayRankWithExt = gradeRankHelper.getDisplayRankForGroupItemWithExt(standardEntryData.getStdBaseEntity(), salaryStdItemEntity, rankEntities);
                List<Long> rankIdentitys = this.getRankIdentityByRankType(displayRankWithExt, needRankType);
                if (CollectionUtils.isEmpty(rankIdentitys)) {
                    throw new KDBizException("itemId has no relation with rank ");
                }
                HashMap gradeDataMap = Maps.newHashMapWithExpectedSize((int)gradeIdentityRange.size());
                for (Long gradeIdentity : gradeIdentityRange) {
                    List<SalaryStdDataEntity> stdDataOfOneGrade = gradeMapData.get(gradeIdentity);
                    stdDataOfOneGrade = SalaryStdDataHelper.fetchDataWithRankId(stdDataOfOneGrade, rankIdentitys);
                    SalaryGradeEntity gradeEntity = gradeIdentityToEntityMap.get(gradeIdentity);
                    if (!CollectionUtils.isNotEmpty(stdDataOfOneGrade) || gradeEntity == null) continue;
                    gradeDataMap.put(gradeEntity.getId(), stdDataOfOneGrade);
                }
                resultMap.put(param2.getUnionId(), gradeDataMap);
            }
        }
        return resultMap;
    }

    private List<Long> getRankIdentityByRankType(List<SalaryRankEntity> rankEntityList, NeedRankType needRankType) {
        switch (needRankType) {
            case ALL: {
                return rankEntityList.stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toList());
            }
            case STANDARD: {
                return GradeRankHelper.fetchStandardRank(rankEntityList).stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toList());
            }
            case SPECIAL: {
                return GradeRankHelper.fetchSpecialRank(rankEntityList).stream().map(SalaryRankEntity::getRankIdentity).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public Map<Long, List<DynamicObject>> queryStdScmVersionObjWithBoId(Collection<Long> boIds) {
        DynamicObject[] versionObjs = this.salaryStdScmService.queryUsableVersionObjsWithBoId(boIds);
        return Arrays.stream(versionObjs).collect(Collectors.groupingBy(obj -> obj.getLong("boid")));
    }

    public Map<Long, List<DynamicObject>> queryStdVersionObjWithBoId(Collection<Long> stdTabBoIds) {
        DynamicObject[] versionObjs = this.salaryStdTabService.queryVersionObjs(stdTabBoIds);
        return Arrays.stream(versionObjs).collect(Collectors.groupingBy(obj -> obj.getLong("boid")));
    }

    public Map<Long, DynamicObject> queryScmVersionObjWithVid(Collection<Long> stdScmIds) {
        DynamicObject[] versionObjs = this.salaryStdScmService.queryVersionObjsWithVid(stdScmIds);
        return Arrays.stream(versionObjs).collect(Collectors.toMap(obj -> obj.getLong("id"), val -> val, (o1, o2) -> o2));
    }

    public Map<Long, DynamicObject> queryStdVersionObjWithVid(Set<Long> stdVIds) {
        DynamicObject[] versionObjs = this.salaryStdTabService.queryVersionObjsWithVid(stdVIds);
        return Arrays.stream(versionObjs).collect(Collectors.toMap(obj -> obj.getLong("id"), val -> val, (o1, o2) -> o2));
    }

    private List<Long> getGradeIdentityRangeByOffSet(Map<Long, SalaryGradeEntity> gradeIdToEntityMap, Map<Integer, SalaryGradeEntity> gradeIndexToEntityMap, StdTableDataQueryParam stdTableDataQueryParam) {
        SalaryGradeEntity currentGradeEntity = gradeIdToEntityMap.get(stdTableDataQueryParam.getGradeId());
        if (currentGradeEntity == null) {
            throw new KDBizException("gradeId not exist in system");
        }
        int gradePreOffset = stdTableDataQueryParam.getGradePreOffset();
        int gradeNextOffset = stdTableDataQueryParam.getGradeNextOffset();
        int startIndex = currentGradeEntity.getGradeIndex();
        int endIndex = currentGradeEntity.getGradeIndex();
        int maxGradeIndex = gradeIdToEntityMap.size();
        if (gradePreOffset == -1) {
            startIndex = 1;
        }
        if (gradePreOffset > 0) {
            startIndex = Math.max(1, currentGradeEntity.getGradeIndex() - gradePreOffset);
        }
        if (gradeNextOffset == -1) {
            endIndex = maxGradeIndex;
        }
        if (gradeNextOffset > 0) {
            endIndex = Math.min(maxGradeIndex, currentGradeEntity.getGradeIndex() + gradeNextOffset);
        }
        if (startIndex > endIndex) {
            endIndex = startIndex;
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)(endIndex - startIndex + 1));
        for (int i = startIndex; i <= endIndex; ++i) {
            SalaryGradeEntity salaryGradeEntity = gradeIndexToEntityMap.get(i);
            if (salaryGradeEntity == null) continue;
            result.add(salaryGradeEntity.getGradeIdentity());
        }
        return result;
    }

    public Map<Long, List<SalaryGradeEntity>> getGradeInfo(Collection<Long> stdTableIds) {
        if (CollectionUtils.isEmpty(stdTableIds)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdTableIds.size());
        Map<Long, DynamicObject> objectMap = this.queryStdObj(Sets.newHashSet(stdTableIds), "salarystditem", "salaryrank", "salarystddata_a", "contrastps", "contrastsumdata");
        for (Long stdTableId : stdTableIds) {
            DynamicObject stdObj = objectMap.get(stdTableId);
            if (stdObj == null) continue;
            SalaryStandardEntryData entryData = EntityConverter.fetchEntityFromModelWithEntryName(stdObj, "salarygrade");
            resultMap.put(stdTableId, GradeRankHelper.sortGradeList(entryData.getGradeEntities(), 1));
        }
        return resultMap;
    }

    public Map<Long, List<SalaryRankEntity>> getRankInfo(Collection<Long> stdTableIds) {
        if (CollectionUtils.isEmpty(stdTableIds)) {
            return Collections.emptyMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)stdTableIds.size());
        Map<Long, DynamicObject> objectMap = this.queryStdObj(Sets.newHashSet(stdTableIds), "salarystditem", "salarygrade", "salarystddata_a", "contrastps", "contrastsumdata");
        for (Long stdTableId : stdTableIds) {
            SalaryStandardEntryData entryData;
            DynamicObject stdObj = objectMap.get(stdTableId);
            if (stdObj == null || !(entryData = EntityConverter.fetchEntityFromModelWithEntryName(stdObj, "salaryrank")).getStdBaseEntity().isUseSalaryRank() || !CollectionUtils.isNotEmpty((Collection)entryData.getRankEntities())) continue;
            resultMap.put(stdTableId, GradeRankHelper.sortRankList(GradeRankHelper.fetchStandardRank(entryData.getRankEntities()), 1));
        }
        return resultMap;
    }

    public Map<String, String> getStdRangeNameByRangeId(List<StdRangeNameFormatParam> rangeNameFormatParams) {
        if (CollectionUtils.isEmpty(rangeNameFormatParams = rangeNameFormatParams.stream().filter(param -> StringUtils.isNotBlank((CharSequence)param.getUnionId()) && MapUtils.isNotEmpty((Map)param.getRangeData()) && param.getStdTableId() != null && param.getStdTableId() > 0L).collect(Collectors.toList()))) {
            return Collections.emptyMap();
        }
        Set unionIds = rangeNameFormatParams.stream().map(StdRangeNameFormatParam::getUnionId).collect(Collectors.toSet());
        if (unionIds.size() < rangeNameFormatParams.size()) {
            throw new KDBizException("unionid is duplicated");
        }
        Map<Long, List<StdRangeNameFormatParam>> paramMap = rangeNameFormatParams.stream().collect(Collectors.groupingBy(StdRangeNameFormatParam::getStdTableId));
        Map<Long, DynamicObject> objectMap = this.queryStdObj(paramMap.keySet(), "salarystditem", "salarystddata_a", "contrastps", "contrastsumdata");
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)rangeNameFormatParams.size());
        for (Map.Entry<Long, List<StdRangeNameFormatParam>> entry : paramMap.entrySet()) {
            DynamicObject stdObj = objectMap.get(entry.getKey());
            if (stdObj == null) continue;
            SalaryStandardEntryData entryData = EntityConverter.fetchEntityFromModelWithEntryName(stdObj, "salaryrank", "salarygrade");
            List<SalaryGradeEntity> gradeList = GradeRankHelper.sortGradeList(entryData.getGradeEntities(), 1);
            List<SalaryRankEntity> rankList = GradeRankHelper.fetchStandardRank(entryData.getRankEntities());
            for (StdRangeNameFormatParam param2 : entry.getValue()) {
                List<GradeRankValue> gradeRankValueList = GradeRankHelper.getRangeCodeByMap(gradeList, rankList, param2.getRangeData());
                if (CollectionUtils.isEmpty(gradeRankValueList)) continue;
                if (param2.isSplitWithGradeName()) {
                    gradeRankValueList = GradeRankHelper.splitRangeCodeByGrade(gradeRankValueList, rankList.size());
                }
                Map<Integer, String> gradeIndexNameMap = GradeRankHelper.getGradeIndexNameMap(gradeList);
                Map<Integer, String> rankIndexNameMap = GradeRankHelper.getRankIndexNameMap(rankList);
                String rangeName = GradeRankHelper.getRangeNamesByRangeCode(gradeRankValueList, rankList.size(), gradeIndexNameMap, rankIndexNameMap, param2.isUseRank());
                resultMap.put(param2.getUnionId(), rangeName);
            }
        }
        return resultMap;
    }

    static enum NeedRankType {
        STANDARD,
        SPECIAL,
        ALL;

    }
}

