/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ArrayUtils;

public class AbandondStatusFieldUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(AbandondStatusFieldUpdateTask.class);
    private SWCDataServiceHelper fileService = new SWCDataServiceHelper("hcdm_adjfileinfo");
    private SWCDataServiceHelper recordService = new SWCDataServiceHelper("hcdm_salaryadjrecord");
    private static int BATCH_SIZE = 500;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("AbandondStatusFieldUpdateTask begin");
        this.updateStatusToAbandon(this.fileService);
        this.updateStatusToAbandon(this.recordService);
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        logger.info("AbandondStatusFieldUpdateTask end");
    }

    private void statusUpdate(List<Long> boids, SWCDataServiceHelper service) {
        try {
            if (CollectionUtils.isEmpty(boids)) {
                return;
            }
            QFilter filter = new QFilter("boid", "in", boids);
            DynamicObject[] dbVersionData = service.query("id,status", new QFilter[]{filter});
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
            for (DynamicObject versionDy : dbVersionData) {
                versionDy.set("status", (Object)"E");
                saveList.add(versionDy);
            }
            service.save(saveList.toArray(new DynamicObject[0]));
        }
        catch (Exception ex) {
            logger.error("AbandondStatusFieldUpdateTask.statusUpdate error: ", (Throwable)ex);
        }
    }

    private void updateStatusToAbandon(SWCDataServiceHelper serviceHelper) {
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
        filter.and(new QFilter("datastatus", "=", (Object)"-1"));
        Object[] data = serviceHelper.query("id", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])data)) {
            return;
        }
        logger.info(" AbandondStatusFieldUpdateTask adjfileStatusUpdate.data.size:", (Object)data.length);
        List boids = Arrays.stream(data).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        ListUtils.partition(boids, (int)BATCH_SIZE).forEach(list -> this.statusUpdate((List<Long>)list, serviceHelper));
    }
}

