/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropConfigEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdMatchResultNew;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.adjfieldcfg.AdjDetailFieldMappingHelper;
import kd.swc.hcdm.business.adjapprbill.enums.OverStandardTypeEnum;
import kd.swc.hcdm.business.matchprop.entity.MatchStdTableWithAdjFileParam;
import kd.swc.hcdm.business.salarystandard.ContrastConfigHelper;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdAmountQueryResult;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.common.entity.adjapprbill.AddFileReturnData;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AdjApprbillEntryUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(AdjApprbillEntryUpdateTask.class);
    private static int BATCH_SIZE = 500;
    private SWCDataServiceHelper adjBillService = new SWCDataServiceHelper("hcdm_adjapprbill");
    private SWCDataServiceHelper fileService = new SWCDataServiceHelper("hcdm_adjfileinfo");
    private SWCDataServiceHelper adjPersonService = new SWCDataServiceHelper("hcdm_adjapprperson");
    private SWCDataServiceHelper stdTableService = new SWCDataServiceHelper("hcdm_salarystandard");
    private SWCDataServiceHelper adjConfirmService = new SWCDataServiceHelper("hcdm_adjconfirmperson");
    MainEntityType adjPersonEntity = MetadataServiceHelper.getDataEntityType((String)"hcdm_adjapprperson");
    Map<String, Long> comparaConCfg = AdjDetailFieldMappingHelper.getAdjDetailFieldToContrastCfg();
    private static String personProperty = "job,position,stdposition,joblevel,jobgrade,laborreltype,laborrelstatus,jobscm,jobseq,jobfamily,jobclass,projectteam,postype,departmenttype,admindivision,workplace,industrytype,operationequal,eocpquallevel,protitle,protitlelevel,protitletype,pocpquallevel,ocpqual,schooltype,diploma,religion,nationality";

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        logger.debug("AdjApprbillEntryUpdateTask begin");
        Set<Long> appBillIds = this.getAppBillIds();
        if (CollectionUtils.isNotEmpty(appBillIds)) {
            logger.info("query total apprbill number is:{}", (Object)appBillIds.size());
            ArrayList<Long> appBillList = new ArrayList<Long>(appBillIds);
            ListUtils.partition(appBillList, (int)BATCH_SIZE).forEach(list -> this.batchHandleData((List<Long>)list));
        }
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        logger.debug("AdjApprbillEntryUpdateTask ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchHandleData(List<Long> appBillList) {
        if (CollectionUtils.isEmpty(appBillList)) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] billDyns = this.adjBillService.loadDynamicObjectArray(appBillList.toArray());
            logger.info("batchHandleData billDyns size:", (Object)billDyns.length);
            ArrayList<DynamicObject> allObjList = new ArrayList<DynamicObject>(BATCH_SIZE);
            HashMap billFileToItemMap = Maps.newHashMapWithExpectedSize((int)BATCH_SIZE);
            int personNum = 0;
            for (DynamicObject dyObj : billDyns) {
                dyObj.set("adjfieldcfg", (Object)Long.valueOf("1652969141403021312"));
                dyObj.set("country", (Object)Long.valueOf("1000001"));
                DynamicObjectCollection adjApprDetailEntCols = dyObj.getDynamicObjectCollection("adjapprdetailent");
                List subList = adjApprDetailEntCols.stream().collect(Collectors.toList());
                Map<Long, List<DynamicObject>> fieldToItemMap = subList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("adjfile.id")));
                int n = fieldToItemMap.size();
                personNum += n;
                billFileToItemMap.put(dyObj.getLong("id"), fieldToItemMap);
                allObjList.addAll(subList);
            }
            logger.info("batch handle personNum:{}", (Object)personNum);
            logger.info("batch handle allObjList number:{}", (Object)allObjList.size());
            Map<Long, List<DynamicObject>> fieldToItemMap = allObjList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("adjfile.id")));
            DynamicObject[] fileDyns = this.fileService.loadDynamicObjectArray(fieldToItemMap.keySet().toArray());
            Map<Long, DynamicObject> idToFileMap = Arrays.stream(fileDyns).collect(Collectors.toMap(key -> key.getLong("id"), val -> val, (k1, k2) -> k1));
            Map<Long, DynamicObject> idToBillMap = Arrays.stream(billDyns).collect(Collectors.toMap(key -> key.getLong("id"), val -> val, (k1, k2) -> k1));
            List<Object> matchParams = Lists.newArrayListWithExpectedSize((int)10);
            Date defaultBsed = SWCDateTimeUtils.getDayDate((Date)TimeServiceHelper.now());
            for (Map.Entry entry : billFileToItemMap.entrySet()) {
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    for (DynamicObject itemRow : (List)entry2.getValue()) {
                        MatchStdTableWithAdjFileParam param = new MatchStdTableWithAdjFileParam();
                        matchParams.add(param);
                        param.setAdjFileId((Long)entry2.getKey());
                        param.setStdItemId(itemRow.getLong("standarditem.id"));
                        param.setBsed(defaultBsed);
                    }
                }
            }
            matchParams = matchParams.stream().distinct().collect(Collectors.toList());
            HashSet employeeIds = new HashSet(BATCH_SIZE);
            HashSet<Long> hashSet = new HashSet<Long>(BATCH_SIZE);
            for (Map.Entry<Object, Object> entry : fieldToItemMap.entrySet()) {
                ((List)entry.getValue()).stream().filter(obj -> ObjectUtils.isNotEmpty((Object)obj.get("adjfile.employee"))).forEach(obj -> {
                    employeeIds.add(obj.getLong("adjfile.employee.id"));
                    personSetIds.add(obj.getLong("adjfile.person.id"));
                });
            }
            logger.info("employeeIds is:{}", (Object)JSON.toJSONString(employeeIds));
            Map<Long, DynamicObject> empToWorkPlaceMap = DecAdjApprGridHelper.getContractWorkPlace(new ArrayList<Long>(employeeIds));
            logger.info("empToWorkPlaceMap size is:{}", (Object)empToWorkPlaceMap.size());
            Map<Long, DynamicObject> map = DecAdjApprGridHelper.getEntryDate(hashSet);
            Map<Long, DynamicObject> realregulardateMap = DecAdjApprGridHelper.getRealRegularDate(hashSet);
            AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
            Map<Long, Map<Long, SalaryStdMatchResultNew>> stdMatchResultMap = adjApprovalApplicationService.batchMatchStdTable(matchParams);
            logger.info("stdMatchResultMap:{}", (Object)JSON.toJSONString(stdMatchResultMap));
            Map<Long, Map<Long, Object>> fileToFreMap = this.getFrequencyByStdTable(stdMatchResultMap);
            Map<Long, Map<Long, Object>> contrastPropValueMap = this.getContrastPropValueMap(new ArrayList<Long>(fieldToItemMap.keySet()));
            logger.info("contrastPropValueMap:{}", (Object)JSON.toJSONString(contrastPropValueMap));
            Map<Long, List<AddFileReturnData>> exctMap = this.getExcessControl(fileDyns);
            Map<Long, List<DynamicObject>> billToConMap = this.getAdjConFirmRecord(appBillList);
            ArrayList<DynamicObject> savePersonList = new ArrayList<DynamicObject>(BATCH_SIZE);
            Map<StdAmountQueryParam, StdAmountQueryResult> stdAmountMap = this.getStdAmount(allObjList);
            this.genePersonInfo(billFileToItemMap, personNum, idToFileMap, idToBillMap, empToWorkPlaceMap, map, realregulardateMap, stdMatchResultMap, fileToFreMap, contrastPropValueMap, exctMap, billToConMap, savePersonList, stdAmountMap);
            this.adjPersonService.save(savePersonList.toArray(new DynamicObject[0]));
            this.adjBillService.update(billDyns);
        }
    }

    private void genePersonInfo(Map<Long, Map<Long, List<DynamicObject>>> billFileToItemMap, int personNum, Map<Long, DynamicObject> idToFileMap, Map<Long, DynamicObject> idToBillMap, Map<Long, DynamicObject> empToWorkPlaceMap, Map<Long, DynamicObject> entryDateMap, Map<Long, DynamicObject> realregulardateMap, Map<Long, Map<Long, SalaryStdMatchResultNew>> stdMatchResultMap, Map<Long, Map<Long, Object>> fileToFreMap, Map<Long, Map<Long, Object>> contrastPropValueMap, Map<Long, List<AddFileReturnData>> exctMap, Map<Long, List<DynamicObject>> billToConMap, List<DynamicObject> savePersonList, Map<StdAmountQueryParam, StdAmountQueryResult> stdAmountMap) {
        long[] personIds = ORM.create().genLongIds("hcdm_adjapprperson", personNum);
        int personIndex = 0;
        for (Map.Entry<Long, Map<Long, List<DynamicObject>>> subList : billFileToItemMap.entrySet()) {
            long billId = subList.getKey();
            DynamicObject billObj = idToBillMap.get(billId);
            Map<Long, List<DynamicObject>> fileToItemMap = subList.getValue();
            List<DynamicObject> confirmList = billToConMap.get(billId);
            Map<Long, List<DynamicObject>> conMap = null;
            if (CollectionUtils.isNotEmpty(confirmList)) {
                conMap = confirmList.stream().collect(Collectors.groupingBy(obj -> obj.getLong("adjfile.id")));
            }
            for (Map.Entry<Long, List<DynamicObject>> ssubList : fileToItemMap.entrySet()) {
                DynamicObject dyObj;
                long adjfileId = ssubList.getKey();
                Map<Long, SalaryStdMatchResultNew> matchMap = AdjApprbillEntryUpdateTask.getMatchMap(adjfileId, stdMatchResultMap);
                Map<Long, Object> itemToFreMap = fileToFreMap.get(adjfileId);
                List<AddFileReturnData> exctList = exctMap.get(adjfileId);
                List<DynamicObject> itemList = ssubList.getValue();
                DynamicObject adjFile = idToFileMap.get(adjfileId);
                Long personId = adjFile.getLong("person.id");
                DynamicObject personObj = this.adjPersonService.generateEmptyDynamicObject();
                personObj.set("id", (Object)personIds[personIndex++]);
                personObj.set("adjapprbill", (Object)billId);
                DynamicObject workPlace = empToWorkPlaceMap.get(adjFile.getLong("employee.id"));
                if (ObjectUtils.isNotEmpty((Object)workPlace)) {
                    personObj.set("agreedlocation", workPlace.get("agreedlocation"));
                }
                if (MapUtils.isNotEmpty(entryDateMap) && ObjectUtils.isNotEmpty((Object)entryDateMap.get(personId))) {
                    dyObj = entryDateMap.get(personId);
                    personObj.set("entrydate", dyObj.getDate("startdate") == null ? " " : dyObj.getDate("startdate"));
                }
                if (MapUtils.isNotEmpty(realregulardateMap) && ObjectUtils.isNotEmpty((Object)realregulardateMap.get(personId))) {
                    dyObj = realregulardateMap.get(personId);
                    personObj.set("realregulardate", dyObj.getDate("realregulardate") == null ? " " : dyObj.getDate("realregulardate"));
                }
                Map<Long, Object> conPropValMap = contrastPropValueMap.get(adjfileId);
                logger.info("AdjApprbillUpdateTask adjFileId:{},conPropValMap:{},matchMap:{}", new Object[]{adjfileId, JSON.toJSONString(conPropValMap), JSON.toJSONString(matchMap)});
                this.assemblePerson(personObj, adjFile, conPropValMap);
                this.setComAndSynStatus(billObj, conMap, adjfileId, personObj);
                this.assemblePersonEntry(itemToFreMap, personObj, itemList, billObj, matchMap, exctList, stdAmountMap);
                savePersonList.add(personObj);
            }
        }
    }

    private Map<Long, List<AddFileReturnData>> getExcessControl(DynamicObject[] fileDyns) {
        Map<Object, Object> exctMap = Maps.newHashMapWithExpectedSize((int)8);
        Map<Object, DynamicObject> fileObjMap = Arrays.stream(fileDyns).collect(Collectors.toMap(key -> key.getLong("id"), val -> val, (k1, k2) -> k1));
        List<AddFileReturnData> exctList = DecAdjApprGridHelper.getAddAdjFileReturnData(fileObjMap);
        if (CollectionUtils.isNotEmpty(exctList)) {
            exctMap = exctList.stream().collect(Collectors.groupingBy(AddFileReturnData::getAdjFileId));
        }
        return exctMap;
    }

    private void setComAndSynStatus(DynamicObject billObj, Map<Long, List<DynamicObject>> conMap, long adjfileId, DynamicObject personObj) {
        if (billObj.getString("billstatus").equals("C")) {
            DynamicObject confirm;
            String confirmstatus;
            personObj.set("confirmstatus", (Object)"1");
            personObj.set("synstatus", (Object)"1");
            if (MapUtils.isNotEmpty(conMap) && CollectionUtils.isNotEmpty((Collection)conMap.get(adjfileId)) && StringUtils.isNotBlank((CharSequence)(confirmstatus = (confirm = conMap.get(adjfileId).get(0)).getString("confirmstatus"))) && confirmstatus.equals("0")) {
                personObj.set("confirmstatus", (Object)"0");
                personObj.set("synstatus", (Object)"0");
            }
        } else {
            personObj.set("confirmstatus", (Object)"0");
            personObj.set("synstatus", (Object)"0");
        }
    }

    private static Map<Long, SalaryStdMatchResultNew> getMatchMap(long adjfileId, Map<Long, Map<Long, SalaryStdMatchResultNew>> stdMatchResultMap) {
        if (adjfileId <= 0L || MapUtils.isEmpty(stdMatchResultMap)) {
            return null;
        }
        return stdMatchResultMap.get(adjfileId);
    }

    private void assemblePersonEntry(Map<Long, Object> itemToFreMap, DynamicObject personObj, List<DynamicObject> itemList, DynamicObject billObj, Map<Long, SalaryStdMatchResultNew> matchMap, List<AddFileReturnData> exctList, Map<StdAmountQueryParam, StdAmountQueryResult> stdAmountMap) {
        DynamicObjectCollection personEntryCollect = personObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject obj : itemList) {
            BigDecimal aftersalaryseeprate;
            BigDecimal presalaryseeprate;
            DynamicObject itemObj = this.adjPersonService.generateEmptyEntryDynamicObject("entryentity");
            itemObj.set("id", (Object)obj.getLong("id"));
            long standarditemid = obj.getLong("standarditem.id");
            itemObj.set("seq", obj.get("seq"));
            itemObj.set("standarditem", obj.get("standarditem"));
            itemObj.set("salarystd", obj.get("salarystdhis"));
            itemObj.set("presalarystd", obj.get("salarystdhis"));
            itemObj.set("pregrade", obj.get("pregradeid"));
            itemObj.set("prerank", obj.get("prerankid"));
            itemObj.set("presalary", obj.get("currentsalary"));
            itemObj.set("precurrency", obj.get("currentcurrency"));
            BigDecimal presalarypercent = obj.getBigDecimal("presalarypercent");
            if (ObjectUtils.isNotEmpty((Object)presalarypercent) && presalarypercent.compareTo(BigDecimal.ZERO) > 0) {
                itemObj.set("presalarypercent", (Object)presalarypercent.divide(BigDecimal.valueOf(100L)));
            }
            if (ObjectUtils.isNotEmpty((Object)(presalaryseeprate = obj.getBigDecimal("presalaryseeprate"))) && presalaryseeprate.compareTo(BigDecimal.ZERO) > 0) {
                itemObj.set("presalaryseeprate", (Object)presalaryseeprate.divide(BigDecimal.valueOf(100L)));
            }
            if (ObjectUtils.isEmpty((Object)obj.get("frequency")) && MapUtils.isNotEmpty(itemToFreMap) && ObjectUtils.isNotEmpty((Object)itemToFreMap.get(standarditemid))) {
                itemObj.set("prefrequency", itemToFreMap.get(standarditemid));
                itemObj.set("frequency", itemToFreMap.get(standarditemid));
            } else {
                itemObj.set("prefrequency", obj.get("frequency"));
                itemObj.set("frequency", obj.get("frequency"));
            }
            itemObj.set("calctype", obj.get("calctype"));
            itemObj.set("amount", obj.get("finalamount"));
            itemObj.set("exratevalue", obj.get("exratevalue"));
            itemObj.set("suggestminrange", obj.get("suggestminrange"));
            itemObj.set("suggestmaxrange", obj.get("suggestmaxrange"));
            itemObj.set("suggestminamount", obj.get("suggestminamount"));
            itemObj.set("suggestmaxamount", obj.get("suggestmaxamount"));
            itemObj.set("actualrange", obj.get("actualrange"));
            itemObj.set("actualamount", obj.get("actualamount"));
            itemObj.set("quotetype", obj.get("quotetype"));
            itemObj.set("grade", obj.get("aftergradeid"));
            itemObj.set("rank", obj.get("afterrankid"));
            BigDecimal aftersalarypercent = obj.getBigDecimal("aftersalarypercent");
            if (ObjectUtils.isNotEmpty((Object)aftersalarypercent) && aftersalarypercent.compareTo(BigDecimal.ZERO) > 0) {
                itemObj.set("salarypercent", (Object)aftersalarypercent.divide(BigDecimal.valueOf(100L)));
            }
            if (ObjectUtils.isNotEmpty((Object)(aftersalaryseeprate = obj.getBigDecimal("aftersalaryseeprate"))) && aftersalaryseeprate.compareTo(BigDecimal.ZERO) > 0) {
                itemObj.set("salaryseeprate", (Object)aftersalaryseeprate.divide(BigDecimal.valueOf(100L)));
            }
            itemObj.set("coefficient", obj.get("coefficient"));
            itemObj.set("currency", obj.get("adjcurrency"));
            itemObj.set("excesscontrol", (Object)"");
            if (CollectionUtils.isNotEmpty(exctList)) {
                itemObj.set("excesscontrol", (Object)exctList.get(0).getExcessControl());
            }
            itemObj.set("intervalmin", obj.get("afterstdintervalmin"));
            itemObj.set("intervalmax", obj.get("afterstdintervalmax"));
            itemObj.set("salbsed", billObj.get("effectivedate"));
            itemObj.set("reason", obj.get("reason"));
            logger.info("salargrel itemId is :{}", (Object)standarditemid);
            if (standarditemid > 0L && MapUtils.isNotEmpty(matchMap) && ObjectUtils.isNotEmpty((Object)matchMap.get(standarditemid))) {
                logger.info("salargrel into first if");
                Map rangeResultData = matchMap.get(standarditemid).getRangeData();
                logger.info("salargrel rangeResultData is:{}", (Object)JSON.toJSONString((Object)rangeResultData));
                if (MapUtils.isNotEmpty((Map)rangeResultData)) {
                    String simpleRangeResultData = JSON.toJSONString((Object)rangeResultData);
                    itemObj.set("salargrel", (Object)simpleRangeResultData);
                    logger.info("salargrel is :", (Object)simpleRangeResultData);
                }
            }
            this.setStdAmountAndOverStdType(itemObj, obj, stdAmountMap);
            personEntryCollect.add((Object)itemObj);
        }
        personObj.set("entryentity", (Object)personEntryCollect);
    }

    private void setStdAmountAndOverStdType(DynamicObject itemObj, DynamicObject oldItemObj, Map<StdAmountQueryParam, StdAmountQueryResult> stdAmountMap) {
        StdAmountQueryParam stdAmountQueryParam;
        StdAmountQueryResult stdAmount;
        if (MapUtils.isNotEmpty(stdAmountMap) && ObjectUtils.isNotEmpty((Object)(stdAmount = stdAmountMap.get(stdAmountQueryParam = this.getStdAmountQueryParam(oldItemObj.getLong("aftergradeid.id"), oldItemObj.getLong("afterrankid.id"), oldItemObj.getLong("salarystdhis.id"), oldItemObj.getLong("standarditem.id")))))) {
            itemObj.set("stdamount", (Object)stdAmount.getAmount());
        }
        BigDecimal amount = oldItemObj.getBigDecimal("finalamount");
        BigDecimal intervalmin = oldItemObj.getBigDecimal("afterstdintervalmin");
        BigDecimal intervalmax = oldItemObj.getBigDecimal("afterstdintervalmax");
        if (amount != null) {
            if (intervalmin != null && amount.compareTo(intervalmin) < 0) {
                itemObj.set("overstandardtype", (Object)OverStandardTypeEnum.BELOW_LIMIT.getCode());
            }
            if (intervalmax != null && amount.compareTo(intervalmax) > 0) {
                itemObj.set("overstandardtype", (Object)OverStandardTypeEnum.UPPER_LIMIT.getCode());
            }
            if (intervalmin != null && intervalmax != null && amount.compareTo(intervalmin) >= 0 && amount.compareTo(intervalmax) <= 0) {
                itemObj.set("overstandardtype", (Object)OverStandardTypeEnum.WITHIN_LIMIT.getCode());
            }
        }
    }

    private StdAmountQueryParam getStdAmountQueryParam(Long gradeId, Long rankId, Long salaryStdId, Long standardItemId) {
        StdAmountQueryParam stdAmountQueryParam = new StdAmountQueryParam();
        stdAmountQueryParam.setGradeId(gradeId);
        stdAmountQueryParam.setRankId(rankId);
        stdAmountQueryParam.setStdTabId(salaryStdId);
        stdAmountQueryParam.setItemId(standardItemId);
        return stdAmountQueryParam;
    }

    private Map<StdAmountQueryParam, StdAmountQueryResult> getStdAmount(List<DynamicObject> allItemObjList) {
        Map<Object, Object> resultMap = Maps.newHashMapWithExpectedSize((int)10);
        if (CollectionUtils.isNotEmpty(allItemObjList)) {
            HashSet<StdAmountQueryParam> salaryStdAmountParams = new HashSet<StdAmountQueryParam>(allItemObjList.size());
            for (DynamicObject obj : allItemObjList) {
                long gradeId = obj.getLong("aftergradeid.id");
                long rankId = obj.getLong("afterrankid.id");
                long stdId = obj.getLong("salarystdhis.id");
                long itmeId = obj.getLong("standarditem.id");
                if (gradeId <= 0L || rankId <= 0L || stdId <= 0L || itmeId <= 0L) continue;
                StdAmountQueryParam stdAmountQueryParam = this.getStdAmountQueryParam(gradeId, rankId, stdId, itmeId);
                salaryStdAmountParams.add(stdAmountQueryParam);
            }
            SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
            resultMap = salaryStdApplicationService.getSalaryStdAmount(new ArrayList<StdAmountQueryParam>(salaryStdAmountParams));
        }
        return resultMap;
    }

    private void assemblePerson(DynamicObject personObj, DynamicObject adjFile, Map<Long, Object> conPropValMap) {
        personObj.set("adjfile", (Object)adjFile);
        personObj.set("employee", adjFile.get("employee"));
        personObj.set("number", adjFile.get("employee.empnumber"));
        personObj.set("person", adjFile.get("person"));
        personObj.set("name", adjFile.get("person.name"));
        personObj.set("empgroup", adjFile.get("empgroup"));
        personObj.set("depcytype", adjFile.get("depcytype"));
        personObj.set("company", adjFile.get("empposorgrel.company"));
        personObj.set("adminorg", adjFile.get("empposorgrel.adminorg"));
        personObj.set("assoadminorg", adjFile.get("adminorg"));
        personObj.set("salarystructure", adjFile.get("salaystructure"));
        personObj.set("stdscm", adjFile.get("stdscm"));
        this.assembleFourPersonInfo(personObj, conPropValMap);
    }

    private void assembleFourPersonInfo(DynamicObject personObj, Map<Long, Object> conPropValMap) {
        String[] allPersonField;
        for (String colName : allPersonField = personProperty.split("[,]")) {
            List mulBaseBataIdList;
            Comparable<Long> obj;
            DynamicProperty property = this.adjPersonEntity.getProperty(colName);
            Long contrastCfgSetId = this.comparaConCfg.get(colName);
            if (property instanceof BasedataProp) {
                obj = (Long)conPropValMap.get(contrastCfgSetId);
                if (obj == null) continue;
                personObj.set(colName, (Object)obj);
                continue;
            }
            if (property instanceof DateProp) {
                obj = (Date)conPropValMap.get(contrastCfgSetId);
                if (obj == null) continue;
                personObj.set(colName, (Object)obj);
                continue;
            }
            if (!(property instanceof MulBasedataProp) || CollectionUtils.isEmpty((Collection)(mulBaseBataIdList = (List)conPropValMap.get(contrastCfgSetId))) || !colName.equals("schooltype")) continue;
            DynamicObjectCollection multiBaseDataDyColl = personObj.getDynamicObjectCollection("schooltype");
            for (Long multiBaseData : mulBaseBataIdList) {
                DynamicObject newMultiBaseData = new DynamicObject(multiBaseDataDyColl.getDynamicObjectType());
                newMultiBaseData.set("fbasedataid", (Object)multiBaseData);
                multiBaseDataDyColl.add((Object)newMultiBaseData);
                logger.info("schooltype id:{}", (Object)multiBaseData);
            }
            personObj.set("schooltype", (Object)multiBaseDataDyColl);
        }
    }

    private Set<Long> getAppBillIds() {
        HashSet<Long> idSets = new HashSet<Long>(BATCH_SIZE);
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("  select distinct t1.fid  ");
        selectSql.append("     from t_hcdm_adjapprent t1 ");
        selectSql.append("  where not exists (select 1 from t_hcdm_adjapprperent t2 where t1.fentryid = t2.fentryid)  ");
        try (DataSet oldEntryDataSet = SWCDbUtil.queryDataSet((String)"AdjApprbillUpdateTask", (DBRoute)new DBRoute("hcdm"), (String)selectSql.toString(), null);){
            while (oldEntryDataSet.hasNext()) {
                Row row = oldEntryDataSet.next();
                long fid = row.getLong("fid");
                idSets.add(fid);
            }
        }
        return idSets;
    }

    private Map<Long, Map<Long, Object>> getContrastPropValueMap(List<Long> adjFileIds) {
        Map<Long, ContrastPropConfigEntity> allContrastConfigMap = ContrastConfigHelper.getAllContrastConfigMap();
        List<ContrastPropConfigEntity> propConfigEntities = Arrays.stream(personProperty.split("[,]")).map(item -> (ContrastPropConfigEntity)allContrastConfigMap.get(this.comparaConCfg.get(item))).collect(Collectors.toList());
        AdjApprovalApplicationService adjApprovalApplicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
        Map<Long, Map<Long, Object>> contrastPropValueMap = adjApprovalApplicationService.getContrastPropValue(propConfigEntities, new ArrayList<Long>(adjFileIds), true);
        return contrastPropValueMap;
    }

    private Map<Long, Map<Long, Object>> getFrequencyByStdTable(Map<Long, Map<Long, SalaryStdMatchResultNew>> stdMatchResultMap) {
        HashMap fileToFrequency = Maps.newHashMapWithExpectedSize((int)8);
        if (MapUtils.isNotEmpty(stdMatchResultMap)) {
            HashSet stdTableIds = Sets.newHashSetWithExpectedSize((int)8);
            for (Map.Entry<Long, Map<Long, SalaryStdMatchResultNew>> subMap : stdMatchResultMap.entrySet()) {
                Map<Long, SalaryStdMatchResultNew> temMap = subMap.getValue();
                temMap.forEach((key, val) -> {
                    if (ObjectUtils.isNotEmpty((Object)val.getStdTableVid()) && val.getStdTableVid() > 0L) {
                        stdTableIds.add(val.getStdTableVid());
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)stdTableIds)) {
                DynamicObject[] dyns = this.stdTableService.query("id,frequency,name,number", new QFilter[]{new QFilter("id", "in", (Object)stdTableIds)});
                Map<Long, Object> tableIdToDyMap = Arrays.stream(dyns).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.get("frequency")));
                for (Map.Entry<Long, Map<Long, SalaryStdMatchResultNew>> subMap : stdMatchResultMap.entrySet()) {
                    Map subFreMap = fileToFrequency.computeIfAbsent(subMap.getKey(), val -> Maps.newHashMapWithExpectedSize((int)8));
                    Map<Long, SalaryStdMatchResultNew> ssubMap = subMap.getValue();
                    for (Map.Entry<Long, SalaryStdMatchResultNew> sdMap : ssubMap.entrySet()) {
                        SalaryStdMatchResultNew ssr = sdMap.getValue();
                        subFreMap.put(sdMap.getKey(), ObjectUtils.isNotEmpty((Object)ssr.getStdTableVid()) ? tableIdToDyMap.get(ssr.getStdTableVid()) : null);
                    }
                }
            }
        }
        return fileToFrequency;
    }

    private Map<Long, List<DynamicObject>> getAdjConFirmRecord(List<Long> appBillList) {
        Map<Object, Object> billToConMap = Maps.newHashMapWithExpectedSize((int)8);
        Object[] ajdConDyns = this.adjConfirmService.query("adjapprovalbill,adjapprovalbill.id,adjfile,adjfile.id,confirmstatus,confirmtype,person,person.id", new QFilter[]{new QFilter("adjapprovalbill", "in", appBillList)});
        if (ArrayUtils.isNotEmpty((Object[])ajdConDyns)) {
            billToConMap = Arrays.stream(ajdConDyns).collect(Collectors.groupingBy(obj -> obj.getLong("adjapprovalbill.id")));
        }
        return billToConMap;
    }

    public void deleteData() {
        String str1 = " delete from t_hcdm_adjapprperschtype where fid in(select fid from t_hcdm_adjapprperent where fentryid in(select fentryid from t_hcdm_adjapprent)) ";
        String str2 = " delete from t_hcdm_adjapprper where fid in(select fid from t_hcdm_adjapprperent where fentryid in(select fentryid from t_hcdm_adjapprent)) ";
        String str3 = " delete from t_hcdm_adjapprperent_a where fentryid in(select fentryid from t_hcdm_adjapprent) ";
        String str4 = " delete from t_hcdm_adjapprperent where fentryid in(select fentryid from t_hcdm_adjapprent) ";
        try {
            DBRoute dbRoute = new DBRoute("hcdm");
            DB.execute((DBRoute)dbRoute, (String)str1);
            DB.execute((DBRoute)dbRoute, (String)str2);
            DB.execute((DBRoute)dbRoute, (String)str3);
            DB.execute((DBRoute)dbRoute, (String)str4);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }
}

