/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AdjBaseLocationUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(AdjBaseLocationUpdateTask.class);
    SWCDataServiceHelper personService = new SWCDataServiceHelper("hcdm_adjapprperson");
    SWCDataServiceHelper recordService = new SWCDataServiceHelper("hcdm_salaryadjrecord");
    private static int BATCH_SIZE = 500;

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        logger.info("AdjBaseLocationUpdateTask begin");
        this.adjapprPersonLocationUpdate();
        this.adjSalaryaRecordLocationUpdate();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        service.disableJob(taskInfo.getJobId());
        logger.info("AdjBaseLocationUpdateTask ended");
    }

    private void adjapprPersonLocationUpdate() {
        QFilter filter = new QFilter("baselocation.id", "=", (Object)0).or("baselocation.id", "is null", null);
        Object[] data = this.personService.query(new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])data)) {
            return;
        }
        logger.info(" adjapprPersonLocationUpdate data.size:", (Object)data.length);
        List ids = Arrays.stream(data).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        ListUtils.partition(ids, (int)BATCH_SIZE).forEach(list -> this.adjPersonUpdate((List<Long>)list));
    }

    private void adjPersonUpdate(List<Long> ids) {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            QFilter filter = new QFilter("id", "in", ids);
            DynamicObject[] dbData = this.personService.query("id,baselocation,baselocation.id,employee,employee.id", new QFilter[]{filter});
            Set employeeIds = Arrays.stream(dbData).filter(obj -> ObjectUtils.isNotEmpty((Object)obj.get("employee")) && obj.getLong("employee.id") > 0L).map(obj -> obj.getLong("employee.id")).collect(Collectors.toSet());
            Map<Long, DynamicObject> locationMap = DecAdjApprGridHelper.getPermanentWorkPlace(new ArrayList<Long>(employeeIds));
            if (MapUtils.isEmpty(locationMap)) {
                return;
            }
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
            for (DynamicObject dbObj : dbData) {
                Long employeeId = dbObj.getLong("employee.id");
                DynamicObject baseLocationc = locationMap.get(employeeId);
                if (!ObjectUtils.isEmpty((Object)dbObj.get("baselocation")) && dbObj.getLong("baselocation.id") > 0L || !ObjectUtils.isNotEmpty((Object)baseLocationc)) continue;
                dbObj.set("baselocation", baseLocationc.get("location"));
                saveList.add(dbObj);
            }
            this.personService.save(saveList.toArray(new DynamicObject[0]));
        }
        catch (Exception ex) {
            logger.error("AdjBaseLocationUpdateTask.adjPersonUpdate error: ", (Throwable)ex);
        }
    }

    private void adjSalaryaRecordLocationUpdate() {
        QFilter filter = new QFilter("baselocation.id", "=", (Object)0).or("baselocation.id", "is null", null);
        Object[] data = this.recordService.query(new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])data)) {
            return;
        }
        List ids = Arrays.stream(data).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        ListUtils.partition(ids, (int)BATCH_SIZE).forEach(list -> this.recordUpdate((List<Long>)list));
    }

    private void recordUpdate(List<Long> ids) {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            QFilter filter = new QFilter("id", "in", ids);
            DynamicObject[] reData = this.recordService.query("id,baselocation,baselocation.id,relpersonid,salaryadjfile,salaryadjfile.employee,salaryadjfile.employee.id", new QFilter[]{filter});
            Set employeeIds = Arrays.stream(reData).filter(obj -> ObjectUtils.isNotEmpty((Object)obj.get("salaryadjfile.employee")) && obj.getLong("salaryadjfile.employee.id") > 0L).map(obj -> obj.getLong("salaryadjfile.employee.id")).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(employeeIds)) {
                return;
            }
            Map<Long, DynamicObject> locationMap = DecAdjApprGridHelper.getPermanentWorkPlace(new ArrayList<Long>(employeeIds));
            if (MapUtils.isEmpty(locationMap)) {
                return;
            }
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
            for (DynamicObject dbObj : reData) {
                Long employeeId = ObjectUtils.isEmpty((Object)dbObj.get("salaryadjfile.employee")) ? 0L : dbObj.getLong("salaryadjfile.employee.id");
                DynamicObject baseLocationc = locationMap.get(employeeId);
                if (!ObjectUtils.isEmpty((Object)dbObj.get("baselocation")) && dbObj.getLong("baselocation.id") > 0L || !ObjectUtils.isNotEmpty((Object)baseLocationc)) continue;
                dbObj.set("baselocation", baseLocationc.get("location"));
                saveList.add(dbObj);
            }
            this.personService.save(saveList.toArray(new DynamicObject[0]));
        }
        catch (Exception ex) {
            logger.error("AdjBaseLocationUpdateTask.recordUpdate error:", (Throwable)ex);
        }
    }
}

