/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapprbill.enums.CalcType;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AdjBillEntryUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(AdjBillEntryUpdateTask.class);
    private static int BATCH_SIZE = 500;
    private SWCDataServiceHelper adjBillService = new SWCDataServiceHelper("hcdm_adjapprbill");
    private SWCDataServiceHelper adjPersonService = new SWCDataServiceHelper("hcdm_adjapprperson");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("AdjBillEntryDataUpGrade202401Task begin");
        List<Long> billIdList = this.getAdjBillIds();
        logger.info("billIdList size is:{}", (Object)billIdList.size());
        if (CollectionUtils.isNotEmpty(billIdList)) {
            ListUtils.partition(billIdList, (int)BATCH_SIZE).forEach(list -> this.handleData((List<Long>)list));
        }
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        logger.info("AdjBillEntryDataUpGrade202401Task ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleData(List<Long> list) {
        Object[] adjBillObjs = this.getAdjBillObjsByFid(list);
        if (ArrayUtils.isEmpty((Object[])adjBillObjs)) {
            logger.info("handleData adjBillObjs is empty ");
            return;
        }
        Map<Object, Object> idToPerson = new HashMap(16);
        Object[] personObjs = this.getAdjPersonObjsByBillFid(list);
        if (ArrayUtils.isNotEmpty((Object[])personObjs)) {
            idToPerson = Arrays.stream(personObjs).collect(Collectors.groupingBy(obj -> obj.getLong("adjapprbill")));
        }
        if (MapUtils.isEmpty(idToPerson)) {
            logger.info("handleData personObjs is empty ");
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"hcdm_adjapprperson");
        DynamicObjectType entryEntityProperty = ((EntryProp)entityType.getProperty("entryentity")).getDynamicCollectionItemPropertyType();
        DynamicProperty calcTypeProperty = entryEntityProperty.getProperty("calctype");
        try (TXHandle tx = TX.requiresNew();){
            for (Object billObj : adjBillObjs) {
                List persons = (List)idToPerson.get(billObj.getLong("id"));
                if (CollectionUtils.isEmpty((Collection)persons)) continue;
                this.updateItemAndDate((DynamicObject)billObj, persons);
                String attributionType = billObj.getString("salaryadjrsn.attributiontype");
                if (!AdjAttributionType.ADJATTRTYPE.getCode().equals(attributionType)) continue;
                this.updateCalType((DynamicObject)billObj, persons, calcTypeProperty);
            }
            this.adjBillService.save((DynamicObject[])adjBillObjs);
            this.adjPersonService.save((DynamicObject[])personObjs);
        }
    }

    private void updateCalType(DynamicObject billObj, List<DynamicObject> persons, DynamicProperty calcTypeProperty) {
        String billNo = billObj.getString("billno");
        HashMap<String, List> calTypeToDyObjsMap = new HashMap<String, List>(16);
        for (DynamicObject person : persons) {
            DynamicObjectCollection personEntryCollect = person.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : personEntryCollect) {
                String calcType = dynamicObject.getString("calctype");
                List entryList = calTypeToDyObjsMap.computeIfAbsent(calcType, key -> Lists.newArrayList());
                entryList.add(dynamicObject);
            }
        }
        if (MapUtils.isEmpty(calTypeToDyObjsMap)) {
            return;
        }
        logger.info("The cal type to dy objs map size is {}, billno is {}", (Object)calTypeToDyObjsMap.size(), (Object)billNo);
        String calType = (String)calTypeToDyObjsMap.entrySet().stream().max(Comparator.comparingInt(key -> ((List)key.getValue()).size())).get().getKey();
        logger.info("The most numerous cal type is {} , billno is {}", (Object)calType, (Object)billNo);
        if (StringUtils.isEmpty((String)calType)) {
            return;
        }
        int size = ((List)calTypeToDyObjsMap.get(calType)).size();
        ArrayList<Object> calTypeList = new ArrayList<Object>();
        for (Map.Entry entry : calTypeToDyObjsMap.entrySet()) {
            if (((List)entry.getValue()).size() != size) continue;
            calTypeList.add(entry.getKey());
        }
        logger.info("The cal type list is {}, billno is {}", calTypeList, (Object)billNo);
        boolean isHasOtherCalType = calTypeList.stream().filter(item -> !CalcType.RATIO.getCode().equals(item) && !CalcType.AMOUNT.getCode().equals(item) && !CalcType.GRADE_RANK.getCode().equals(item)).findAny().isPresent();
        String string = billObj.getString("caltype");
        if (StringUtils.isEmpty((String)string)) {
            if (isHasOtherCalType) {
                calTypeList.removeIf(item -> CalcType.RATIO.getCode().equals(item) || CalcType.AMOUNT.getCode().equals(item) || CalcType.GRADE_RANK.getCode().equals(item));
                ComboProp calTypeComboProp = (ComboProp)calcTypeProperty;
                List comboItems = calTypeComboProp.getComboItems();
                List comboItemValues = comboItems.stream().filter(item -> item.isItemVisible()).map(item -> item.getValue()).collect(Collectors.toList());
                logger.info("The combo item values is {} ", comboItemValues);
                for (ValueMapItem valueMapItem : comboItems) {
                    if (!calTypeList.contains(valueMapItem.getValue())) continue;
                    billObj.set("caltype", (Object)valueMapItem.getValue());
                    break;
                }
            } else if (calTypeList.contains(CalcType.RATIO.getCode())) {
                billObj.set("caltype", (Object)CalcType.RATIO.getCode());
            } else if (calTypeList.contains(CalcType.AMOUNT.getCode())) {
                billObj.set("caltype", (Object)CalcType.AMOUNT.getCode());
            } else if (calTypeList.contains(CalcType.GRADE_RANK.getCode())) {
                billObj.set("caltype", (Object)CalcType.GRADE_RANK.getCode());
            }
        }
    }

    private void updateItemAndDate(DynamicObject billObj, List<DynamicObject> persons) {
        Date createtime = billObj.getDate("createtime");
        DynamicObjectCollection multiBaseDataDyColl = billObj.getDynamicObjectCollection("stditem");
        HashSet<Long> itemIds = new HashSet<Long>(16);
        for (DynamicObject person : persons) {
            if (ObjectUtils.isEmpty((Object)person.get("createtime"))) {
                person.set("createtime", (Object)createtime);
            }
            if (ObjectUtils.isEmpty((Object)person.get("updatetime"))) {
                person.set("updatetime", (Object)createtime);
            }
            DynamicObjectCollection personEntryCollect = person.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : personEntryCollect) {
                itemIds.add(entry.getLong("standarditem.id"));
            }
        }
        if (multiBaseDataDyColl.size() <= 0) {
            for (Long multiBaseData : itemIds) {
                DynamicObject newMultiBaseData = multiBaseDataDyColl.addNew();
                newMultiBaseData.set("fbasedataid", (Object)multiBaseData);
                logger.info("standarditem id:{}", (Object)multiBaseData);
            }
        }
        billObj.set("stditem", (Object)multiBaseDataDyColl);
    }

    private List<Long> getAdjBillIds() {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        QFilter qFilter = new QFilter("auditstatus", "!=", (Object)"F");
        Object[] dynamicObjects = this.adjBillService.query("id,stditem.fbasedataid_id,caltype", new QFilter[]{qFilter});
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            Arrays.stream(dynamicObjects).filter(obj -> ObjectUtils.isEmpty((Object)obj.get("stditem")) || ObjectUtils.isEmpty((Object)obj.get("caltype"))).forEach(obj -> ids.add(obj.getLong("id")));
        }
        return ids;
    }

    private DynamicObject[] getAdjBillObjsByFid(List<Long> ids) {
        return this.adjBillService.query("id,billno,billname,stditem,caltype,createtime,modifytime,salaryadjrsn,salaryadjrsn.attributiontype", new QFilter[]{new QFilter("id", "in", ids)});
    }

    private DynamicObject[] getAdjPersonObjsByBillFid(List<Long> ids) {
        return this.adjPersonService.query("id,adjapprbill,createtime,updatetime,entryentity.standarditem,entryentity.calctype", new QFilter[]{new QFilter("adjapprbill", "in", ids)});
    }

    public void deleteData() {
        String str1 = " delete from t_hcdm_adjapprstditem where fid in(select fid from t_hcdm_adjapprbill where fcreatetime < date('2023-12-05 00:00:00')) ";
        String str2 = " update t_hcdm_adjapprper set fcreatetime =null,fupdatetime=null where fadjapprbillid in(select fid from t_hcdm_adjapprbill where fcreatetime < date('2023-12-05 00:00:00')) ";
        try {
            DBRoute dbRoute = new DBRoute("hcdm");
            DB.execute((DBRoute)dbRoute, (String)str1);
            DB.execute((DBRoute)dbRoute, (String)str2);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }
}

