/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class AdjFileFieldUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(AdjFileFieldUpdateTask.class);
    private static int BATCH_SIZE = 500;
    private SWCDataServiceHelper adjFileService = new SWCDataServiceHelper("hcdm_adjfileinfo");
    private static final String updateJobGradeJobLevelSql = "update t_hcdm_adjfileinfo set fjoblevelid = ?, fjobgradeid= ? where fid = ?";
    private static final String KEY_SPLIT_FALG = "###";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.debug("AdjFileFieldUpdateTask begin");
        this.doUpdatePositionAndAdminorg();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        logger.debug("AdjApprbillEntryUpdateTask ended");
    }

    private void doUpdatePositionAndAdminorg() {
        Set<Long> fileIds = this.getNeedUpdateFileID();
        if (CollectionUtils.isNotEmpty(fileIds)) {
            logger.info("query total adjfile number is:{}", (Object)fileIds.size());
            ArrayList<Long> adjfileList = new ArrayList<Long>(fileIds);
            ListUtils.partition(adjfileList, (int)BATCH_SIZE).forEach(list -> this.batchHandleData((List<Long>)list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchHandleData(List<Long> fileList) {
        if (CollectionUtils.isEmpty(fileList)) {
            return;
        }
        try (TXHandle tx = TX.required();){
            DynamicObject[] adjfileDyns = this.adjFileService.loadDynamicObjectArray(fileList.toArray());
            logger.info("AdjFileFieldUpdateTask billDyns size:", (Object)adjfileDyns.length);
            for (DynamicObject fileDy : adjfileDyns) {
                fileDy.set("assoadminorg", fileDy.get("adminorg"));
                long adminorgId = fileDy.getLong("empposorgrel.adminorg.id");
                long positionId = fileDy.getLong("empposorgrel.position.id");
                fileDy.set("adminorg", (Object)adminorgId);
                fileDy.set("position", (Object)positionId);
            }
            this.adjFileService.update(adjfileDyns);
        }
    }

    private Set<Long> getNeedUpdateFileID() {
        QFilter filter = new QFilter("assoadminorg", "=", (Object)0);
        filter.and(new QFilter("empposorgrel", ">", (Object)0));
        DynamicObject[] query = this.adjFileService.query("id,boid", new QFilter[]{filter});
        return Arrays.stream(query).map(o1 -> o1.getLong("id")).collect(Collectors.toSet());
    }

    private Set<Long> getNeedUpdateJobGradeLevelFileID() {
        QFilter filter = new QFilter("position", ">", (Object)0);
        filter.and(new QFilter("empposorgrel", ">", (Object)0));
        filter.and(new QFilter("jobgrade", "=", (Object)0));
        filter.and(new QFilter("joblevel", "=", (Object)0));
        DynamicObject[] query = this.adjFileService.query("id", new QFilter[]{filter});
        return Arrays.stream(query).map(o1 -> o1.getLong("id")).collect(Collectors.toSet());
    }
}

