/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjFieldFactory;
import kd.swc.hcdm.business.salaryadjsync.SalaryAdjSyncConstants;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.DataStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class AdjSalarySynUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AdjSalarySynUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        LOGGER.info("AdjSalarySynUpdateTask start");
        QFilter eventFilter = new QFilter("salaryadjevent.id", "=", (Object)0L);
        eventFilter.or(new QFilter("salaryadjevent.id", "is null", null));
        eventFilter.or(new QFilter("createtime", "is null", null));
        QFilter operatorFilter = new QFilter("operator", "!=", (Object)" ");
        operatorFilter.and(new QFilter("operator", "is not null", null));
        SWCDataServiceHelper adjSalarySynHelper = new SWCDataServiceHelper("hcdm_adjsalsyn");
        Object[] synRecs = adjSalarySynHelper.query("id,org,country,salaryadjevent,syncschedule.id,syncstrategy,batchnumber,syntypes,synstatus,syntime,modifier,adjsalarysynset,totalnum,successnum,failnum,errormsg,datasource,srcbill,srcbillid,createtime,needrepush,syntimes", new QFilter[]{eventFilter, operatorFilter});
        if (!ArrayUtils.isEmpty((Object[])synRecs)) {
            for (Object synRec : synRecs) {
                try {
                    this.dataUpgrade((DynamicObject)synRec, adjSalarySynHelper);
                }
                catch (Exception ex) {
                    LOGGER.error("Error occurs AdjSalarySynUpdateTask.dataUpgrade", (Throwable)ex);
                }
            }
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        service.disableSchedule(taskInfo.getScheduleId());
        LOGGER.info("AdjSalarySynUpdateTask end");
    }

    private void dataUpgrade(DynamicObject synRec, SWCDataServiceHelper adjSalarySynHelper) {
        QFilter synRecFilter = new QFilter("adjsalsyn", "=", (Object)synRec.getLong("id"));
        QFilter salaryAdjRecordFilter = new QFilter("salaryadjrecord.id", "=", (Object)0L);
        salaryAdjRecordFilter.or(new QFilter("salaryadjrecord.id", "is null", null));
        SWCDataServiceHelper detailServiceHelper = new SWCDataServiceHelper("hcdm_adjsalsyndetail");
        Object[] synDetails = detailServiceHelper.query("id,adjsalsyn,salaryadjrecord.id,salaryadjrecordboid,decadjrelperson.id,adjfile.id,adjfile.org.id,adjfile.country.id,salarystditem.id,bsled,bsed,syntype,approvalbillid,adjsalarysynset.id,salaystructure.id,job.id,position.id", new QFilter[]{synRecFilter, salaryAdjRecordFilter});
        if (!ArrayUtils.isEmpty((Object[])synDetails)) {
            String synTypesOld;
            HashSet fileIds = Sets.newHashSetWithExpectedSize((int)synDetails.length);
            HashSet itemIds = Sets.newHashSetWithExpectedSize((int)Math.min(100, synDetails.length));
            HashSet synTypes = Sets.newHashSetWithExpectedSize((int)3);
            long appBillId = 0L;
            long orgId = 0L;
            long countryId = 0L;
            long adjSalarySynSetId = 0L;
            Date minEffectDate = null;
            Date maxEffectDate = null;
            for (Object synDetail : synDetails) {
                fileIds.add(synDetail.getLong("adjfile.id"));
                itemIds.add(synDetail.getLong("salarystditem.id"));
                Date expireDate = synDetail.getDate("bsled");
                String synType = expireDate != null && expireDate.after(SalaryAdjSyncConstants.MAX_EXPIRE_DATE) ? "1" : "2";
                synDetail.set("syntype", (Object)synType);
                synTypes.add(synType);
                Date effectDate = synDetail.getDate("bsed");
                if (effectDate != null) {
                    if (minEffectDate == null) {
                        minEffectDate = effectDate;
                        maxEffectDate = effectDate;
                    } else if (effectDate.after(maxEffectDate)) {
                        maxEffectDate = effectDate;
                    } else if (effectDate.before(minEffectDate)) {
                        minEffectDate = effectDate;
                    }
                }
                if (appBillId == 0L) {
                    appBillId = synDetail.getLong("approvalbillid");
                }
                if (orgId == 0L) {
                    orgId = synDetail.getLong("adjfile.org.id");
                }
                if (countryId == 0L) {
                    countryId = synDetail.getLong("adjfile.country.id");
                }
                if (adjSalarySynSetId != 0L) continue;
                adjSalarySynSetId = synDetail.getLong("adjsalarysynset.id");
            }
            if (synRec.getLong("salaryadjevent.id") == 0L) {
                SWCDataServiceHelper billServiceHelper;
                DynamicObject billObj;
                synRec.set("org", (Object)orgId);
                synRec.set("country", (Object)countryId);
                synRec.set("adjsalarysynset", (Object)adjSalarySynSetId);
                if (appBillId != 0L && (billObj = (billServiceHelper = new SWCDataServiceHelper("hcdm_adjapprbill")).queryOriginalOne("billname,salaryadjrsn.attributiontype", (Object)appBillId)) != null) {
                    synRec.set("srcbillid", (Object)appBillId);
                    synRec.set("srcbill", (Object)billObj.getString("billname"));
                    String type = billObj.getString("salaryadjrsn.attributiontype");
                    if (!StringUtils.isEmpty((CharSequence)type)) {
                        synRec.set("datasource", (Object)("3" + type));
                    }
                }
                String ukKey = "UPGRADE_" + synRec.getLong("id");
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_salaryadjevent");
                DynamicObject eventObj = serviceHelper.generateEmptyDynamicObject();
                eventObj.set("eventtype", (Object)"3");
                eventObj.set("eventdate", (Object)new Date());
                eventObj.set("comment", (Object)"update by self");
                eventObj.set("eventstatus", (Object)"0");
                eventObj.set("event", (Object)ukKey);
                serviceHelper.saveOne(eventObj);
                synRec.set("salaryadjevent", (Object)eventObj);
            }
            if (!StringUtils.isEmpty((CharSequence)(synTypesOld = synRec.getString("syntypes")))) {
                synTypes.addAll(Arrays.asList(synTypesOld.split(",")));
            }
            synRec.set("syntypes", (Object)Joiner.on((String)",").join((Iterable)synTypes));
            QFilter fileFilter = new QFilter("salaryadjfile.id", "in", (Object)fileIds);
            QFilter itemFilter = new QFilter("standarditem.id", "in", (Object)itemIds);
            QFilter effectFilter = new QFilter("bsed", "<=", maxEffectDate);
            QFilter expireFilter = new QFilter("bsled", ">=", (Object)minEffectDate);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.INVALID.getCode(), DataStatusEnum.SCHEDULEEFFECT.getCode()});
            SWCDataServiceHelper salaryAdjRecServiceHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
            Object[] query = salaryAdjRecServiceHelper.query("id,boid,relpersonid,salaryadjfile.id,standarditem.id,bsed,bsled", new QFilter[]{fileFilter, itemFilter, expireFilter, effectFilter, statusFilter, dataStatusFilter});
            if (!ArrayUtils.isEmpty((Object[])query)) {
                Object[] relPersons;
                HashBasedTable adjRecOfFileAndItem = HashBasedTable.create();
                for (Object object : query) {
                    long fileId = object.getLong("salaryadjfile.id");
                    long itemId = object.getLong("standarditem.id");
                    List objects = (List)adjRecOfFileAndItem.get((Object)fileId, (Object)itemId);
                    if (objects == null) {
                        objects = Lists.newArrayListWithExpectedSize((int)4);
                        adjRecOfFileAndItem.put((Object)fileId, (Object)itemId, (Object)objects);
                    }
                    objects.add(object);
                }
                HashSet relPersonIds = Sets.newHashSetWithExpectedSize((int)query.length);
                for (Object detail : synDetails) {
                    long fileId = detail.getLong("adjfile.id");
                    long itemId = detail.getLong("salarystditem.id");
                    Date effectDate = detail.getDate("bsed");
                    List adjRec = (List)adjRecOfFileAndItem.get((Object)fileId, (Object)itemId);
                    if (CollectionUtils.isEmpty((Collection)adjRec)) continue;
                    for (DynamicObject object : adjRec) {
                        if (!SWCDateTimeUtils.isCover((Date)effectDate, (Date)object.getDate("bsed"), (Date)object.getDate("bsled"))) continue;
                        detail.set("salaryadjrecord", (Object)object.getLong("id"));
                        detail.set("salaryadjrecordboid", (Object)object.getLong("boid"));
                        long relPersonId = object.getLong("relpersonid");
                        relPersonIds.add(relPersonId);
                        detail.set("decadjrelperson", (Object)relPersonId);
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)relPersonIds) && !ArrayUtils.isEmpty((Object[])(relPersons = new SWCDataServiceHelper("hcdm_decadjrelperson").query("id,salaystructure.id,job.id,position.id", new QFilter[]{new QFilter("id", "in", (Object)relPersonIds)})))) {
                    Map<Long, DynamicObject> personMap = Arrays.stream(relPersons).collect(Collectors.toMap(ele -> ele.getLong("id"), ele -> ele, (k1, k2) -> k1));
                    for (Object detail : synDetails) {
                        Long personId = SalaryAdjFieldFactory.getIdOfBaseProp((DynamicObject)detail, "decadjrelperson");
                        DynamicObject person = personMap.get(personId);
                        if (person == null) continue;
                        detail.set("salaystructure", person.get("salaystructure"));
                        detail.set("job", person.get("job"));
                        detail.set("position", person.get("position"));
                    }
                }
            }
            detailServiceHelper.save((DynamicObject[])synDetails);
        }
        if (synRec.getDate("createtime") == null) {
            synRec.set("createtime", synRec.get("syntime"));
        }
        adjSalarySynHelper.saveOne(synRec);
    }
}

