/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ApprovalBillUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(ApprovalBillUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        this.main();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void main() {
        DynamicObject[] bills = this.queryTodayRateApprovalBill();
        HashMap<Date, Set<Long>> dateFileMap = new HashMap<Date, Set<Long>>(16);
        HashMap<Long, List<DynamicObject>> idDataMap = new HashMap<Long, List<DynamicObject>>(16);
        this.calcAndCollectData(bills, dateFileMap, idDataMap);
        QFilter sumFilter = this.collectQFilter(dateFileMap);
        if (sumFilter == null) {
            return;
        }
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hcdm_adjsalaryhis");
        QFilter[] filters = new QFilter[]{sumFilter};
        String selectProperties = "id,salaryadjfile.id,entryentity.standarditem,entryentity.actualamount,entryentity.finalamount";
        DynamicObject[] adjSalaryInfos = fileHelper.query(selectProperties, filters);
        this.setAdjSalaryInfo(adjSalaryInfos, idDataMap);
        SWCDataServiceHelper billHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
        try (TXHandle tx = TX.requiresNew();){
            logger.info("\u8c03\u85aa\u7533\u8bf7\u5355\u5b9a\u65f6\u8fdb\u884c\u6c47\u7387\u76f8\u5173\u8ba1\u7b97\u7684\u4e8b\u52a1\u5f00\u542f\uff1a{}", (Object)new Date());
            fileHelper.update(adjSalaryInfos);
            billHelper.update(bills);
            tx.commit();
            logger.info("\u8c03\u85aa\u7533\u8bf7\u5355\u5b9a\u65f6\u8fdb\u884c\u6c47\u7387\u76f8\u5173\u8ba1\u7b97\u7684\u4e8b\u52a1\u5b8c\u6210\uff1a{}", (Object)new Date());
        }
    }

    private QFilter collectQFilter(Map<Date, Set<Long>> dateFileMap) {
        QFilter sumFilter = null;
        for (Map.Entry<Date, Set<Long>> dateFileEntry : dateFileMap.entrySet()) {
            Date effectiveDate = dateFileEntry.getKey();
            Set<Long> fileIds = dateFileEntry.getValue();
            QFilter filter = new QFilter("bsed", "<=", (Object)effectiveDate);
            filter.and("bsled", ">", (Object)effectiveDate);
            filter.and("salaryadjfile", "in", fileIds);
            if (sumFilter == null) {
                sumFilter = filter;
                continue;
            }
            sumFilter.or(filter);
        }
        return sumFilter;
    }

    private void setAdjSalaryInfo(DynamicObject[] adjSalaryInfos, Map<Long, List<DynamicObject>> idDataMap) {
        for (DynamicObject adjSalaryInfo : adjSalaryInfos) {
            long fileId = adjSalaryInfo.getLong("salaryadjfile.id");
            List<DynamicObject> approveBillEnts = idDataMap.get(fileId);
            if (approveBillEnts == null) continue;
            Map stdItemBillDetailMap = approveBillEnts.stream().collect(Collectors.toMap(dy -> dy.getLong("standarditem.id"), Function.identity()));
            DynamicObjectCollection adjSalaryEnts = adjSalaryInfo.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjSalaryEnt : adjSalaryEnts) {
                long stdItemId = adjSalaryEnt.getLong("standarditem.id");
                DynamicObject billDetail = (DynamicObject)stdItemBillDetailMap.get(stdItemId);
                if (billDetail == null) continue;
                adjSalaryEnt.set("actualamount", (Object)billDetail.getBigDecimal("actualamount"));
                adjSalaryEnt.set("finalamount", (Object)billDetail.getBigDecimal("finalamount"));
            }
        }
    }

    private void calcAndCollectData(DynamicObject[] bills, Map<Date, Set<Long>> dateFileMap, Map<Long, List<DynamicObject>> idDataMap) {
        for (DynamicObject bill : bills) {
            if (!SWCStringUtils.equals((String)bill.getString("auditstatus"), (String)"C") || !SWCStringUtils.equals((String)bill.getString("billstatus"), (String)"C")) continue;
            Object afterCalcEnts = null;
            Date date = bill.getDate("effectivedate");
        }
    }

    private DynamicObject[] queryTodayRateApprovalBill() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_adjapprbill");
        String selectProperties = "id,billstatus,auditstatus,exctable.id,effectivedate,exchangeratedate,currency,totalamount,adjapprdetailent.actualrange,adjapprdetailent.adjfile,adjapprdetailent.standarditem,adjapprdetailent.currentsalary,adjapprdetailent.finalamount,adjapprdetailent.actualamount,adjapprdetailent.currentcurrency_id,adjapprdetailent.adjcurrency_id";
        Date today = SWCDateTimeUtils.getTodayDateWithoutTime();
        QFilter filter = new QFilter("exchangeratedate", "=", (Object)today);
        QFilter[] filters = new QFilter[]{filter};
        return helper.query(selectProperties, filters);
    }
}

