/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.task.GradeRankUpdateBaseTask;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class CandEscrowStaffUpdateTask
extends GradeRankUpdateBaseTask {
    private static final Log logger = LogFactory.getLog(CandEscrowStaffUpdateTask.class);
    private static final String TYPE = "CandEscrowStaffUpdate";
    private static final String updateCandSql = "update t_hcdm_candsetsalperson set fescrowstaff = ? where fentryid = ?";

    protected CandEscrowStaffUpdateTask() {
        super("SELECT t1.fentryid,t1.fadminorgid,t1.fescrowstaff,t2.fdepartmentid FROM t_hcdm_candsetsalperson t1\nleft join t_hcdm_candsetsalperson_a t2 on t1.fentryid = t2.fentryid\nleft join t_hcdm_salarelupdate t3 on t1.fentryid = t3.fdataid AND t3.ftype = 'CandEscrowStaffUpdate'\nWHERE t3.fid IS NULL;");
    }

    @Override
    protected void logException(Exception exception) {
        logger.error("doUpdateCandidateEscrowStaff execute error:", (Throwable)exception);
    }

    @Override
    protected void logFinish() {
        logger.info("doUpdateCandidateEscrowStaff finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetailUpdateAction(DataSet dataRows) {
        int i1;
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)5000);
        HashSet adminOrgHRIdSet = Sets.newHashSetWithExpectedSize((int)16);
        int count = 0;
        while (dataRows.hasNext()) {
            Row row = dataRows.next();
            Long entryId = row.getLong("fentryid");
            Long adminOrgId = row.getLong("fadminorgid");
            String escrowStaff = row.getString("fescrowstaff");
            Long departmentId = row.getLong("fdepartmentid");
            adminOrgHRIdSet.add(adminOrgId);
            adminOrgHRIdSet.add(departmentId);
            List list = rowMap.computeIfAbsent(entryId, k1 -> Lists.newArrayListWithExpectedSize((int)3));
            list.add(adminOrgId);
            list.add(escrowStaff);
            list.add(departmentId);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        ArrayList updateParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList successParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList failParams = Lists.newArrayListWithExpectedSize((int)5000);
        Map<Long, Long> admingOrgMap = this.getAdmingOrgMap(adminOrgHRIdSet);
        for (Map.Entry entry : rowMap.entrySet()) {
            Object[] item;
            String escrowStaff;
            Long entryId;
            block14: {
                entryId = (Long)entry.getKey();
                Long adminOrgId = (Long)((ArrayList)entry.getValue()).get(0);
                Long departmentId = (Long)((ArrayList)entry.getValue()).get(2);
                escrowStaff = "0";
                try {
                    Long adminOrgBoId = admingOrgMap.get(adminOrgId);
                    Long departmentBoId = admingOrgMap.get(departmentId);
                    if (adminOrgBoId.equals(departmentBoId)) break block14;
                    escrowStaff = "1";
                }
                catch (Exception ex) {
                    logger.error("doUpdateCandidateEscrowStaff error", (Throwable)ex);
                    logger.error("doUpdateCandidateEscrowStaff fentryid is [{}]", (Object)entryId);
                    item = new Object[5];
                    item[1] = entryId;
                    item[2] = TYPE;
                    item[3] = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
                    item[4] = "0";
                    failParams.add(item);
                    continue;
                }
            }
            Object[] updateItem = new Object[2];
            updateParams.add(updateItem);
            updateItem[0] = escrowStaff;
            updateItem[1] = entryId;
            item = new Object[5];
            item[1] = entryId;
            item[2] = TYPE;
            item[3] = "";
            item[4] = "1";
            successParams.add(item);
        }
        long[] fids = DB.genLongIds((String)"T_HCDM_SALARELUPDATE", (int)(failParams.size() + successParams.size()));
        for (i1 = 0; i1 < failParams.size(); ++i1) {
            Object[] items = (Object[])failParams.get(i1);
            items[0] = fids[i1];
        }
        for (Object[] items : successParams) {
            items[0] = fids[i1];
            ++i1;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty((Collection)updateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateCandSql, (List)updateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)successParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)successParams);
            }
            if (!CollectionUtils.isEmpty((Collection)failParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)failParams);
            }
        }
    }

    private Map<Long, Long> getAdmingOrgMap(Set<Long> adminOrgHRIdSet) {
        if (CollectionUtils.isEmpty(adminOrgHRIdSet)) {
            return ImmutableMap.of();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorghr");
        Object[] query = serviceHelper.query("id,boid", new QFilter[]{new QFilter("id", "in", adminOrgHRIdSet)});
        if (ArrayUtils.isEmpty((Object[])query)) {
            return ImmutableMap.of();
        }
        return Arrays.stream(query).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("boid"), (o1, o2) -> o2));
    }
}

