/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.task.GradeRankUpdateBaseTask;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class CandGradeRankUpdateTask
extends GradeRankUpdateBaseTask {
    private static final Log logger = LogFactory.getLog(CandGradeRankUpdateTask.class);
    private static final String candType = "t_hcdm_persetsalrec";
    private static final String updateCandSql = "update t_hcdm_persetsalrec set fsalarel = ? where fdetailid = ?";

    protected CandGradeRankUpdateTask() {
        super("SELECT t1.fdetailid,t1.fsalarel,t1.fstandarditemid,t1.fsalarystdvid,t2.fid FROM t_hcdm_persetsalrec t1\n         LEFT JOIN t_hcdm_salarelupdate t2 ON t1.fdetailid = t2.fdataid AND t2.ftype = 't_hcdm_persetsalrec'\nWHERE t1.fsalarel IS NOT NULL\n  AND t1.fsalarel != ' '\n  AND t2.fid IS NULL;");
    }

    @Override
    protected void logException(Exception e1) {
        logger.error("doUpdateCandidateSetSalaryApplData execute error:", (Throwable)e1);
    }

    @Override
    protected void logFinish() {
        logger.info("doUpdateCandidateSetSalaryApplData finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetailUpdateAction(DataSet dataRows) {
        int i2;
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)5000);
        int count = 0;
        while (dataRows.hasNext()) {
            Row row = dataRows.next();
            Long id = row.getLong("fdetailid");
            Long standardItemId = row.getLong("fstandarditemid");
            Long salaryStdId = row.getLong("fsalarystdvid");
            String fSalaRelStr = row.getString("fsalarel");
            List list = rowMap.computeIfAbsent(id, k1 -> Lists.newArrayListWithExpectedSize((int)3));
            list.add(standardItemId);
            list.add(salaryStdId);
            list.add(fSalaRelStr);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        Map<Long, Map<Long, Boolean>> useRankMap = this.getUseRankMap(rowMap);
        ArrayList updateParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList successParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList failParams = Lists.newArrayListWithExpectedSize((int)5000);
        for (Map.Entry entry : rowMap.entrySet()) {
            Object[] item;
            String newFSalaRelStr = null;
            Long detailId = null;
            detailId = (Long)entry.getKey();
            Long standardItemId = (Long)((ArrayList)entry.getValue()).get(0);
            Long salaryStdId = (Long)((ArrayList)entry.getValue()).get(1);
            String oldFSalaRelStr = (String)((ArrayList)entry.getValue()).get(2);
            Map<Long, Boolean> flagMap = useRankMap.get(salaryStdId);
            try {
                Object parseObj = JSON.parse((String)oldFSalaRelStr);
                if (parseObj instanceof JSONArray) {
                    List matchRangeDataList = (List)JSON.parseObject((String)oldFSalaRelStr, (TypeReference)new TypeReference<List<GradeRankKey>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
                    Map<Long, List<Long>> matchRangeMap = GradeRankHelper.groupByRangeKeyToIdMap(matchRangeDataList);
                    if (!flagMap.get(standardItemId).booleanValue()) {
                        for (Map.Entry<Long, List<Long>> matchRangeMapEntry : matchRangeMap.entrySet()) {
                            matchRangeMapEntry.setValue(Collections.emptyList());
                        }
                    }
                    newFSalaRelStr = JSON.toJSONString(matchRangeMap);
                } else {
                    newFSalaRelStr = oldFSalaRelStr;
                }
            }
            catch (Exception ex) {
                logger.error("CandidateSetSalaryApplGradeRankUpdate error", (Throwable)ex);
                logger.error("CandidateSetSalaryApplGradeRankUpdate detailId is [{}]", (Object)detailId);
                item = new Object[5];
                item[1] = detailId;
                item[2] = candType;
                item[3] = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
                item[4] = "0";
                failParams.add(item);
                continue;
            }
            Object[] updateItem = new Object[2];
            updateParams.add(updateItem);
            updateItem[0] = newFSalaRelStr;
            updateItem[1] = detailId;
            item = new Object[5];
            item[1] = detailId;
            item[2] = candType;
            item[3] = "";
            item[4] = "1";
            successParams.add(item);
        }
        long[] fids = DB.genLongIds((String)"T_HCDM_SALARELUPDATE", (int)(failParams.size() + successParams.size()));
        for (i2 = 0; i2 < failParams.size(); ++i2) {
            Object[] items = (Object[])failParams.get(i2);
            items[0] = fids[i2];
        }
        for (Object[] items : successParams) {
            items[0] = fids[i2];
            ++i2;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty((Collection)updateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateCandSql, (List)updateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)successParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)successParams);
            }
            if (!CollectionUtils.isEmpty((Collection)failParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)failParams);
            }
        }
    }
}

