/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDException;
import kd.bos.form.control.events.UploadListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hcdm.business.salarystandardscm.SalaryStandardScmHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class CandidateSalaryOrgAndStdScmUpdateTask
extends AbstractTask
implements UploadListener {
    private static final Log LOGGER = LogFactory.getLog(CandidateSalaryOrgAndStdScmUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object[] offerDys;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_candidatebill");
        QFilter offerCodeFilter = new QFilter("offercode", "!=", (Object)" ");
        offerCodeFilter.and("offercode", "is not null", (Object)"");
        offerCodeFilter.and("salaryadjorg", "=", (Object)0L);
        Object[] dys = helper.query("offercode,salarystructure,stdscm,salaryadjorg", new QFilter[]{offerCodeFilter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            this.disableTask();
            return;
        }
        HashMap candidateDysMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        HashSet salaryStructureDysSet = Sets.newHashSetWithExpectedSize((int)dys.length);
        for (Object object : dys) {
            if (null != object.get("salaryadjorg")) continue;
            candidateDysMap.put(object.getString("offercode"), object);
            salaryStructureDysSet.add(object.getLong("salarystructure.id"));
        }
        try {
            helper = new SWCDataServiceHelper("tso_somk_waitofferbase");
            offerCodeFilter = new QFilter("number", "in", candidateDysMap.keySet());
            offerDys = helper.query("number,peadminorg", new QFilter[]{offerCodeFilter}, "createtime desc");
        }
        catch (Exception exception) {
            this.disableTask();
            LOGGER.error((Throwable)exception);
            return;
        }
        if (ArrayUtils.isEmpty((Object[])offerDys)) {
            this.disableTask();
            return;
        }
        HashMap offerNUmberAndPeAdminOrgMap = Maps.newHashMapWithExpectedSize((int)offerDys.length);
        HashSet peadminOrgSet = Sets.newHashSetWithExpectedSize((int)dys.length);
        for (Object object : offerDys) {
            if (null == object.get("peadminorg")) continue;
            peadminOrgSet.add(object.getLong("peadminorg.id"));
            offerNUmberAndPeAdminOrgMap.put(object.getString("number"), object.getLong("peadminorg.id"));
        }
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)peadminOrgSet.size());
        for (Long aAdminOrgId : peadminOrgSet) {
            hashMap.put(aAdminOrgId, Sets.newHashSet((Object[])new Long[]{107020L}));
        }
        LOGGER.info("OnBrdInfoPushToCandSetSalApplService getHrBuByBusinessType pram= {}", (Object)hashMap);
        List result = (List)SWCMServiceUtils.invokeHRMPService((String)"hrcs", (String)"IHRCSStrategyService", (String)"getHrBuByBusinessType", (Object[])new Object[]{hashMap, 1010L});
        LOGGER.info("OnBrdInfoPushToCandSetSalApplService getHrBuByBusinessType result= {}", (Object)result);
        HashMap buMap = Maps.newHashMapWithExpectedSize((int)result.size());
        if (!CollectionUtils.isEmpty((Collection)result)) {
            for (Map en : result) {
                buMap.put(en.get("adminOrgId"), en.get("hrBuId"));
            }
        }
        Map<Long, List<DynamicObject>> map2 = SalaryStandardScmHelper.queryStdScmMapByStructureIds(salaryStructureDysSet);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hcdm_candsetsalappl");
        QFilter filter = new QFilter("candsetsalperson.offercode", "in", candidateDysMap.keySet());
        Object[] candsetsalaDys = serviceHelper.query("id,candsetsalperson.offercode,candsetsalperson.salarystructure,candsetsalperson.stdscmvid", new QFilter[]{filter});
        HashMap candsetsalaDysMaps = Maps.newHashMapWithExpectedSize((int)candidateDysMap.size());
        if (!ArrayUtils.isEmpty((Object[])candsetsalaDys)) {
            for (Object candsetsalaDy : candsetsalaDys) {
                DynamicObjectCollection candsetsalperson = candsetsalaDy.getDynamicObjectCollection("candsetsalperson");
                DynamicObject dynamicObject = (DynamicObject)candsetsalperson.get(0);
                candsetsalaDysMaps.put(dynamicObject.getString("offercode"), dynamicObject);
            }
        }
        HashSet updateSet = Sets.newHashSetWithExpectedSize((int)candidateDysMap.size());
        for (Map.Entry entry : candidateDysMap.entrySet()) {
            String offerNumber = (String)entry.getKey();
            DynamicObject dy = (DynamicObject)entry.getValue();
            Long peAdminOrgId = (Long)offerNUmberAndPeAdminOrgMap.get(offerNumber);
            Long hrId = null;
            if (null != peAdminOrgId && null != (hrId = (Long)buMap.get(peAdminOrgId))) {
                dy.set("salaryadjorg", (Object)hrId);
                updateSet.add(dy);
            }
            long salarystructureId = dy.getLong("salarystructure.id");
            List<DynamicObject> list = map2.get(salarystructureId);
            DynamicObject dynamicObject = (DynamicObject)candsetsalaDysMaps.get(offerNumber);
            if (null != dynamicObject && salarystructureId == dynamicObject.getLong("salarystructure.id")) {
                dy.set("stdscm", dynamicObject.get("stdscmvid"));
                updateSet.add(dy);
                continue;
            }
            this.getStdScmVid(updateSet, dy, list, hrId);
        }
        if (!CollectionUtils.isEmpty((Collection)updateSet)) {
            helper.update(updateSet.toArray(new DynamicObject[0]));
        }
        this.disableTask();
    }

    private void getStdScmVid(Set<DynamicObject> updateSet, DynamicObject dy, List<DynamicObject> list, Long hrId) {
        if (!CollectionUtils.isEmpty(list)) {
            if (list.size() == 1) {
                dy.set("stdscm", (Object)list.get(0).getLong("sourcevid"));
                updateSet.add(dy);
                return;
            }
            if (null == hrId) {
                return;
            }
            for (DynamicObject stdScmDy : list) {
                if (stdScmDy.getLong("createorg.id") != hrId.longValue()) continue;
                dy.set("stdscm", (Object)stdScmDy.getLong("sourcevid"));
                updateSet.add(dy);
                break;
            }
        }
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

