/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import org.apache.commons.lang3.ArrayUtils;

public class CandsetsalOfferIdUpdaTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(CandsetsalOfferIdUpdaTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("OfferIdUpdateService update");
        this.updateOfferId();
    }

    public void updateOfferId() {
        List<Object[]> updateCandsetsalactParams;
        Map<Long, Long> onbrdinfoMap;
        String querySql = "SELECT FENTRYID,FONBRDINFOID FROM T_HCDM_CANDSETSALPERSON WHERE FOFFERCODE != ' ' AND FOFFERID = 0 OR FOFFERCODE != ' ' AND FOFFERID is null";
        HashSet onbrdinfoIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryHCDMCandidateBill", (DBRoute)new DBRoute("hcdm"), (String)querySql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row next = dateSet.next();
                onbrdinfoIdSet.add(next.getLong("FONBRDINFOID"));
                map.put(next.getLong("FENTRYID"), next.getLong("FONBRDINFOID"));
            }
        }
        log.info("hcdm_candsetsalperson update data {}", (Object)map);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_candsetsalact");
        QFilter offerIdFilter = new QFilter("entryentity.offerid", "=", (Object)0L);
        offerIdFilter.or("entryentity.offerid", "is null", (Object)"");
        QFilter offerCOdeFilter = new QFilter("entryentity.offernumber", "!=", (Object)" ");
        DynamicObject[] dys = helper.query("entryentity.id,onbrdinfoid", new QFilter[]{offerIdFilter, offerCOdeFilter});
        HashMap candsetsalactMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dy2 : dys) {
            DynamicObjectCollection entryentity = dy2.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryentity)) continue;
            for (DynamicObject dynamicObject : entryentity) {
                candsetsalactMap.put(dynamicObject.getLong("id"), dy2.getLong("onbrdinfoid"));
            }
            onbrdinfoIdSet.add(dy2.getLong("onbrdinfoid"));
        }
        log.info("hcdm_candsetsalact update data {}", (Object)candsetsalactMap);
        if (CollectionUtils.isEmpty((Collection)onbrdinfoIdSet)) {
            this.disableTask();
            return;
        }
        helper = new SWCDataServiceHelper("hom_onbrdinfo");
        QFilter filter = new QFilter("id", "in", (Object)onbrdinfoIdSet);
        QFilter datasourceFilter = new QFilter("candidate.datasource", "=", (Object)"0");
        Object[] onbrdinfo = helper.query("id,offerid", new QFilter[]{filter, datasourceFilter});
        if (ArrayUtils.isEmpty((Object[])onbrdinfo)) {
            this.disableTask();
        }
        if (CollectionUtils.isEmpty(onbrdinfoMap = Arrays.stream(onbrdinfo).filter(dy -> 0L != dy.getLong("offerid")).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("offerid"), (o1, o2) -> o2)))) {
            log.info("kd/swc/hcdm/business/task/CandsetsalOfferIdUpdaTask");
            return;
        }
        List<Object[]> updateCandsetsalPersonParams = this.getUpdateParams(map, onbrdinfoMap);
        if (!CollectionUtils.isEmpty(updateCandsetsalPersonParams)) {
            String updateSql = "UPDATE T_HCDM_CANDSETSALPERSON SET FOFFERID = ? WHERE FENTRYID = ? ";
            SWCDbUtil.executeBatch((DBRoute)new DBRoute("hcdm"), (String)updateSql, updateCandsetsalPersonParams);
        }
        if (!CollectionUtils.isEmpty(updateCandsetsalactParams = this.getUpdateParams(candsetsalactMap, onbrdinfoMap))) {
            String updateSql = "UPDATE T_HCDM_CANDACTENTRY SET FOFFERID = ? WHERE FENTRYID = ? ";
            SWCDbUtil.executeBatch((DBRoute)new DBRoute("hcdm"), (String)updateSql, updateCandsetsalactParams);
        }
        if (onbrdinfoMap.size() == onbrdinfo.length) {
            this.disableTask();
        }
    }

    private List<Object[]> getUpdateParams(HashMap<Long, Long> map, Map<Long, Long> onbrdinfoMap) {
        ArrayList updateParams = Lists.newArrayListWithExpectedSize((int)map.size());
        for (Map.Entry<Long, Long> entry : map.entrySet()) {
            Long id = entry.getKey();
            Long offerId = onbrdinfoMap.get(entry.getValue());
            if (null == offerId) continue;
            Object[] upParam = new Object[]{offerId, id};
            updateParams.add(upParam);
        }
        return updateParams;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

