/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.adjapplication.service.AdjApprovalApplicationService;
import kd.swc.hcdm.business.adjapplication.service.AdjFileApplicationService;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprBillSynServiceHelper;
import kd.swc.hcdm.common.enums.ConfirmStatusEnum;
import kd.swc.hcdm.common.enums.DecAdjSynStatusEnum;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import kd.swc.hcdm.common.enums.SynOperationEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import org.apache.commons.collections.CollectionUtils;

public class DecAdjApprBillRetryTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(DecAdjApprBillRetryTask.class);
    private static final int BATCH_SIZE = 1000;
    private AdjFileApplicationService adjFileApplicationService = (AdjFileApplicationService)DomainFactory.getInstance(AdjFileApplicationService.class);
    private static final String adjApprPerSelectProperties = SWCHisBaseDataHelper.getSelectProperties((String)"hcdm_adjapprperson");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("DecAdjApprBillRetryTask_retryCreateConfirmPerson.execute: begin.");
        this.retryCreateAdjConfirmPerson();
        logger.info("DecAdjApprBillRetryTask_retryCreateConfirmPerson.execute: end.");
        logger.info("DecAdjApprBillRetryTask_retrySyncToFile.execute: begin.");
        QFilter synStatusQFilter = new QFilter("synstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{DecAdjSynStatusEnum.TO_SYNC.getCode(), DecAdjSynStatusEnum.FAILED.getCode()}));
        QFilter confirmStatusQFilter = new QFilter("confirmstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{ConfirmStatusEnum.HAS_CONFIRM.getCode()}));
        SWCDataServiceHelper adjApprPersonHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
        QFilter[] qFilters = new QFilter[]{synStatusQFilter, confirmStatusQFilter};
        DynamicObject[] adjApprPersonArray = adjApprPersonHelper.query("id,adjapprbill", qFilters, "adjapprbill desc", 1000);
        if (adjApprPersonArray.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> adjApprPersonGroupMap = Arrays.stream(adjApprPersonArray).collect(Collectors.groupingBy(item -> item.getLong("adjapprbill")));
        Set<Long> adjApprBillSet = adjApprPersonGroupMap.keySet();
        SWCDataServiceHelper adjApprBillHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
        DynamicObject[] adjApprBillObjArray = adjApprBillHelper.query(adjApprBillSet.toArray());
        Map adjApprBillMap = Arrays.stream(adjApprBillObjArray).collect(Collectors.toMap(item -> item.getLong("id"), Function.identity()));
        for (Map.Entry<Long, List<DynamicObject>> adjApprPersonGroupMapEntry : adjApprPersonGroupMap.entrySet()) {
            Long adjApprBillId = adjApprPersonGroupMapEntry.getKey();
            DynamicObject adjApprBillDyObj = (DynamicObject)adjApprBillMap.get(adjApprBillId);
            String event = this.adjFileApplicationService.beginEvent(EventTypeEnum.DECADJ.getCode());
            List<DynamicObject> adjApprPersonList = adjApprPersonGroupMap.get(adjApprBillId);
            List<Long> ids = adjApprPersonList.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            DecAdjApprBillSynServiceHelper.asynDataToRelPersonWithId(event, adjApprBillDyObj, SynOperationEnum.TIMER_TASK.getCode(), ids);
            QFilter adjApprBillQFilter = new QFilter("adjapprbill", "in", (Object)adjApprBillId);
            Integer count = adjApprPersonHelper.count(new QFilter[]{adjApprBillQFilter, synStatusQFilter, confirmStatusQFilter});
            if (count == 0) {
                this.adjFileApplicationService.endEvent(Lists.newArrayList((Object[])new String[]{event}));
                continue;
            }
            logger.error("apprbillid = {} timer task syn data finished, left data to be deal, need timer task todo again.", (Object)adjApprBillId);
        }
        logger.info("DecAdjApprBillRetryTask_retrySyncToFile.execute: end.");
        logger.info("DecAdjApprBillRetryTask.execute: end.");
    }

    private void retryCreateAdjConfirmPerson() {
        String querySql = "select distinct b.fid,p.fadjfileid from t_hcdm_adjapprbill b\ninner join t_hcdm_adjapprovescm scm on b.fsalaryadjscmid = scm.fid\ninner join t_hcdm_adjapprper p on p.fadjapprbillid = b.fid \nleft join t_hcdm_adjconfirmperson cp on cp.fadjapprovalbillid = b.fid and cp.fadjfileid = p.fadjfileid\nwhere b.fbillstatus = 'C' and scm.fenableconfirm = '1' and cp.fid is null order by b.fid";
        try (DataSet dataSet = HCDMDbHelper.queryDataSet(querySql, new Object[0]);){
            HashMap billToFileIdMap = Maps.newHashMapWithExpectedSize((int)16);
            AdjApprovalApplicationService applicationService = (AdjApprovalApplicationService)DomainFactory.getInstance(AdjApprovalApplicationService.class);
            int dealPersonCount = 0;
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long billId = row.getLong("fid");
                Long fileId = row.getLong("fadjfileid");
                List values = billToFileIdMap.computeIfAbsent(billId, val -> Lists.newArrayListWithExpectedSize((int)10));
                values.add(fileId);
                if (values.size() < 500) continue;
                applicationService.createAdjConfirmPersonByFileId(billId, values);
                dealPersonCount += values.size();
                values.clear();
            }
            dataSet.close();
            for (Map.Entry entry : billToFileIdMap.entrySet()) {
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))) continue;
                applicationService.createAdjConfirmPersonByFileId((Long)entry.getKey(), (List)entry.getValue());
                dealPersonCount += ((List)entry.getValue()).size();
            }
            if (dealPersonCount > 0) {
                logger.info("retryCreateAdjConfirmPerson_dealPersonCount = {}", (Object)dealPersonCount);
            }
        }
    }
}

