/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.task.GradeRankUpdateBaseTask;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class DecAdjApprEntryGradeRankRelUpdateTask
extends GradeRankUpdateBaseTask {
    private static final Log logger = LogFactory.getLog(DecAdjApprEntryGradeRankRelUpdateTask.class);
    private static final String adjApprEntType = "t_hcdm_adjapprperent_a";
    private static final String updateAdjApprEntSql = "update t_hcdm_adjapprperent_a set fsalarel = ? where fentryid = ?";

    protected DecAdjApprEntryGradeRankRelUpdateTask() {
        super("select t1.fentryid, t1.fsalarel, t2.fid, t3.fstandarditemid, t3.fsalarystdvid from t_hcdm_adjapprperent_a t1 left join t_hcdm_adjapprperent t3 on t1.fid = t3.fid left join t_hcdm_salarelupdate t2 on t1.fentryid = t2.fdataid and t2.ftype = 't_hcdm_adjapprperent_a' where t1.fsalarel is not null and t1.fsalarel != ' ' and t2.fid is null");
    }

    @Override
    protected void logException(Exception exception) {
        logger.error("doUpdateDecAdjApprEntryGradeRankRelTask execute error:", (Throwable)exception);
    }

    @Override
    protected void logFinish() {
        logger.info("doUpdateDecAdjApprEntryGradeRankRelTask finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetailUpdateAction(DataSet dataRows) {
        int index;
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)5000);
        int count = 0;
        while (dataRows.hasNext()) {
            Row row = dataRows.next();
            Long id = row.getLong("fentryid");
            Long standardItemId = row.getLong("fstandarditemid");
            Long salaryStdId = row.getLong("fsalarystdvid");
            String fSalaRelStr = row.getString("fsalarel");
            List list = rowMap.computeIfAbsent(id, k1 -> Lists.newArrayListWithExpectedSize((int)3));
            list.add(standardItemId);
            list.add(salaryStdId);
            list.add(fSalaRelStr);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        Map<Long, Map<Long, Boolean>> useRankMap = this.getUseRankMap(rowMap);
        ArrayList updateParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList successParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList failParams = Lists.newArrayListWithExpectedSize((int)5000);
        for (Map.Entry entry : rowMap.entrySet()) {
            Object[] item;
            String newFSalaRelStr;
            Long detailId = (Long)entry.getKey();
            Long standardItemId = (Long)((ArrayList)entry.getValue()).get(0);
            Long salaryStdId = (Long)((ArrayList)entry.getValue()).get(1);
            String oldFSalaRelStr = (String)((ArrayList)entry.getValue()).get(2);
            Map<Long, Boolean> flagMap = useRankMap.get(salaryStdId);
            try {
                Object parseObj = JSON.parse((String)oldFSalaRelStr);
                if (parseObj instanceof JSONArray) {
                    List matchRangeDataList = (List)JSON.parseObject((String)oldFSalaRelStr, (TypeReference)new TypeReference<List<GradeRankKey>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
                    Map<Long, List<Long>> matchRangeMap = GradeRankHelper.groupByRangeKeyToIdMap(matchRangeDataList);
                    if (!flagMap.get(standardItemId).booleanValue()) {
                        for (Map.Entry<Long, List<Long>> matchRangeMapEntry : matchRangeMap.entrySet()) {
                            matchRangeMapEntry.setValue(Collections.emptyList());
                        }
                    }
                    newFSalaRelStr = JSON.toJSONString(matchRangeMap);
                } else {
                    newFSalaRelStr = oldFSalaRelStr;
                }
            }
            catch (Exception ex) {
                logger.error("CandidateSetSalaryApplGradeRankUpdate error", (Throwable)ex);
                logger.error("CandidateSetSalaryApplGradeRankUpdate fentryid is [{}]", (Object)detailId);
                item = new Object[5];
                item[1] = detailId;
                item[2] = adjApprEntType;
                item[3] = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
                item[4] = "0";
                failParams.add(item);
                continue;
            }
            Object[] updateItem = new Object[2];
            updateParams.add(updateItem);
            updateItem[0] = newFSalaRelStr;
            updateItem[1] = detailId;
            item = new Object[5];
            item[1] = detailId;
            item[2] = adjApprEntType;
            item[3] = "";
            item[4] = "1";
            successParams.add(item);
        }
        long[] fids = DB.genLongIds((String)"T_HCDM_SALARELUPDATE", (int)(failParams.size() + successParams.size()));
        for (index = 0; index < failParams.size(); ++index) {
            Object[] items = (Object[])failParams.get(index);
            items[0] = fids[index];
        }
        for (Object[] items : successParams) {
            items[0] = fids[index];
            ++index;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty((Collection)updateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateAdjApprEntSql, (List)updateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)successParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)successParams);
            }
            if (!CollectionUtils.isEmpty((Collection)failParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)failParams);
            }
        }
    }
}

