/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.sdk.swc.hcdm.common.Pair;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchResult;
import kd.swc.hcdm.business.task.GradeRankUpdateBaseTask;
import kd.swc.hcdm.common.entity.adjapprbill.AmountStdRangeEntity;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class DecAdjApprGradeRankRangeUpdateTask
extends GradeRankUpdateBaseTask {
    private static final Log logger = LogFactory.getLog(DecAdjApprGradeRankRangeUpdateTask.class);
    private static final String adjApprEntType = "t_hcdm_adjapprperent";
    private static final String updateAdjApprEntSql = "update t_hcdm_adjapprperent set famountstdrange = ? where fentryid = ?";
    private static final String updateAdjApprEntNoUseRankSql = "update t_hcdm_adjapprperent set famountstdrange = ?, fgradeid= ? where fentryid = ?";
    private static final String updateSalAdjRecordSql = "update t_hcdm_salaryadjrecord set famountstdrange = ? where fid = ?";
    private static final String updateSalAdjRecordNoUseRankSql = "update t_hcdm_salaryadjrecord set famountstdrange = ?, fgradeid= ? where fid = ?";

    protected DecAdjApprGradeRankRangeUpdateTask() {
        super("select t1.fentryid, t3.fadjapprbillid, t3.fadjfileid, t1.fstandarditemid, t1.fsalarystdvid, t1.famountstdrange, t1.fcurrencyid, t1.fprecurrencyid, t1.famount, t4.fcurrencyid stdcurrencyid from t_hcdm_adjapprperent t1 left join t_hcdm_adjapprper t3 on t1.fid = t3.fid left join t_hcdm_salarystd t4 on t1.fsalarystdvid = t4.fid left join t_hcdm_salarelupdate t2 on t1.fentryid = t2.fdataid and t2.ftype = 't_hcdm_adjapprperent' where t2.fid is null");
    }

    @Override
    protected void logException(Exception exception) {
        logger.error("doUpdateApprGradeRankRangeTask execute error:", (Throwable)exception);
    }

    @Override
    protected void logFinish() {
        logger.info("doUpdateApprGradeRankRangeTask finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void doDetailUpdateAction(DataSet dataRows) {
        void var24_28;
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)5000);
        int count = 0;
        while (dataRows.hasNext()) {
            Row row = dataRows.next();
            Long id = row.getLong("fentryid");
            Long adjApprBillId = row.getLong("fadjapprbillid");
            Long adjFileId = row.getLong("fadjfileid");
            Long standardItemId = row.getLong("fstandarditemid");
            Long salaryStdVid = row.getLong("fsalarystdvid");
            Long currencyId = row.getLong("fcurrencyid");
            Long preCurrencyId = row.getLong("fprecurrencyid");
            Long stdCurrencyId = row.getLong("stdcurrencyid");
            BigDecimal amount = row.getBigDecimal("famount");
            List list = rowMap.computeIfAbsent(id, k1 -> Lists.newArrayListWithExpectedSize((int)4));
            list.add(adjApprBillId);
            list.add(adjFileId);
            list.add(standardItemId);
            list.add(salaryStdVid);
            list.add(currencyId);
            list.add(preCurrencyId);
            list.add(stdCurrencyId);
            list.add(amount);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        if (MapUtils.isEmpty((Map)rowMap)) {
            return;
        }
        this.getAdjApprBillData(rowMap);
        Map<String, SalaryCountAmountMatchResult> salaryCountAmountMatchResultMap = this.getSalaryCountAmountMatchResultMap(rowMap);
        ArrayList adjApprEntUpdateParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList adjApprEntNoUseRankUpdateParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList adjApprEntSuccessParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList adjApprEntFailedParams = Lists.newArrayListWithExpectedSize((int)5000);
        HashSet<Long> adjFileIdSet = new HashSet<Long>(16);
        HashSet<Long> salaryStdIdSet = new HashSet<Long>(16);
        HashSet<Long> stdItemIdSet = new HashSet<Long>(16);
        HashSet<Long> adjApprBillIdSet = new HashSet<Long>(16);
        HashMap<String, String> amountStdRangeMap = new HashMap<String, String>(16);
        HashMap<String, Long> noUseRankGradeIdMap = new HashMap<String, Long>(16);
        for (Map.Entry entry : rowMap.entrySet()) {
            Object[] updateItem;
            String amountStdRange;
            AmountStdRangeEntity amountStdRangeEntity;
            long detailId = (Long)entry.getKey();
            Long adjApprBillId = (Long)((List)entry.getValue()).get(0);
            Long adjFileId = (Long)((List)entry.getValue()).get(1);
            Long standardItemId = (Long)((List)entry.getValue()).get(2);
            Long salaryStdVid = (Long)((List)entry.getValue()).get(3);
            String unionKey = String.format("%s_%s_%s_%s", adjApprBillId, adjFileId, salaryStdVid, standardItemId);
            SalaryCountAmountMatchResult salaryCountAmountMatchResult = salaryCountAmountMatchResultMap.get(unionKey);
            Long afterGradeId = null;
            if (salaryCountAmountMatchResult == null) continue;
            Map positionInfoMap = salaryCountAmountMatchResult.getPositionInfo();
            List positionInfoOfNotUseRankList = salaryCountAmountMatchResult.getPositionInfoOfNotUseRank();
            if (salaryCountAmountMatchResult.isItemUseRank() && MapUtils.isNotEmpty((Map)positionInfoMap)) {
                ArrayList gradeIdList = new ArrayList(10);
                positionInfoMap.forEach((key, value) -> {
                    List positionInfo = (List)positionInfoMap.get(key);
                    positionInfo.forEach(item -> {
                        Long minRankId = (Long)item.getValue();
                        Long maxRankId = (Long)item.getKey();
                        if (minRankId == 0L || maxRankId == 0L) {
                            gradeIdList.add(key);
                        }
                    });
                });
                positionInfoMap.keySet().removeIf(item -> gradeIdList.contains(item));
            } else if (!CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRankList)) {
                HashSet<Long> gradeIdSet = new HashSet<Long>(16);
                for (Pair positionInfoOfNotUseRank : positionInfoOfNotUseRankList) {
                    Long minGradeId = (Long)positionInfoOfNotUseRank.getKey();
                    Long maxGradeId = (Long)positionInfoOfNotUseRank.getValue();
                    if (minGradeId != 0L && maxGradeId != 0L) continue;
                    gradeIdSet.add(minGradeId);
                    gradeIdSet.add(maxGradeId);
                }
                positionInfoOfNotUseRankList.removeIf(item -> gradeIdSet.contains(item.getKey()) || gradeIdSet.contains(item.getValue()));
                if (!CollectionUtils.isEmpty((Collection)positionInfoOfNotUseRankList)) {
                    ArrayList gradeIdList = new ArrayList(10);
                    positionInfoOfNotUseRankList.stream().forEach(item -> {
                        gradeIdList.add(item.getKey());
                        gradeIdList.add(item.getValue());
                    });
                    afterGradeId = gradeIdList.stream().distinct().findFirst().orElse(null);
                }
            }
            if (MapUtils.isNotEmpty((Map)positionInfoMap)) {
                amountStdRangeEntity = new AmountStdRangeEntity(positionInfoMap, new ArrayList());
                amountStdRange = JSON.toJSONString((Object)amountStdRangeEntity);
                updateItem = new Object[2];
                adjApprEntUpdateParams.add(updateItem);
                updateItem[0] = amountStdRange;
                updateItem[1] = detailId;
                String key2 = String.format("%s_%s_%s_%s", adjApprBillId, adjFileId, salaryStdVid, standardItemId);
                amountStdRangeMap.put(key2, amountStdRange);
                this.getAdjApprEntSuccessParams(adjApprEntSuccessParams, detailId);
                this.getSalAdjRecordQueryParams(adjFileIdSet, salaryStdIdSet, stdItemIdSet, adjApprBillIdSet, adjApprBillId, adjFileId, standardItemId, salaryStdVid);
                continue;
            }
            if (CollectionUtils.isNotEmpty((Collection)positionInfoOfNotUseRankList)) {
                amountStdRangeEntity = new AmountStdRangeEntity(new HashMap(), positionInfoOfNotUseRankList);
                amountStdRange = JSON.toJSONString((Object)amountStdRangeEntity);
                updateItem = new Object[3];
                adjApprEntNoUseRankUpdateParams.add(updateItem);
                updateItem[0] = amountStdRange;
                updateItem[1] = afterGradeId;
                updateItem[2] = detailId;
                String key2 = String.format("%s_%s_%s_%s", adjApprBillId, adjFileId, salaryStdVid, standardItemId);
                amountStdRangeMap.put(key2, amountStdRange);
                noUseRankGradeIdMap.put(key2, afterGradeId);
                this.getAdjApprEntSuccessParams(adjApprEntSuccessParams, detailId);
                this.getSalAdjRecordQueryParams(adjFileIdSet, salaryStdIdSet, stdItemIdSet, adjApprBillIdSet, adjApprBillId, adjFileId, standardItemId, salaryStdVid);
                continue;
            }
            Object[] item2 = new Object[5];
            item2[1] = detailId;
            item2[2] = adjApprEntType;
            item2[3] = "can not match amountstdrange";
            item2[4] = "0";
            adjApprEntFailedParams.add(item2);
        }
        ArrayList salAdjRecordUpdateParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList salAdjRecordNoUseRankUpdateParams = Lists.newArrayListWithExpectedSize((int)5000);
        QFilter stdItemQFilter = new QFilter("standarditem", "in", stdItemIdSet);
        QFilter adjApprBillQFilter = new QFilter("bussinessid", "in", adjApprBillIdSet);
        QFilter salaryStdQFilter = new QFilter("salarystd", "in", salaryStdIdSet);
        QFilter adjFileQFilter = new QFilter("salaryadjfile", "in", adjFileIdSet);
        SWCDataServiceHelper salaryRecordService = new SWCDataServiceHelper("hcdm_salaryadjrecord");
        DynamicObject[] salaryRecordArray = salaryRecordService.query("id, standarditem, bussinessid, amountstdrange, salarystd, salaryadjfile", new QFilter[]{stdItemQFilter, adjApprBillQFilter, salaryStdQFilter, adjFileQFilter});
        for (Map.Entry entry : rowMap.entrySet()) {
            Long adjApprAdjApprBillId = (Long)((List)entry.getValue()).get(0);
            Long adjApprAdjFileId = (Long)((List)entry.getValue()).get(1);
            Long adjApprStdItemId = (Long)((List)entry.getValue()).get(2);
            Long adjApprSalaryStdId = (Long)((List)entry.getValue()).get(3);
            for (DynamicObject salaryRecord : salaryRecordArray) {
                Object[] updateItem;
                Long salRecordId = salaryRecord.getLong("id");
                Long adjFileId = salaryRecord.getLong("salaryadjfile.id");
                Long adjApprBillId = salaryRecord.getLong("bussinessid");
                Long salaryStdId = salaryRecord.getLong("salarystd.id");
                Long stdItemId = salaryRecord.getLong("standarditem.id");
                if (!adjFileId.equals(adjApprAdjFileId) || !adjApprBillId.equals(adjApprAdjApprBillId) || !salaryStdId.equals(adjApprSalaryStdId) || !stdItemId.equals(adjApprStdItemId)) continue;
                String key3 = String.format("%s_%s_%s_%s", adjApprBillId, adjFileId, salaryStdId, stdItemId);
                String amountStdRange = (String)amountStdRangeMap.get(key3);
                Long gradeId = (Long)noUseRankGradeIdMap.get(key3);
                if (gradeId != null) {
                    updateItem = new Object[3];
                    salAdjRecordNoUseRankUpdateParams.add(updateItem);
                    updateItem[0] = amountStdRange;
                    updateItem[1] = gradeId;
                    updateItem[2] = salRecordId;
                    continue;
                }
                updateItem = new Object[2];
                salAdjRecordUpdateParams.add(updateItem);
                updateItem[0] = amountStdRange;
                updateItem[1] = salRecordId;
            }
        }
        long[] fids = DB.genLongIds((String)"T_HCDM_SALARELUPDATE", (int)(adjApprEntFailedParams.size() + adjApprEntSuccessParams.size()));
        boolean bl = false;
        while (var24_28 < adjApprEntFailedParams.size()) {
            Object[] items = (Object[])adjApprEntFailedParams.get((int)var24_28);
            items[0] = fids[var24_28];
            ++var24_28;
        }
        for (Object[] items : adjApprEntSuccessParams) {
            void var24_29;
            items[0] = fids[var24_29];
            ++var24_29;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty((Collection)adjApprEntUpdateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateAdjApprEntSql, (List)adjApprEntUpdateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)adjApprEntNoUseRankUpdateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateAdjApprEntNoUseRankSql, (List)adjApprEntNoUseRankUpdateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)salAdjRecordUpdateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateSalAdjRecordSql, (List)salAdjRecordUpdateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)salAdjRecordNoUseRankUpdateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateSalAdjRecordNoUseRankSql, (List)salAdjRecordNoUseRankUpdateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)adjApprEntSuccessParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)adjApprEntSuccessParams);
            }
            if (!CollectionUtils.isEmpty((Collection)adjApprEntFailedParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)adjApprEntFailedParams);
            }
        }
    }

    private void getSalAdjRecordQueryParams(Set<Long> adjFileIdSet, Set<Long> salaryStdIdSet, Set<Long> stdItemIdSet, Set<Long> adjApprBillIdSet, Long adjApprBillId, Long adjFileId, Long standardItemId, Long salaryStdVid) {
        adjFileIdSet.add(adjFileId);
        stdItemIdSet.add(standardItemId);
        salaryStdIdSet.add(salaryStdVid);
        adjApprBillIdSet.add(adjApprBillId);
    }

    private void getAdjApprEntSuccessParams(List<Object[]> adjApprEntSuccessParams, long detailId) {
        Object[] item = new Object[5];
        item[1] = detailId;
        item[2] = adjApprEntType;
        item[3] = "";
        item[4] = "1";
        adjApprEntSuccessParams.add(item);
    }

    private void getAdjApprBillData(Map<Long, List<Object>> rowMap) {
        HashSet<Long> adjApprBillIdSet = new HashSet<Long>(16);
        for (List<Object> list : rowMap.values()) {
            Long adjApprBillId = (Long)list.get(0);
            adjApprBillIdSet.add(adjApprBillId);
        }
        SWCDataServiceHelper adjApprBillService = new SWCDataServiceHelper("hcdm_adjapprbill");
        DynamicObject[] adjApprBillArray = adjApprBillService.query(adjApprBillIdSet.toArray());
        List adjApprBillIdList = Arrays.stream(adjApprBillArray).filter(item -> AdjAttributionType.DECATTRTYPE.getCode().equals(item.getString("salaryadjrsn.attributiontype"))).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        Iterator<Map.Entry<Long, List<Object>>> iterator = rowMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<Object>> entry = iterator.next();
            List<Object> entryValue = entry.getValue();
            Long adjApprBillId = (Long)entryValue.get(0);
            if (!adjApprBillIdList.contains(adjApprBillId)) continue;
            iterator.remove();
        }
    }
}

