/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;

public class DecAdjApprRankUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(DecAdjApprRankUpdateTask.class);
    private static int BATCH_SIZE = 500;
    private String SELECT_FIELD = "id, adjapprbill, entryentity, entryentity.salarystd, entryentity.standarditem, entryentity.presalarystd, entryentity.rank, entryentity.prerank";
    private SWCDataServiceHelper adjApprPersonService = new SWCDataServiceHelper("hcdm_adjapprperson");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Map<Long, Map<Long, Boolean>> itemUseRankMap;
        List<DynamicObject> adjApprPersonEntryList;
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        SWCDataServiceHelper adjApprPersonService = new SWCDataServiceHelper("hcdm_adjapprperson");
        DynamicObject[] adjApprPersonArray = adjApprPersonService.query(this.SELECT_FIELD, new QFilter[]{qFilter});
        if (adjApprPersonArray.length == 0) {
            return;
        }
        List<DynamicObject> adjApprPersonDecList = DecAdjApprGridHelper.getAdjApprPersonList(adjApprPersonArray, AdjAttributionType.DECATTRTYPE.getCode());
        List<DynamicObject> adjApprPersonAdjList = DecAdjApprGridHelper.getAdjApprPersonList(adjApprPersonArray, AdjAttributionType.ADJATTRTYPE.getCode());
        if (CollectionUtils.isNotEmpty(adjApprPersonDecList)) {
            adjApprPersonEntryList = this.getAdjApprPersonEntryList(adjApprPersonDecList);
            itemUseRankMap = this.getItemUseRankFlag(adjApprPersonEntryList);
            ListUtils.partition(adjApprPersonDecList, (int)BATCH_SIZE).forEach(list -> this.batchHandleData((List<DynamicObject>)list, itemUseRankMap, null));
        }
        if (CollectionUtils.isNotEmpty(adjApprPersonAdjList)) {
            adjApprPersonEntryList = this.getAdjApprPersonEntryList(adjApprPersonAdjList);
            itemUseRankMap = this.getItemUseRankFlag(adjApprPersonEntryList);
            Map<Long, Map<Long, Boolean>> itemPreUseRankMap = this.getItemUseRankFlag(adjApprPersonEntryList);
            ListUtils.partition(adjApprPersonAdjList, (int)BATCH_SIZE).forEach(list -> this.batchHandleData((List<DynamicObject>)list, itemUseRankMap, itemPreUseRankMap));
        }
        this.disableTask();
    }

    private void disableTask() {
        ScheduleManager serviceManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        serviceManager.disableJob(taskInfo.getJobId());
        serviceManager.disableSchedule(taskInfo.getScheduleId());
    }

    private Map<Long, Map<Long, Boolean>> getItemUseRankFlag(List<DynamicObject> list) {
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)list.size());
        for (DynamicObject adjApprDetailEnt : list) {
            long stdId = adjApprDetailEnt.getLong("salarystd.id");
            long itemId = adjApprDetailEnt.getLong("standarditem.id");
            if (stdId <= 0L || itemId <= 0L) continue;
            List itemIds = stdItemMap.computeIfAbsent(stdId, v1 -> Lists.newArrayList());
            itemIds.add(itemId);
        }
        return service.getSalaryItemUseRankFlag(stdItemMap);
    }

    private List<DynamicObject> getAdjApprPersonEntryList(List<DynamicObject> adjApprPersonList) {
        ArrayList<DynamicObject> adjApprPersonEntryList = new ArrayList<DynamicObject>();
        for (int index = 0; index < adjApprPersonList.size(); ++index) {
            DynamicObject adjApprPerson = adjApprPersonList.get(index);
            DynamicObjectCollection adjApprPersonEntry = adjApprPerson.getDynamicObjectCollection("entryentity");
            adjApprPersonEntryList.addAll((Collection<DynamicObject>)adjApprPersonEntry);
        }
        return adjApprPersonEntryList;
    }

    private void batchHandleData(List<DynamicObject> list, Map<Long, Map<Long, Boolean>> itemUseRankMap, Map<Long, Map<Long, Boolean>> itemPreUseRankMap) {
        try {
            for (DynamicObject adjApprPerson : list) {
                DynamicObjectCollection adjApprPersonEntryColl = adjApprPerson.getDynamicObjectCollection("entryentity");
                for (DynamicObject adjApprDetailEnt : adjApprPersonEntryColl) {
                    boolean isPreUseRank;
                    boolean isUseRank = this.checkItemUseRank(adjApprDetailEnt, itemUseRankMap);
                    if (!isUseRank) {
                        adjApprDetailEnt.set("rank", (Object)0);
                    }
                    if (!MapUtils.isNotEmpty(itemPreUseRankMap) || (isPreUseRank = this.checkItemUseRank(adjApprDetailEnt, itemPreUseRankMap))) continue;
                    adjApprDetailEnt.set("prerank", (Object)0);
                }
            }
            this.adjApprPersonService.update(list.toArray(new DynamicObject[0]));
        }
        catch (Exception ex) {
            logger.error("DecAdjApprRankUpdateTask error: ", (Throwable)ex);
        }
    }

    private boolean checkItemUseRank(DynamicObject adjApprDetailEnt, Map<Long, Map<Long, Boolean>> salaryItemUseRankFlag) {
        Map<Long, Boolean> flagMap;
        long stdId = adjApprDetailEnt.getLong("salarystd.id");
        long itemId = adjApprDetailEnt.getLong("standarditem.id");
        boolean userRank = false;
        if (stdId > 0L && itemId > 0L && (flagMap = salaryItemUseRankFlag.get(stdId)) != null && flagMap.get(itemId).booleanValue()) {
            userRank = true;
        }
        return userRank;
    }
}

