/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hcdm.business.salaryadjfile.AdjFileFormHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCMultithreadedQueryService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class DecAdjRankUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(DecAdjRankUpdateTask.class);
    private static int BATCH_SIZE = 500;
    private SWCDataServiceHelper recordService = new SWCDataServiceHelper("hcdm_salaryadjrecord");
    private String SELECT_FIELD = "id,salarystd.id,standarditem.id,rank.id";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        hisCurrFilter.and("boid", "!=", (Object)0);
        long startTime = System.currentTimeMillis();
        logger.info("\u5168\u91cf\u67e5\u8be2\u6240\u6709\u5b9a\u8c03\u85aa\u4fe1\u606fboid \u5f00\u59cb\uff0c{}", (Object)new Date(startTime));
        DynamicObject[] allRecordBoIdDys = new SWCDataServiceHelper("hcdm_salaryadjrecord").queryOriginalArray("id", new QFilter[]{hisCurrFilter});
        long endTime = System.currentTimeMillis();
        logger.info("\u5168\u91cf\u67e5\u8be2\u6240\u6709\u5b9a\u8c03\u85aa\u4fe1\u606fboid \u7ed3\u675f\uff0c\u8017\u65f6 {} \u79d2", (Object)((endTime - startTime) / 1000L));
        if (allRecordBoIdDys.length <= 0) {
            return;
        }
        Set<Long> boIdSet = Arrays.stream(allRecordBoIdDys).map(o1 -> o1.getLong("id")).collect(Collectors.toSet());
        logger.info("query total record boid is:{}", (Object)boIdSet.size());
        this.updateDecAdjData(boIdSet);
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        long endTime1 = System.currentTimeMillis();
        logger.info("DecAdjRankUpdateTask execute end...endTime = {}, costTime = {} second", (Object)new Date(startTime), (Object)((endTime1 - startTime) / 1000L));
    }

    private void updateDecAdjData(Set<Long> boIdSet) {
        SWCMultithreadedQueryService service = SWCMultithreadedQueryService.getInstance();
        ArrayList<Long> adjfileList = new ArrayList<Long>(boIdSet);
        ListUtils.partition(adjfileList, (int)BATCH_SIZE).forEach(list -> this.batchHandleData((List<Long>)list, service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchHandleData(List<Long> list, SWCMultithreadedQueryService service) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            QFilter boFilter = new QFilter("boid", "in", list);
            DynamicObject[] recordDyns = service.getData("hcdm_salaryadjrecord", this.SELECT_FIELD, new QFilter[]{boFilter}, "", BATCH_SIZE);
            if (recordDyns == null || recordDyns.length <= 0) {
                return;
            }
            logger.info("DecAdjRankUpdateTask recordDyns size:", (Object)recordDyns.length);
            Map<Long, Boolean> recordAndRanKMap = AdjFileFormHelper.itemUseRankFlag(new ArrayList<DynamicObject>(Arrays.asList(recordDyns)));
            ArrayList needUpdateList = Lists.newArrayListWithCapacity((int)recordDyns.length);
            for (DynamicObject recordDy : recordDyns) {
                Boolean status;
                Long pkId = recordDy.getLong("id");
                Long stdId = recordDy.getLong("salarystd.id");
                Long standarditemId = recordDy.getLong("standarditem.id");
                Long rankId = recordDy.getLong("rank.id");
                if (stdId == 0L || standarditemId == 0L || rankId == 0L || recordAndRanKMap.isEmpty() || null != (status = recordAndRanKMap.get(pkId)) && status.booleanValue()) continue;
                recordDy.set("rank", (Object)0);
                needUpdateList.add(recordDy);
            }
            this.recordService.update(needUpdateList.toArray(new DynamicObject[0]));
            tx.commit();
        }
    }
}

