/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hcdm.business.task.GradeRankUpdateBaseTask;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class DecRelPersonStdScmUpdateTask
extends GradeRankUpdateBaseTask {
    private static final Log logger = LogFactory.getLog(DecRelPersonStdScmUpdateTask.class);
    private static final String adjApprPerType = "t_hcdm_adjapprper";
    private static final String updateAdjApprPerStdScmSql = "update t_hcdm_adjapprper set fstdscmvid = ? where fid = ?";
    private static final String updateAdjRelPerStdScmSql = "update t_hcdm_decadjrelperson set fstdscmvid = ? where fid = ?";

    protected DecRelPersonStdScmUpdateTask() {
        super("select t1.fid, t1.fadjapprbillid, t1.fadjfileid from t_hcdm_adjapprper t1 left join t_hcdm_salarelupdate t2 on t1.fid = t2.fdataid and t2.ftype = 't_hcdm_adjapprper' where t2.fid is null and t1.fstdscmvid = '0'");
    }

    @Override
    protected void logException(Exception exception) {
        logger.error("doUpdateDecAdjApprEntryStdscmTask execute error:", (Throwable)exception);
    }

    @Override
    protected void logFinish() {
        logger.info("doUpdateDecAdjApprEntryStdscmTask finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetailUpdateAction(DataSet dataRows) {
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)5000);
        int count = 0;
        while (dataRows.hasNext()) {
            Row row = dataRows.next();
            Long id = row.getLong("fid");
            Long adjApprBillId = row.getLong("fadjapprbillid");
            Long adjFileId = row.getLong("fadjfileid");
            List list = rowMap.computeIfAbsent(id, k1 -> Lists.newArrayListWithExpectedSize((int)3));
            list.add(adjApprBillId);
            list.add(adjFileId);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        Map<Long, DynamicObject> adjFileIdToAdjObjMap = this.getAdjFileIdToAdjObjMap(rowMap);
        Set<Long> billIdSet = this.getBillIdSet(adjFileIdToAdjObjMap, rowMap);
        ArrayList adjApprUpdateParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList adjApprSuccessParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList adjApprFailedParams = Lists.newArrayListWithExpectedSize((int)5000);
        long adjApprStdScmVid = 0L;
        long adjApprDetailId = 0L;
        for (Map.Entry entry : rowMap.entrySet()) {
            adjApprDetailId = (Long)entry.getKey();
            Long adjFileId = (Long)((List)entry.getValue()).get(1);
            DynamicObject adjFileDyObj = adjFileIdToAdjObjMap.get(adjFileId);
            if (adjFileDyObj == null) continue;
            adjApprStdScmVid = adjFileDyObj.getLong("stdscm.sourcevid");
            if (adjApprStdScmVid != 0L) {
                Object[] updateItem = new Object[2];
                adjApprUpdateParams.add(updateItem);
                updateItem[0] = adjApprStdScmVid;
                updateItem[1] = adjApprDetailId;
                Object[] item = new Object[5];
                item[1] = adjApprDetailId;
                item[2] = adjApprPerType;
                item[3] = "";
                item[4] = "1";
                adjApprSuccessParams.add(item);
                continue;
            }
            Object[] item = new Object[5];
            item[1] = adjApprDetailId;
            item[2] = adjApprPerType;
            item[3] = "can not find stdscm";
            item[4] = "0";
            adjApprFailedParams.add(item);
        }
        DataSet decRelPersonDataSet = this.getDecRelPersonDataSet(billIdSet, adjFileIdToAdjObjMap.keySet());
        ArrayList relPerUpdateParams = Lists.newArrayListWithExpectedSize((int)5000);
        while (decRelPersonDataSet.hasNext()) {
            Row row = decRelPersonDataSet.next();
            long decRelPersonId = row.getLong("fid");
            long salaryAdjFileId = row.getLong("fsalaryadjfileid");
            DynamicObject adjFileObj = adjFileIdToAdjObjMap.get(salaryAdjFileId);
            if (adjFileObj == null) continue;
            long relPerStdScmVid = adjFileObj.getLong("stdscm.sourcevid");
            Object[] updateItem = new Object[2];
            relPerUpdateParams.add(updateItem);
            updateItem[0] = relPerStdScmVid;
            updateItem[1] = decRelPersonId;
        }
        this.generateIds(adjApprSuccessParams, adjApprFailedParams);
        try (TXHandle txHandle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty((Collection)adjApprUpdateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateAdjApprPerStdScmSql, (List)adjApprUpdateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)relPerUpdateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateAdjRelPerStdScmSql, (List)relPerUpdateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)adjApprSuccessParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)adjApprSuccessParams);
            }
            if (!CollectionUtils.isEmpty((Collection)adjApprFailedParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)adjApprFailedParams);
            }
        }
    }

    private void generateIds(List<Object[]> successParams, List<Object[]> failParams) {
        int i1;
        long[] fids = DB.genLongIds((String)"T_HCDM_SALARELUPDATE", (int)(failParams.size() + successParams.size()));
        for (i1 = 0; i1 < failParams.size(); ++i1) {
            Object[] items = failParams.get(i1);
            items[0] = fids[i1];
        }
        for (Object[] items : successParams) {
            items[0] = fids[i1];
            ++i1;
        }
    }

    private DataSet getDecRelPersonDataSet(Set<Long> adjApprBillIdSet, Set<Long> adjFileIdIdSet) {
        StringJoiner adjApprBillIdSj = new StringJoiner(",");
        for (Long l : adjApprBillIdSet) {
            adjApprBillIdSj.add(l.toString());
        }
        StringJoiner adjFileIdIdSj = new StringJoiner(",");
        for (Long adjFileIdId : adjFileIdIdSet) {
            adjFileIdIdSj.add(adjFileIdId.toString());
        }
        String string = "select t1.fid, t1.fstdscmvid, t2.fbussinessid, t2.fsalaryadjfileid from t_hcdm_decadjrelperson t1 left join t_hcdm_salaryadjrecord t2 on t1.fid = t2.frelpersonid where t2.fbussinessid in (" + adjApprBillIdSj + ") and t2.fsalaryadjfileid in (" + adjFileIdIdSj + ") ";
        DataSet decRelPersonDataSet = DB.queryDataSet((String)"getDecRelPersonDataSet", (DBRoute)ROUETE_HCDM, (String)string);
        return decRelPersonDataSet;
    }
}

