/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchParam;
import kd.sdk.swc.hcdm.common.stdtab.SalaryCountAmountMatchResult;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public abstract class GradeRankUpdateBaseTask {
    private static final Log logger = LogFactory.getLog(GradeRankUpdateBaseTask.class);
    protected static final DBRoute ROUETE_HCDM = new DBRoute("hcdm");
    private DataSet dataRows = null;
    protected int queryBatch = 0;
    protected static final int batchSize = 5000;
    protected static final String success = "1";
    protected static final String fail = "0";
    private final String selectSql;
    protected static final String insertSalRelUpdateSql = "insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)";

    protected GradeRankUpdateBaseTask(String selectSql) {
        this.selectSql = selectSql;
    }

    public void batchHandleData() {
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.doUpdateData();
            }
        }
        catch (Exception e) {
            this.logException(e);
        }
        this.logFinish();
        logger.info("doUpdateData total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    protected abstract void logException(Exception var1);

    protected abstract void logFinish();

    private boolean doUpdateData() {
        if (this.dataRows == null) {
            this.dataRows = DB.queryDataSet((String)"queryGradeRankDataSQl", (DBRoute)ROUETE_HCDM, (String)this.selectSql);
        }
        if (this.queryBatch >= 1000) {
            this.dataRows.close();
            this.dataRows = DB.queryDataSet((String)"queryBizDataSQl", (DBRoute)ROUETE_HCDM, (String)this.selectSql);
            this.queryBatch = 0;
            logger.info("after 1000 batch queries, reset dataset, preventing timeouts!");
        }
        if (!this.dataRows.hasNext()) {
            return false;
        }
        this.doDetailUpdateAction(this.dataRows);
        return true;
    }

    protected abstract void doDetailUpdateAction(DataSet var1);

    protected Map<Long, Map<Long, Boolean>> getUseRankMap(Map<Long, ArrayList<Object>> rowMap) {
        HashMap stdItemMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!CollectionUtils.isEmpty(rowMap)) {
            for (ArrayList<Object> list : rowMap.values()) {
                Long salaryStdId = (Long)list.get(1);
                List itemIds = stdItemMap.computeIfAbsent(salaryStdId, v1 -> Lists.newArrayList());
                itemIds.add((Long)list.get(0));
            }
        }
        SalaryStdApplicationService service = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
        return service.getSalaryItemUseRankFlag(stdItemMap);
    }

    protected Map<String, String> getMatchGradeRankRelMap(Map<Long, ArrayList<Object>> rowMap) {
        HashSet<Long> adjFileIdSet = new HashSet<Long>(16);
        HashSet<Long> salaryStdIdSet = new HashSet<Long>(16);
        HashSet<Long> stdItemIdSet = new HashSet<Long>(16);
        HashSet<Long> adjApprBillIdSet = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty(rowMap)) {
            for (ArrayList<Object> list : rowMap.values()) {
                String dataSource = (String)list.get(0);
                if (!"3".equals(dataSource)) continue;
                Long bussinessId = (Long)list.get(1);
                Long standardItemId = (Long)list.get(2);
                Long salaryAdjFileId = (Long)list.get(3);
                Long salaryStdId = (Long)list.get(4);
                adjFileIdSet.add(salaryAdjFileId);
                salaryStdIdSet.add(salaryStdId);
                stdItemIdSet.add(standardItemId);
                adjApprBillIdSet.add(bussinessId);
            }
        }
        SWCDataServiceHelper adjApprPersonService = new SWCDataServiceHelper("hcdm_adjapprperson");
        QFilter stdItemQFilter = new QFilter("entryentity.standarditem", "in", stdItemIdSet);
        QFilter adjApprBillQFilter = new QFilter("adjapprbill", "in", adjApprBillIdSet);
        QFilter salaryStdQFilter = new QFilter("entryentity.salarystd", "in", salaryStdIdSet);
        QFilter adjFileQFilter = new QFilter("adjfile", "in", adjFileIdSet);
        DynamicObject[] adjApprPersonArray = adjApprPersonService.query("id, standarditem, adjapprbill, salargrel, salarystd, adjfile", new QFilter[]{stdItemQFilter, adjApprBillQFilter, salaryStdQFilter, adjFileQFilter});
        HashMap<String, String> matchGradeRankRelMap = new HashMap<String, String>(16);
        for (DynamicObject adjApprPerson : adjApprPersonArray) {
            DynamicObjectCollection adjApprPersonEntryColl = adjApprPerson.getDynamicObjectCollection("entryentity");
            for (DynamicObject adjApprDetailEnt : adjApprPersonEntryColl) {
                long adjApprBillId = adjApprPerson.getLong("adjapprbill");
                long fileId = adjApprPerson.getLong("adjfile.id");
                long salaryStdId = adjApprDetailEnt.getLong("salarystd.id");
                long itemId = adjApprDetailEnt.getLong("standarditem.id");
                String salarGrel = adjApprDetailEnt.getString("salargrel");
                String unionKey = String.format("%s_%s_%s_%s", adjApprBillId, fileId, salaryStdId, itemId);
                if (StringUtils.isEmpty((Object)salarGrel)) continue;
                matchGradeRankRelMap.put(unionKey, salarGrel);
            }
        }
        return matchGradeRankRelMap;
    }

    protected Map<Long, DynamicObject> getAdjFileIdToAdjObjMap(Map<Long, List<Object>> rowMap) {
        HashSet<Long> adjFileIdSet = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty(rowMap)) {
            for (List<Object> list : rowMap.values()) {
                Long salaryAdjFileId = (Long)list.get(1);
                adjFileIdSet.add(salaryAdjFileId);
            }
            SWCDataServiceHelper adjFileInfoService = new SWCDataServiceHelper("hcdm_adjfileinfo");
            DynamicObject[] adjFileArray = adjFileInfoService.query("id, stdscm", new QFilter[]{new QFilter("id", "in", adjFileIdSet)});
            Map<Long, DynamicObject> adjFileMap = Arrays.stream(adjFileArray).collect(Collectors.toMap(o1 -> o1.getLong("id"), Function.identity()));
            return adjFileMap;
        }
        return new HashMap<Long, DynamicObject>();
    }

    protected Set<Long> getBillIdSet(Map<Long, DynamicObject> adjFileIdToStdScmMap, Map<Long, List<Object>> rowMap) {
        HashSet<Long> billIdSet = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty(rowMap)) {
            for (List<Object> list : rowMap.values()) {
                Long adjApprBillId = (Long)list.get(0);
                Long salaryAdjFileId = (Long)list.get(1);
                DynamicObject adjFileDyObj = adjFileIdToStdScmMap.get(salaryAdjFileId);
                if (adjFileDyObj == null) continue;
                billIdSet.add(adjApprBillId);
            }
        }
        return billIdSet;
    }

    protected Map<String, SalaryCountAmountMatchResult> getSalaryCountAmountMatchResultMap(Map<Long, List<Object>> rowMap) {
        HashSet<Long> adjApprBillIdSet = new HashSet<Long>(16);
        for (List<Object> list : rowMap.values()) {
            Long adjApprBillId = (Long)list.get(0);
            adjApprBillIdSet.add(adjApprBillId);
        }
        BillExRateManager rateManager = new BillExRateManager();
        SWCDataServiceHelper adjApprBillService = new SWCDataServiceHelper("hcdm_adjapprbill");
        DynamicObject[] adjApprBillArray = adjApprBillService.query(adjApprBillIdSet.toArray());
        Map adjApprBillMap = Arrays.stream(adjApprBillArray).collect(Collectors.toMap(o1 -> o1.getLong("id"), Function.identity()));
        ArrayList<SalaryCountAmountMatchParam> params = new ArrayList<SalaryCountAmountMatchParam>(10);
        SalaryCountAmountMatchParam salaryCountAmountMatchParam = null;
        for (List<Object> list : rowMap.values()) {
            ExchangeRateInfo exchangeRate;
            BigDecimal finalAmountOfStdCurrency;
            long adjApprBillId = (Long)list.get(0);
            long fileId = (Long)list.get(1);
            DynamicObject adjApprBill = (DynamicObject)adjApprBillMap.get(adjApprBillId);
            if (adjApprBill == null) continue;
            long exctableId = adjApprBill.getLong("exctable.id");
            Date rateDate = adjApprBill.getDate("exchangeratedate");
            salaryCountAmountMatchParam = new SalaryCountAmountMatchParam();
            long itemId = (Long)list.get(2);
            long stdTableId = (Long)list.get(3);
            long adjCurrencyId = (Long)list.get(4);
            long preCurrencyId = (Long)list.get(5);
            long stdCurrencyId = 0L;
            stdCurrencyId = preCurrencyId <= 0L ? (Long)list.get(6) : preCurrencyId;
            BigDecimal finalAmount = (BigDecimal)list.get(7);
            if (finalAmount == null || (finalAmountOfStdCurrency = DecAdjApprGridHelper.convertAmountByExrate(exchangeRate = DecAdjApprGridHelper.getExchangeRate(rateManager, stdCurrencyId, adjCurrencyId, exctableId, rateDate), finalAmount, adjCurrencyId, stdCurrencyId)) == null || stdTableId <= 0L || itemId <= 0L) continue;
            salaryCountAmountMatchParam.setStdTableId(Long.valueOf(stdTableId));
            salaryCountAmountMatchParam.setItemId(Long.valueOf(itemId));
            salaryCountAmountMatchParam.setAmount(finalAmountOfStdCurrency);
            salaryCountAmountMatchParam.setUnionId(String.format("%s_%s_%s_%s", adjApprBillId, fileId, stdTableId, itemId));
            params.add(salaryCountAmountMatchParam);
        }
        List<SalaryCountAmountMatchResult> salaryCountAmountMatchResults = ((SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class)).matchTableRangeBySalaryCountOrAmount(params);
        logger.info("dec adj appr rank update task, salary count amount match params={}, results={}", (Object)JSON.toJSONString(params), (Object)JSON.toJSONString(salaryCountAmountMatchResults));
        Map<String, SalaryCountAmountMatchResult> salaryCountAmountMatchResultMap = salaryCountAmountMatchResults.stream().collect(Collectors.toMap(SalaryCountAmountMatchResult::getUnionId, Function.identity(), (key1, key2) -> key1));
        return salaryCountAmountMatchResultMap;
    }
}

