/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardEntryData;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountAndSalaryCountQueryResult;
import kd.sdk.swc.hcdm.common.stdtab.StdAmountQueryParam;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.calculate.SalaryStdCalculateHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.SalaryStdDataHelper;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hcdm.business.task.StdTableDataUpgradeTask;
import kd.swc.hcdm.common.constants.SalaryStandardConstants;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class HCDMMiddleValueUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(HCDMMiddleValueUpdateTask.class);
    private SWCDataServiceHelper adjPersonServiceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
    private SWCDataServiceHelper adjRecordServiceHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
    private SWCDataServiceHelper salaryStdServiceHelper = new SWCDataServiceHelper("hcdm_salarystandard");
    private SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
    private DBRoute dbRoute = new DBRoute("hcdm");
    private int batchCount = 200;
    private int stdTableBatchCount = 10;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("begin task");
        new StdTableDataUpgradeTask().upgradeMainTableField();
        this.doUpdateStdTab();
        this.doUpdateAdjApprovalBill();
        this.doUpdateCandidateBill();
        this.doUpdateAdjRecord();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        logger.info("SalaryStdMiddleValueUpdateTask ended");
    }

    public void doUpdateStdTab() {
        String querySql = "select fid from T_HCDM_SALARYSTD where FTYPE = 'C' ";
        String updateSql = "update t_hcdm_salarystddata set fmin = ? where fid = ? and fsalarystditemid = ? and fsalarygradeid = ? and fsalaryrankid = ?";
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"UpdateStdTab_querytable", (DBRoute)this.dbRoute, (String)querySql, null);
        ArrayList tableIds = Lists.newArrayListWithExpectedSize((int)10);
        while (dataSet.hasNext()) {
            tableIds.add(dataSet.next().getLong("fid"));
        }
        if (tableIds.isEmpty()) {
            return;
        }
        List partitions = Lists.partition((List)Lists.newArrayList((Iterable)tableIds), (int)this.stdTableBatchCount);
        for (List partition : partitions) {
            DynamicObject[] stdObjArr;
            for (DynamicObject stdObj : stdObjArr = this.salaryStdServiceHelper.loadDynamicObjectArray(partition.toArray(new Object[0]))) {
                if (stdObj.getDynamicObjectCollection("salaryrank").isEmpty() || stdObj.getDynamicObjectCollection("salarygrade").isEmpty()) continue;
                SalaryStandardEntryData salaryStandardEntryData = EntityConverter.fetchEntityFromModel(stdObj);
                List stdDataEntities = salaryStandardEntryData.getStdDataEntities();
                List<SalaryStdDataEntity> oldMiddleRankData = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_MEDIANVALUE), salaryStandardEntryData.getStdDataEntities());
                stdDataEntities.removeAll(oldMiddleRankData);
                SalaryStdCalculateHelper.calculate((IFormView)new FormView(), salaryStandardEntryData, null);
                List<SalaryStdDataEntity> newData = SalaryStdDataHelper.getByRankIds(Collections.singleton(SalaryStandardConstants.S_RANK_MEDIANVALUE), salaryStandardEntryData.getStdDataEntities());
                Map<Long, Map<Long, List<SalaryStdDataEntity>>> oldEntityMap = SalaryStdDataHelper.groupByItemGrade(oldMiddleRankData);
                Map<Long, Map<Long, List<SalaryStdDataEntity>>> newEntityMap = SalaryStdDataHelper.groupByItemGrade(newData);
                List<Object[]> params = this.compareUpdate(oldEntityMap, newEntityMap, salaryStandardEntryData.getStdBaseEntity().getId());
                if (params.isEmpty()) continue;
                SWCDbUtil.executeBatch((DBRoute)this.dbRoute, (String)updateSql, params);
            }
        }
    }

    private List<Object[]> compareUpdate(Map<Long, Map<Long, List<SalaryStdDataEntity>>> oldEntityMap, Map<Long, Map<Long, List<SalaryStdDataEntity>>> newEntityMap, Long id) {
        ArrayList params = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<Long, Map<Long, List<SalaryStdDataEntity>>> itemEntry : oldEntityMap.entrySet()) {
            Long itemIdentity = itemEntry.getKey();
            Map<Long, List<SalaryStdDataEntity>> oldItemDatas = itemEntry.getValue();
            Map<Long, List<SalaryStdDataEntity>> newItemDatas = newEntityMap.get(itemIdentity);
            if (MapUtils.isEmpty(oldItemDatas) || MapUtils.isEmpty(newItemDatas)) continue;
            for (Map.Entry<Long, List<SalaryStdDataEntity>> gradeEntry : oldItemDatas.entrySet()) {
                Long gradeIdentity = gradeEntry.getKey();
                List<SalaryStdDataEntity> oldOneGradeDatas = gradeEntry.getValue();
                List<SalaryStdDataEntity> newOneGradeDatas = newItemDatas.get(gradeIdentity);
                if (CollectionUtils.isEmpty(oldOneGradeDatas) || CollectionUtils.isEmpty(newOneGradeDatas)) continue;
                BigDecimal oldMiddleValue = oldOneGradeDatas.get(0).getMin();
                BigDecimal newMiddleValue = newOneGradeDatas.get(0).getMin();
                if (oldMiddleValue == null || newMiddleValue == null || newMiddleValue.compareTo(BigDecimal.ZERO) == 0 || oldMiddleValue.compareTo(newMiddleValue) == 0) continue;
                params.add(new Object[]{newMiddleValue, id, itemIdentity, gradeIdentity, SalaryStandardConstants.S_RANK_MEDIANVALUE});
            }
        }
        return params;
    }

    public void doUpdateAdjApprovalBill() {
        String fileSql = "select distinct a.fadjfilevid from  t_hcdm_adjapprper a inner join t_hcdm_adjapprperent b on a.fid = b.fid and b.fstdmiddlevalue is null and b.fsalarypercent is not null";
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"UpdateAdjApprovalBill_filesql", (DBRoute)this.dbRoute, (String)fileSql, null);
        HashSet fileVidSet = Sets.newHashSetWithExpectedSize((int)16);
        while (dataSet.hasNext()) {
            fileVidSet.add(dataSet.next().getLong("fadjfilevid"));
        }
        List partitions = Lists.partition((List)Lists.newArrayList((Iterable)fileVidSet), (int)this.batchCount);
        for (List fileVids : partitions) {
            DynamicObject[] personResult = this.adjPersonServiceHelper.query("id,adjfilevid,entryentity.entryid,entryentity.salarystd,entryentity.standarditem,entryentity.grade,entryentity.rank,entryentity.coefficient,entryentity.stdmiddlevalue,entryentity.salarypercent,entryentity.amount", new QFilter[]{new QFilter("adjfilevid", "in", (Object)fileVids), QFilter.isNotNull((String)"entryentity.salarypercent"), QFilter.isNotNull((String)"entryentity.amount"), QFilter.isNull((String)"entryentity.stdmiddlevalue"), new QFilter("entryentity.standarditem.id", "!=", (Object)0), new QFilter("entryentity.salarystd.id", "!=", (Object)0), new QFilter("entryentity.grade.id", "!=", (Object)0)});
            if (personResult.length == 0) continue;
            ArrayList amountQueryParams = Lists.newArrayListWithExpectedSize((int)fileVids.size());
            HashSet coefficientIds = Sets.newHashSetWithExpectedSize((int)16);
            for (DynamicObject personObj : personResult) {
                DynamicObjectCollection itemRows = personObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject itemRow : itemRows) {
                    long entryId = itemRow.getLong("id");
                    long itemId = itemRow.getLong("standarditem.id");
                    long salarystdId = itemRow.getLong("salarystd.id");
                    long gradeId = itemRow.getLong("grade.id");
                    long rankId = itemRow.getLong("rank.id");
                    long coefficientId = itemRow.getLong("coefficient.id");
                    StdAmountQueryParam stdAmountQueryParam = new StdAmountQueryParam();
                    stdAmountQueryParam.setUnionId(entryId + "");
                    stdAmountQueryParam.setItemId(Long.valueOf(itemId));
                    stdAmountQueryParam.setStdTabId(Long.valueOf(salarystdId));
                    stdAmountQueryParam.setGradeId(Long.valueOf(gradeId));
                    stdAmountQueryParam.setRankId(Long.valueOf(rankId));
                    amountQueryParams.add(stdAmountQueryParam);
                    if (coefficientId <= 0L) continue;
                    coefficientIds.add(coefficientId);
                }
            }
            List<StdAmountAndSalaryCountQueryResult> amountQueryResult = this.salaryStdApplicationService.queryAmountAndSalaryCount(amountQueryParams);
            Map<Long, BigDecimal> coefficientValueMap = this.salaryStdApplicationService.queryCoefficientValueByIds(coefficientIds);
            Map amountQueryResultMap = amountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity()));
            int itemEntryUpdateCount = 0;
            int adjPersonUpdateCount = 0;
            ArrayList personObjOfNeedUpdate = Lists.newArrayListWithExpectedSize((int)personResult.length);
            for (DynamicObject personObj : personResult) {
                DynamicObjectCollection itemRows = personObj.getDynamicObjectCollection("entryentity");
                boolean personNeedUpdate = false;
                for (DynamicObject itemRow : itemRows) {
                    BigDecimal coefficientVal;
                    long entryId = itemRow.getLong("id");
                    BigDecimal stdMiddleValue = itemRow.getBigDecimal("stdmiddlevalue");
                    BigDecimal salaryPercent = itemRow.getBigDecimal("salarypercent");
                    BigDecimal amount = itemRow.getBigDecimal("amount");
                    long coefficientId = itemRow.getLong("coefficient.id");
                    StdAmountAndSalaryCountQueryResult queryResult = (StdAmountAndSalaryCountQueryResult)amountQueryResultMap.get(entryId + "");
                    if (salaryPercent == null || stdMiddleValue != null || queryResult == null || queryResult.getGradeMiddleAmount() == null) continue;
                    itemRow.set("stdmiddlevalue", (Object)queryResult.getGradeMiddleAmount());
                    BigDecimal bigDecimal = coefficientValueMap.get(coefficientId);
                    BigDecimal bigDecimal2 = coefficientVal = coefficientId > 0L && coefficientValueMap.get(coefficientId) != null ? bigDecimal : BigDecimal.ONE;
                    BigDecimal newSalaryPercent = SalaryStdCalculateHelper.calcSalaryRatioNew(amount, queryResult.getGradeMiddleAmount(), coefficientVal);
                    if (newSalaryPercent == null || newSalaryPercent.compareTo(salaryPercent) == 0) continue;
                    itemRow.set("salarypercent", (Object)newSalaryPercent);
                    ++itemEntryUpdateCount;
                    personNeedUpdate = true;
                }
                if (!personNeedUpdate) continue;
                ++adjPersonUpdateCount;
                personObjOfNeedUpdate.add(personObj);
            }
            if (personObjOfNeedUpdate.isEmpty()) continue;
            logger.info("update adjbill middlevalue and salarypercent ,itemEntryCount = {} ,adjPersonCount = {} ,originalPersonCount = {}", new Object[]{itemEntryUpdateCount, adjPersonUpdateCount, personResult.length});
            this.adjPersonServiceHelper.save(personObjOfNeedUpdate.toArray(new DynamicObject[0]));
        }
    }

    public void doUpdateCandidateBill() {
        String personQuerySql = "select distinct p.fentryid as personentryid from T_HCDM_CANDSETSALPERSON p inner join T_HCDM_PERSETSALREC pe on p.fentryid = pe.fentryid where pe.fsalarystdvid != 0 and pe.fstandarditemid != 0 and pe.fgradeid != 0 and pe.famount != 0";
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"UpdateCandidateBill_personQuery", (DBRoute)this.dbRoute, (String)personQuerySql, null);
        ArrayList personEntryIds = Lists.newArrayListWithExpectedSize((int)10);
        while (dataSet.hasNext()) {
            personEntryIds.add(dataSet.next().getLong("personentryid"));
        }
        logger.info("UpdateCandidateBill personEntryCount = {}", (Object)personEntryIds.size());
        if (personEntryIds.isEmpty()) {
            return;
        }
        List partitions = Lists.partition((List)personEntryIds, (int)this.batchCount);
        String updateSql = "update T_HCDM_PERSETSALREC set fsalarypercent = ? where fdetailid = ?";
        for (List partition : partitions) {
            BigDecimal amount;
            BigDecimal oldSalarypercent;
            String itemQuerySql = "select fdetailid,fentryid,fsalarystdvid,fcoefficientvid,fstandarditemid,fgradeid,frankid,famount,fsalarypercent from T_HCDM_PERSETSALREC  where fentryid in " + HCDMDbHelper.getFidHolder(partition.size()) + " and fsalarystdvid != 0 and fstandarditemid != 0 and fgradeid != 0 and famount != 0";
            DataSet itemDataSet = SWCDbUtil.queryDataSet((String)"UpdateCandidateBill_personQuery", (DBRoute)this.dbRoute, (String)itemQuerySql, (Object[])partition.toArray(new Object[0]));
            ArrayList amountQueryParams = Lists.newArrayListWithExpectedSize((int)(partition.size() * 2));
            HashSet coefficientIds = Sets.newHashSetWithExpectedSize((int)16);
            ArrayList itemRows = Lists.newArrayListWithExpectedSize((int)(partition.size() * 2));
            while (itemDataSet.hasNext()) {
                Row row = itemDataSet.next();
                Long detailid = row.getLong("fdetailid");
                Long salarystdvid = row.getLong("fsalarystdvid");
                Long coefficientvid = row.getLong("fcoefficientvid");
                Long standarditemid = row.getLong("fstandarditemid");
                Long gradeid = row.getLong("fgradeid");
                Long rankid = row.getLong("frankid");
                oldSalarypercent = row.getBigDecimal("fsalarypercent");
                amount = row.getBigDecimal("famount");
                HashMap dataRow = Maps.newHashMapWithExpectedSize((int)16);
                dataRow.put("fdetailid", detailid);
                dataRow.put("fsalarystdvid", salarystdvid);
                dataRow.put("fcoefficientvid", coefficientvid);
                dataRow.put("fstandarditemid", standarditemid);
                dataRow.put("fgradeid", gradeid);
                dataRow.put("frankid", rankid);
                dataRow.put("fsalarypercent", oldSalarypercent);
                dataRow.put("famount", amount);
                itemRows.add(dataRow);
                StdAmountQueryParam param = new StdAmountQueryParam();
                param.setStdTabId(salarystdvid);
                param.setItemId(standarditemid);
                param.setGradeId(gradeid);
                param.setRankId(rankid);
                param.setUnionId(detailid + "");
                amountQueryParams.add(param);
                if (coefficientvid <= 0L) continue;
                coefficientIds.add(coefficientvid);
            }
            List<StdAmountAndSalaryCountQueryResult> amountQueryResult = this.salaryStdApplicationService.queryAmountAndSalaryCount(amountQueryParams);
            Map<Long, BigDecimal> coefficientValueMap = this.salaryStdApplicationService.queryCoefficientValueByIds(coefficientIds);
            Map amountQueryResultMap = amountQueryResult.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity()));
            ArrayList sqlParam = Lists.newArrayListWithExpectedSize((int)itemRows.size());
            for (Map row : itemRows) {
                BigDecimal salaryRatioNew;
                BigDecimal coefficientVal;
                Long detailid = (Long)row.get("fdetailid");
                oldSalarypercent = (BigDecimal)row.get("fsalarypercent");
                amount = (BigDecimal)row.get("famount");
                Long coefficientvid = (Long)row.get("fcoefficientvid");
                StdAmountAndSalaryCountQueryResult res = (StdAmountAndSalaryCountQueryResult)amountQueryResultMap.get(detailid + "");
                BigDecimal bigDecimal = coefficientValueMap.get(coefficientvid);
                BigDecimal bigDecimal2 = coefficientVal = coefficientvid > 0L && coefficientValueMap.get(coefficientvid) != null ? bigDecimal : BigDecimal.ONE;
                if (res == null || res.getGradeMiddleAmount() == null || (salaryRatioNew = SalaryStdCalculateHelper.calcSalaryRatioNew(amount, res.getGradeMiddleAmount(), coefficientVal)) == null || salaryRatioNew.compareTo(oldSalarypercent) == 0) continue;
                sqlParam.add(new Object[]{salaryRatioNew, detailid});
            }
            if (sqlParam.isEmpty()) continue;
            logger.info("UpdateCandidateBill current batch update itemRowCount = {}", (Object)sqlParam.size());
            SWCDbUtil.executeBatch((DBRoute)this.dbRoute, (String)updateSql, (List)sqlParam);
        }
    }

    public void doUpdateAdjRecord() {
        DynamicObject[] fileRecord = this.adjRecordServiceHelper.query("salaryadjfile.id", new QFilter[]{new QFilter("datasource", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"})), new QFilter("datastatus", "not in", (Object)Lists.newArrayList((Object[])new String[]{"-2", "-1"}))});
        Set fileIdSet = Arrays.stream(fileRecord).map(object -> object.getLong("salaryadjfile.id")).collect(Collectors.toSet());
        List partitions = Lists.partition((List)Lists.newArrayList(fileIdSet), (int)this.batchCount);
        for (List fileIds : partitions) {
            DynamicObject[] result = this.adjRecordServiceHelper.query("id,salaryadjfile,standarditem,salarystd,grade,rank,amount,intervalmin,intervalmax,coefficient,salarypercent,datastatus,datasource,bussinessid", new QFilter[]{new QFilter("datasource", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"})), new QFilter("datastatus", "not in", (Object)Lists.newArrayList((Object[])new String[]{"-2", "-1"})), new QFilter("salaryadjfile.id", "in", (Object)fileIds), new QFilter("salarystd.id", "!=", (Object)0), new QFilter("grade.id", "!=", (Object)0)});
            ArrayList params = Lists.newArrayListWithExpectedSize((int)result.length);
            HashSet coefficientIds = Sets.newHashSetWithExpectedSize((int)16);
            for (int i = 0; i < result.length; ++i) {
                DynamicObject record = result[i];
                StdAmountQueryParam stdAmountQueryParam = new StdAmountQueryParam();
                stdAmountQueryParam.setUnionId(i + "");
                stdAmountQueryParam.setStdTabId(Long.valueOf(record.getLong("salarystd.id")));
                stdAmountQueryParam.setItemId(Long.valueOf(record.getLong("standarditem.id")));
                stdAmountQueryParam.setGradeId(Long.valueOf(record.getLong("grade.id")));
                stdAmountQueryParam.setRankId(Long.valueOf(record.getLong("rank.id")));
                long coefficientId = record.getLong("coefficient.id");
                params.add(stdAmountQueryParam);
                if (coefficientId <= 0L) continue;
                coefficientIds.add(coefficientId);
            }
            List<StdAmountAndSalaryCountQueryResult> queryResultList = this.salaryStdApplicationService.queryAmountAndSalaryCount(params);
            Map<Long, BigDecimal> coefficientValueMap = this.salaryStdApplicationService.queryCoefficientValueByIds(coefficientIds);
            Map amountResultMap = queryResultList.stream().collect(Collectors.toMap(StdAmountAndSalaryCountQueryResult::getUnionId, Function.identity()));
            ArrayList needSaveRecord = Lists.newArrayListWithExpectedSize((int)result.length);
            HashSet needUpdateFileIds = Sets.newHashSetWithExpectedSize((int)fileIds.size());
            for (int i = 0; i < result.length; ++i) {
                BigDecimal salaryRatioNew;
                BigDecimal coefficientVal;
                DynamicObject record = result[i];
                StdAmountAndSalaryCountQueryResult amountResult = (StdAmountAndSalaryCountQueryResult)amountResultMap.get(i + "");
                BigDecimal oldSalaryPercent = record.getBigDecimal("salarypercent");
                long adjFileId = record.getLong("salaryadjfile.id");
                long itemId = record.getLong("standarditem.id");
                BigDecimal amount = record.getBigDecimal("amount");
                BigDecimal intervalMin = record.getBigDecimal("intervalmin");
                BigDecimal intervalMax = record.getBigDecimal("intervalmax");
                long coefficientId = record.getLong("coefficient.id");
                BigDecimal bigDecimal = coefficientValueMap.get(coefficientId);
                BigDecimal bigDecimal2 = coefficientVal = coefficientId > 0L && coefficientValueMap.get(coefficientId) != null ? bigDecimal : BigDecimal.ONE;
                if (amount == null || oldSalaryPercent == null || amountResult == null || amountResult.getGradeMiddleAmount() == null || oldSalaryPercent.compareTo(salaryRatioNew = SalaryStdCalculateHelper.calcSalaryRatioNew(amount, amountResult.getGradeMiddleAmount(), coefficientVal)) == 0) continue;
                record.set("salarypercent", (Object)salaryRatioNew);
                logger.info("adjRecord will update , fileid = {} ,itemid = {} ,amount = {}, coefficientVal = {} ,intervalmin = {},intervalmax = {}, oldsalarypercent = {} ,newsalarypercent = {},middleAmount = {}", new Object[]{adjFileId, itemId, amount, coefficientVal, intervalMin, intervalMax, oldSalaryPercent, salaryRatioNew, amountResult.getGradeMiddleAmount()});
                needSaveRecord.add(record);
                needUpdateFileIds.add(adjFileId);
            }
            if (needSaveRecord.isEmpty()) continue;
            logger.info("current batch update adjRecord number {}/{}", (Object)needSaveRecord.size(), (Object)result.length);
            TXHandle th = TX.required();
            Throwable throwable = null;
            try {
                this.adjRecordServiceHelper.save(needSaveRecord.toArray(new DynamicObject[0]));
                this.doUpdateAdjApprovalBillPreRatio(needUpdateFileIds);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (th == null) continue;
                if (throwable != null) {
                    try {
                        th.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                th.close();
            }
        }
    }

    public void doUpdateAdjApprovalBillPreRatio(Collection<Long> adjFileIds) {
        DynamicObject[] result = this.adjPersonServiceHelper.query("id,adjfilevid.boid,entryentity.id,entryentity.standarditem,entryentity.presalary,entryentity.amount,entryentity.presalarypercent,entryentity.salbsed", new QFilter[]{new QFilter("adjfilevid.boid", "in", adjFileIds), QFilter.isNotNull((String)"entryentity.presalarypercent"), QFilter.isNotNull((String)"entryentity.amount"), QFilter.isNotNull((String)"entryentity.actualamount"), QFilter.isNotNull((String)"entryentity.calctype")});
        DynamicObject[] recordResult = this.adjRecordServiceHelper.query("id,salaryadjfile,standarditem,salarypercent,amount,bsed,bsled,datastatus,enable", new QFilter[]{new QFilter("salaryadjfile.id", "in", adjFileIds), new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "1", "0"})), BaseDataHisHelper.getHisVerFilter()}, "bsed desc");
        HashMap fileItemRecordsMap = Maps.newHashMapWithExpectedSize((int)adjFileIds.size());
        for (DynamicObject record : recordResult) {
            long fileId = record.getLong("salaryadjfile.id");
            long itemId = record.getLong("standarditem.id");
            if (fileId <= 0L || itemId <= 0L) continue;
            Map itemMap = fileItemRecordsMap.computeIfAbsent(fileId, v1 -> Maps.newHashMap());
            List itemRecords = itemMap.computeIfAbsent(itemId, v1 -> Lists.newArrayList());
            itemRecords.add(record);
        }
        ArrayList needUpdateList = Lists.newArrayListWithExpectedSize((int)result.length);
        int itemCountOfNeedUpdate = 0;
        HashSet needUpdateFileIds = Sets.newHashSetWithExpectedSize((int)adjFileIds.size());
        for (DynamicObject personObj : result) {
            Map itemRecordMap;
            long fileId = personObj.getLong("adjfilevid.boid");
            DynamicObjectCollection itemRows = personObj.getDynamicObjectCollection("entryentity");
            if (fileId == 0L || MapUtils.isEmpty((Map)(itemRecordMap = (Map)fileItemRecordsMap.get(fileId)))) continue;
            boolean needUpdateOfCurPerson = false;
            for (DynamicObject itemRow : itemRows) {
                long itemId = itemRow.getLong("standarditem.id");
                Date bsed = itemRow.getDate("salbsed");
                BigDecimal preSalary = itemRow.getBigDecimal("presalary");
                BigDecimal preSalaryPercent = itemRow.getBigDecimal("presalarypercent");
                List recordList = (List)itemRecordMap.get(itemId);
                DynamicObject matchedRecord = this.findLatestRecordLessThanBsed(bsed, preSalary, recordList);
                if (matchedRecord == null) continue;
                BigDecimal salaryPercentOfRec = matchedRecord.getBigDecimal("salarypercent");
                if (preSalaryPercent == null || salaryPercentOfRec == null || preSalaryPercent.compareTo(salaryPercentOfRec) == 0) continue;
                itemRow.set("presalarypercent", (Object)salaryPercentOfRec);
                needUpdateOfCurPerson = true;
                ++itemCountOfNeedUpdate;
                logger.info("update adjbill presalarypercent iteminfo: file = {} ,item = {} ,bsed = {} ,oldpresalarypercent = {} ,newpresalarypercent = {}", new Object[]{fileId, itemId, SWCDateTimeUtils.formatDate((Date)bsed), preSalaryPercent, salaryPercentOfRec});
            }
            if (!needUpdateOfCurPerson) continue;
            needUpdateFileIds.add(fileId);
            needUpdateList.add(personObj);
        }
        if (!needUpdateList.isEmpty()) {
            logger.info("update adjbill presalarypercent totalinfo: file count = {}, adjperson count = {},itemrow count = {}", (Object)needUpdateList.size(), (Object)itemCountOfNeedUpdate);
            this.adjPersonServiceHelper.save(needUpdateList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject findLatestRecordLessThanBsed(Date bsedOfBillEntry, BigDecimal preSalary, List<DynamicObject> recordList) {
        if (preSalary == null) {
            return null;
        }
        for (DynamicObject record : recordList) {
            Date bsedOfRec = record.getDate("bsed");
            BigDecimal amount = record.getBigDecimal("amount");
            if (!bsedOfRec.before(bsedOfBillEntry) || amount.compareTo(preSalary) != 0) continue;
            return record;
        }
        return null;
    }
}

