/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hcdm.business.helper.CommonHcdmBizHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;

public class HcdmBizDataUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(HcdmBizDataUpdateTask.class);
    SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hcdm_bizdata");
    private static int BATCH_SIZE = 500;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("HcdmBizDataUpdateTask start");
        QFilter filter = new QFilter("employee", "=", (Object)0).or("employee", "is null", null);
        Object[] data = this.serviceHelper.query(new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])data)) {
            return;
        }
        List ids = Arrays.stream(data).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        ListUtils.partition(ids, (int)BATCH_SIZE).forEach(list -> this.handleData((List<Long>)list));
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        service.disableJob(taskInfo.getJobId());
        logger.info("HcdmBizDataUpdateTask ended");
    }

    private void handleData(List<Long> ids) {
        HashSet<String> personNumber = new HashSet<String>(16);
        HashSet<Long> adminorgIds = new HashSet<Long>(16);
        HashSet<Long> employeeIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
        DynamicObject[] bizData = this.getBizData(ids);
        Arrays.stream(bizData).filter(obj -> ObjectUtils.isNotEmpty((Object)obj.get("person")) && ObjectUtils.isNotEmpty((Object)obj.get("adminorg"))).forEach(obj -> {
            personNumber.add(obj.getString("person.number"));
            adminorgIds.add(obj.getLong("adminorg.id"));
        });
        Object[] depempDyn = CommonHcdmBizHelper.queryEmployeeFromHrpi(personNumber, adminorgIds);
        if (ArrayUtils.isEmpty((Object[])depempDyn)) {
            logger.info(" depempDyn is empty ");
            return;
        }
        Map<String, List<DynamicObject>> depempMap = Arrays.stream(depempDyn).collect(Collectors.groupingBy(obj -> obj.getString("person.number") + "_" + obj.getLong("adminorg.id")));
        Arrays.stream(depempDyn).forEach(obj -> employeeIds.add(obj.getLong("employee.id")));
        Object[] employeeDyn = CommonHcdmBizHelper.queryEmployeeByIds(employeeIds);
        HashMap<Long, DynamicObject> idToEmployeeMap = new HashMap(16);
        if (ArrayUtils.isNotEmpty((Object[])employeeDyn)) {
            idToEmployeeMap = Arrays.stream(employeeDyn).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (dy1, dy2) -> dy1));
        }
        for (DynamicObject bizObj : bizData) {
            String key = bizObj.getString("person.number") + "_" + bizObj.getLong("adminorg.id");
            List<DynamicObject> depempList = depempMap.get(key);
            DynamicObject matchObj = CommonHcdmBizHelper.matchEmployee(bizObj.getDate("bizdatatime"), depempList, idToEmployeeMap);
            if (matchObj == null) continue;
            bizObj.set("employee", (Object)matchObj);
            saveList.add(bizObj);
        }
        this.serviceHelper.save(saveList.toArray(new DynamicObject[0]));
    }

    private DynamicObject[] getBizData(List<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return this.serviceHelper.query("id,person,person.id,person.number,adminorg,adminorg.id,bizdatatime,employee,employee.id", new QFilter[]{filter});
    }

    public void deleteData() {
        String str = " update t_hcdm_bizdata set femployeeid = 0 where fcreatetime < date('2023-12-12 00:00:00') ";
        try {
            DBRoute dbRoute = new DBRoute("hcdm");
            DB.execute((DBRoute)dbRoute, (String)str);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }
}

