/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.common.constants.AdjSalSynConstants;
import kd.swc.hcdm.common.entity.adjfile.AdjFileInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCMultithreadedQueryService;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;

public class HcdmMoveByKsqlTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(HcdmMoveByKsqlTask.class);
    public static final int DEFAULT_SIZE = 200;
    private static final Map<String, String[]> NEED_DECODE_ENP_SET_INFO = new HashMap<String, String[]>(6);
    private static final Set<String> ENTRY_TABLE_INFO = new LinkedHashSet<String>(3);
    private static final Set<String> VARCHAR_COLUMN_INFO = new LinkedHashSet<String>(1);
    private static final String queryAdjFileSQL = "SELECT T.FID ID, T.FPERSONID PERSONID FROM T_HCDM_ADJFILEINFO T WHERE T.FEMPLOYEEID = '0'";
    private static final String updateAdjFileEmployeeIdSQL = "UPDATE T_HCDM_ADJFILEINFO SET FEMPLOYEEID = ? WHERE FID = ?";
    private static final String queryAdjConPersonSQL = "SELECT T.FID ID, T.FPERSONID PERSONID FROM T_HCDM_ADJCONFIRMPERSON T WHERE T.FEMPLOYEEID = '0'";
    private static final String updateAdjConEmployeeIdSQL = "UPDATE T_HCDM_ADJCONFIRMPERSON SET FEMPLOYEEID = ? WHERE FID = ?";
    private static final String queryAdjFileDepempSQL = "SELECT T.FID ID, T.FPERSONID PERSONID,T.FDEPEMPID DEPEMPID FROM T_HCDM_ADJFILEINFO T WHERE T.FBIZNUMBER = ' '";
    private static final String updateAdjFileBiznumberSQL = "UPDATE T_HCDM_ADJFILEINFO SET FBIZNUMBER = ? WHERE FID = ?";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.decodeEnpInfo();
        this.updateEmployee(queryAdjFileSQL, updateAdjFileEmployeeIdSQL);
        this.updateEmployee(queryAdjConPersonSQL, updateAdjConEmployeeIdSQL);
        this.updateBiznumber();
        this.appliedRangeDataUpgrade();
        this.updateApplyRangeToContrastData();
        this.disableTask();
    }

    private void updateEmployee(String querySql, String updateSql) {
        List<Map<String, Object>> adjFileList = this.doGetNeedUpdateData(querySql);
        if (!CollectionUtils.isEmpty(adjFileList)) {
            List<Object[]> paramList = this.doBuildUpdateParam(adjFileList);
            this.doUpdateEmployeeInfo(paramList, updateSql);
        }
    }

    private void decodeEnpInfo() {
        try {
            for (Map.Entry<String, String[]> entry : NEED_DECODE_ENP_SET_INFO.entrySet()) {
                String tableKey = entry.getKey();
                String[] columnList = entry.getValue();
                StringBuilder columnCondition = new StringBuilder();
                for (String column : columnList) {
                    columnCondition.append(column).append(',');
                }
                String whereCondColumn = null;
                String finalColumnCond = columnCondition.substring(0, columnCondition.length() - 1);
                StringBuilder queryDataSQL = new StringBuilder();
                whereCondColumn = !ENTRY_TABLE_INFO.contains(tableKey) ? "FID" : "FENTRYID";
                queryDataSQL.append("SELECT ").append(whereCondColumn).append(',');
                queryDataSQL.append(finalColumnCond).append(" FROM ").append(tableKey);
                Map<String, List<Object[]>> updateParamMap = this.queryEnpData(queryDataSQL.toString(), whereCondColumn, columnList);
                if (updateParamMap == null || updateParamMap.size() == 0) continue;
                for (Map.Entry<String, List<Object[]>> updateParamEntry : updateParamMap.entrySet()) {
                    String updateColumn = updateParamEntry.getKey();
                    List<Object[]> updateParamList = updateParamEntry.getValue();
                    List partUpdateParamList = SWCListUtils.split(updateParamList, (int)200);
                    for (List subUpdateParamList : partUpdateParamList) {
                        StringBuilder updateDataSQL = new StringBuilder("UPDATE ");
                        updateDataSQL.append(tableKey).append(' ').append("SET ").append(updateColumn).append(" = ? ").append("WHERE ").append(whereCondColumn).append(" = ").append('?');
                        SWCDbUtil.executeBatch((DBRoute)AdjSalSynConstants.DB_ROUTE, (String)updateDataSQL.toString(), (List)subUpdateParamList);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private Map<String, List<Object[]>> queryEnpData(String queryDataSQL, String whereCondColumn, String[] columnList) {
        ArrayList<Object[]> updateParamList = null;
        HashMap<String, List<Object[]>> updateParamMap = new HashMap<String, List<Object[]>>();
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryDataSql", (DBRoute)AdjSalSynConstants.DB_ROUTE, (String)queryDataSQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long id = row.getLong(whereCondColumn);
                for (String column : columnList) {
                    boolean isEnpColumn;
                    updateParamList = new ArrayList<Object[]>(1);
                    String enpColumn = row.getString(column);
                    boolean bl = isEnpColumn = StringUtils.isNotEmpty((CharSequence)enpColumn) && enpColumn.startsWith("d@f*g:");
                    if (!isEnpColumn) continue;
                    String decodeColumn = Encrypters.decode((String)enpColumn);
                    Object decodeColumnBig = null;
                    decodeColumnBig = VARCHAR_COLUMN_INFO.contains(column) ? decodeColumn : (decodeColumn == null || StringUtils.isEmpty((CharSequence)decodeColumn) || StringUtils.isBlank((CharSequence)decodeColumn) ? BigDecimal.ZERO : new BigDecimal(decodeColumn));
                    String[] columnSplit = column.split("_");
                    updateParamList.add(new Object[]{decodeColumnBig, id});
                    if (updateParamMap.get(columnSplit[0]) == null) {
                        updateParamMap.put(columnSplit[0], updateParamList);
                        continue;
                    }
                    ((List)updateParamMap.get(columnSplit[0])).addAll(updateParamList);
                }
            }
        }
        return updateParamMap;
    }

    protected List<Map<String, Object>> doGetNeedUpdateData(String queryNeedUpdateDataSql) {
        ArrayList<Map<String, Object>> needUpdateDataList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Long> resultMap = new HashMap<String, Long>(16);
        Object objectBean = null;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryDataSql", (DBRoute)AdjSalSynConstants.DB_ROUTE, (String)queryNeedUpdateDataSql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long id = row.getLong("ID");
                Long personId = row.getLong("PERSONID");
                resultMap.put("id", id);
                resultMap.put("personId", personId);
                needUpdateDataList.add(resultMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("queryNeedUpdateDataSql error: {}", (Object)e.getMessage());
        }
        LOGGER.info("needUpdateDataList is: {}", (Object)JSON.toJSONString(needUpdateDataList));
        return needUpdateDataList;
    }

    protected List<Object[]> doBuildUpdateParam(List<Map<String, Object>> businessDataList) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (Map<String, Object> targetData : businessDataList) {
            Long employeeId;
            Object personId = targetData.get("personId");
            Object id = targetData.get("id");
            if (personId == null || id == null || (employeeId = this.getEmployeeInfo((Long)personId)) == null) continue;
            paramList.add(new Object[]{employeeId, id});
        }
        return paramList;
    }

    protected Long getEmployeeInfo(Long personId) {
        String queryEmployeeSQL = "SELECT T.FID ID FROM T_HRPI_EMPLOYEE T WHERE T.FISCURRENTVERSION = '1' AND T.FPERSONID = " + personId;
        Long employeeId = null;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryEmployeeSQL", (DBRoute)DBRoute.of((String)"hr"), (String)queryEmployeeSQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                employeeId = row.getLong("ID");
                if (null == employeeId || 0L == employeeId) continue;
                break;
            }
        }
        return employeeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpdateEmployeeInfo(List<Object[]> paramList, String updateSQL) {
        try (TXHandle txHandle = TX.required();){
            if (!SWCListUtils.isEmpty(paramList)) {
                SWCDbUtil.executeBatch((DBRoute)AdjSalSynConstants.DB_ROUTE, (String)updateSQL, paramList);
            }
        }
    }

    private void appliedRangeDataUpgrade() {
        try {
            DynamicObject[] datas = SWCMultithreadedQueryService.getInstance().getData("hcdm_salarystandard", "id, appliedrange.id, appliedrange.rangetype, appliedrange.rangeid", null, null, 20);
            LinkedHashMap<String, DynamicObject> rangeTypeFirstRowMap = new LinkedHashMap<String, DynamicObject>();
            for (DynamicObject data : datas) {
                DynamicObjectCollection appliedRangeList = data.getDynamicObjectCollection("appliedrange");
                for (DynamicObject row : appliedRangeList) {
                    rangeTypeFirstRowMap.putIfAbsent(row.getString("rangetype"), row);
                }
                Iterator iterator = appliedRangeList.iterator();
                while (iterator.hasNext()) {
                    DynamicObject row;
                    row = (DynamicObject)iterator.next();
                    DynamicObject firstRow = (DynamicObject)rangeTypeFirstRowMap.get(row.getString("rangetype"));
                    if (firstRow.getLong("id") == row.getLong("id")) continue;
                    String rangeId = firstRow.getString("rangeid");
                    firstRow.set("rangeid", (Object)(rangeId + "," + row.getString("rangeid")));
                    iterator.remove();
                }
                data.set("appliedrange", (Object)appliedRangeList);
                rangeTypeFirstRowMap.clear();
            }
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hcdm_salarystandard");
            helper.save(datas);
        }
        catch (Exception e) {
            LOGGER.error("appliedRangeDataUpgrade Error", (Object)e.getMessage());
        }
    }

    private void disableTask() {
        try (TXHandle handle = TX.requiresNew();){
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sch_schedule");
            DynamicObject schedule = helper.queryOne("id,status", new QFilter[]{new QFilter("number", "=", (Object)"hcdm_DataUpGrade230330Task_SKDP_S")});
            if (schedule != null) {
                schedule.set("status", (Object)"0");
                helper.updateOne(schedule);
            }
        }
    }

    private void updateBiznumber() {
        List<AdjFileInfo> needUpdateDataList = HcdmMoveByKsqlTask.getNeedUpdateAdjFileInfos();
        List<Object[]> paramList = this.buildUpdateParam(needUpdateDataList);
        this.doUpdateBiznumber(paramList, updateAdjFileBiznumberSQL);
    }

    private static List<AdjFileInfo> getNeedUpdateAdjFileInfos() {
        DataSet dataSet = HCDMDbHelper.queryDataSet(queryAdjFileDepempSQL, new Object[0]);
        ArrayList<AdjFileInfo> needUpdateDataList = new ArrayList<AdjFileInfo>(10);
        AdjFileInfo adjFileInfo = null;
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long id = row.getLong("ID");
            Long depempId = row.getLong("DEPEMPID");
            Long personId = row.getLong("PERSONID");
            adjFileInfo = new AdjFileInfo();
            adjFileInfo.setDepempId(depempId.longValue());
            adjFileInfo.setId(id.longValue());
            adjFileInfo.setPersonId(personId.longValue());
            needUpdateDataList.add(adjFileInfo);
        }
        return needUpdateDataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateBiznumber(List<Object[]> paramList, String updateSQL) {
        try (TXHandle txHandle = TX.required();){
            if (!SWCListUtils.isEmpty(paramList)) {
                SWCDbUtil.executeBatch((DBRoute)AdjSalSynConstants.DB_ROUTE, (String)updateSQL, paramList);
            }
        }
    }

    private List<Object[]> buildUpdateParam(List<AdjFileInfo> adjFileList) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
        for (AdjFileInfo adjFileInfo : adjFileList) {
            long personId = adjFileInfo.getPersonId();
            long depempId = adjFileInfo.getDepempId();
            long id = adjFileInfo.getId();
            String biznumber = this.queryHrpiEmpposorgrel(depempId, personId);
            if (null == biznumber) continue;
            paramList.add(new Object[]{biznumber, id});
        }
        return paramList;
    }

    private String queryHrpiEmpposorgrel(Long depempId, Long personId) {
        String queryEmployeeSQL = "SELECT T.FNUMBER NUMBER FROM T_HRPI_EMPPOSORGREL T WHERE T.FISCURRENTVERSION = '1' AND T.FPERSONID = " + personId + " AND T.FDEPEMPID = " + depempId;
        String biznumber = null;
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryBiznumberSQL", (DBRoute)DBRoute.of((String)"hr"), (String)queryEmployeeSQL, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                biznumber = row.getString("NUMBER");
                if (null == biznumber) continue;
                String string = biznumber;
                return string;
            }
        }
        return " ";
    }

    @Deprecated
    public void updateApplyRangeToContrastData() {
    }

    @Deprecated
    private void createContrastDataInsertParam(Long tabId, ArrayList<Long> propIdOfNotInContrast, List<ContrastDataEntity> rangeDataList, List<Integer> rowIndexList, List<Object[]> contrastValueSet) {
    }

    private void createContrastPsInsertParam(Long tabId, ArrayList<Long> propIdOfNotInContrast, List<Object[]> propValueSet) {
        long[] entryIdArr = DB.genLongIds((String)"t_hcdm_contrastps", (int)propIdOfNotInContrast.size());
        int startSeq = 1 - propIdOfNotInContrast.size();
        for (int i = 0; i < propIdOfNotInContrast.size(); ++i) {
            long entryId = entryIdArr[i];
            Long propConfId = propIdOfNotInContrast.get(i);
            int seq = startSeq++;
            propValueSet.add(new Object[]{entryId, tabId, seq, propConfId, seq, entryId});
        }
    }

    static {
        NEED_DECODE_ENP_SET_INFO.put("T_HCDM_ADJSALSYNDETAIL", new String[]{"FAMOUNT_ENP"});
        NEED_DECODE_ENP_SET_INFO.put("T_HCDM_ADJSALARYENTRY", new String[]{"FPRESALARYPERCENT_ENP", "FPRESALARYSEEPRATE_ENP", "FCALCTYPE_ENP", "FSUGGESTMINRANGE_ENP", "FSUGGESTMAXRANGE_ENP", "FSUGGESTMINAMOUNT_ENP", "FSUGGESTMAXAMOUNT_ENP", "FACTUALRANGE_ENP", "FACTUALAMOUNT_ENP", "FFINALAMOUNT_ENP", "FAFTERSALARYPERCENT_ENP", "FAFTERSALARYSEEPRATE_ENP"});
        NEED_DECODE_ENP_SET_INFO.put("T_HCDM_ADJAPPRENT", new String[]{"FCURRENTSALARY_ENP", "FSUGGESTMINAMOUNT_ENP", "FSUGGESTMAXAMOUNT_ENP", "FACTUALAMOUNT_ENP", "FFINALAMOUNT_ENP", "FSUGGESTMINRANGE_ENP", "FSUGGESTMAXRANGE_ENP", "FACTUALRANGE_ENP", "FPRESALARYPERCENT_ENP", "FPRESALARYSEEPRATE_ENP", "FAFTERSALARYPERCENT_ENP", "FAFTERSALARYSEEPRATE_ENP", "FCALCTYPE_ENP"});
        NEED_DECODE_ENP_SET_INFO.put("T_HCDM_DECIDESALARY", new String[]{"FTOTALAMOUNT_ENP"});
        NEED_DECODE_ENP_SET_INFO.put("T_HCDM_ADJCONFIRMACCOUNT", new String[]{"FPASSWORD_ENP"});
        NEED_DECODE_ENP_SET_INFO.put("T_HCDM_DECIDESALENT", new String[]{"FSTANDARDAMOUNT_ENP", "FCONFIRMEDAMOUNT_ENP", "FSALARYPERCENT_ENP", "FSALARYSEEPRATE_ENP"});
        ENTRY_TABLE_INFO.add("T_HCDM_ADJSALARYENTRY");
        ENTRY_TABLE_INFO.add("T_HCDM_ADJAPPRENT");
        ENTRY_TABLE_INFO.add("T_HCDM_DECIDESALENT");
        VARCHAR_COLUMN_INFO.add("FPASSWORD_ENP");
        VARCHAR_COLUMN_INFO.add("FCALCTYPE_ENP");
    }
}

