/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.swc.hcdm.business.HCDMDbHelper;
import kd.swc.hcdm.business.adjapprbill.BillExRateManager;
import kd.swc.hcdm.business.adjapprbill.DecAdjApprGridHelper;
import kd.swc.hcdm.business.adjapprbill.enums.OverStandardTypeEnum;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryParam;
import kd.swc.hcdm.business.stdapplication.interfaces.dto.StdOverStandardQueryResult;
import kd.swc.hcdm.business.stdapplication.service.SalaryStdApplicationService;
import kd.swc.hsbp.business.exchangerate.ExchangeRateInfo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class OverStandardTypeUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(OverStandardTypeUpdateTask.class);
    private SWCDataServiceHelper adjPersonServiceHelper = new SWCDataServiceHelper("hcdm_adjapprperson");
    private SWCDataServiceHelper adjRecordServiceHelper = new SWCDataServiceHelper("hcdm_salaryadjrecord");
    private SWCDataServiceHelper adjApprBillServiceHelper = new SWCDataServiceHelper("hcdm_adjapprbill");
    private SalaryStdApplicationService salaryStdApplicationService = (SalaryStdApplicationService)DomainFactory.getInstance(SalaryStdApplicationService.class);
    private DBRoute dbRoute = new DBRoute("hcdm");
    private int batchCount = 100;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("begin task");
        this.doUpdateAdjApprovalBill();
        this.doUpdateCandidateBill();
        this.doUpdateAdjRecord();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        logger.info("OverStandardTypeUpdateTask ended");
    }

    public void doUpdateAdjApprovalBill() {
        String fileSql = "select distinct a.fadjfilevid from  t_hcdm_adjapprper a";
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"UpdateAdjApprovalBill_filesql", (DBRoute)this.dbRoute, (String)fileSql, null);
        HashSet fileVidSet = Sets.newHashSetWithExpectedSize((int)16);
        while (dataSet.hasNext()) {
            fileVidSet.add(dataSet.next().getLong("fadjfilevid"));
        }
        List partitions = Lists.partition((List)Lists.newArrayList((Iterable)fileVidSet), (int)this.batchCount);
        BillExRateManager rateManager = new BillExRateManager();
        for (List fileVids : partitions) {
            DynamicObject[] personResult = this.adjPersonServiceHelper.query("id,adjapprbill,adjfilevid,entryentity.entryid,entryentity.salarystd,entryentity.standarditem,entryentity.salargrel,entryentity.amount,entryentity.coefficient,entryentity.overstandardtype,entryentity.currency", new QFilter[]{new QFilter("adjfilevid", "in", (Object)fileVids), QFilter.isNotNull((String)"entryentity.amount"), new QFilter("entryentity.standarditem.id", "!=", (Object)0), new QFilter("entryentity.salarystd.id", "!=", (Object)0)});
            if (personResult.length == 0) continue;
            Set billIdSet = Arrays.stream(personResult).map(o -> o.getLong("adjapprbill")).collect(Collectors.toSet());
            DynamicObject[] billResult = this.adjApprBillServiceHelper.query("id,exchangeratedate,exctable", new QFilter[]{new QFilter("id", "in", billIdSet)});
            Map billMap = Arrays.stream(billResult).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
            ArrayList overStandardQueryParams = Lists.newArrayListWithExpectedSize((int)fileVids.size());
            for (DynamicObject personObj : personResult) {
                long billId = personObj.getLong("adjapprbill");
                DynamicObject billObj = null;
                if (billId > 0L) {
                    billObj = (DynamicObject)billMap.get(billId);
                }
                DynamicObjectCollection itemRows = personObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject itemRow : itemRows) {
                    long entryId = itemRow.getLong("id");
                    long itemId = itemRow.getLong("standarditem.id");
                    long salarystdId = itemRow.getLong("salarystd.id");
                    long stdCurrencyId = itemRow.getLong("salarystd.currency.id");
                    long currencyId = itemRow.getLong("currency.id");
                    String salaryRel = itemRow.getString("salargrel");
                    BigDecimal amount = itemRow.getBigDecimal("amount");
                    long coefficientId = itemRow.getLong("coefficient.id");
                    StdOverStandardQueryParam overStandardQueryParam = new StdOverStandardQueryParam();
                    overStandardQueryParam.setUnionId(entryId + "");
                    overStandardQueryParam.setItemId(itemId);
                    overStandardQueryParam.setTabId(salarystdId);
                    try {
                        overStandardQueryParam.setPersonRange((Map)JSON.parseObject((String)salaryRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField}));
                    }
                    catch (Exception e) {
                        logger.error("JSON parse error ,source string = {}", (Object)salaryRel);
                    }
                    if (CollectionUtils.isEmpty(overStandardQueryParam.getPersonRange())) continue;
                    if (coefficientId > 0L) {
                        overStandardQueryParam.setCoefficientId(coefficientId);
                    }
                    if (currencyId != stdCurrencyId && billObj != null && amount != null) {
                        Date rateDate = billObj.getDate("exchangeratedate");
                        long exctableId = billObj.getLong("exctable.id");
                        ExchangeRateInfo exchangeRate = DecAdjApprGridHelper.getExchangeRate(rateManager, currencyId, stdCurrencyId, exctableId, rateDate);
                        amount = DecAdjApprGridHelper.convertAmountByExrate(exchangeRate, amount, currencyId, stdCurrencyId);
                    }
                    overStandardQueryParam.setAmount(amount);
                    if (amount == null) continue;
                    overStandardQueryParams.add(overStandardQueryParam);
                }
            }
            List<StdOverStandardQueryResult> overStandardTypeResult = this.salaryStdApplicationService.getOverStandardType(overStandardQueryParams);
            logger.info("adjbill entry update, overstandardquery paramList = {}", (Object)JSON.toJSONString((Object)overStandardQueryParams));
            logger.info("adjbill entry update,overstandardquery resultList = {}", (Object)JSON.toJSONString(overStandardTypeResult));
            Map overStandardTypeResultMap = overStandardTypeResult.stream().collect(Collectors.toMap(StdOverStandardQueryResult::getUnionId, Function.identity()));
            ArrayList personObjOfNeedUpdate = Lists.newArrayListWithExpectedSize((int)personResult.length);
            int itemEntryUpdateCount = 0;
            int adjPersonUpdateCount = 0;
            for (DynamicObject personObj : personResult) {
                DynamicObjectCollection itemRows = personObj.getDynamicObjectCollection("entryentity");
                boolean personNeedUpdate = false;
                for (DynamicObject itemRow : itemRows) {
                    long entryId = itemRow.getLong("id");
                    String overStandardType = itemRow.getString("overstandardtype");
                    StdOverStandardQueryResult queryResult = (StdOverStandardQueryResult)overStandardTypeResultMap.get(entryId + "");
                    if (queryResult != null && !StringUtils.equals((CharSequence)overStandardType, (CharSequence)queryResult.getOverStandardTypeEnum().getCode())) {
                        itemRow.set("overstandardtype", (Object)queryResult.getOverStandardTypeEnum().getCode());
                        ++itemEntryUpdateCount;
                        personNeedUpdate = true;
                    }
                    OverStandardTypeEnum oldOverStandardTypeEnum = OverStandardTypeEnum.getByCode(overStandardType);
                    logger.info("adjbill entry update,entryId = {}, oldoverStandardType={} , newoverStandardType={} ", new Object[]{entryId, oldOverStandardTypeEnum == null ? null : oldOverStandardTypeEnum.getNameParam().loadKDString(), queryResult == null ? null : queryResult.getOverStandardTypeEnum().getNameParam().loadKDString()});
                }
                if (!personNeedUpdate) continue;
                ++adjPersonUpdateCount;
                personObjOfNeedUpdate.add(personObj);
            }
            if (personObjOfNeedUpdate.isEmpty()) continue;
            logger.info("update adjbill overstandardtype  ,itemEntryCount = {} ,adjPersonCount = {} ,originalPersonCount = {}", new Object[]{itemEntryUpdateCount, adjPersonUpdateCount, personResult.length});
            this.adjPersonServiceHelper.save(personObjOfNeedUpdate.toArray(new DynamicObject[0]));
        }
    }

    public void doUpdateCandidateBill() {
        String personQuerySql = "select distinct p.fentryid as personentryid from T_HCDM_CANDSETSALPERSON p\n    inner join T_HCDM_PERSETSALREC pe on p.fentryid = pe.fentryid \nwhere pe.fsalarystdvid != 0 and pe.fstandarditemid != 0 and pe.famount > 0";
        DataSet dataSet = SWCDbUtil.queryDataSet((String)"UpdateCandidateBill_personQuery", (DBRoute)this.dbRoute, (String)personQuerySql, null);
        ArrayList personEntryIds = Lists.newArrayListWithExpectedSize((int)10);
        while (dataSet.hasNext()) {
            personEntryIds.add(dataSet.next().getLong("personentryid"));
        }
        logger.info("UpdateCandidateBill personEntryCount = {}", (Object)personEntryIds.size());
        if (personEntryIds.isEmpty()) {
            return;
        }
        List partitions = Lists.partition((List)personEntryIds, (int)this.batchCount);
        String updateSql = "update T_HCDM_PERSETSALREC set foverstandardtype = ? where fdetailid = ?";
        for (List partition : partitions) {
            String itemQuerySql = "select fdetailid,fentryid,fsalarystdvid,fcoefficientvid,fstandarditemid,famount,foverstandardtype,fsalarel from T_HCDM_PERSETSALREC  where fentryid in " + HCDMDbHelper.getFidHolder(partition.size()) + " and fsalarystdvid != 0 and fstandarditemid != 0 and famount > 0 ";
            DataSet itemDataSet = SWCDbUtil.queryDataSet((String)"UpdateCandidateBill_personQuery", (DBRoute)this.dbRoute, (String)itemQuerySql, (Object[])partition.toArray(new Object[0]));
            ArrayList overStandardQueryParams = Lists.newArrayListWithExpectedSize((int)(partition.size() * 2));
            ArrayList itemRows = Lists.newArrayListWithExpectedSize((int)(partition.size() * 2));
            while (itemDataSet.hasNext()) {
                Row row = itemDataSet.next();
                Long detailid = row.getLong("fdetailid");
                Long salarystdvid = row.getLong("fsalarystdvid");
                Long coefficientvid = row.getLong("fcoefficientvid");
                Long standarditemid = row.getLong("fstandarditemid");
                BigDecimal amount = row.getBigDecimal("famount");
                String overstandardtype = row.getString("foverstandardtype");
                String salarel = row.getString("fsalarel");
                HashMap dataRow = Maps.newHashMapWithExpectedSize((int)16);
                dataRow.put("fdetailid", detailid);
                dataRow.put("fsalarystdvid", salarystdvid);
                dataRow.put("fcoefficientvid", coefficientvid);
                dataRow.put("fstandarditemid", standarditemid);
                dataRow.put("foverstandardtype", overstandardtype);
                dataRow.put("fsalarel", salarel);
                dataRow.put("famount", amount);
                itemRows.add(dataRow);
                StdOverStandardQueryParam param = new StdOverStandardQueryParam();
                param.setTabId(salarystdvid);
                param.setItemId(standarditemid);
                param.setPersonRange((Map)JSON.parseObject((String)salarel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField}));
                param.setAmount(amount);
                param.setUnionId(detailid + "");
                if (coefficientvid > 0L) {
                    param.setCoefficientId(coefficientvid);
                }
                if (amount == null) continue;
                overStandardQueryParams.add(param);
            }
            List<StdOverStandardQueryResult> overStandardQueryResult = this.salaryStdApplicationService.getOverStandardType(overStandardQueryParams);
            logger.info("candibill entry update, overstandardquery paramList = {}", (Object)JSON.toJSONString((Object)overStandardQueryParams));
            logger.info("candibill entry update,overstandardquery resultList = {}", (Object)JSON.toJSONString(overStandardQueryResult));
            Map overStandardQueryResultMap = overStandardQueryResult.stream().collect(Collectors.toMap(StdOverStandardQueryResult::getUnionId, Function.identity()));
            ArrayList sqlParam = Lists.newArrayListWithExpectedSize((int)itemRows.size());
            for (Map row : itemRows) {
                Long detailid = (Long)row.get("fdetailid");
                String oldOverStandardType = (String)row.get("foverstandardtype");
                StdOverStandardQueryResult res = (StdOverStandardQueryResult)overStandardQueryResultMap.get(detailid + "");
                if (res != null && !StringUtils.equals((CharSequence)oldOverStandardType, (CharSequence)res.getOverStandardTypeEnum().getCode())) {
                    sqlParam.add(new Object[]{res.getOverStandardTypeEnum().getCode(), detailid});
                }
                OverStandardTypeEnum oldOverStandardTypeEnum = OverStandardTypeEnum.getByCode(oldOverStandardType);
                logger.info("candibill entry update,detailid = {}, oldoverStandardType={} , newoverStandardType={} ", new Object[]{detailid, oldOverStandardTypeEnum == null ? null : oldOverStandardTypeEnum.getNameParam().loadKDString(), res == null ? null : res.getOverStandardTypeEnum().getNameParam().loadKDString()});
            }
            if (sqlParam.isEmpty()) continue;
            logger.info("UpdateCandidateBill current batch update itemRowCount = {}", (Object)sqlParam.size());
            SWCDbUtil.executeBatch((DBRoute)this.dbRoute, (String)updateSql, (List)sqlParam);
        }
    }

    public void doUpdateAdjRecord() {
        DynamicObject[] fileRecord = this.adjRecordServiceHelper.query("salaryadjfile.id", new QFilter[]{new QFilter("datasource", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"})), new QFilter("datastatus", "not in", (Object)Lists.newArrayList((Object[])new String[]{"-2", "-1"})), new QFilter("amount", ">", (Object)0)});
        Set fileIdSet = Arrays.stream(fileRecord).map(object -> object.getLong("salaryadjfile.id")).collect(Collectors.toSet());
        List partitions = Lists.partition((List)Lists.newArrayList(fileIdSet), (int)this.batchCount);
        BillExRateManager rateManager = new BillExRateManager();
        for (List fileIds : partitions) {
            DynamicObject[] result = this.adjRecordServiceHelper.query("id,salaryadjfile,standarditem,salarystd,coefficient,currency,amount,salargrel,overstandardtype,datastatus,datasource,bussinessid", new QFilter[]{new QFilter("datasource", "in", (Object)Lists.newArrayList((Object[])new String[]{"2", "3"})), new QFilter("datastatus", "not in", (Object)Lists.newArrayList((Object[])new String[]{"-2", "-1"})), new QFilter("salaryadjfile.id", "in", (Object)fileIds), new QFilter("amount", ">", (Object)0)});
            if (result.length == 0) continue;
            ArrayList params = Lists.newArrayListWithExpectedSize((int)result.length);
            Map<Object, Object> billMap = Collections.emptyMap();
            Set billIdSet = Arrays.stream(result).filter(o -> StringUtils.equals((CharSequence)o.getString("datasource"), (CharSequence)"3")).map(o -> o.getLong("bussinessid")).collect(Collectors.toSet());
            if (!billIdSet.isEmpty()) {
                DynamicObject[] billResult = this.adjApprBillServiceHelper.query("id,exchangeratedate,exctable", new QFilter[]{new QFilter("id", "in", billIdSet)});
                billMap = Arrays.stream(billResult).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
            }
            for (int i = 0; i < result.length; ++i) {
                DynamicObject billObj;
                long coefficientId;
                DynamicObject record = result[i];
                StdOverStandardQueryParam param = new StdOverStandardQueryParam();
                param.setUnionId(i + "");
                param.setTabId(record.getLong("salarystd.id"));
                param.setItemId(record.getLong("standarditem.id"));
                param.setCoefficientId(record.getLong("coefficient.id"));
                String salaryRel = record.getString("salargrel");
                BigDecimal amount = record.getBigDecimal("amount");
                long currencyId = record.getLong("currency.id");
                long stdCurrencyId = record.getLong("salarystd.currency.id");
                String datasource = record.getString("datasource");
                long bussinessid = record.getLong("bussinessid");
                if (StringUtils.isNotBlank((CharSequence)salaryRel)) {
                    param.setPersonRange((Map)JSON.parseObject((String)salaryRel, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField}));
                }
                if ((coefficientId = record.getLong("coefficient.id")) > 0L) {
                    param.setCoefficientId(coefficientId);
                }
                if (currencyId > 0L && currencyId != stdCurrencyId && StringUtils.equals((CharSequence)datasource, (CharSequence)"3") && bussinessid > 0L && (billObj = (DynamicObject)billMap.get(bussinessid)) != null && amount != null) {
                    Date rateDate = billObj.getDate("exchangeratedate");
                    long exctableId = billObj.getLong("exctable.id");
                    ExchangeRateInfo exchangeRate = DecAdjApprGridHelper.getExchangeRate(rateManager, currencyId, stdCurrencyId, exctableId, rateDate);
                    amount = DecAdjApprGridHelper.convertAmountByExrate(exchangeRate, amount, currencyId, stdCurrencyId);
                }
                param.setAmount(amount);
                if (amount == null) continue;
                params.add(param);
            }
            List<StdOverStandardQueryResult> queryResultList = this.salaryStdApplicationService.getOverStandardType(params);
            Map overStandardResultMap = queryResultList.stream().collect(Collectors.toMap(StdOverStandardQueryResult::getUnionId, Function.identity()));
            ArrayList needSaveRecord = Lists.newArrayListWithExpectedSize((int)result.length);
            for (int i = 0; i < result.length; ++i) {
                DynamicObject record = result[i];
                StdOverStandardQueryResult overStandardQueryResult = (StdOverStandardQueryResult)overStandardResultMap.get(i + "");
                String oldOverStandard = record.getString("overstandardtype");
                if (overStandardQueryResult != null && !StringUtils.equals((CharSequence)overStandardQueryResult.getOverStandardTypeEnum().getCode(), (CharSequence)oldOverStandard)) {
                    record.set("overstandardtype", (Object)overStandardQueryResult.getOverStandardTypeEnum().getCode());
                    needSaveRecord.add(record);
                }
                OverStandardTypeEnum oldOverStandardTypeEnum = OverStandardTypeEnum.getByCode(oldOverStandard);
                logger.info("salaryadjrecord update,detailid = {}, oldoverStandardType={} , newoverStandardType={} ", new Object[]{record.getLong("id"), oldOverStandardTypeEnum == null ? null : oldOverStandardTypeEnum.getNameParam().loadKDString(), overStandardQueryResult == null ? null : overStandardQueryResult.getOverStandardTypeEnum().getNameParam().loadKDString()});
            }
            if (needSaveRecord.isEmpty()) continue;
            logger.info("current batch update adjRecord number {}/{}", (Object)needSaveRecord.size(), (Object)result.length);
            this.adjRecordServiceHelper.save(needSaveRecord.toArray(new DynamicObject[0]));
        }
    }
}

