/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hcdm.business.salaryadjfile.dao.SalaryAdjFileServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

public class RecordFieldUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(RecordFieldUpdateTask.class);
    private SWCDataServiceHelper recordService = new SWCDataServiceHelper("hcdm_salaryadjrecord");
    private SWCDataServiceHelper relPersonService = new SWCDataServiceHelper("hcdm_decadjrelperson");
    private static int BATCH_SIZE = 500;
    private static final String HAOS_ADMINORGHR = "haos_adminorghr";
    private static final String HBPM_POSITIONHR = "hbpm_positionhr";
    private static final String HBPM_STPOSITION = "hbpm_stposition";
    private static final String HAOS_PROJECTTEAMHR = "haos_projectteamhr";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("RecordFieldUpdateTask begin");
        this.recordFixedItemUpdate();
        this.relPersonBoFieldUpdate();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
        logger.info("RecordFieldUpdateTask ended");
    }

    private void relPersonBoFieldUpdate() {
        QFilter company = new QFilter("company.id", ">", (Object)0);
        company.and(new QFilter("companybo.id", "=", (Object)0).or("companybo.id", "is null", null));
        QFilter adminorg = new QFilter("adminorg.id", ">", (Object)0);
        adminorg.and(new QFilter("adminorgbo.id", "=", (Object)0).or("adminorgbo.id", "is null", null));
        QFilter assoadminorg = new QFilter("assoadminorg.id", ">", (Object)0);
        assoadminorg.and(new QFilter("assoadminorgbo.id", "=", (Object)0).or("assoadminorgbo.id", "is null", null));
        QFilter position = new QFilter("position.id", ">", (Object)0);
        position.and(new QFilter("positionbo.id", "=", (Object)0).or("positionbo.id", "is null", null));
        QFilter stdposition = new QFilter("stdposition.id", ">", (Object)0);
        stdposition.and(new QFilter("stdpositionbo.id", "=", (Object)0).or("stdpositionbo.id", "is null", null));
        QFilter projectteam = new QFilter("projectteam.id", ">", (Object)0);
        projectteam.and(new QFilter("projectteambo.id", "=", (Object)0).or("projectteambo.id", "is null", null));
        QFilter qFilter = company.or(adminorg).or(assoadminorg).or(position).or(stdposition).or(projectteam);
        Object[] data = this.relPersonService.query("id", new QFilter[]{qFilter});
        if (ArrayUtils.isEmpty((Object[])data)) {
            return;
        }
        List ids = Arrays.stream(data).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        ListUtils.partition(ids, (int)BATCH_SIZE).forEach(this::boUpdate);
    }

    private void boUpdate(List<Long> ids) {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            DynamicObject[] relPersonDys = this.relPersonService.loadDynamicObjectArray(ids.toArray());
            logger.info("RecordFieldUpdateTask boUpdate size:", (Object)relPersonDys.length);
            for (DynamicObject relPersonDyn : relPersonDys) {
                if (relPersonDyn.getLong("company.id") > 0L) {
                    relPersonDyn.set("companybo", relPersonDyn.get("company.boid"));
                }
                if (relPersonDyn.getLong("adminorg.id") > 0L) {
                    relPersonDyn.set("adminorgbo", relPersonDyn.get("adminorg.boid"));
                }
                if (relPersonDyn.getLong("assoadminorg.id") > 0L) {
                    relPersonDyn.set("assoadminorgbo", relPersonDyn.get("assoadminorg.boid"));
                }
                if (relPersonDyn.getLong("position.id") > 0L) {
                    relPersonDyn.set("positionbo", relPersonDyn.get("position.boid"));
                }
                if (relPersonDyn.getLong("stdposition.id") > 0L) {
                    relPersonDyn.set("stdpositionbo", relPersonDyn.get("stdposition.boid"));
                }
                if (relPersonDyn.getLong("projectteam.id") <= 0L) continue;
                relPersonDyn.set("projectteambo", relPersonDyn.get("projectteam.boid"));
            }
            this.relPersonService.update(relPersonDys);
        }
        catch (Exception ex) {
            logger.error("RecordFieldUpdateTask.boUpdate error: ", (Throwable)ex);
        }
    }

    private void recordFixedItemUpdate() {
        QFilter filter = new QFilter("fixeditem", "=", (Object)" ").or("fixeditem", "is null", null);
        filter.and(new QFilter("standarditem.id", ">", (Object)0));
        Object[] data = this.recordService.query("id", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])data)) {
            return;
        }
        logger.info(" RecordFieldUpdateTask data.size:", (Object)data.length);
        List ids = Arrays.stream(data).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        ListUtils.partition(ids, (int)BATCH_SIZE).forEach(this::fixedItemUpdate);
    }

    private void fixedItemUpdate(List<Long> ids) {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                return;
            }
            QFilter filter = new QFilter("id", "in", ids);
            DynamicObject[] dbData = this.recordService.query("id,fixeditem,standarditem.id", new QFilter[]{filter});
            Set<Long> standarditemIds = Arrays.stream(dbData).map(obj -> obj.getLong("standarditem.id")).collect(Collectors.toSet());
            Map<Long, DynamicObject> standardItemMap = SalaryAdjFileServiceHelper.getStandardItemMap("id,fixeditem", standarditemIds);
            if (MapUtils.isEmpty(standardItemMap)) {
                return;
            }
            ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(10);
            for (DynamicObject dbObj : dbData) {
                Long standarditemId = dbObj.getLong("standarditem.id");
                DynamicObject standarditemDy = standardItemMap.get(standarditemId);
                if (null == standarditemDy) continue;
                dbObj.set("fixeditem", (Object)standarditemDy.getString("fixeditem"));
                saveList.add(dbObj);
            }
            this.recordService.save(saveList.toArray(new DynamicObject[0]));
        }
        catch (Exception ex) {
            logger.error("RecordFieldUpdateTask.fixedItemUpdate error: ", (Throwable)ex);
        }
    }
}

