/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.swc.hcdm.business.extpoint.adjfile.AdjAttributionType;
import kd.swc.hcdm.common.enums.EventTypeEnum;
import org.apache.commons.collections4.ListUtils;

public class SalaryAdjRecordFieldUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SalaryAdjRecordFieldUpdateTask.class);
    private static final int BATCH_SIZE = 500;
    private final HRBaseServiceHelper recordService = new HRBaseServiceHelper("hcdm_salaryadjrecord");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("SalaryAdjRecordFieldUpdateTask begin");
        this.doUpdateCalcType();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        logger.debug("SalaryAdjRecordFieldUpdateTask finish");
    }

    private void doUpdateCalcType() {
        List<Map<String, Long>> recordIdInfoList = this.getNeedUpdateRecordIdInfoMap();
        if (!CollectionUtils.isEmpty(recordIdInfoList)) {
            logger.info("SalaryAdjRecordFieldUpdateTask recordIdInfoList size is:{}", (Object)recordIdInfoList.size());
            ListUtils.partition(recordIdInfoList, (int)500).forEach(list -> this.batchHandleData((List<Map<String, Long>>)list));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchHandleData(List<Map<String, Long>> recordIdInfoList) {
        if (CollectionUtils.isEmpty(recordIdInfoList)) {
            return;
        }
        Set decAdjBillIdSet = recordIdInfoList.stream().map(map -> (Long)map.get("bussinessid")).collect(Collectors.toSet());
        Set recordInfoIdSet = recordIdInfoList.stream().map(map -> (Long)map.get("id")).collect(Collectors.toSet());
        ArrayList personFilters = Lists.newArrayList();
        personFilters.add(new QFilter("adjapprbill", "in", decAdjBillIdSet));
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"hcdm_adjapprperson", (String)"adjapprbill,afteradjfilevid.id,adjfile.id,adjfilevid.id,entryentity.standarditem.id,entryentity.calctype", (QFilter[])personFilters.toArray(new QFilter[0]));
        Map<String, DynamicObject> adjApprBillPersonMap = queryResult.stream().collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("adjapprbill")) + String.valueOf(dy.getLong("adjfilevid.id") + String.valueOf(dy.getLong("entryentity.standarditem.id"))), dy -> dy, (k1, k2) -> k1));
        Map<String, DynamicObject> adjApprBillPersonMap2 = queryResult.stream().collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("adjapprbill")) + String.valueOf(dy.getLong("afteradjfilevid.id") + String.valueOf(dy.getLong("entryentity.standarditem.id"))), dy -> dy, (k1, k2) -> k1));
        Map<String, DynamicObject> adjApprBillPersonMap3 = queryResult.stream().collect(Collectors.toMap(dy -> String.valueOf(dy.getLong("adjapprbill")) + String.valueOf(dy.getLong("adjfile.id") + String.valueOf(dy.getLong("entryentity.standarditem.id"))), dy -> dy, (k1, k2) -> k1));
        HashSet getAdjApprBillPersonIsNull = Sets.newHashSet();
        try (TXHandle tx = TX.required();){
            QFilter idFilter = new QFilter("id", "in", recordInfoIdSet);
            logger.info("SalaryAdjRecordFieldUpdateTask recordInfoIdSet is [{}]:", recordInfoIdSet);
            DynamicObject[] recordDys = this.recordService.query("id,standarditem,bussinessid,salaryadjfile,salaryadjfilevid,calctype", new QFilter[]{idFilter});
            logger.info("SalaryAdjRecordFieldUpdateTask recordDys size: [{}]:", (Object)recordDys.length);
            this.dealRecordCaclType(adjApprBillPersonMap, adjApprBillPersonMap2, adjApprBillPersonMap3, getAdjApprBillPersonIsNull, recordDys);
            if (!CollectionUtils.isEmpty((Collection)getAdjApprBillPersonIsNull)) {
                logger.info("SalaryAdjRecordFieldUpdateTask getAdjApprBillPersonIsNull is [{}]:", (Object)getAdjApprBillPersonIsNull);
            }
            this.recordService.update(recordDys);
        }
    }

    private void dealRecordCaclType(Map<String, DynamicObject> adjApprBillPersonMap, Map<String, DynamicObject> adjApprBillPersonMap2, Map<String, DynamicObject> adjApprBillPersonMap3, Set<Long> getAdjApprBillPersonIsNull, DynamicObject[] recordDys) {
        for (DynamicObject recordDy : recordDys) {
            long businessId = recordDy.getLong("bussinessid");
            long standardItemId = recordDy.getLong("standarditem.id");
            long salaryAdjFileVid = recordDy.getLong("salaryadjfilevid.id");
            long salaryAdjFileId = recordDy.getLong("salaryadjfile.id");
            String key = String.valueOf(businessId) + String.valueOf(salaryAdjFileVid) + String.valueOf(standardItemId);
            DynamicObject personDy = adjApprBillPersonMap.get(key);
            if (personDy != null) {
                recordDy.set("calctype", (Object)personDy.getString("entryentity.calctype"));
                continue;
            }
            personDy = adjApprBillPersonMap2.get(key);
            if (personDy != null) {
                recordDy.set("calctype", (Object)personDy.getString("entryentity.calctype"));
                continue;
            }
            key = String.valueOf(businessId) + String.valueOf(salaryAdjFileId) + String.valueOf(standardItemId);
            personDy = adjApprBillPersonMap3.get(key);
            if (personDy != null) {
                recordDy.set("calctype", (Object)personDy.getString("entryentity.calctype"));
                continue;
            }
            getAdjApprBillPersonIsNull.add(recordDy.getLong("id"));
        }
    }

    private List<Map<String, Long>> getNeedUpdateRecordIdInfoMap() {
        ArrayList qFilters = Lists.newArrayList();
        qFilters.add(new QFilter("salaryadjrsn.attributiontype", "=", (Object)AdjAttributionType.ADJATTRTYPE.getCode()));
        qFilters.add(new QFilter("datasource", "=", (Object)EventTypeEnum.DECADJ.getCode()));
        ArrayList result = Lists.newArrayList();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)SalaryAdjRecordFieldUpdateTask.class.getName(), (String)"hcdm_salaryadjrecord", (String)"id,bussinessid", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row row : dataSet) {
                HashMap infoMap = Maps.newHashMap();
                infoMap.put("id", row.getLong("id"));
                infoMap.put("bussinessid", row.getLong("bussinessid"));
                result.add(infoMap);
            }
        }
        logger.info("SalaryAdjRecordFieldUpdateTask getNeedUpdateRecordIdInfoMap is [{}]:", (Object)result);
        return result;
    }
}

