/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hcdm.business.task.GradeRankUpdateBaseTask;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class SalaryAdjRecordGradeRankRelUpdateTask
extends GradeRankUpdateBaseTask {
    private static final Log logger = LogFactory.getLog(SalaryAdjRecordGradeRankRelUpdateTask.class);
    private static final String salAdjRecordType = "t_hcdm_salaryadjrecord";
    private static final String updateSalAdjRecordSql = "update t_hcdm_salaryadjrecord_a set fsalargrel = ? where fid = ?";

    protected SalaryAdjRecordGradeRankRelUpdateTask() {
        super("select t1.fid, t3.fsalargrel, t1.fdatasource, fsalaryadjfileid, fsalarystdvid, fbussinessid, fstandarditemid from t_hcdm_salaryadjrecord t1 left join t_hcdm_salaryadjrecord_a t3 on t1.fid = t3.fid left join t_hcdm_salarelupdate t2 on t1.fid = t2.fdataid and t2.ftype = 't_hcdm_salaryadjrecord' where t2.fid is null and t1.fdatasource in ('2', '3', '4')");
    }

    @Override
    protected void logException(Exception exception) {
        logger.error("doUpdateSalaryAdjRecordGradeRankRelTask execute error:", (Throwable)exception);
    }

    @Override
    protected void logFinish() {
        logger.info("doUpdateSalaryAdjRecordGradeRankRelTask finish");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetailUpdateAction(DataSet dataRows) {
        int i1;
        HashMap rowMap = Maps.newHashMapWithExpectedSize((int)5000);
        int count = 0;
        while (dataRows.hasNext()) {
            Row row = dataRows.next();
            Long id = row.getLong("fid");
            String dataSource = row.getString("fdatasource");
            Long standardItemId = row.getLong("fstandarditemid");
            Long salaryAdjFileId = row.getLong("fsalaryadjfileid");
            Long salaryStdVid = row.getLong("fsalarystdvid");
            Long bussinessId = row.getLong("fbussinessid");
            String fSalaRelStr = row.getString("fsalargrel");
            List list = rowMap.computeIfAbsent(id, k1 -> Lists.newArrayListWithExpectedSize((int)3));
            list.add(dataSource);
            list.add(bussinessId);
            list.add(standardItemId);
            list.add(salaryAdjFileId);
            list.add(salaryStdVid);
            list.add(fSalaRelStr);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        Map<String, String> matchGradeRankRelMap = this.getMatchGradeRankRelMap(rowMap);
        ArrayList updateParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList successParams = Lists.newArrayListWithExpectedSize((int)5000);
        ArrayList failParams = Lists.newArrayListWithExpectedSize((int)5000);
        String newFSalaRelStr = null;
        Long detailId = null;
        for (Map.Entry entry : rowMap.entrySet()) {
            Object[] item;
            detailId = (Long)entry.getKey();
            String dataSource = (String)((ArrayList)entry.getValue()).get(0);
            Long bussinessId = (Long)((ArrayList)entry.getValue()).get(1);
            Long standardItemId = (Long)((ArrayList)entry.getValue()).get(2);
            Long salaryAdjFileId = (Long)((ArrayList)entry.getValue()).get(3);
            Long salaryStdId = (Long)((ArrayList)entry.getValue()).get(4);
            String oldFSalaRelStr = (String)((ArrayList)entry.getValue()).get(5);
            try {
                Object parseObj = JSON.parse((String)oldFSalaRelStr);
                if (parseObj instanceof JSONArray) {
                    List matchRangeDataList = (List)JSON.parseObject((String)oldFSalaRelStr, (TypeReference)new TypeReference<List<GradeRankKey>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
                    Map<Long, List<Long>> matchRangeMap = GradeRankHelper.groupByRangeKeyToIdMap(matchRangeDataList);
                    newFSalaRelStr = JSON.toJSONString(matchRangeMap);
                } else {
                    newFSalaRelStr = oldFSalaRelStr;
                }
            }
            catch (Exception ex) {
                logger.error("parse salary adj record fsalarel error", (Throwable)ex);
                logger.error("parse salary adj record fsalarel fid is [{}]", (Object)detailId);
                item = new Object[5];
                item[1] = detailId;
                item[2] = salAdjRecordType;
                item[3] = ExceptionUtils.getExceptionStackTraceMessage((Exception)ex);
                item[4] = "0";
                failParams.add(item);
                continue;
            }
            if (dataSource.equals("3")) {
                String unionKey = String.format("%s_%s_%s_%s", bussinessId, salaryAdjFileId, salaryStdId, standardItemId);
                newFSalaRelStr = matchGradeRankRelMap.get(unionKey);
                try {
                    JSON.parseObject((String)newFSalaRelStr, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
                }
                catch (Exception e) {
                    logger.error("parse adj record rel from adj appr entry error", (Throwable)e);
                    Object[] item2 = new Object[5];
                    item2[1] = detailId;
                    item2[2] = salAdjRecordType;
                    item2[3] = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    item2[4] = "0";
                    failParams.add(item2);
                    continue;
                }
            }
            Object[] updateItem = new Object[2];
            updateParams.add(updateItem);
            updateItem[0] = newFSalaRelStr == null ? " " : newFSalaRelStr;
            updateItem[1] = detailId;
            item = new Object[5];
            item[1] = detailId;
            item[2] = salAdjRecordType;
            item[3] = "";
            item[4] = "1";
            successParams.add(item);
        }
        long[] fids = DB.genLongIds((String)"T_HCDM_SALARELUPDATE", (int)(failParams.size() + successParams.size()));
        for (i1 = 0; i1 < failParams.size(); ++i1) {
            Object[] items = (Object[])failParams.get(i1);
            items[0] = fids[i1];
        }
        for (Object[] items : successParams) {
            items[0] = fids[i1];
            ++i1;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if (!CollectionUtils.isEmpty((Collection)updateParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)updateSalAdjRecordSql, (List)updateParams);
            }
            if (!CollectionUtils.isEmpty((Collection)successParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)successParams);
            }
            if (!CollectionUtils.isEmpty((Collection)failParams)) {
                SWCDbUtil.executeBatch((DBRoute)ROUETE_HCDM, (String)"insert into t_hcdm_salarelupdate(fid,fdataid,ftype,ffailreason,fupdatestatus) values (?,?,?,?,?)", (List)failParams);
            }
        }
    }
}

