/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hcdm.business.salaryadjsync.AdjSalarySynHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.ListUtils;

public class SalaryAdjSynDetailErrorMsgUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(SalaryAdjSynDetailErrorMsgUpdateTask.class);
    private static int BATCH_SIZE = 500;
    private SWCDataServiceHelper synDetailService = new SWCDataServiceHelper("hcdm_adjsalsyndetail");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.debug("SalaryAdjSynDetailErrorMsgUpdateTask begin");
        this.doUpdateErrorMessage();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        logger.debug("SalaryAdjSynDetailErrorMsgUpdateTask ended");
    }

    private void doUpdateErrorMessage() {
        Set<Long> synDetailIds = this.getNeedUpdateSynDetailID();
        if (CollectionUtils.isNotEmpty(synDetailIds)) {
            logger.info("query total syndetail number is:{}", (Object)synDetailIds.size());
            ArrayList<Long> adjfileList = new ArrayList<Long>(synDetailIds);
            for (List list : ListUtils.partition(adjfileList, (int)BATCH_SIZE)) {
                this.batchHandleData(list);
            }
        }
    }

    private void batchHandleData(List<Long> synDetailList) {
        DynamicObject[] synDetails;
        if (CollectionUtils.isEmpty(synDetailList)) {
            return;
        }
        for (DynamicObject synDetail : synDetails = this.synDetailService.query("errormessage,errormsg", new QFilter[]{new QFilter("id", "in", synDetailList)})) {
            synDetail.set("errormessage", (Object)AdjSalarySynHelper.getErrorDescByCode(synDetail.getString("errormsg")));
        }
        this.synDetailService.update(synDetails);
    }

    private Set<Long> getNeedUpdateSynDetailID() {
        QFilter filter = new QFilter("errormsg", "!=", (Object)" ");
        filter.and(new QFilter("errormessage", "=", (Object)" "));
        DynamicObject[] query = this.synDetailService.query("id", new QFilter[]{filter});
        return Arrays.stream(query).map(o1 -> o1.getLong("id")).collect(Collectors.toSet());
    }
}

