/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.sdk.swc.hcdm.common.stdtab.ContrastDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropEntity;
import kd.sdk.swc.hcdm.common.stdtab.ContrastPropLabelEnum;
import kd.sdk.swc.hcdm.common.stdtab.ContrastRowDataEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankKey;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankRangeDBEntity;
import kd.sdk.swc.hcdm.common.stdtab.GradeRankValue;
import kd.sdk.swc.hcdm.common.stdtab.SalaryGradeEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryRankEntity;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStandardTypeEnum;
import kd.swc.hcdm.business.salarystandard.ContrastDataHelper;
import kd.swc.hcdm.business.salarystandard.EntityConverter;
import kd.swc.hcdm.business.salarystandard.GradeRankHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;
import org.apache.commons.collections.CollectionUtils;

public class StdTableContrastDataUpgradeTask
extends AbstractTask {
    private static final String salaryGrade = "salarygrade";
    private static final String salaryRank = "salaryrank";
    private static final String contrastps = "contrastps";
    private static final String salaryStdDataNew = "contrastsumdata";
    private static final Log logger = LogFactory.getLog(StdTableContrastDataUpgradeTask.class);
    private static final String gradeRankField = "salarygrade,salarygrade.gradeidentity,salarygrade.gradeindex,salarygrade.gradename,salarygrade.gradenumber,salaryrank,salaryrank.rankidentity,salaryrank.rankindex,salaryrank.rankname,salaryrank.ranknumber,salaryrank.ranklabel,salaryrank.rankisuserset,salaryrank.rankissyspreset";
    private static final String contrastpsField = "contrastps,contrastps.pscontrastpropconf,contrastps.pspropindex";
    private static final String baseField = "id,type,salarygrade,salarygrade.gradeidentity,salarygrade.gradeindex,salarygrade.gradename,salarygrade.gradenumber,salaryrank,salaryrank.rankidentity,salaryrank.rankindex,salaryrank.rankname,salaryrank.ranknumber,salaryrank.ranklabel,salaryrank.rankisuserset,salaryrank.rankissyspreset,contrastps,contrastps.pscontrastpropconf,contrastps.pspropindex";
    private static final String stdDataTableField = "id,type,salarygrade,salarygrade.gradeidentity,salarygrade.gradeindex,salarygrade.gradename,salarygrade.gradenumber,salaryrank,salaryrank.rankidentity,salaryrank.rankindex,salaryrank.rankname,salaryrank.ranknumber,salaryrank.ranklabel,salaryrank.rankisuserset,salaryrank.rankissyspreset,contrastps,contrastps.pscontrastpropconf,contrastps.pspropindex,contrastsumdata,contrastsumdata.sumrowindex,contrastsumdata.standardpropvalue,contrastsumdata.graderankrange,contrastsumdata.seq,contrastsumdata.entryboid61";
    private static final String DELETE_DATA_STEP3 = "DELETE FROM T_HCDM_CONTRASTDATA T1 WHERE T1.FID = ? AND T1.FENTRYID IN (SELECT T2.FENTRYID FROM T_HCDM_CONTRASTDATABAK T2 WHERE T2.FID = ?)";
    private String queryEntrySql = "SELECT FID,FCONTRASTIDENTITY,FCONTRASTPARENTIDENTITY,FCONTRASTPROPCONFID,FCONTRASTPROPVALUE,FROWINDEX,FSUBINDEX,FCONTRASTPROPLABEL FROM T_HCDM_CONTRASTDATA WHERE FID = ?";
    private String queryMainSql = "SELECT A.FID FROM T_HCDM_SALARYSTD A WHERE NOT EXISTS (SELECT FID FROM T_HCDM_CONTRASTSUMDATA B WHERE A.FID = B.FID) AND EXISTS (SELECT FID FROM T_HCDM_CONTRASTDATA C WHERE A.FID = C.FID)";

    public void setQueryEntrySql(String queryEntrySql) {
        this.queryEntrySql = queryEntrySql;
    }

    public void setQueryMainSql(String queryMainSql) {
        this.queryMainSql = queryMainSql;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.upgradeStdDatas();
    }

    public void upgradeStdDatas() {
        String querySql = this.queryMainSql;
        HashSet<Long> needUpdateStdIds = new HashSet<Long>(100);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryHCDMStdTableId2", (DBRoute)new DBRoute("hcdm"), (String)querySql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                needUpdateStdIds.add(row.getLong("FID"));
            }
        }
        for (Long needUpdateStdId : needUpdateStdIds) {
            try {
                this.upgradeDataWithBak(needUpdateStdId);
            }
            catch (Exception exc) {
                logger.error("stdTable step3 upgrade error, stdId = {}", (Object)needUpdateStdId);
            }
        }
    }

    public void upgradeDataWithBak(Long needUpdateStdId) {
        this.backUpTableNameData("INSERT INTO T_HCDM_CONTRASTDATABAK (FENTRYID,FID,FSEQ,FCONTRASTIDENTITY,FCONTRASTPARENTIDENTITY,FCONTRASTPROPCONFID,FCONTRASTPROPVALUE,FROWINDEX,FSUBINDEX,FCONTRASTPROPLABEL,FENTRYBOID) SELECT FENTRYID,FID,FSEQ,FCONTRASTIDENTITY,FCONTRASTPARENTIDENTITY,FCONTRASTPROPCONFID,FCONTRASTPROPVALUE,FROWINDEX,FSUBINDEX,FCONTRASTPROPLABEL,FENTRYBOID FROM T_HCDM_CONTRASTDATA WHERE FID = ? AND FENTRYID NOT IN (SELECT FENTRYID FROM T_HCDM_CONTRASTDATABAK WHERE FID = ? )", needUpdateStdId);
        this.upgradeStdData(needUpdateStdId);
        this.toDeleteData(needUpdateStdId);
    }

    public void upgradeStdData(Long stdId) {
        SWCDataServiceHelper stdHelper = new SWCDataServiceHelper("hcdm_salarystandard");
        DynamicObject stdDy = stdHelper.queryOne(stdDataTableField, (Object)stdId);
        if (stdDy == null) {
            return;
        }
        String querySql = this.queryEntrySql;
        ArrayList<ContrastDataEntity> stdDataEntities = new ArrayList<ContrastDataEntity>(100);
        ArrayList<ContrastDataEntity> gradeRankDataEntities = new ArrayList<ContrastDataEntity>(100);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryHCDMStdTableContrastEntryData", (DBRoute)new DBRoute("hcdm"), (String)querySql, (Object[])new Object[]{stdId});){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                ContrastDataEntity entity = new ContrastDataEntity();
                entity.setContrastIdentity(row.getLong("FCONTRASTIDENTITY"));
                entity.setContrastParentIdentity(row.getLong("FCONTRASTPARENTIDENTITY"));
                entity.setContrastPropConfId(row.getLong("FCONTRASTPROPCONFID"));
                entity.setContrastPropValue(row.getLong("FCONTRASTPROPVALUE"));
                entity.setRowIndex(row.getInteger("FROWINDEX").intValue());
                entity.setSubIndex(row.getInteger("FSUBINDEX").intValue());
                String label = row.getString("FCONTRASTPROPLABEL");
                ContrastPropLabelEnum num = ContrastPropLabelEnum.STANDARD;
                if ("GRADE".equals(label)) {
                    num = ContrastPropLabelEnum.GRADE;
                    gradeRankDataEntities.add(entity);
                } else if ("RANK".equals(label)) {
                    num = ContrastPropLabelEnum.RANK;
                    gradeRankDataEntities.add(entity);
                } else {
                    stdDataEntities.add(entity);
                }
                entity.setContrastPropLabelEnum(num);
            }
        }
        if (stdDataEntities.isEmpty()) {
            return;
        }
        List<ContrastPropEntity> props = EntityConverter.dynamicObjToContrastPropEntity(stdDy.getDynamicObjectCollection(contrastps));
        List<SalaryGradeEntity> gradeEntities = EntityConverter.dynamicObjToSalaryGradeEntity(stdDy.getDynamicObjectCollection(salaryGrade), (Long)stdDy.getLong("id"));
        List<SalaryRankEntity> rankEntities = EntityConverter.dynamicObjToSalaryRankEntity(stdDy.getDynamicObjectCollection(salaryRank), stdDy.getLong("id"), SalaryStandardTypeEnum.getFromCode((String)stdDy.getString("type")));
        List<SalaryRankEntity> standardRanks = GradeRankHelper.fetchStandardRank(rankEntities);
        Map<Long, SalaryGradeEntity> gradeEntityMap = GradeRankHelper.groupByGradeIdentity(gradeEntities);
        Map<Long, SalaryRankEntity> rankEntityMap = GradeRankHelper.groupByRankIdentity(rankEntities);
        List<ContrastDataEntity> stdDataEntities2 = ContrastDataHelper.sortByIndex(stdDataEntities);
        List<ContrastDataEntity> gradeRankDataEntities2 = ContrastDataHelper.sortByIndex(gradeRankDataEntities);
        Map<Integer, List<ContrastDataEntity>> rowStdDataMap = ContrastDataHelper.groupByRowIndexWithLinkedMap(stdDataEntities2);
        Map<Integer, List<ContrastDataEntity>> rowGradeAndRankMap = ContrastDataHelper.groupByRowIndexWithLinkedMap(gradeRankDataEntities2);
        ArrayList<ContrastRowDataEntity> rowDataEntities = new ArrayList<ContrastRowDataEntity>(100);
        for (Map.Entry<Integer, List<ContrastDataEntity>> rowStdDataEntry : rowStdDataMap.entrySet()) {
            Integer rowIndex = rowStdDataEntry.getKey();
            List<ContrastDataEntity> rowStdDatas = rowStdDataEntry.getValue();
            List<ContrastDataEntity> rowGradeAndRanks = rowGradeAndRankMap.get(rowIndex);
            List<ContrastDataEntity> contrastDataEntities = this.buildStructureForGradeRank(rowGradeAndRanks);
            List<GradeRankKey> gradeRankKey = this.getGradeRankKey(contrastDataEntities, gradeEntityMap, rankEntityMap);
            GradeRankRangeDBEntity gradeRankRangeDBEntity = this.getGradeRankRangeDBEntity(gradeRankKey, gradeEntities, standardRanks, stdId);
            Map<Long, List<Long>> stdContrastData = this.getStdContrastData(rowStdDatas);
            ContrastRowDataEntity rowDataEntity = new ContrastRowDataEntity();
            rowDataEntity.setRowIndex(rowIndex.intValue());
            rowDataEntity.setProps(props);
            rowDataEntity.setStdContrastData(stdContrastData);
            rowDataEntity.setGradeRankRangeDBEntity(gradeRankRangeDBEntity);
            rowDataEntity.saveChange();
            rowDataEntities.add(rowDataEntity);
        }
        DynamicObjectCollection newDataDyColl = stdDy.getDynamicObjectCollection(salaryStdDataNew);
        if (newDataDyColl.size() > 0) {
            logger.error("stdTable step3 has upgrade before, stdId = {}", (Object)stdId);
            return;
        }
        DynamicObjectType stdDataType = newDataDyColl.getDynamicObjectType();
        long[] entryIds = DB.genLongIds((String)"T_HCDM_CONTRASTSUMDATA", (int)rowDataEntities.size());
        int index = 1;
        for (ContrastRowDataEntity rowDataEntity : rowDataEntities) {
            DynamicObject dynamicObject = new DynamicObject(stdDataType);
            dynamicObject.set("sumrowindex", (Object)rowDataEntity.getRowIndex());
            dynamicObject.set("standardpropvalue", (Object)rowDataEntity.getStdPropValueDBVal());
            dynamicObject.set("graderankrange", (Object)rowDataEntity.getGradeRankRangeDBVal());
            dynamicObject.set("entryboid61", (Object)entryIds[index - 1]);
            dynamicObject.set("id", (Object)entryIds[index - 1]);
            dynamicObject.set("seq", (Object)index++);
            newDataDyColl.add((Object)dynamicObject);
        }
        stdHelper.saveOne(stdDy);
    }

    public GradeRankRangeDBEntity getGradeRankRangeDBEntity(List<GradeRankKey> gradeRankKey, List<SalaryGradeEntity> gradeEntities, List<SalaryRankEntity> rankEntities, Long stdId) {
        GradeRankRangeDBEntity gradeRankRangeDBEntity = new GradeRankRangeDBEntity();
        List<GradeRankValue> rangeCodeByRangeKeys = null;
        try {
            rangeCodeByRangeKeys = GradeRankHelper.getRangeCodeByRangeKeys(gradeEntities, rankEntities, gradeRankKey);
        }
        catch (Exception exception) {
            rangeCodeByRangeKeys = new ArrayList<GradeRankValue>(10);
            logger.error("getGradeRankRangeDBEntity rangeCodeByRangeKeys error, stdId = {}", (Object)stdId);
        }
        gradeRankRangeDBEntity.setRangeCodeArr(rangeCodeByRangeKeys);
        gradeRankRangeDBEntity.setGradeNum(Integer.valueOf(gradeEntities == null ? 0 : gradeEntities.size()));
        gradeRankRangeDBEntity.setRankNum(Integer.valueOf(rankEntities == null ? 0 : rankEntities.size()));
        return gradeRankRangeDBEntity;
    }

    private Map<Long, List<Long>> getStdContrastData(List<ContrastDataEntity> contrastDataEntities) {
        HashMap<Long, List<Long>> stdContrastData = new HashMap<Long, List<Long>>(16);
        if (contrastDataEntities == null) {
            return stdContrastData;
        }
        for (ContrastDataEntity contrastData : contrastDataEntities) {
            Long contrastId = contrastData.getContrastPropConfId();
            List valueIds = stdContrastData.computeIfAbsent(contrastId, val -> Lists.newArrayListWithCapacity((int)10));
            valueIds.add(contrastData.getContrastPropValue());
        }
        return stdContrastData;
    }

    private List<ContrastDataEntity> buildStructureForGradeRank(List<ContrastDataEntity> gradeRankContrastDatas) {
        if (gradeRankContrastDatas == null || gradeRankContrastDatas.isEmpty()) {
            return new ArrayList<ContrastDataEntity>(10);
        }
        Map<Long, List<ContrastDataEntity>> childrenDataMap = gradeRankContrastDatas.stream().filter(o1 -> o1.getContrastParentIdentity() > 0L).distinct().collect(Collectors.groupingBy(ContrastDataEntity::getContrastParentIdentity));
        List<ContrastDataEntity> topList = gradeRankContrastDatas.stream().filter(o1 -> o1.getContrastParentIdentity() == 0L).distinct().collect(Collectors.toList());
        for (ContrastDataEntity topData : topList) {
            topData.getChildren().clear();
            List<ContrastDataEntity> children = childrenDataMap.get(topData.getContrastIdentity());
            if (children == null) continue;
            topData.getChildren().addAll(children);
        }
        return topList;
    }

    private List<GradeRankKey> getGradeRankKey(List<ContrastDataEntity> gradeRankContrastData, Map<Long, SalaryGradeEntity> gradeEntityMap, Map<Long, SalaryRankEntity> rankEntityMap) {
        ArrayList<GradeRankKey> result = new ArrayList<GradeRankKey>(10);
        if (CollectionUtils.isEmpty(gradeRankContrastData) || gradeEntityMap == null || rankEntityMap == null || gradeEntityMap.isEmpty() && rankEntityMap.isEmpty()) {
            return result;
        }
        for (ContrastDataEntity contrastData : gradeRankContrastData) {
            List list = contrastData.getChildren();
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            for (ContrastDataEntity dataEntity : list) {
                GradeRankKey gradeRankKey = new GradeRankKey(gradeEntityMap.get(contrastData.getContrastPropValue()), rankEntityMap.get(dataEntity.getContrastPropValue()));
                result.add(gradeRankKey);
            }
        }
        return result;
    }

    private boolean toDeleteData(Long stdId) {
        try {
            return DB.execute((DBRoute)new DBRoute("hcdm"), (String)DELETE_DATA_STEP3, (Object[])new Object[]{stdId, stdId});
        }
        catch (Exception ex) {
            logger.error("Error when delete table data,sql is {}", (Object)DELETE_DATA_STEP3, (Object)ex);
            return false;
        }
    }

    private boolean backUpTableNameData(String backUpSql, Long stdId) {
        try {
            return DB.execute((DBRoute)new DBRoute("hcdm"), (String)backUpSql, (Object[])new Object[]{stdId, stdId});
        }
        catch (Exception ex) {
            logger.error("Error when back-up table data,sql is {}", (Object)backUpSql, (Object)ex);
            return false;
        }
    }
}

