/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.task;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.common.util.DomainFactory;
import kd.sdk.swc.hcdm.common.stdtab.SalaryStdDataEntity;
import kd.swc.hcdm.business.salarystandard.SalaryStandardPageInteractionHelper;
import kd.swc.hcdm.business.stdapplication.domain.stdtab.service.SalaryStdDomainService;
import kd.swc.hcdm.business.task.StdTableContrastDataUpgradeTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class StdTableDataUpgradeTask
extends AbstractTask {
    private SWCDataServiceHelper stdHelper = new SWCDataServiceHelper("hcdm_salarystandard");
    private static final String gradeRankSeqMapKey = "graderankseqmap";
    private static final String salaryGrade = "salarygrade";
    private static final String salaryRank = "salaryrank";
    private static final String baseField = "id,graderankseqmap";
    private static final String gradeRankField = "id,graderankseqmap,salarygrade,salarygrade.gradeidentity,salaryrank,salaryrank.rankidentity";
    private static final String salaryStdDataNew = "salarystddata_a";
    private static final String stdDataTableField = "id,graderankseqmap,salarystddata_a,salarystddata_a.salarystditemid_a,salarystddata_a.stddata,salarystddata_a.seq,salarystddata_a.entryboid21";
    static final String BAK_TABLE_NAME_SUFFIX = "BAK";
    static final String STEP2_TABLE_NAME = "T_HCDM_SALARYSTDDATA";
    static final String STEP3_TABLE_NAME = "T_HCDM_CONTRASTDATA";
    private static final String CREATE_STEP2_TABLE_SQL = "create table %s (  FENTRYID BIGINT DEFAULT 0 NOT NULL,  FID BIGINT DEFAULT 0  NOT NULL,  FSEQ INT DEFAULT 0 NULL,  FSALARYSTDITEMID BIGINT DEFAULT 0 NULL,  FSALARYRANKID BIGINT DEFAULT 0 NULL,  FSALARYGRADEID BIGINT DEFAULT 0 NULL,  FSALARYCOUNT DECIMAL(19,6) DEFAULT NULL NULL,  FMIN DECIMAL(23,10) DEFAULT NULL NULL,  FMIDDLE DECIMAL(23,10) DEFAULT NULL NULL,  FMAX DECIMAL(23,10) DEFAULT NULL NULL,  FENTRYBOID BIGINT DEFAULT 0 NULL,  constraint %s primary key (FENTRYID) ) ";
    private static final String CREATE_STEP3_TABLE_SQL = "create table %s (  FENTRYID BIGINT DEFAULT 0 NOT NULL,  FID BIGINT DEFAULT 0 NOT NULL,  FSEQ INT DEFAULT 0 NULL,  FCONTRASTIDENTITY BIGINT DEFAULT 0 NULL,  FCONTRASTPARENTIDENTITY BIGINT DEFAULT 0 NULL,  FCONTRASTPROPCONFID BIGINT DEFAULT 0 NULL,  FCONTRASTPROPVALUE BIGINT DEFAULT 0 NULL,  FROWINDEX INT DEFAULT 0 NULL,  FSUBINDEX INT DEFAULT 0 NULL,  FCONTRASTPROPLABEL VARCHAR(30) DEFAULT 'Standard' NULL,  FENTRYBOID BIGINT DEFAULT 0 NULL,  constraint %s primary key (FENTRYID) ) ";
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";
    private static final String CREATE_INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s (%s)";
    private static final String STEP2_TABLE_COLUMN = "FENTRYID,FID,FSEQ,FSALARYSTDITEMID,FSALARYRANKID,FSALARYGRADEID,FSALARYCOUNT,FMIN,FMIDDLE,FMAX,FENTRYBOID";
    private static final String STEP3_TABLE_COLUMN = "FENTRYID,FID,FSEQ,FCONTRASTIDENTITY,FCONTRASTPARENTIDENTITY,FCONTRASTPROPCONFID,FCONTRASTPROPVALUE,FROWINDEX,FSUBINDEX,FCONTRASTPROPLABEL,FENTRYBOID";
    private static final String INSERT_SELECT_SQL_STEP2 = "INSERT INTO T_HCDM_SALARYSTDDATABAK (FENTRYID,FID,FSEQ,FSALARYSTDITEMID,FSALARYRANKID,FSALARYGRADEID,FSALARYCOUNT,FMIN,FMIDDLE,FMAX,FENTRYBOID) SELECT FENTRYID,FID,FSEQ,FSALARYSTDITEMID,FSALARYRANKID,FSALARYGRADEID,FSALARYCOUNT,FMIN,FMIDDLE,FMAX,FENTRYBOID FROM T_HCDM_SALARYSTDDATA WHERE FID = ? AND FENTRYID NOT IN (SELECT FENTRYID FROM T_HCDM_SALARYSTDDATABAK WHERE FID = ? )";
    static final String INSERT_SELECT_SQL_STEP3 = "INSERT INTO T_HCDM_CONTRASTDATABAK (FENTRYID,FID,FSEQ,FCONTRASTIDENTITY,FCONTRASTPARENTIDENTITY,FCONTRASTPROPCONFID,FCONTRASTPROPVALUE,FROWINDEX,FSUBINDEX,FCONTRASTPROPLABEL,FENTRYBOID) SELECT FENTRYID,FID,FSEQ,FCONTRASTIDENTITY,FCONTRASTPARENTIDENTITY,FCONTRASTPROPCONFID,FCONTRASTPROPVALUE,FROWINDEX,FSUBINDEX,FCONTRASTPROPLABEL,FENTRYBOID FROM T_HCDM_CONTRASTDATA WHERE FID = ? AND FENTRYID NOT IN (SELECT FENTRYID FROM T_HCDM_CONTRASTDATABAK WHERE FID = ? )";
    private static final String DELETE_DATA_STEP2 = "DELETE FROM T_HCDM_SALARYSTDDATA T1 WHERE T1.FID = ? AND T1.FENTRYID IN (SELECT T2.FENTRYID FROM T_HCDM_SALARYSTDDATABAK T2 WHERE T2.FID = ?)";
    private SalaryStdDomainService service = (SalaryStdDomainService)DomainFactory.getInstance(SalaryStdDomainService.class);
    private static final Log logger = LogFactory.getLog(StdTableDataUpgradeTask.class);
    private String queryEntrySql = "SELECT FID,FSALARYSTDITEMID,FSALARYGRADEID,FSALARYRANKID,FSALARYCOUNT,FMIN,FMIDDLE,FMAX FROM T_HCDM_SALARYSTDDATA WHERE FID = ?";
    private String queryMainSql = "SELECT A.FID FROM T_HCDM_SALARYSTD A WHERE NOT EXISTS (SELECT FID FROM T_HCDM_STDSUMDATA B WHERE A.FID = B.FID) AND EXISTS (SELECT FID FROM T_HCDM_SALARYSTDDATA C WHERE A.FID = C.FID)";

    public void setQueryMainSql(String queryMainSql) {
        this.queryMainSql = queryMainSql;
    }

    public void setQueryEntrySql(String queryEntrySql) {
        this.queryEntrySql = queryEntrySql;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.toCreateBakTable();
        this.upgradeMainTableField();
        this.upgradeStdDatas();
        new StdTableContrastDataUpgradeTask().execute(requestContext, map);
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    public void upgradeMainTableField() {
        QFilter filter = new QFilter(gradeRankSeqMapKey, "=", (Object)"");
        filter.or(QFilter.isNull((String)gradeRankSeqMapKey));
        filter.or(gradeRankSeqMapKey, "=", (Object)" ");
        DynamicObject[] stdDyObjs = this.stdHelper.query(gradeRankField, filter.toArray());
        if (stdDyObjs == null || stdDyObjs.length <= 0) {
            return;
        }
        Map stdDyObjMap = Arrays.stream(stdDyObjs).collect(Collectors.toMap(stdDyObj -> stdDyObj.getLong("id"), stdDyObj -> stdDyObj, (a1, b1) -> b1, () -> new HashMap(16)));
        DynamicObject[] stdDyObjs2 = this.stdHelper.query(baseField, new QFilter("id", "in", stdDyObjMap.keySet()).toArray());
        Map stdDyObjMap2 = Arrays.stream(stdDyObjs2).collect(Collectors.toMap(stdDyObj -> stdDyObj.getLong("id"), stdDyObj -> stdDyObj, (a1, b1) -> b1, () -> new HashMap(16)));
        for (DynamicObject stdDyObj2 : stdDyObjs) {
            DynamicObject stdDyObj22 = (DynamicObject)stdDyObjMap2.get(stdDyObj2.getLong("id"));
            if (stdDyObj22 == null) continue;
            DynamicObjectCollection gradeDyColl = stdDyObj2.getDynamicObjectCollection(salaryGrade);
            DynamicObjectCollection rankDyColl = stdDyObj2.getDynamicObjectCollection(salaryRank);
            Map<String, Map<Long, Integer>> gradeRankSeqMap = SalaryStandardPageInteractionHelper.getGradeRankSeqMap("", gradeDyColl, true, true);
            Map<String, Map<Long, Integer>> gradeRankSeqMaps = SalaryStandardPageInteractionHelper.getGradeRankSeqMap(JSON.toJSONString(gradeRankSeqMap), rankDyColl, false, true);
            stdDyObj22.set(gradeRankSeqMapKey, (Object)JSON.toJSONString(gradeRankSeqMaps));
        }
        this.stdHelper.save(stdDyObjs2);
    }

    public void upgradeStdDatas() {
        String querySql = this.queryMainSql;
        HashSet<Long> needUpdateStdIds = new HashSet<Long>(100);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryHCDMStdTableId", (DBRoute)new DBRoute("hcdm"), (String)querySql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                needUpdateStdIds.add(row.getLong("FID"));
            }
        }
        for (Long needUpdateStdId : needUpdateStdIds) {
            try {
                this.upgradeDataWithBak(needUpdateStdId);
            }
            catch (Exception exc) {
                logger.error("stdTable step2 upgrade error, stdId = {}", (Object)needUpdateStdId);
            }
        }
    }

    public void upgradeDataWithBak(Long needUpdateStdId) {
        this.backUpTableNameData(INSERT_SELECT_SQL_STEP2, needUpdateStdId);
        this.upgradeStdData(needUpdateStdId);
        this.toDeleteData(needUpdateStdId);
    }

    public void upgradeStdData(Long stdId) {
        DynamicObject stdDy = this.stdHelper.queryOne(stdDataTableField, (Object)stdId);
        if (stdDy == null) {
            return;
        }
        String querySql = this.queryEntrySql;
        ArrayList<SalaryStdDataEntity> stdDataEntities = new ArrayList<SalaryStdDataEntity>(100);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryHCDMStdTableEntryData", (DBRoute)new DBRoute("hcdm"), (String)querySql, (Object[])new Object[]{stdId});){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                SalaryStdDataEntity entity = new SalaryStdDataEntity();
                entity.setSalaryStandardId(stdId);
                entity.setItemIdentity(row.getLong("FSALARYSTDITEMID"));
                entity.setGradeIdentity(row.getLong("FSALARYGRADEID"));
                entity.setRankIdentity(row.getLong("FSALARYRANKID"));
                entity.setSalaryCount(row.getBigDecimal("FSALARYCOUNT"));
                entity.setMin(row.getBigDecimal("FMIN"));
                entity.setMiddle(row.getBigDecimal("FMIDDLE"));
                entity.setMax(row.getBigDecimal("FMAX"));
                stdDataEntities.add(entity);
            }
        }
        if (stdDataEntities.isEmpty()) {
            return;
        }
        String gradeRankSeqMapStr = stdDy.getString(gradeRankSeqMapKey);
        Map<String, Map<Long, Integer>> gradeRankSeqMapI = this.service.parseGradeRankSeqMap(gradeRankSeqMapStr);
        LinkedHashMap<Long, String> itemLevelStdDataStr = this.service.getItemLevelStdDataStr(stdDataEntities, gradeRankSeqMapI);
        DynamicObjectCollection newDataDyColl = stdDy.getDynamicObjectCollection(salaryStdDataNew);
        if (newDataDyColl.size() > 0) {
            logger.error("stdTable step2 has upgrade before, stdId = {}", (Object)stdId);
            return;
        }
        DynamicObjectType stdDataType = newDataDyColl.getDynamicObjectType();
        long[] entryIds = DB.genLongIds((String)"T_HCDM_STDSUMDATA", (int)itemLevelStdDataStr.size());
        int index = 1;
        for (Map.Entry entry : itemLevelStdDataStr.entrySet()) {
            Long itemIdentity = (Long)entry.getKey();
            String dataStr = (String)entry.getValue();
            DynamicObject dynamicObject = new DynamicObject(stdDataType);
            dynamicObject.set("salarystditemid_a", (Object)itemIdentity);
            dynamicObject.set("stddata", (Object)dataStr);
            dynamicObject.set("entryboid21", (Object)entryIds[index - 1]);
            dynamicObject.set("id", (Object)entryIds[index - 1]);
            dynamicObject.set("seq", (Object)index++);
            newDataDyColl.add((Object)dynamicObject);
        }
        this.stdHelper.saveOne(stdDy);
    }

    private boolean tableIsExisted(String tableName) {
        String tableExistSql = String.format(Locale.ROOT, TABLE_IS_EXISTED_SQL, tableName);
        return (Boolean)DB.query((DBRoute)new DBRoute("hcdm"), (String)tableExistSql, null, ResultSet::next);
    }

    private boolean createTable(String tableName, String pkName) {
        String table = CREATE_STEP2_TABLE_SQL;
        if (tableName.startsWith(STEP3_TABLE_NAME)) {
            table = CREATE_STEP3_TABLE_SQL;
        }
        String createTableSql = String.format(table, tableName, pkName);
        try {
            DB.execute((DBRoute)new DBRoute("hcdm"), (String)createTableSql, null);
            return true;
        }
        catch (Exception ex) {
            logger.error("Error when create table {}", (Object)tableName, (Object)ex);
            return false;
        }
    }

    private boolean createIndex(String indexName, String tableName, String columns) {
        String createIndexSql = String.format(CREATE_INDEX_SQL, indexName, indexName, tableName, columns);
        try {
            return DB.execute((DBRoute)new DBRoute("hcdm"), (String)createIndexSql, null);
        }
        catch (Exception ex) {
            logger.error("Error when create table index {}", (Object)tableName, (Object)ex);
            return false;
        }
    }

    private Map<String, List<String>> colsOfIndexes(String entityNameUp) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)1);
        result.put("IDX_" + entityNameUp + "_1", Lists.newArrayList((Object[])new String[]{"FID ASC"}));
        return result;
    }

    private String pkName(String entityNameUp) {
        return "PK_" + entityNameUp;
    }

    private void toCreateBakTable() {
        String[] originalNames;
        for (String originalName : originalNames = new String[]{STEP2_TABLE_NAME, STEP3_TABLE_NAME}) {
            String pkName;
            String sql = "SELECT COUNT(*) AS TOTAL FROM " + originalName;
            boolean isHasData = true;
            try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"countStdStep23Bak", (DBRoute)new DBRoute("hcdm"), (String)sql, (Object[])new Object[0]);){
                while (dateSet.hasNext()) {
                    Row row = dateSet.next();
                    Integer total = row.getInteger("TOTAL");
                    if (total == null || total != 0) continue;
                    isHasData = false;
                }
            }
            if (!isHasData) continue;
            String tableName = originalName.toUpperCase(Locale.ROOT) + BAK_TABLE_NAME_SUFFIX;
            String entityNameUp = tableName.substring(2);
            if (this.tableIsExisted(tableName) || !this.createTable(tableName, pkName = this.pkName(entityNameUp))) continue;
            Map<String, List<String>> colsOfIndexes = this.colsOfIndexes(entityNameUp);
            for (Map.Entry<String, List<String>> entry : colsOfIndexes.entrySet()) {
                String indexName = entry.getKey();
                List<String> value = entry.getValue();
                String columns = Joiner.on((char)',').join(value);
                this.createIndex(indexName, tableName, columns);
            }
        }
    }

    private boolean backUpTableNameData(String backUpSql, Long stdId) {
        try {
            return DB.execute((DBRoute)new DBRoute("hcdm"), (String)backUpSql, (Object[])new Object[]{stdId, stdId});
        }
        catch (Exception ex) {
            logger.error("Error when back-up table data,sql is {}", (Object)backUpSql, (Object)ex);
            return false;
        }
    }

    private boolean toDeleteData(Long stdId) {
        try {
            return DB.execute((DBRoute)new DBRoute("hcdm"), (String)DELETE_DATA_STEP2, (Object[])new Object[]{stdId, stdId});
        }
        catch (Exception ex) {
            logger.error("Error when delete table data,sql is {}", (Object)DELETE_DATA_STEP2, (Object)ex);
            return false;
        }
    }
}

