/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hcdm.business.validator;

import java.io.Serializable;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hcdm.business.validator.bean.ValidateContext;
import kd.swc.hcdm.business.validator.bean.ValidateResult;
import kd.swc.hcdm.business.validator.bean.ValidatorTree;
import kd.swc.hcdm.business.validator.impl.Validator;

public class ValidatorAdapter
implements Serializable {
    private static final long serialVersionUID = -7052829452938364156L;
    private static final Log log = LogFactory.getLog(ValidatorAdapter.class);
    private ValidatorTree validatorTree;
    private ValidateContext validateContext;

    private ValidatorAdapter() {
    }

    public static ValidatorAdapter build(ValidateContext validateContext, ValidatorTree validatorTree) {
        ValidatorAdapter adapter = new ValidatorAdapter();
        adapter.validatorTree = validatorTree;
        adapter.validateContext = validateContext;
        return adapter;
    }

    public ValidateContext getValidateContext() {
        return this.validateContext;
    }

    private void DepthFirstValidate(ValidatorTree.ValidatorNode node) {
        block3: {
            block2: {
                if (!node.isRoot()) break block2;
                List<ValidatorTree.ValidatorNode> childs = node.getChild();
                for (ValidatorTree.ValidatorNode child : childs) {
                    this.DepthFirstValidate(child);
                }
                break block3;
            }
            Validator validator = node.getValidator();
            validator.validate();
            ValidateResult result = validator.getResult();
            if (!result.isSuccess()) break block3;
            List<ValidatorTree.ValidatorNode> childs = node.getChild();
            for (ValidatorTree.ValidatorNode child : childs) {
                this.DepthFirstValidate(child);
            }
        }
    }

    public void validate() {
        this.DepthFirstValidate(this.validatorTree.getRoot());
    }
}

